/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import junit.framework.TestCase;
import org.apache.pig.ExecType;
import org.apache.pig.PigServer;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.Tuple;
import org.apache.pig.test.MiniCluster;
import org.apache.pig.test.Util;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestPoissonSampleLoader
extends TestCase {
    private static final String INPUT_FILE1 = "SkewedJoinInput1.txt";
    private PigServer pigServer;
    private MiniCluster cluster = MiniCluster.buildCluster();

    public TestPoissonSampleLoader() throws ExecException, IOException {
        this.pigServer = new PigServer(ExecType.LOCAL, this.cluster.getProperties());
        this.pigServer.getPigContext().getProperties().setProperty("pig.skewedjoin.reduce.maxtuple", "5");
        this.pigServer.getPigContext().getProperties().setProperty("pig.skewedjoin.reduce.memusage", "0.0001");
        this.pigServer.getPigContext().getProperties().setProperty("mapred.child.java.opts", "-Xmx512m");
        this.pigServer.getPigContext().getProperties().setProperty("pig.mapsplits.count", "5");
    }

    @Before
    public void setUp() throws Exception {
        this.createFiles();
    }

    private void createFiles() throws IOException {
        PrintWriter w = new PrintWriter(new FileWriter(INPUT_FILE1));
        int k = 0;
        for (int j = 0; j < 100; ++j) {
            w.println("100:apple1:aaa" + k);
            w.println("200:orange1:bbb" + ++k);
            w.println("300:strawberry:ccc" + ++k);
            ++k;
        }
        w.close();
        Util.copyFromLocalToCluster(this.cluster, INPUT_FILE1, INPUT_FILE1);
    }

    @After
    public void tearDown() throws Exception {
        new File(INPUT_FILE1).delete();
        Util.deleteFile(this.cluster, INPUT_FILE1);
    }

    @Test
    public void testNumSamples() throws IOException {
        this.pigServer.registerQuery("A = Load 'SkewedJoinInput1.txt' Using PoissonSampleLoader('PigStorage()', '100');");
        Iterator iter = this.pigServer.openIterator("A");
        int count = 0;
        while (iter.hasNext()) {
            ++count;
            iter.next();
        }
        TestPoissonSampleLoader.assertEquals((int)count, (int)1);
    }

    @Test
    public void testInstantiation() throws IOException {
        this.pigServer.registerQuery("A = Load 'SkewedJoinInput1.txt' Using PoissonSampleLoader('PigStorage(\\\\\\':\\\\\\')', '100');");
        Iterator iter = this.pigServer.openIterator("A");
        TestPoissonSampleLoader.assertTrue((boolean)iter.hasNext());
        TestPoissonSampleLoader.assertEquals((int)5, (int)((Tuple)iter.next()).size());
    }
}

