/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.pig.ExecType;
import org.apache.pig.PigServer;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POProject;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.test.Util;
import org.apache.pig.test.utils.GenPhyOp;
import org.apache.pig.test.utils.GenRandomData;
import org.apache.pig.test.utils.TestHelper;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestProject
extends TestCase {
    Random r;
    Tuple t;
    Tuple tRandom;
    Tuple tRandomAndNull;
    Result res;
    POProject proj;

    @Before
    public void setUp() throws Exception {
        this.r = new Random();
        this.tRandom = GenRandomData.genRandSmallBagTuple(this.r, 10, 100);
        this.tRandomAndNull = GenRandomData.genRandSmallBagTupleWithNulls(this.r, 10, 100);
        this.res = new Result();
        this.proj = GenPhyOp.exprProject();
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testGetNext() throws ExecException, IOException {
        this.t = this.tRandom;
        this.proj.attachInput(this.t);
        for (int j = 0; j < this.t.size(); ++j) {
            this.proj.attachInput(this.t);
            this.proj.setColumn(j);
            this.res = this.proj.getNext();
            TestProject.assertEquals((byte)0, (byte)this.res.returnStatus);
            TestProject.assertEquals((Object)this.t.get(j), (Object)this.res.result);
        }
    }

    @Test
    public void testGetNextTuple() throws IOException, ExecException {
        this.t = this.tRandom;
        this.proj.attachInput(this.t);
        this.proj.setColumn(0);
        this.proj.setOverloaded(true);
        DataBag inpBag = (DataBag)this.t.get(0);
        int cntr = 0;
        boolean contains = true;
        while (true) {
            this.res = this.proj.getNext(this.t);
            if (this.res.returnStatus == 3) break;
            if (!TestHelper.bagContains(inpBag, (Tuple)this.res.result)) {
                contains = false;
                break;
            }
            ++cntr;
        }
        TestProject.assertEquals((float)inpBag.size(), (float)cntr, (float)0.01f);
        TestProject.assertEquals((boolean)true, (boolean)contains);
        this.proj.attachInput(this.t);
        this.proj.setColumn(9);
        this.proj.setOverloaded(false);
        this.res = this.proj.getNext(this.t);
        TestProject.assertEquals((byte)0, (byte)this.res.returnStatus);
        TestProject.assertEquals((Object)this.t.get(9), (Object)this.res.result);
    }

    @Test
    public void testGetNextMultipleProjections() throws ExecException, IOException {
        this.t = this.tRandom;
        ArrayList<Integer> cols = new ArrayList<Integer>();
        this.proj.attachInput(this.t);
        for (int j = 0; j < this.t.size() - 1; ++j) {
            this.proj.attachInput(this.t);
            cols.add(j);
            cols.add(j + 1);
            this.proj.setColumns(cols);
            this.res = this.proj.getNext();
            TupleFactory tupleFactory = TupleFactory.getInstance();
            ArrayList<Object> objList = new ArrayList<Object>();
            objList.add(this.t.get(j));
            objList.add(this.t.get(j + 1));
            Tuple expectedResult = tupleFactory.newTuple(objList);
            TestProject.assertEquals((byte)0, (byte)this.res.returnStatus);
            TestProject.assertEquals((Object)expectedResult, (Object)this.res.result);
            cols.clear();
        }
    }

    @Test
    public void testGetNextTupleMultipleProjections() throws IOException, ExecException {
        this.t = this.tRandom;
        this.proj.attachInput(this.t);
        this.proj.setOverloaded(true);
        int j = 0;
        ArrayList<Integer> cols = new ArrayList<Integer>();
        while (true) {
            cols.add(j);
            cols.add(j + 1);
            this.proj.setColumns(cols);
            this.res = this.proj.getNext(this.t);
            if (this.res.returnStatus == 3) break;
            TupleFactory tupleFactory = TupleFactory.getInstance();
            ArrayList<Object> objList = new ArrayList<Object>();
            objList.add(this.t.get(j));
            objList.add(this.t.get(j + 1));
            Tuple expectedResult = tupleFactory.newTuple(objList);
            TestProject.assertEquals((byte)0, (byte)this.res.returnStatus);
            TestProject.assertEquals((Object)expectedResult, (Object)this.res.result);
            ++j;
            cols.clear();
        }
        this.proj.attachInput(this.t);
        this.proj.setColumn(9);
        this.proj.setOverloaded(false);
        this.res = this.proj.getNext(this.t);
        TestProject.assertEquals((byte)0, (byte)this.res.returnStatus);
        TestProject.assertEquals((Object)this.t.get(9), (Object)this.res.result);
    }

    @Test
    public void testGetNextWithNull() throws ExecException, IOException {
        this.t = this.tRandomAndNull;
        this.proj.attachInput(this.t);
        for (int j = 0; j < this.t.size(); ++j) {
            this.proj.attachInput(this.t);
            this.proj.setColumn(j);
            this.res = this.proj.getNext();
            TestProject.assertEquals((byte)0, (byte)this.res.returnStatus);
            TestProject.assertEquals((Object)this.t.get(j), (Object)this.res.result);
        }
    }

    @Test
    public void testGetNextTupleWithNull() throws IOException, ExecException {
        this.t = this.tRandomAndNull;
        this.proj.attachInput(this.t);
        this.proj.setColumn(0);
        this.proj.setOverloaded(true);
        DataBag inpBag = (DataBag)this.t.get(0);
        int cntr = 0;
        boolean contains = true;
        while (true) {
            this.res = this.proj.getNext(this.t);
            if (this.res.returnStatus == 3) break;
            if (!TestHelper.bagContains(inpBag, (Tuple)this.res.result)) {
                contains = false;
                break;
            }
            ++cntr;
        }
        TestProject.assertEquals((float)inpBag.size(), (float)cntr, (float)0.01f);
        TestProject.assertEquals((boolean)true, (boolean)contains);
        this.proj.attachInput(this.t);
        this.proj.setColumn(9);
        this.proj.setOverloaded(false);
        this.res = this.proj.getNext(this.t);
        TestProject.assertEquals((byte)0, (byte)this.res.returnStatus);
        TestProject.assertEquals((Object)this.t.get(9), (Object)this.res.result);
    }

    @Test
    public void testGetNextMultipleProjectionsWithNull() throws ExecException, IOException {
        this.t = this.tRandomAndNull;
        ArrayList<Integer> cols = new ArrayList<Integer>();
        this.proj.attachInput(this.t);
        for (int j = 0; j < this.t.size() - 1; ++j) {
            this.proj.attachInput(this.t);
            cols.add(j);
            cols.add(j + 1);
            this.proj.setColumns(cols);
            this.res = this.proj.getNext();
            TupleFactory tupleFactory = TupleFactory.getInstance();
            ArrayList<Object> objList = new ArrayList<Object>();
            objList.add(this.t.get(j));
            objList.add(this.t.get(j + 1));
            Tuple expectedResult = tupleFactory.newTuple(objList);
            TestProject.assertEquals((byte)0, (byte)this.res.returnStatus);
            TestProject.assertEquals((Object)expectedResult, (Object)this.res.result);
            cols.clear();
        }
    }

    @Test
    public void testGetNextTupleMultipleProjectionsWithNull() throws IOException, ExecException {
        this.t = this.tRandomAndNull;
        this.proj.attachInput(this.t);
        this.proj.setOverloaded(true);
        int j = 0;
        ArrayList<Integer> cols = new ArrayList<Integer>();
        while (true) {
            cols.add(j);
            cols.add(j + 1);
            this.proj.setColumns(cols);
            this.res = this.proj.getNext(this.t);
            if (this.res.returnStatus == 3) break;
            TupleFactory tupleFactory = TupleFactory.getInstance();
            ArrayList<Object> objList = new ArrayList<Object>();
            objList.add(this.t.get(j));
            objList.add(this.t.get(j + 1));
            Tuple expectedResult = tupleFactory.newTuple(objList);
            TestProject.assertEquals((byte)0, (byte)this.res.returnStatus);
            TestProject.assertEquals((Object)expectedResult, (Object)this.res.result);
            ++j;
            cols.clear();
        }
        this.proj.attachInput(this.t);
        this.proj.setColumn(9);
        this.proj.setOverloaded(false);
        this.res = this.proj.getNext(this.t);
        TestProject.assertEquals((byte)0, (byte)this.res.returnStatus);
        TestProject.assertEquals((Object)this.t.get(9), (Object)this.res.result);
    }

    @Test
    public void testMissingCols1() throws Exception {
        String inputFileName = "TestProject-testMissingCols1-input.txt";
        String[] input = new String[]{"hello\tworld", "good\tbye"};
        Util.createLocalInputFile(inputFileName, input);
        String query = "a = load '" + inputFileName + "' as (s1:chararray, s2:chararray, extra:chararray);" + "b = foreach a generate s1, s2, extra;";
        PigServer ps = new PigServer(ExecType.LOCAL);
        Util.registerMultiLineQuery(ps, query);
        Iterator it = ps.openIterator("b");
        Tuple[] expectedResults = new Tuple[]{(Tuple)Util.getPigConstant("('hello', 'world', null)"), (Tuple)Util.getPigConstant("('good', 'bye', null)")};
        int i = 0;
        while (it.hasNext()) {
            TestProject.assertEquals((Object)expectedResults[i++], it.next());
        }
    }

    @Test
    public void testMissingCols2() throws Exception {
        String inputFileName = "TestProject-testMissingCols2-input.txt";
        String[] input = new String[]{"1\t(hello,world)", "2\t(good,bye)"};
        Util.createLocalInputFile(inputFileName, input);
        String query = "a = load '" + inputFileName + "' as (i:int, " + "t:tuple(s1:chararray, s2:chararray, s3:chararray));" + "b = foreach a generate t.(s2,s3);";
        PigServer ps = new PigServer(ExecType.LOCAL);
        Util.registerMultiLineQuery(ps, query);
        Iterator it = ps.openIterator("b");
        Tuple[] expectedResults = new Tuple[]{(Tuple)Util.getPigConstant("((null, null))"), (Tuple)Util.getPigConstant("((null, null))")};
        int i = 0;
        while (it.hasNext()) {
            TestProject.assertEquals((Object)expectedResults[i++], it.next());
        }
    }

    @Test
    public void testMissingCols3() throws Exception {
        String inputFileName = "TestProject-testMissingCols3-input.txt";
        String[] input = new String[]{"hello\tworld", "good\tbye"};
        Util.createLocalInputFile(inputFileName, input);
        String query = "a = load '" + inputFileName + "';" + "b = group a all;" + "c = foreach b generate flatten(a.($1, $2)),a.$2;";
        PigServer ps = new PigServer(ExecType.LOCAL);
        Util.registerMultiLineQuery(ps, query);
        Iterator it = ps.openIterator("c");
        Tuple[] expectedResults = new Tuple[]{(Tuple)Util.getPigConstant("('world', null, {(null),(null)})"), (Tuple)Util.getPigConstant("('bye', null, {(null),(null)})")};
        int i = 0;
        while (it.hasNext()) {
            TestProject.assertEquals((String)expectedResults[i++].toString(), (String)((Tuple)it.next()).toString());
        }
    }

    @Test
    public void testNullTupleCols() throws Exception {
        String inputFileName = "TestProject-testNullTupleCols-input.txt";
        String[] input = new String[]{"1\t(hello,world)", "2\t(good)", "3"};
        Util.createLocalInputFile(inputFileName, input);
        String query = "a = load '" + inputFileName + "' as (i:int, " + "t:tuple(s1:chararray, s2:chararray));" + "b = foreach a generate t.s1, t.s2;";
        PigServer ps = new PigServer(ExecType.LOCAL);
        Util.registerMultiLineQuery(ps, query);
        Iterator it = ps.openIterator("b");
        Tuple[] expectedResults = new Tuple[]{(Tuple)Util.getPigConstant("('hello', 'world')"), (Tuple)Util.getPigConstant("(null, null)"), (Tuple)Util.getPigConstant("(null, null)")};
        int i = 0;
        while (it.hasNext()) {
            TestProject.assertEquals((Object)expectedResults[i++], it.next());
        }
    }
}

