/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.util.Random;
import junit.framework.TestCase;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.BinaryComparisonOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.ConstantExpression;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.ExpressionOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.PORegexp;
import org.apache.pig.impl.plan.OperatorKey;
import org.junit.Before;
import org.junit.Test;

public class TestRegexp
extends TestCase {
    Random r = new Random();
    ConstantExpression lt;
    ConstantExpression rt;
    BinaryComparisonOperator op;

    @Before
    public void setUp() throws Exception {
        this.lt = new ConstantExpression(new OperatorKey("", this.r.nextLong()));
        this.lt.setResultType((byte)55);
        this.rt = new ConstantExpression(new OperatorKey("", this.r.nextLong()));
        this.rt.setResultType((byte)55);
        this.op = new PORegexp(new OperatorKey("", this.r.nextLong()));
        this.op.setLhs((ExpressionOperator)this.lt);
        this.op.setRhs((ExpressionOperator)this.rt);
        this.op.setOperandType((byte)55);
    }

    @Test
    public void testMatches() throws ExecException {
        this.lt.setValue((Object)new String("The quick sly fox jumped over the lazy brown dog"));
        this.rt.setValue((Object)".*s.y.*");
        Result res = this.op.getNext(new Boolean(true));
        TestRegexp.assertEquals((byte)0, (byte)res.returnStatus);
        TestRegexp.assertTrue((boolean)((Boolean)res.result));
        this.lt.setValue(null);
        this.rt.setValue((Object)".*s.y.*");
        res = this.op.getNext(new Boolean(true));
        TestRegexp.assertEquals(null, (Object)((Boolean)res.result));
        this.lt.setValue((Object)new String("The quick sly fox jumped over the lazy brown dog"));
        this.rt.setValue(null);
        res = this.op.getNext(new Boolean(true));
        TestRegexp.assertEquals(null, (Object)((Boolean)res.result));
    }

    @Test
    public void testDoesntMatch() throws ExecException {
        this.lt.setValue((Object)new String("The quick sly fox jumped over the lazy brown dog"));
        this.rt.setValue((Object)new String("zzz"));
        Result res = this.op.getNext(new Boolean(true));
        TestRegexp.assertEquals((byte)0, (byte)res.returnStatus);
        TestRegexp.assertFalse((boolean)((Boolean)res.result));
    }
}

