/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import junit.framework.TestCase;
import org.apache.pig.ExecType;
import org.apache.pig.PigServer;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DefaultTuple;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.parser.ParseException;
import org.apache.pig.test.MiniCluster;
import org.apache.pig.test.Util;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestRelationToExprProject
extends TestCase {
    private MiniCluster cluster = MiniCluster.buildCluster();
    private PigServer pigServer;
    private static final String TEST_FILTER_COUNT3_INPUT = "test/org/apache/pig/test/data/TestRelationToExprProjectInput.txt";

    @Before
    protected void setUp() throws Exception {
        this.pigServer = new PigServer(ExecType.MAPREDUCE, this.cluster.getProperties());
    }

    @After
    protected void tearDown() throws Exception {
        this.pigServer.shutdown();
    }

    @Test
    public void testFilterCount1() throws IOException, ParseException {
        String[] inputData = new String[]{"1\t1\t3", "1\t2\t3", "2\t1\t3", "2\t1\t3"};
        Util.createInputFile(this.cluster, "test.txt", inputData);
        String script = "test   = load 'test.txt' as (col1: int, col2: int, col3: int);test2 = group test by col1;test3 = foreach test2 {        filter_one    = filter test by (col2==1);        filter_notone = filter test by (col2!=1);        generate group as col1, COUNT(filter_one) as cnt_one, COUNT(filter_notone) as cnt_notone;};";
        Util.registerMultiLineQuery(this.pigServer, script);
        Iterator it = this.pigServer.openIterator("test3");
        DefaultTuple[] expected = new DefaultTuple[]{(Tuple)Util.getPigConstant("(1,1L,1L)"), (Tuple)Util.getPigConstant("(2,2L,0L)")};
        Object[] results = new Object[2];
        int i = 0;
        while (it.hasNext()) {
            Tuple t;
            if (i == 2) {
                TestRelationToExprProject.fail((String)"Got more tuples than expected!");
            }
            if ((t = (Tuple)it.next()).get(0).equals(1)) {
                results[0] = t;
            } else {
                results[1] = t;
            }
            ++i;
        }
        for (int j = 0; j < expected.length; ++j) {
            TestRelationToExprProject.assertTrue((boolean)expected[j].equals(results[j]));
        }
        Util.deleteFile(this.cluster, "test.txt");
    }

    @Test
    public void testFilterCount2() throws IOException, ParseException {
        Util.createInputFile(this.cluster, "filterbug.data", new String[]{"a\thello", "a\tgoodbye", "b\tgoodbye", "c\thello", "c\thello", "c\thello", "d\twhat"});
        String query = "A = load 'filterbug.data' using PigStorage() as ( id:chararray, str:chararray );B = group A by ( id );Cfiltered = foreach B {        D = filter A by (                str matches 'hello'                );        matchedcount = COUNT(D);        generate                group,                matchedcount as matchedcount,                A.str;        };";
        Util.registerMultiLineQuery(this.pigServer, query);
        Iterator it = this.pigServer.openIterator("Cfiltered");
        HashMap<String, Tuple> expected = new HashMap<String, Tuple>();
        expected.put("a", (Tuple)Util.getPigConstant("('a',1L,{('hello'),('goodbye')})"));
        expected.put("b", (Tuple)Util.getPigConstant("('b',0L,{('goodbye')})"));
        expected.put("c", (Tuple)Util.getPigConstant("('c',3L,{('hello'),('hello'),('hello')})"));
        expected.put("d", (Tuple)Util.getPigConstant("('d',0L,{('what')})"));
        int i = 0;
        while (it.hasNext()) {
            Tuple actual = (Tuple)it.next();
            TestRelationToExprProject.assertEquals(expected.get(actual.get(0)), (Object)actual);
            ++i;
        }
        TestRelationToExprProject.assertEquals((int)4, (int)i);
        Util.deleteFile(this.cluster, "filterbug.data");
    }

    @Test
    public void testFilterCount3() throws IOException, ParseException {
        Util.copyFromLocalToCluster(this.cluster, TEST_FILTER_COUNT3_INPUT, "testdata");
        String query = "TESTDATA =  load 'testdata' using PigStorage() as (timestamp:chararray, testid:chararray, userid: chararray, sessionid:chararray, value:long, flag:int);TESTDATA_FILTERED = filter TESTDATA by (timestamp gte '1230800400000' and timestamp lt '1230804000000' and value != 0);TESTDATA_GROUP = group TESTDATA_FILTERED by testid;TESTDATA_AGG = foreach TESTDATA_GROUP {                        A = filter TESTDATA_FILTERED by (userid eq sessionid);                        C = distinct A.userid;                        generate group as testid, COUNT(TESTDATA_FILTERED) as counttestdata, COUNT(C) as distcount, SUM(TESTDATA_FILTERED.flag) as total_flags;                }TESTDATA_AGG_1 = group TESTDATA_AGG ALL;TESTDATA_AGG_2 = foreach TESTDATA_AGG_1 generate COUNT(TESTDATA_AGG);";
        Util.registerMultiLineQuery(this.pigServer, query);
        Iterator it = this.pigServer.openIterator("TESTDATA_AGG_2");
        int i = 0;
        while (it.hasNext()) {
            Tuple actual = (Tuple)it.next();
            TestRelationToExprProject.assertEquals((Object)20L, (Object)actual.get(0));
            ++i;
        }
        TestRelationToExprProject.assertEquals((int)1, (int)i);
        Util.deleteFile(this.cluster, "testdata");
    }

    @Test
    public void testFilter1() throws IOException, ParseException {
        String[] inputData = new String[]{"1\t1\t3", "1\t2\t3", "2\t1\t3", "2\t1\t3", "3\t4\t4"};
        Util.createInputFile(this.cluster, "test.txt", inputData);
        String script = "test   = load 'test.txt' as (col1: int, col2: int, col3: int);test2 = group test by col1;test3 = foreach test2 {        filter_one    = filter test by (col2==1);        generate filter_one;};";
        Util.registerMultiLineQuery(this.pigServer, script);
        Iterator it = this.pigServer.openIterator("test3");
        HashMap<Tuple, Integer> expected = new HashMap<Tuple, Integer>();
        expected.put((Tuple)Util.getPigConstant("({(1,1,3)})"), 0);
        expected.put((Tuple)Util.getPigConstant("({(2,1,3),(2,1,3)})"), 0);
        Tuple t = TupleFactory.getInstance().newTuple();
        t.append((Object)BagFactory.getInstance().newDefaultBag());
        expected.put(t, 0);
        int i = 0;
        while (it.hasNext()) {
            if (i == 3) {
                TestRelationToExprProject.fail((String)"Got more tuples than expected!");
            }
            t = (Tuple)it.next();
            TestRelationToExprProject.assertTrue((boolean)expected.containsKey(t));
            int occurences = (Integer)expected.get(t);
            expected.put(t, ++occurences);
            ++i;
        }
        for (Integer occurences : expected.values()) {
            TestRelationToExprProject.assertEquals((Object)new Integer(1), (Object)occurences);
        }
        Util.deleteFile(this.cluster, "test.txt");
    }

    @Test
    public void testFilter2() throws IOException, ParseException {
        String[] inputData = new String[]{"1\t1\t3", "1\t2\t3", "2\t1\t3", "2\t1\t3", "3\t4\t4"};
        Util.createInputFile(this.cluster, "test.txt", inputData);
        String script = "test   = load 'test.txt' as (col1: int, col2: int, col3: int);test2 = group test by col1;test3 = foreach test2 {        filter_one    = filter test by (col2==1);        generate group, filter_one;};";
        Util.registerMultiLineQuery(this.pigServer, script);
        Iterator it = this.pigServer.openIterator("test3");
        HashMap<Tuple, Integer> expected = new HashMap<Tuple, Integer>();
        expected.put((Tuple)Util.getPigConstant("(1,{(1,1,3)})"), 0);
        expected.put((Tuple)Util.getPigConstant("(2,{(2,1,3),(2,1,3)})"), 0);
        Tuple t = TupleFactory.getInstance().newTuple();
        t.append((Object)new Integer(3));
        t.append((Object)BagFactory.getInstance().newDefaultBag());
        expected.put(t, 0);
        int i = 0;
        while (it.hasNext()) {
            if (i == 3) {
                TestRelationToExprProject.fail((String)"Got more tuples than expected!");
            }
            t = (Tuple)it.next();
            TestRelationToExprProject.assertTrue((boolean)expected.containsKey(t));
            int occurences = (Integer)expected.get(t);
            expected.put(t, ++occurences);
            ++i;
        }
        for (Integer occurences : expected.values()) {
            TestRelationToExprProject.assertEquals((Object)new Integer(1), (Object)occurences);
        }
        Util.deleteFile(this.cluster, "test.txt");
    }
}

