/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.util.List;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.builtin.PigStorage;
import org.apache.pig.impl.logicalLayer.LOCogroup;
import org.apache.pig.impl.logicalLayer.LOCross;
import org.apache.pig.impl.logicalLayer.LODistinct;
import org.apache.pig.impl.logicalLayer.LOFilter;
import org.apache.pig.impl.logicalLayer.LOForEach;
import org.apache.pig.impl.logicalLayer.LOJoin;
import org.apache.pig.impl.logicalLayer.LOLimit;
import org.apache.pig.impl.logicalLayer.LOLoad;
import org.apache.pig.impl.logicalLayer.LOSort;
import org.apache.pig.impl.logicalLayer.LOSplit;
import org.apache.pig.impl.logicalLayer.LOSplitOutput;
import org.apache.pig.impl.logicalLayer.LOStream;
import org.apache.pig.impl.logicalLayer.LOUnion;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.impl.plan.RequiredFields;
import org.apache.pig.impl.util.Pair;
import org.apache.pig.test.utils.LogicalPlanTester;
import org.junit.After;
import org.junit.Test;

public class TestRequiredFields
extends TestCase {
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    LogicalPlanTester planTester = new LogicalPlanTester();
    private static final String simpleEchoStreamingCommand = System.getProperty("os.name").toUpperCase().startsWith("WINDOWS") ? "perl -ne 'print \\\"$_\\\"'" : "perl -ne 'print \"$_\"'";

    @After
    public void tearDown() throws Exception {
        this.planTester.reset();
    }

    @Test
    public void testQueryForeach1() {
        String query = "foreach (load 'a') generate $1,$2;";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOLoad load = (LOLoad)lp.getRoots().get(0);
        List loadRequiredFields = load.getRequiredFields();
        TestRequiredFields.assertTrue((loadRequiredFields.size() == 1 ? 1 : 0) != 0);
        RequiredFields requiredField = (RequiredFields)loadRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        List foreachRequiredFields = foreach.getRequiredFields();
        TestRequiredFields.assertTrue((foreachRequiredFields.size() == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)foreachRequiredFields.get(0);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        List fields = requiredField.getFields();
        TestRequiredFields.assertTrue((fields.size() == 2 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).second == 1 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)1)).first == 0 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)1)).second == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testQueryForeach2() {
        String query = "foreach (load 'a' using " + PigStorage.class.getName() + "(':')) generate $1, 'aoeuaoeu' ;";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOLoad load = (LOLoad)lp.getRoots().get(0);
        List loadRequiredFields = load.getRequiredFields();
        TestRequiredFields.assertTrue((loadRequiredFields.size() == 1 ? 1 : 0) != 0);
        RequiredFields requiredField = (RequiredFields)loadRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        List foreachRequiredFields = foreach.getRequiredFields();
        TestRequiredFields.assertTrue((foreachRequiredFields.size() == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)foreachRequiredFields.get(0);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        List fields = requiredField.getFields();
        TestRequiredFields.assertTrue((fields.size() == 1 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).second == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testQueryCogroup1() {
        String query = "foreach (cogroup (load 'a') by $1, (load 'b') by $1) generate org.apache.pig.builtin.AVG($1) ;";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        List loadaRequiredFields = loada.getRequiredFields();
        TestRequiredFields.assertTrue((loadaRequiredFields.size() == 1 ? 1 : 0) != 0);
        RequiredFields requiredField = (RequiredFields)loadaRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOLoad loadb = (LOLoad)lp.getRoots().get(1);
        List loadbRequiredFields = loadb.getRequiredFields();
        TestRequiredFields.assertTrue((loadbRequiredFields.size() == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)loadbRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOCogroup cogroup = (LOCogroup)lp.getSuccessors((Operator)loada).get(0);
        List cogroupRequiredFields = cogroup.getRequiredFields();
        TestRequiredFields.assertTrue((cogroupRequiredFields.size() == 2 ? 1 : 0) != 0);
        requiredField = (RequiredFields)cogroupRequiredFields.get(0);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        List fields = requiredField.getFields();
        TestRequiredFields.assertTrue((fields.size() == 1 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).second == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)cogroupRequiredFields.get(1);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        fields = requiredField.getFields();
        TestRequiredFields.assertTrue((fields.size() == 1 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).first == 1 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).second == 1 ? 1 : 0) != 0);
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        List foreachRequiredFields = foreach.getRequiredFields();
        TestRequiredFields.assertTrue((foreachRequiredFields.size() == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)foreachRequiredFields.get(0);
        fields = requiredField.getFields();
        TestRequiredFields.assertTrue((fields.size() == 1 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).second == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testQueryGroupAll() throws Exception {
        String query = "foreach (group (load 'a') ALL) generate $1 ;";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        List loadaRequiredFields = loada.getRequiredFields();
        TestRequiredFields.assertTrue((loadaRequiredFields.size() == 1 ? 1 : 0) != 0);
        RequiredFields requiredField = (RequiredFields)loadaRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOCogroup cogroup = (LOCogroup)lp.getSuccessors((Operator)loada).get(0);
        List cogroupRequiredFields = cogroup.getRequiredFields();
        TestRequiredFields.assertTrue((cogroupRequiredFields.size() == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)cogroupRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        List foreachRequiredFields = foreach.getRequiredFields();
        TestRequiredFields.assertTrue((foreachRequiredFields.size() == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)foreachRequiredFields.get(0);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        List fields = requiredField.getFields();
        TestRequiredFields.assertTrue((fields.size() == 1 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).second == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testQueryGroup2() {
        String query = "foreach (group (load 'a') by $1) generate group, '1' ;";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        List loadaRequiredFields = loada.getRequiredFields();
        TestRequiredFields.assertTrue((loadaRequiredFields.size() == 1 ? 1 : 0) != 0);
        RequiredFields requiredField = (RequiredFields)loadaRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOCogroup cogroup = (LOCogroup)lp.getSuccessors((Operator)loada).get(0);
        List cogroupRequiredFields = cogroup.getRequiredFields();
        TestRequiredFields.assertTrue((cogroupRequiredFields.size() == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)cogroupRequiredFields.get(0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        List fields = requiredField.getFields();
        TestRequiredFields.assertTrue((fields.size() == 1 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).second == 1 ? 1 : 0) != 0);
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        List foreachRequiredFields = foreach.getRequiredFields();
        TestRequiredFields.assertTrue((foreachRequiredFields.size() == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)foreachRequiredFields.get(0);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        fields = requiredField.getFields();
        TestRequiredFields.assertTrue((fields.size() == 1 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).second == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testQueryCogroup2() {
        String query = "foreach (cogroup (load 'a') by ($1), (load 'b') by ($1)) generate $1.$1, $2.$1 ;";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        List loadaRequiredFields = loada.getRequiredFields();
        TestRequiredFields.assertTrue((loadaRequiredFields.size() == 1 ? 1 : 0) != 0);
        RequiredFields requiredField = (RequiredFields)loadaRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOLoad loadb = (LOLoad)lp.getRoots().get(1);
        List loadbRequiredFields = loadb.getRequiredFields();
        TestRequiredFields.assertTrue((loadbRequiredFields.size() == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)loadbRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOCogroup cogroup = (LOCogroup)lp.getSuccessors((Operator)loada).get(0);
        List cogroupRequiredFields = cogroup.getRequiredFields();
        TestRequiredFields.assertTrue((cogroupRequiredFields.size() == 2 ? 1 : 0) != 0);
        requiredField = (RequiredFields)cogroupRequiredFields.get(0);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        List fields = requiredField.getFields();
        TestRequiredFields.assertTrue((fields.size() == 1 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).second == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)cogroupRequiredFields.get(1);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        fields = requiredField.getFields();
        TestRequiredFields.assertTrue((fields.size() == 1 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).first == 1 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).second == 1 ? 1 : 0) != 0);
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        List foreachRequiredFields = foreach.getRequiredFields();
        TestRequiredFields.assertTrue((foreachRequiredFields.size() == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)foreachRequiredFields.get(0);
        fields = requiredField.getFields();
        TestRequiredFields.assertTrue((fields.size() == 2 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).second == 1 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)1)).first == 0 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)1)).second == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testQueryGroup3() {
        String query = "foreach (group (load 'a') by ($6, $7)) generate flatten(group) ;";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        List loadaRequiredFields = loada.getRequiredFields();
        TestRequiredFields.assertTrue((loadaRequiredFields.size() == 1 ? 1 : 0) != 0);
        RequiredFields requiredField = (RequiredFields)loadaRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOCogroup cogroup = (LOCogroup)lp.getSuccessors((Operator)loada).get(0);
        List cogroupRequiredFields = cogroup.getRequiredFields();
        TestRequiredFields.assertTrue((cogroupRequiredFields.size() == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)cogroupRequiredFields.get(0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        List fields = requiredField.getFields();
        TestRequiredFields.assertTrue((fields.size() == 2 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).second == 6 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)1)).first == 0 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)1)).second == 7 ? 1 : 0) != 0);
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        List foreachRequiredFields = foreach.getRequiredFields();
        TestRequiredFields.assertTrue((foreachRequiredFields.size() == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)foreachRequiredFields.get(0);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        fields = requiredField.getFields();
        TestRequiredFields.assertTrue((fields.size() == 1 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).second == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testQueryFilterNoSchema() {
        this.planTester.buildPlan("a = load 'a';");
        LogicalPlan lp = this.planTester.buildPlan("b = filter a by $1 == '3';");
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        List loadaRequiredFields = loada.getRequiredFields();
        TestRequiredFields.assertTrue((loadaRequiredFields.size() == 1 ? 1 : 0) != 0);
        RequiredFields requiredField = (RequiredFields)loadaRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOFilter filter = (LOFilter)lp.getSuccessors((Operator)loada).get(0);
        List filterRequiredFields = filter.getRequiredFields();
        TestRequiredFields.assertTrue((filterRequiredFields.size() == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)filterRequiredFields.get(0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        List fields = requiredField.getFields();
        TestRequiredFields.assertTrue((fields.size() == 1 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).second == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testQuerySplitNoSchema() {
        this.planTester.buildPlan("a = load 'a';");
        LogicalPlan lp = this.planTester.buildPlan("split a into b if $0 == '3', c if $1 == '3';");
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        List loadaRequiredFields = loada.getRequiredFields();
        TestRequiredFields.assertTrue((loadaRequiredFields.size() == 1 ? 1 : 0) != 0);
        RequiredFields requiredField = (RequiredFields)loadaRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOSplit split = (LOSplit)lp.getSuccessors((Operator)loada).get(0);
        List splitRequiredFields = split.getRequiredFields();
        TestRequiredFields.assertTrue((splitRequiredFields.size() == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)splitRequiredFields.get(0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOSplitOutput splitb = (LOSplitOutput)lp.getSuccessors((Operator)split).get(0);
        List splitbRequiredFields = splitb.getRequiredFields();
        TestRequiredFields.assertTrue((splitbRequiredFields.size() == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)splitbRequiredFields.get(0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        List fields = requiredField.getFields();
        TestRequiredFields.assertTrue((fields.size() == 1 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).second == 0 ? 1 : 0) != 0);
        LOSplitOutput splitc = (LOSplitOutput)lp.getSuccessors((Operator)split).get(1);
        List splitcRequiredFields = splitc.getRequiredFields();
        TestRequiredFields.assertTrue((splitcRequiredFields.size() == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)splitcRequiredFields.get(0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        fields = requiredField.getFields();
        TestRequiredFields.assertTrue((fields.size() == 1 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).second == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testQueryOrderByNoSchema() {
        this.planTester.buildPlan("a = load 'a';");
        LogicalPlan lp = this.planTester.buildPlan("b = order a by $1;");
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        List loadaRequiredFields = loada.getRequiredFields();
        TestRequiredFields.assertTrue((loadaRequiredFields.size() == 1 ? 1 : 0) != 0);
        RequiredFields requiredField = (RequiredFields)loadaRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOSort sort = (LOSort)lp.getSuccessors((Operator)loada).get(0);
        List sortRequiredFields = sort.getRequiredFields();
        TestRequiredFields.assertTrue((sortRequiredFields.size() == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)sortRequiredFields.get(0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        List fields = requiredField.getFields();
        TestRequiredFields.assertTrue((fields.size() == 1 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).second == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testQueryLimitNoSchema() {
        this.planTester.buildPlan("a = load 'a';");
        this.planTester.buildPlan("b = order a by $1;");
        LogicalPlan lp = this.planTester.buildPlan("c = limit b 10;");
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        List loadaRequiredFields = loada.getRequiredFields();
        TestRequiredFields.assertTrue((loadaRequiredFields.size() == 1 ? 1 : 0) != 0);
        RequiredFields requiredField = (RequiredFields)loadaRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOSort sort = (LOSort)lp.getSuccessors((Operator)loada).get(0);
        List sortRequiredFields = sort.getRequiredFields();
        TestRequiredFields.assertTrue((sortRequiredFields.size() == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)sortRequiredFields.get(0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        List fields = requiredField.getFields();
        TestRequiredFields.assertTrue((fields.size() == 1 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).second == 1 ? 1 : 0) != 0);
        LOLimit limit = (LOLimit)lp.getLeaves().get(0);
        List limitRequiredFields = limit.getRequiredFields();
        TestRequiredFields.assertTrue((limitRequiredFields.size() == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)limitRequiredFields.get(0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
    }

    @Test
    public void testQueryDistinctNoSchema() {
        this.planTester.buildPlan("a = load 'a';");
        LogicalPlan lp = this.planTester.buildPlan("b = distinct a;");
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        List loadaRequiredFields = loada.getRequiredFields();
        TestRequiredFields.assertTrue((loadaRequiredFields.size() == 1 ? 1 : 0) != 0);
        RequiredFields requiredField = (RequiredFields)loadaRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LODistinct distinct = (LODistinct)lp.getSuccessors((Operator)loada).get(0);
        List distinctRequiredFields = distinct.getRequiredFields();
        TestRequiredFields.assertTrue((distinctRequiredFields.size() == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)distinctRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
    }

    @Test
    public void testQueryStreamingNoSchema() {
        String query = "stream (load 'a') through `" + simpleEchoStreamingCommand + "`;";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        List loadaRequiredFields = loada.getRequiredFields();
        TestRequiredFields.assertTrue((loadaRequiredFields.size() == 1 ? 1 : 0) != 0);
        RequiredFields requiredField = (RequiredFields)loadaRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOStream stream = (LOStream)lp.getSuccessors((Operator)loada).get(0);
        List streamRequiredFields = stream.getRequiredFields();
        TestRequiredFields.assertTrue((streamRequiredFields.size() == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)streamRequiredFields.get(0);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
    }

    @Test
    public void testQueryStreamingNoSchema1() {
        String query = "stream (load 'a' as (url, hitCount)) through `" + simpleEchoStreamingCommand + "` ;";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        List loadaRequiredFields = loada.getRequiredFields();
        TestRequiredFields.assertTrue((loadaRequiredFields.size() == 1 ? 1 : 0) != 0);
        RequiredFields requiredField = (RequiredFields)loadaRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOStream stream = (LOStream)lp.getSuccessors((Operator)loada).get(0);
        List streamRequiredFields = stream.getRequiredFields();
        TestRequiredFields.assertTrue((streamRequiredFields.size() == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)streamRequiredFields.get(0);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
    }

    @Test
    public void testQueryForeach3() {
        String query = "foreach (load 'a') generate ($1 == '3'? $2 : $3) ;";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        List loadaRequiredFields = loada.getRequiredFields();
        TestRequiredFields.assertTrue((loadaRequiredFields.size() == 1 ? 1 : 0) != 0);
        RequiredFields requiredField = (RequiredFields)loadaRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        List foreachRequiredFields = foreach.getRequiredFields();
        TestRequiredFields.assertTrue((foreachRequiredFields.size() == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)foreachRequiredFields.get(0);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        List fields = requiredField.getFields();
        TestRequiredFields.assertTrue((fields.size() == 3 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).second == 1 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)1)).first == 0 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)1)).second == 2 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)2)).first == 0 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)2)).second == 3 ? 1 : 0) != 0);
    }

    @Test
    public void testQueryForeach4() {
        this.planTester.buildPlan("A = load 'a';");
        this.planTester.buildPlan("B = load 'b';");
        LogicalPlan lp = this.planTester.buildPlan("foreach (cogroup A by ($1), B by ($1)) generate A, flatten(B.($1, $2, $3));");
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        List loadaRequiredFields = loada.getRequiredFields();
        TestRequiredFields.assertTrue((loadaRequiredFields.size() == 1 ? 1 : 0) != 0);
        RequiredFields requiredField = (RequiredFields)loadaRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOLoad loadb = (LOLoad)lp.getRoots().get(1);
        List loadbRequiredFields = loadb.getRequiredFields();
        TestRequiredFields.assertTrue((loadbRequiredFields.size() == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)loadbRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOCogroup cogroup = (LOCogroup)lp.getSuccessors((Operator)loada).get(0);
        List cogroupRequiredFields = cogroup.getRequiredFields();
        TestRequiredFields.assertTrue((cogroupRequiredFields.size() == 2 ? 1 : 0) != 0);
        requiredField = (RequiredFields)cogroupRequiredFields.get(0);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        List fields = requiredField.getFields();
        TestRequiredFields.assertTrue((fields.size() == 1 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).second == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)cogroupRequiredFields.get(1);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        fields = requiredField.getFields();
        TestRequiredFields.assertTrue((fields.size() == 1 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).first == 1 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).second == 1 ? 1 : 0) != 0);
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        List foreachRequiredFields = foreach.getRequiredFields();
        TestRequiredFields.assertTrue((foreachRequiredFields.size() == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)foreachRequiredFields.get(0);
        fields = requiredField.getFields();
        TestRequiredFields.assertTrue((fields.size() == 2 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).second == 1 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)1)).first == 0 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)1)).second == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testForeach5() {
        this.planTester.buildPlan("A = load 'a';");
        this.planTester.buildPlan("B = load 'b';");
        this.planTester.buildPlan("C = cogroup A by ($1), B by ($1);");
        String query = "foreach C { B = order B by $0; generate FLATTEN(A), B.($1, $2, $3) ;};";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        List loadaRequiredFields = loada.getRequiredFields();
        TestRequiredFields.assertTrue((loadaRequiredFields.size() == 1 ? 1 : 0) != 0);
        RequiredFields requiredField = (RequiredFields)loadaRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOLoad loadb = (LOLoad)lp.getRoots().get(1);
        List loadbRequiredFields = loadb.getRequiredFields();
        TestRequiredFields.assertTrue((loadbRequiredFields.size() == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)loadbRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOCogroup cogroup = (LOCogroup)lp.getSuccessors((Operator)loada).get(0);
        List cogroupRequiredFields = cogroup.getRequiredFields();
        TestRequiredFields.assertTrue((cogroupRequiredFields.size() == 2 ? 1 : 0) != 0);
        requiredField = (RequiredFields)cogroupRequiredFields.get(0);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        List fields = requiredField.getFields();
        TestRequiredFields.assertTrue((fields.size() == 1 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).second == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)cogroupRequiredFields.get(1);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        fields = requiredField.getFields();
        TestRequiredFields.assertTrue((fields.size() == 1 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).first == 1 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).second == 1 ? 1 : 0) != 0);
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        List foreachRequiredFields = foreach.getRequiredFields();
        TestRequiredFields.assertTrue((foreachRequiredFields.size() == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)foreachRequiredFields.get(0);
        fields = requiredField.getFields();
        TestRequiredFields.assertTrue((fields.size() == 2 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).second == 1 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)1)).first == 0 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)1)).second == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testQueryCrossNoSchema() {
        String query = "c = cross (load 'a'), (load 'b');";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        List loadaRequiredFields = loada.getRequiredFields();
        TestRequiredFields.assertTrue((loadaRequiredFields.size() == 1 ? 1 : 0) != 0);
        RequiredFields requiredField = (RequiredFields)loadaRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOLoad loadb = (LOLoad)lp.getRoots().get(1);
        List loadbRequiredFields = loadb.getRequiredFields();
        TestRequiredFields.assertTrue((loadbRequiredFields.size() == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)loadbRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOCross cross = (LOCross)lp.getSuccessors((Operator)loada).get(0);
        List crossRequiredFields = cross.getRequiredFields();
        TestRequiredFields.assertTrue((crossRequiredFields.size() == 2 ? 1 : 0) != 0);
        requiredField = (RequiredFields)crossRequiredFields.get(0);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        requiredField = (RequiredFields)crossRequiredFields.get(1);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
    }

    @Test
    public void testQueryUnionNoSchema() {
        String query = "c = union (load 'a'), (load 'b');";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        List loadaRequiredFields = loada.getRequiredFields();
        TestRequiredFields.assertTrue((loadaRequiredFields.size() == 1 ? 1 : 0) != 0);
        RequiredFields requiredField = (RequiredFields)loadaRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOLoad loadb = (LOLoad)lp.getRoots().get(1);
        List loadbRequiredFields = loadb.getRequiredFields();
        TestRequiredFields.assertTrue((loadbRequiredFields.size() == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)loadbRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOUnion union = (LOUnion)lp.getSuccessors((Operator)loada).get(0);
        List unionRequiredFields = union.getRequiredFields();
        TestRequiredFields.assertTrue((unionRequiredFields.size() == 2 ? 1 : 0) != 0);
        requiredField = (RequiredFields)unionRequiredFields.get(0);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        requiredField = (RequiredFields)unionRequiredFields.get(1);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
    }

    @Test
    public void testQueryFRJoinNoSchema() {
        String query = "c = join (load 'a') by $0, (load 'b') by $0 using \"replicated\";";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        List loadaRequiredFields = loada.getRequiredFields();
        TestRequiredFields.assertTrue((loadaRequiredFields.size() == 1 ? 1 : 0) != 0);
        RequiredFields requiredField = (RequiredFields)loadaRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOLoad loadb = (LOLoad)lp.getRoots().get(1);
        List loadbRequiredFields = loadb.getRequiredFields();
        TestRequiredFields.assertTrue((loadbRequiredFields.size() == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)loadbRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOJoin frjoin = (LOJoin)lp.getSuccessors((Operator)loada).get(0);
        List frjoinRequiredFields = frjoin.getRequiredFields();
        TestRequiredFields.assertTrue((frjoinRequiredFields.size() == 2 ? 1 : 0) != 0);
        requiredField = (RequiredFields)frjoinRequiredFields.get(0);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        List fields = requiredField.getFields();
        TestRequiredFields.assertTrue((fields.size() == 1 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).second == 0 ? 1 : 0) != 0);
        requiredField = (RequiredFields)frjoinRequiredFields.get(1);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        fields = requiredField.getFields();
        TestRequiredFields.assertTrue((fields.size() == 1 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).first == 1 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).second == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testQueryJoinNoSchema() {
        String query = "c = join (load 'a') by $0, (load 'b') by $0;";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        List loadaRequiredFields = loada.getRequiredFields();
        TestRequiredFields.assertTrue((loadaRequiredFields.size() == 1 ? 1 : 0) != 0);
        RequiredFields requiredField = (RequiredFields)loadaRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOLoad loadb = (LOLoad)lp.getRoots().get(1);
        List loadbRequiredFields = loadb.getRequiredFields();
        TestRequiredFields.assertTrue((loadbRequiredFields.size() == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)loadbRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOJoin join = (LOJoin)lp.getSuccessors((Operator)loada).get(0);
        List joinRequiredFields = join.getRequiredFields();
        TestRequiredFields.assertTrue((joinRequiredFields.size() == 2 ? 1 : 0) != 0);
        requiredField = (RequiredFields)joinRequiredFields.get(0);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        List fields = requiredField.getFields();
        TestRequiredFields.assertTrue((fields.size() == 1 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).second == 0 ? 1 : 0) != 0);
        requiredField = (RequiredFields)joinRequiredFields.get(1);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        fields = requiredField.getFields();
        TestRequiredFields.assertTrue((fields.size() == 1 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).first == 1 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).second == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testQueryFilterWithSchema() {
        this.planTester.buildPlan("a = load 'a' as (url,hitCount);");
        LogicalPlan lp = this.planTester.buildPlan("b = filter a by $1 == '3';");
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        List loadaRequiredFields = loada.getRequiredFields();
        TestRequiredFields.assertTrue((loadaRequiredFields.size() == 1 ? 1 : 0) != 0);
        RequiredFields requiredField = (RequiredFields)loadaRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOFilter filter = (LOFilter)lp.getSuccessors((Operator)loada).get(0);
        List filterRequiredFields = filter.getRequiredFields();
        TestRequiredFields.assertTrue((filterRequiredFields.size() == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)filterRequiredFields.get(0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        List fields = requiredField.getFields();
        TestRequiredFields.assertTrue((fields.size() == 1 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).second == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testQuerySplitWithSchema() {
        this.planTester.buildPlan("a = load 'a' as (url, hitCount);");
        LogicalPlan lp = this.planTester.buildPlan("split a into b if url == '3', c if hitCount == '3';");
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        List loadaRequiredFields = loada.getRequiredFields();
        TestRequiredFields.assertTrue((loadaRequiredFields.size() == 1 ? 1 : 0) != 0);
        RequiredFields requiredField = (RequiredFields)loadaRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOSplit split = (LOSplit)lp.getSuccessors((Operator)loada).get(0);
        List splitRequiredFields = split.getRequiredFields();
        TestRequiredFields.assertTrue((splitRequiredFields.size() == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)splitRequiredFields.get(0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOSplitOutput splitb = (LOSplitOutput)lp.getSuccessors((Operator)split).get(0);
        List splitbRequiredFields = splitb.getRequiredFields();
        TestRequiredFields.assertTrue((splitbRequiredFields.size() == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)splitbRequiredFields.get(0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        List fields = requiredField.getFields();
        TestRequiredFields.assertTrue((fields.size() == 1 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).second == 0 ? 1 : 0) != 0);
        LOSplitOutput splitc = (LOSplitOutput)lp.getSuccessors((Operator)split).get(1);
        List splitcRequiredFields = splitc.getRequiredFields();
        TestRequiredFields.assertTrue((splitcRequiredFields.size() == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)splitcRequiredFields.get(0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        fields = requiredField.getFields();
        TestRequiredFields.assertTrue((fields.size() == 1 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).second == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testQueryOrderByWithSchema() {
        this.planTester.buildPlan("a = load 'a' as (url,hitCount);");
        LogicalPlan lp = this.planTester.buildPlan("b = order a by $1;");
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        List loadaRequiredFields = loada.getRequiredFields();
        TestRequiredFields.assertTrue((loadaRequiredFields.size() == 1 ? 1 : 0) != 0);
        RequiredFields requiredField = (RequiredFields)loadaRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOSort sort = (LOSort)lp.getSuccessors((Operator)loada).get(0);
        List sortRequiredFields = sort.getRequiredFields();
        TestRequiredFields.assertTrue((sortRequiredFields.size() == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)sortRequiredFields.get(0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        List fields = requiredField.getFields();
        TestRequiredFields.assertTrue((fields.size() == 1 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).second == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testQueryLimitWithSchema() {
        this.planTester.buildPlan("a = load 'a' as (url,hitCount);");
        this.planTester.buildPlan("b = order a by $1;");
        LogicalPlan lp = this.planTester.buildPlan("c = limit b 10;");
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        List loadaRequiredFields = loada.getRequiredFields();
        TestRequiredFields.assertTrue((loadaRequiredFields.size() == 1 ? 1 : 0) != 0);
        RequiredFields requiredField = (RequiredFields)loadaRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOSort sort = (LOSort)lp.getSuccessors((Operator)loada).get(0);
        List sortRequiredFields = sort.getRequiredFields();
        TestRequiredFields.assertTrue((sortRequiredFields.size() == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)sortRequiredFields.get(0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        List fields = requiredField.getFields();
        TestRequiredFields.assertTrue((fields.size() == 1 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).second == 1 ? 1 : 0) != 0);
        LOLimit limit = (LOLimit)lp.getLeaves().get(0);
        List limitRequiredFields = limit.getRequiredFields();
        TestRequiredFields.assertTrue((limitRequiredFields.size() == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)limitRequiredFields.get(0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
    }

    @Test
    public void testQueryDistinctWithSchema() {
        this.planTester.buildPlan("a = load 'a' as (url,hitCount);");
        LogicalPlan lp = this.planTester.buildPlan("b = distinct a;");
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        List loadaRequiredFields = loada.getRequiredFields();
        TestRequiredFields.assertTrue((loadaRequiredFields.size() == 1 ? 1 : 0) != 0);
        RequiredFields requiredField = (RequiredFields)loadaRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LODistinct distinct = (LODistinct)lp.getSuccessors((Operator)loada).get(0);
        List distinctRequiredFields = distinct.getRequiredFields();
        TestRequiredFields.assertTrue((distinctRequiredFields.size() == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)distinctRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
    }

    @Test
    public void testQueryStreamingWithSchema() {
        String query = "stream (load 'a') through `" + simpleEchoStreamingCommand + "` as (x, y);";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        List loadaRequiredFields = loada.getRequiredFields();
        TestRequiredFields.assertTrue((loadaRequiredFields.size() == 1 ? 1 : 0) != 0);
        RequiredFields requiredField = (RequiredFields)loadaRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOStream stream = (LOStream)lp.getSuccessors((Operator)loada).get(0);
        List streamRequiredFields = stream.getRequiredFields();
        TestRequiredFields.assertTrue((streamRequiredFields.size() == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)streamRequiredFields.get(0);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
    }

    @Test
    public void testQueryStreamingWithSchema1() {
        String query = "stream (load 'a' as (url, hitCount)) through `" + simpleEchoStreamingCommand + "` as (x, y);";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        List loadaRequiredFields = loada.getRequiredFields();
        TestRequiredFields.assertTrue((loadaRequiredFields.size() == 1 ? 1 : 0) != 0);
        RequiredFields requiredField = (RequiredFields)loadaRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOStream stream = (LOStream)lp.getSuccessors((Operator)loada).get(0);
        List streamRequiredFields = stream.getRequiredFields();
        TestRequiredFields.assertTrue((streamRequiredFields.size() == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)streamRequiredFields.get(0);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
    }

    @Test
    public void testQueryImplicitJoinWithSchema() {
        this.planTester.buildPlan("a = load 'a' as (url,hitCount);");
        this.planTester.buildPlan("b = load 'b' as (url,rank);");
        this.planTester.buildPlan("c = cogroup a by url, b by url;");
        LogicalPlan lp = this.planTester.buildPlan("d = foreach c generate group,flatten(a),flatten(b);");
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        List loadaRequiredFields = loada.getRequiredFields();
        TestRequiredFields.assertTrue((loadaRequiredFields.size() == 1 ? 1 : 0) != 0);
        RequiredFields requiredField = (RequiredFields)loadaRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOLoad loadb = (LOLoad)lp.getRoots().get(1);
        List loadbRequiredFields = loadb.getRequiredFields();
        TestRequiredFields.assertTrue((loadbRequiredFields.size() == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)loadbRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOCogroup cogroup = (LOCogroup)lp.getSuccessors((Operator)loada).get(0);
        List cogroupRequiredFields = cogroup.getRequiredFields();
        TestRequiredFields.assertTrue((cogroupRequiredFields.size() == 2 ? 1 : 0) != 0);
        requiredField = (RequiredFields)cogroupRequiredFields.get(0);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        List fields = requiredField.getFields();
        TestRequiredFields.assertTrue((fields.size() == 1 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).second == 0 ? 1 : 0) != 0);
        requiredField = (RequiredFields)cogroupRequiredFields.get(1);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        fields = requiredField.getFields();
        TestRequiredFields.assertTrue((fields.size() == 1 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).first == 1 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).second == 0 ? 1 : 0) != 0);
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        List foreachRequiredFields = foreach.getRequiredFields();
        TestRequiredFields.assertTrue((foreachRequiredFields.size() == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)foreachRequiredFields.get(0);
        fields = requiredField.getFields();
        TestRequiredFields.assertTrue((fields.size() == 3 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).second == 0 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)1)).first == 0 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)1)).second == 1 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)2)).first == 0 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)2)).second == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testQueryCrossWithSchema() {
        String query = "c = cross (load 'a' as (url, hitcount)), (load 'b' as (url, rank));";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        List loadaRequiredFields = loada.getRequiredFields();
        TestRequiredFields.assertTrue((loadaRequiredFields.size() == 1 ? 1 : 0) != 0);
        RequiredFields requiredField = (RequiredFields)loadaRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOLoad loadb = (LOLoad)lp.getRoots().get(1);
        List loadbRequiredFields = loadb.getRequiredFields();
        TestRequiredFields.assertTrue((loadbRequiredFields.size() == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)loadbRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOCross cross = (LOCross)lp.getSuccessors((Operator)loada).get(0);
        List crossRequiredFields = cross.getRequiredFields();
        TestRequiredFields.assertTrue((crossRequiredFields.size() == 2 ? 1 : 0) != 0);
        requiredField = (RequiredFields)crossRequiredFields.get(0);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        requiredField = (RequiredFields)crossRequiredFields.get(1);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
    }

    @Test
    public void testQueryUnionWithSchema() {
        String query = "c = union (load 'a' as (url, hitcount)), (load 'b' as (url, rank));";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        List loadaRequiredFields = loada.getRequiredFields();
        TestRequiredFields.assertTrue((loadaRequiredFields.size() == 1 ? 1 : 0) != 0);
        RequiredFields requiredField = (RequiredFields)loadaRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOLoad loadb = (LOLoad)lp.getRoots().get(1);
        List loadbRequiredFields = loadb.getRequiredFields();
        TestRequiredFields.assertTrue((loadbRequiredFields.size() == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)loadbRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOUnion union = (LOUnion)lp.getSuccessors((Operator)loada).get(0);
        List unionRequiredFields = union.getRequiredFields();
        TestRequiredFields.assertTrue((unionRequiredFields.size() == 2 ? 1 : 0) != 0);
        requiredField = (RequiredFields)unionRequiredFields.get(0);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        requiredField = (RequiredFields)unionRequiredFields.get(1);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
    }

    @Test
    public void testQueryFRJoinWithSchema() {
        String query = "c = join (load 'a' as (url, hitcount)) by $0, (load 'b' as (url, rank)) by $0 using \"replicated\";";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        List loadaRequiredFields = loada.getRequiredFields();
        TestRequiredFields.assertTrue((loadaRequiredFields.size() == 1 ? 1 : 0) != 0);
        RequiredFields requiredField = (RequiredFields)loadaRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOLoad loadb = (LOLoad)lp.getRoots().get(1);
        List loadbRequiredFields = loadb.getRequiredFields();
        TestRequiredFields.assertTrue((loadbRequiredFields.size() == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)loadbRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOJoin frjoin = (LOJoin)lp.getSuccessors((Operator)loada).get(0);
        List frjoinRequiredFields = frjoin.getRequiredFields();
        TestRequiredFields.assertTrue((frjoinRequiredFields.size() == 2 ? 1 : 0) != 0);
        requiredField = (RequiredFields)frjoinRequiredFields.get(0);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        List fields = requiredField.getFields();
        TestRequiredFields.assertTrue((fields.size() == 1 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).second == 0 ? 1 : 0) != 0);
        requiredField = (RequiredFields)frjoinRequiredFields.get(1);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        fields = requiredField.getFields();
        TestRequiredFields.assertTrue((fields.size() == 1 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).first == 1 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).second == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testQueryJoinWithSchema() {
        String query = "c = join (load 'a' as (url, hitcount)) by $0, (load 'b' as (url, rank)) by $0;";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        List loadaRequiredFields = loada.getRequiredFields();
        TestRequiredFields.assertTrue((loadaRequiredFields.size() == 1 ? 1 : 0) != 0);
        RequiredFields requiredField = (RequiredFields)loadaRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOLoad loadb = (LOLoad)lp.getRoots().get(1);
        List loadbRequiredFields = loadb.getRequiredFields();
        TestRequiredFields.assertTrue((loadbRequiredFields.size() == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)loadbRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOJoin join = (LOJoin)lp.getSuccessors((Operator)loada).get(0);
        List joinRequiredFields = join.getRequiredFields();
        TestRequiredFields.assertTrue((joinRequiredFields.size() == 2 ? 1 : 0) != 0);
        requiredField = (RequiredFields)joinRequiredFields.get(0);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        List fields = requiredField.getFields();
        TestRequiredFields.assertTrue((fields.size() == 1 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).second == 0 ? 1 : 0) != 0);
        requiredField = (RequiredFields)joinRequiredFields.get(1);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        fields = requiredField.getFields();
        TestRequiredFields.assertTrue((fields.size() == 1 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).first == 1 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).second == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testQueryCrossWithMixedSchema() {
        String query = "c = cross (load 'a' as (url, hitcount)), (load 'b');";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        List loadaRequiredFields = loada.getRequiredFields();
        TestRequiredFields.assertTrue((loadaRequiredFields.size() == 1 ? 1 : 0) != 0);
        RequiredFields requiredField = (RequiredFields)loadaRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOLoad loadb = (LOLoad)lp.getRoots().get(1);
        List loadbRequiredFields = loadb.getRequiredFields();
        TestRequiredFields.assertTrue((loadbRequiredFields.size() == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)loadbRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOCross cross = (LOCross)lp.getSuccessors((Operator)loada).get(0);
        List crossRequiredFields = cross.getRequiredFields();
        TestRequiredFields.assertTrue((crossRequiredFields.size() == 2 ? 1 : 0) != 0);
        requiredField = (RequiredFields)crossRequiredFields.get(0);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        requiredField = (RequiredFields)crossRequiredFields.get(1);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
    }

    @Test
    public void testQueryUnionWithMixedSchema() {
        String query = "c = union (load 'a' as (url, hitcount)), (load 'b');";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        List loadaRequiredFields = loada.getRequiredFields();
        TestRequiredFields.assertTrue((loadaRequiredFields.size() == 1 ? 1 : 0) != 0);
        RequiredFields requiredField = (RequiredFields)loadaRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOLoad loadb = (LOLoad)lp.getRoots().get(1);
        List loadbRequiredFields = loadb.getRequiredFields();
        TestRequiredFields.assertTrue((loadbRequiredFields.size() == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)loadbRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOUnion union = (LOUnion)lp.getSuccessors((Operator)loada).get(0);
        List unionRequiredFields = union.getRequiredFields();
        TestRequiredFields.assertTrue((unionRequiredFields.size() == 2 ? 1 : 0) != 0);
        requiredField = (RequiredFields)unionRequiredFields.get(0);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        requiredField = (RequiredFields)unionRequiredFields.get(1);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
    }

    @Test
    public void testQueryFRJoinWithMixedSchema() {
        String query = "c = join (load 'a' as (url, hitcount)) by $0, (load 'b') by $0 using \"replicated\";";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        List loadaRequiredFields = loada.getRequiredFields();
        TestRequiredFields.assertTrue((loadaRequiredFields.size() == 1 ? 1 : 0) != 0);
        RequiredFields requiredField = (RequiredFields)loadaRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOLoad loadb = (LOLoad)lp.getRoots().get(1);
        List loadbRequiredFields = loadb.getRequiredFields();
        TestRequiredFields.assertTrue((loadbRequiredFields.size() == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)loadbRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOJoin frjoin = (LOJoin)lp.getSuccessors((Operator)loada).get(0);
        List frjoinRequiredFields = frjoin.getRequiredFields();
        TestRequiredFields.assertTrue((frjoinRequiredFields.size() == 2 ? 1 : 0) != 0);
        requiredField = (RequiredFields)frjoinRequiredFields.get(0);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        List fields = requiredField.getFields();
        TestRequiredFields.assertTrue((fields.size() == 1 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).second == 0 ? 1 : 0) != 0);
        requiredField = (RequiredFields)frjoinRequiredFields.get(1);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        fields = requiredField.getFields();
        TestRequiredFields.assertTrue((fields.size() == 1 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).first == 1 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).second == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testQueryJoinWithMixedSchema() {
        String query = "c = join (load 'a' as (url, hitcount)) by $0, (load 'b') by $0;";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        List loadaRequiredFields = loada.getRequiredFields();
        TestRequiredFields.assertTrue((loadaRequiredFields.size() == 1 ? 1 : 0) != 0);
        RequiredFields requiredField = (RequiredFields)loadaRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOLoad loadb = (LOLoad)lp.getRoots().get(1);
        List loadbRequiredFields = loadb.getRequiredFields();
        TestRequiredFields.assertTrue((loadbRequiredFields.size() == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)loadbRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOJoin join = (LOJoin)lp.getSuccessors((Operator)loada).get(0);
        List joinRequiredFields = join.getRequiredFields();
        TestRequiredFields.assertTrue((joinRequiredFields.size() == 2 ? 1 : 0) != 0);
        requiredField = (RequiredFields)joinRequiredFields.get(0);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        List fields = requiredField.getFields();
        TestRequiredFields.assertTrue((fields.size() == 1 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).second == 0 ? 1 : 0) != 0);
        requiredField = (RequiredFields)joinRequiredFields.get(1);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        fields = requiredField.getFields();
        TestRequiredFields.assertTrue((fields.size() == 1 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).first == 1 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).second == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testQueryFilterWithStarNoSchema() {
        this.planTester.buildPlan("a = load 'a';");
        LogicalPlan lp = this.planTester.buildPlan("b = filter a by COUNT(*) == 3;");
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        List loadaRequiredFields = loada.getRequiredFields();
        TestRequiredFields.assertTrue((loadaRequiredFields.size() == 1 ? 1 : 0) != 0);
        RequiredFields requiredField = (RequiredFields)loadaRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOFilter filter = (LOFilter)lp.getSuccessors((Operator)loada).get(0);
        List filterRequiredFields = filter.getRequiredFields();
        TestRequiredFields.assertTrue((filterRequiredFields.size() == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)filterRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
    }

    @Test
    public void testQueryOrderByStarNoSchema() {
        this.planTester.buildPlan("a = load 'a';");
        LogicalPlan lp = this.planTester.buildPlan("b = order a by *;");
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        List loadaRequiredFields = loada.getRequiredFields();
        TestRequiredFields.assertTrue((loadaRequiredFields.size() == 1 ? 1 : 0) != 0);
        RequiredFields requiredField = (RequiredFields)loadaRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOSort sort = (LOSort)lp.getSuccessors((Operator)loada).get(0);
        List sortRequiredFields = sort.getRequiredFields();
        TestRequiredFields.assertTrue((sortRequiredFields.size() == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)sortRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
    }

    @Test
    public void testQueryGroupByStarNoSchema() throws Exception {
        String query = "foreach (group (load 'a') by *) generate $1 ;";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        List loadaRequiredFields = loada.getRequiredFields();
        TestRequiredFields.assertTrue((loadaRequiredFields.size() == 1 ? 1 : 0) != 0);
        RequiredFields requiredField = (RequiredFields)loadaRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOCogroup cogroup = (LOCogroup)lp.getSuccessors((Operator)loada).get(0);
        List cogroupRequiredFields = cogroup.getRequiredFields();
        TestRequiredFields.assertTrue((cogroupRequiredFields.size() == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)cogroupRequiredFields.get(0);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        List foreachRequiredFields = foreach.getRequiredFields();
        TestRequiredFields.assertTrue((foreachRequiredFields.size() == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)foreachRequiredFields.get(0);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        List fields = requiredField.getFields();
        TestRequiredFields.assertTrue((fields.size() == 1 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).second == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testQueryFRJoinOnStarNoSchema() {
        String query = "c = join (load 'a') by *, (load 'b') by * using \"replicated\";";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        List loadaRequiredFields = loada.getRequiredFields();
        TestRequiredFields.assertTrue((loadaRequiredFields.size() == 1 ? 1 : 0) != 0);
        RequiredFields requiredField = (RequiredFields)loadaRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOLoad loadb = (LOLoad)lp.getRoots().get(1);
        List loadbRequiredFields = loadb.getRequiredFields();
        TestRequiredFields.assertTrue((loadbRequiredFields.size() == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)loadbRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOJoin frjoin = (LOJoin)lp.getSuccessors((Operator)loada).get(0);
        List frjoinRequiredFields = frjoin.getRequiredFields();
        TestRequiredFields.assertTrue((frjoinRequiredFields.size() == 2 ? 1 : 0) != 0);
        requiredField = (RequiredFields)frjoinRequiredFields.get(0);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        requiredField = (RequiredFields)frjoinRequiredFields.get(1);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
    }

    @Test
    public void testQueryJoinOnStarNoSchema() {
        String query = "c = join (load 'a') by *, (load 'b') by *;";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        List loadaRequiredFields = loada.getRequiredFields();
        TestRequiredFields.assertTrue((loadaRequiredFields.size() == 1 ? 1 : 0) != 0);
        RequiredFields requiredField = (RequiredFields)loadaRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOLoad loadb = (LOLoad)lp.getRoots().get(1);
        List loadbRequiredFields = loadb.getRequiredFields();
        TestRequiredFields.assertTrue((loadbRequiredFields.size() == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)loadbRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOJoin join = (LOJoin)lp.getSuccessors((Operator)loada).get(0);
        List joinRequiredFields = join.getRequiredFields();
        TestRequiredFields.assertTrue((joinRequiredFields.size() == 2 ? 1 : 0) != 0);
        requiredField = (RequiredFields)joinRequiredFields.get(0);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        requiredField = (RequiredFields)joinRequiredFields.get(1);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
    }

    @Test
    public void testQueryFilterStarWithSchema() {
        this.planTester.buildPlan("a = load 'a' as (url,hitCount);");
        LogicalPlan lp = this.planTester.buildPlan("b = filter a by COUNT(*) == 3;");
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        List loadaRequiredFields = loada.getRequiredFields();
        TestRequiredFields.assertTrue((loadaRequiredFields.size() == 1 ? 1 : 0) != 0);
        RequiredFields requiredField = (RequiredFields)loadaRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOFilter filter = (LOFilter)lp.getSuccessors((Operator)loada).get(0);
        List filterRequiredFields = filter.getRequiredFields();
        TestRequiredFields.assertTrue((filterRequiredFields.size() == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)filterRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
    }

    @Test
    public void testQuerySplitWithStarSchema() {
        this.planTester.buildPlan("a = load 'a' as (url, hitCount);");
        LogicalPlan lp = this.planTester.buildPlan("split a into b if url == '3', c if COUNT(*) == '3';");
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        List loadaRequiredFields = loada.getRequiredFields();
        TestRequiredFields.assertTrue((loadaRequiredFields.size() == 1 ? 1 : 0) != 0);
        RequiredFields requiredField = (RequiredFields)loadaRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOSplit split = (LOSplit)lp.getSuccessors((Operator)loada).get(0);
        List splitRequiredFields = split.getRequiredFields();
        TestRequiredFields.assertTrue((splitRequiredFields.size() == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)splitRequiredFields.get(0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOSplitOutput splitb = (LOSplitOutput)lp.getSuccessors((Operator)split).get(0);
        List splitbRequiredFields = splitb.getRequiredFields();
        TestRequiredFields.assertTrue((splitbRequiredFields.size() == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)splitbRequiredFields.get(0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        List fields = requiredField.getFields();
        TestRequiredFields.assertTrue((fields.size() == 1 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).second == 0 ? 1 : 0) != 0);
        LOSplitOutput splitc = (LOSplitOutput)lp.getSuccessors((Operator)split).get(1);
        List splitcRequiredFields = splitc.getRequiredFields();
        TestRequiredFields.assertTrue((splitcRequiredFields.size() == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)splitcRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
    }

    @Test
    public void testQueryOrderByStarWithSchema() {
        this.planTester.buildPlan("a = load 'a' as (url,hitCount);");
        LogicalPlan lp = this.planTester.buildPlan("b = order a by *;");
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        List loadaRequiredFields = loada.getRequiredFields();
        TestRequiredFields.assertTrue((loadaRequiredFields.size() == 1 ? 1 : 0) != 0);
        RequiredFields requiredField = (RequiredFields)loadaRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOSort sort = (LOSort)lp.getSuccessors((Operator)loada).get(0);
        List sortRequiredFields = sort.getRequiredFields();
        TestRequiredFields.assertTrue((sortRequiredFields.size() == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)sortRequiredFields.get(0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        List fields = requiredField.getFields();
        TestRequiredFields.assertTrue((fields.size() == 2 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).second == 0 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)1)).first == 0 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)1)).second == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testQueryGroupByStarWithSchema() throws Exception {
        String query = "foreach (group (load 'a' as (url, hitCount)) by *) generate $1 ;";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        List loadaRequiredFields = loada.getRequiredFields();
        TestRequiredFields.assertTrue((loadaRequiredFields.size() == 1 ? 1 : 0) != 0);
        RequiredFields requiredField = (RequiredFields)loadaRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOCogroup cogroup = (LOCogroup)lp.getSuccessors((Operator)loada).get(0);
        List cogroupRequiredFields = cogroup.getRequiredFields();
        TestRequiredFields.assertTrue((cogroupRequiredFields.size() == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)cogroupRequiredFields.get(0);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        List fields = requiredField.getFields();
        TestRequiredFields.assertTrue((fields.size() == 2 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).second == 0 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)1)).first == 0 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)1)).second == 1 ? 1 : 0) != 0);
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        List foreachRequiredFields = foreach.getRequiredFields();
        TestRequiredFields.assertTrue((foreachRequiredFields.size() == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)foreachRequiredFields.get(0);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        fields = requiredField.getFields();
        TestRequiredFields.assertTrue((fields.size() == 1 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).second == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testQueryFRJoinOnStarWithSchema() {
        String query = "c = join (load 'a' as (url, hitcount)) by *, (load 'b' as (url, rank)) by * using \"replicated\";";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        List loadaRequiredFields = loada.getRequiredFields();
        TestRequiredFields.assertTrue((loadaRequiredFields.size() == 1 ? 1 : 0) != 0);
        RequiredFields requiredField = (RequiredFields)loadaRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOLoad loadb = (LOLoad)lp.getRoots().get(1);
        List loadbRequiredFields = loadb.getRequiredFields();
        TestRequiredFields.assertTrue((loadbRequiredFields.size() == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)loadbRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOJoin frjoin = (LOJoin)lp.getSuccessors((Operator)loada).get(0);
        List frjoinRequiredFields = frjoin.getRequiredFields();
        TestRequiredFields.assertTrue((frjoinRequiredFields.size() == 2 ? 1 : 0) != 0);
        requiredField = (RequiredFields)frjoinRequiredFields.get(0);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        List fields = requiredField.getFields();
        TestRequiredFields.assertTrue((fields.size() == 2 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).second == 0 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)1)).first == 0 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)1)).second == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)frjoinRequiredFields.get(1);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        fields = requiredField.getFields();
        TestRequiredFields.assertTrue((fields.size() == 2 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).first == 1 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).second == 0 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)1)).first == 1 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)1)).second == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testQueryJoinOnStarWithSchema() {
        String query = "c = join (load 'a' as (url, hitcount)) by *, (load 'b' as (url, rank)) by *;";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        List loadaRequiredFields = loada.getRequiredFields();
        TestRequiredFields.assertTrue((loadaRequiredFields.size() == 1 ? 1 : 0) != 0);
        RequiredFields requiredField = (RequiredFields)loadaRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOLoad loadb = (LOLoad)lp.getRoots().get(1);
        List loadbRequiredFields = loadb.getRequiredFields();
        TestRequiredFields.assertTrue((loadbRequiredFields.size() == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)loadbRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOJoin join = (LOJoin)lp.getSuccessors((Operator)loada).get(0);
        List joinRequiredFields = join.getRequiredFields();
        TestRequiredFields.assertTrue((joinRequiredFields.size() == 2 ? 1 : 0) != 0);
        requiredField = (RequiredFields)joinRequiredFields.get(0);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        List fields = requiredField.getFields();
        TestRequiredFields.assertTrue((fields.size() == 2 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).second == 0 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)1)).first == 0 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)1)).second == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)joinRequiredFields.get(1);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        fields = requiredField.getFields();
        TestRequiredFields.assertTrue((fields.size() == 2 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).first == 1 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).second == 0 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)1)).first == 1 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)1)).second == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testQueryForeachGenerateStarNoSchema() {
        String query = "foreach (load 'a') generate * ;";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        List loadaRequiredFields = loada.getRequiredFields();
        TestRequiredFields.assertTrue((loadaRequiredFields.size() == 1 ? 1 : 0) != 0);
        RequiredFields requiredField = (RequiredFields)loadaRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        List foreachRequiredFields = foreach.getRequiredFields();
        TestRequiredFields.assertTrue((foreachRequiredFields.size() == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)foreachRequiredFields.get(0);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
    }

    @Test
    public void testQueryForeachGenerateCountStarNoSchema() {
        String query = "foreach (load 'a') generate COUNT(*) ;";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        List loadaRequiredFields = loada.getRequiredFields();
        TestRequiredFields.assertTrue((loadaRequiredFields.size() == 1 ? 1 : 0) != 0);
        RequiredFields requiredField = (RequiredFields)loadaRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        List foreachRequiredFields = foreach.getRequiredFields();
        TestRequiredFields.assertTrue((foreachRequiredFields.size() == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)foreachRequiredFields.get(0);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
    }

    @Test
    public void testQueryForeachGenerateStarNoSchema1() {
        String query = "foreach (load 'a') generate *, COUNT(*) ;";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        List loadaRequiredFields = loada.getRequiredFields();
        TestRequiredFields.assertTrue((loadaRequiredFields.size() == 1 ? 1 : 0) != 0);
        RequiredFields requiredField = (RequiredFields)loadaRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        List foreachRequiredFields = foreach.getRequiredFields();
        TestRequiredFields.assertTrue((foreachRequiredFields.size() == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)foreachRequiredFields.get(0);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
    }

    @Test
    public void testQueryForeachGenerateStarNoSchema2() {
        String query = "foreach (load 'a') generate *, $0 ;";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        List loadaRequiredFields = loada.getRequiredFields();
        TestRequiredFields.assertTrue((loadaRequiredFields.size() == 1 ? 1 : 0) != 0);
        RequiredFields requiredField = (RequiredFields)loadaRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        List foreachRequiredFields = foreach.getRequiredFields();
        TestRequiredFields.assertTrue((foreachRequiredFields.size() == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)foreachRequiredFields.get(0);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
    }

    @Test
    public void testQueryForeachGenerateStarWithSchema() {
        String query = "foreach (load 'a' as (url, hitCount)) generate * ;";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        List loadaRequiredFields = loada.getRequiredFields();
        TestRequiredFields.assertTrue((loadaRequiredFields.size() == 1 ? 1 : 0) != 0);
        RequiredFields requiredField = (RequiredFields)loadaRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        List foreachRequiredFields = foreach.getRequiredFields();
        TestRequiredFields.assertTrue((foreachRequiredFields.size() == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)foreachRequiredFields.get(0);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        List fields = requiredField.getFields();
        TestRequiredFields.assertTrue((fields.size() == 2 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).second == 0 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)1)).first == 0 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)1)).second == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testQueryForeachGenerateCountStarWithSchema() {
        String query = "foreach (load 'a' as (url, hitCount)) generate COUNT(*) ;";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        List loadaRequiredFields = loada.getRequiredFields();
        TestRequiredFields.assertTrue((loadaRequiredFields.size() == 1 ? 1 : 0) != 0);
        RequiredFields requiredField = (RequiredFields)loadaRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        List foreachRequiredFields = foreach.getRequiredFields();
        TestRequiredFields.assertTrue((foreachRequiredFields.size() == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)foreachRequiredFields.get(0);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
    }

    @Test
    public void testQueryForeachGenerateStarWithSchema1() {
        String query = "foreach (load 'a' as (url, hitCount)) generate *, COUNT(*) ;";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        List loadaRequiredFields = loada.getRequiredFields();
        TestRequiredFields.assertTrue((loadaRequiredFields.size() == 1 ? 1 : 0) != 0);
        RequiredFields requiredField = (RequiredFields)loadaRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        List foreachRequiredFields = foreach.getRequiredFields();
        TestRequiredFields.assertTrue((foreachRequiredFields.size() == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)foreachRequiredFields.get(0);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
    }

    @Test
    public void testQueryForeachGenerateStarWithSchema2() {
        String query = "foreach (load 'a' as (url, hitCount)) generate *, url ;";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        List loadaRequiredFields = loada.getRequiredFields();
        TestRequiredFields.assertTrue((loadaRequiredFields.size() == 1 ? 1 : 0) != 0);
        RequiredFields requiredField = (RequiredFields)loadaRequiredFields.get(0);
        TestRequiredFields.assertTrue((requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((requiredField.getFields() == null ? 1 : 0) != 0);
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        List foreachRequiredFields = foreach.getRequiredFields();
        TestRequiredFields.assertTrue((foreachRequiredFields.size() == 1 ? 1 : 0) != 0);
        requiredField = (RequiredFields)foreachRequiredFields.get(0);
        TestRequiredFields.assertTrue((!requiredField.needNoFields() ? 1 : 0) != 0);
        TestRequiredFields.assertTrue((!requiredField.needAllFields() ? 1 : 0) != 0);
        List fields = requiredField.getFields();
        TestRequiredFields.assertTrue((fields.size() == 2 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)0)).second == 0 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)1)).first == 0 ? 1 : 0) != 0);
        TestRequiredFields.assertTrue(((Integer)((Pair)fields.get((int)1)).second == 1 ? 1 : 0) != 0);
    }
}

