/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.pig.ResourceSchema;
import org.apache.pig.SortColInfo;
import org.apache.pig.SortInfo;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.logicalLayer.schema.SchemaMergeException;
import org.apache.pig.test.utils.TypeCheckingTestUtil;
import org.junit.Assert;
import org.junit.Test;

public class TestResourceSchema {
    @Test
    public void testResourceFlatSchemaCreation() throws ExecException, SchemaMergeException, FrontendException {
        String[] aliases = new String[]{"f1", "f2"};
        byte[] types = new byte[]{55, 10};
        Schema origSchema = TypeCheckingTestUtil.genFlatSchema(aliases, types);
        ResourceSchema rsSchema = new ResourceSchema(origSchema);
        Assert.assertEquals((String)"num fields", (long)aliases.length, (long)rsSchema.getFields().length);
        ResourceSchema.ResourceFieldSchema[] fields = rsSchema.getFields();
        for (int i = 0; i < fields.length; ++i) {
            Assert.assertEquals((Object)fields[i].getName(), (Object)aliases[i]);
            Assert.assertEquals((long)fields[i].getType(), (long)types[i]);
        }
        Schema genSchema = Schema.getPigSchema((ResourceSchema)rsSchema);
        Assert.assertTrue((String)"generated schema equals original", (boolean)Schema.equals((Schema)genSchema, (Schema)origSchema, (boolean)true, (boolean)false));
    }

    @Test
    public void testResourceFlatSchemaCreation2() throws ExecException, SchemaMergeException, FrontendException {
        String[] aliases = new String[]{"f1", "f2"};
        byte[] types = new byte[]{55, 10};
        Schema origSchema = new Schema(new Schema.FieldSchema("t1", new Schema(new Schema.FieldSchema("t0", TypeCheckingTestUtil.genFlatSchema(aliases, types), 110)), 120));
        ResourceSchema rsSchema = new ResourceSchema(origSchema);
        Schema genSchema = Schema.getPigSchema((ResourceSchema)rsSchema);
        Assert.assertTrue((String)"generated schema equals original", (boolean)Schema.equals((Schema)genSchema, (Schema)origSchema, (boolean)true, (boolean)false));
    }

    @Test
    public void testResourceFlatSchemaCreationWithSortInfo() throws ExecException, SchemaMergeException, FrontendException {
        String[] aliases = new String[]{"f1", "f2"};
        byte[] types = new byte[]{55, 10};
        Schema origSchema = new Schema(new Schema.FieldSchema("t1", new Schema(new Schema.FieldSchema("t0", TypeCheckingTestUtil.genFlatSchema(aliases, types), 110)), 120));
        ArrayList<SortColInfo> colList = new ArrayList<SortColInfo>();
        SortColInfo col1 = new SortColInfo("f1", 0, SortColInfo.Order.ASCENDING);
        SortColInfo col2 = new SortColInfo("f1", 1, SortColInfo.Order.DESCENDING);
        colList.add(col1);
        colList.add(col2);
        SortInfo sortInfo = new SortInfo(colList);
        ResourceSchema rsSchema = new ResourceSchema(origSchema, sortInfo);
        Schema genSchema = Schema.getPigSchema((ResourceSchema)rsSchema);
        Assert.assertTrue((String)"generated schema equals original", (boolean)Schema.equals((Schema)genSchema, (Schema)origSchema, (boolean)true, (boolean)false));
        Assert.assertTrue((rsSchema.getSortKeys()[0] == 0 ? 1 : 0) != 0);
        Assert.assertTrue((rsSchema.getSortKeys()[1] == 1 ? 1 : 0) != 0);
        Assert.assertTrue((rsSchema.getSortKeyOrders()[0] == ResourceSchema.Order.ASCENDING ? 1 : 0) != 0);
        Assert.assertTrue((rsSchema.getSortKeyOrders()[1] == ResourceSchema.Order.DESCENDING ? 1 : 0) != 0);
    }

    @Test
    public void testToPigSchemaWithTwoLevelAccess() throws IOException {
        ResourceSchema.ResourceFieldSchema[] level0 = new ResourceSchema.ResourceFieldSchema[]{new ResourceSchema.ResourceFieldSchema().setName("fld0").setType((byte)55), new ResourceSchema.ResourceFieldSchema().setName("fld1").setType((byte)25), new ResourceSchema.ResourceFieldSchema().setName("fld2").setType((byte)10)};
        ResourceSchema rSchema0 = new ResourceSchema().setFields(level0);
        ResourceSchema.ResourceFieldSchema[] level1 = new ResourceSchema.ResourceFieldSchema[]{new ResourceSchema.ResourceFieldSchema().setName("t1").setType((byte)110).setSchema(rSchema0)};
        ResourceSchema rSchema1 = new ResourceSchema().setFields(level1);
        ResourceSchema.ResourceFieldSchema[] level2 = new ResourceSchema.ResourceFieldSchema[]{new ResourceSchema.ResourceFieldSchema().setName("t2").setType((byte)120).setSchema(rSchema1)};
        ResourceSchema origSchema = new ResourceSchema().setFields(level2);
        Schema pSchema = Schema.getPigSchema((ResourceSchema)origSchema);
        Assert.assertTrue((boolean)this.CheckTwoLevelAccess(pSchema));
        Assert.assertTrue((boolean)ResourceSchema.equals((ResourceSchema)origSchema, (ResourceSchema)new ResourceSchema(pSchema)));
    }

    private boolean CheckTwoLevelAccess(Schema s) {
        if (s == null) {
            return false;
        }
        for (Schema.FieldSchema fs : s.getFields()) {
            if (fs.type == 120 && fs.schema != null && fs.schema.isTwoLevelAccessRequired()) {
                return true;
            }
            if (!this.CheckTwoLevelAccess(fs.schema)) continue;
            return true;
        }
        return false;
    }

    @Test(expected=FrontendException.class)
    public void testToPigSchemaWithInvalidSchema() throws IOException {
        ResourceSchema.ResourceFieldSchema[] level0 = new ResourceSchema.ResourceFieldSchema[]{new ResourceSchema.ResourceFieldSchema().setName("fld0").setType((byte)55), new ResourceSchema.ResourceFieldSchema().setName("fld1").setType((byte)25), new ResourceSchema.ResourceFieldSchema().setName("fld2").setType((byte)10)};
        ResourceSchema rSchema0 = new ResourceSchema().setFields(level0);
        ResourceSchema.ResourceFieldSchema[] level2 = new ResourceSchema.ResourceFieldSchema[]{new ResourceSchema.ResourceFieldSchema().setName("t2").setType((byte)120).setSchema(rSchema0)};
    }

    @Test(expected=FrontendException.class)
    public void testToPigSchemaWithInvalidSchema2() throws IOException {
        ResourceSchema.ResourceFieldSchema[] level0 = new ResourceSchema.ResourceFieldSchema[]{new ResourceSchema.ResourceFieldSchema().setName("fld0").setType((byte)55)};
        ResourceSchema rSchema0 = new ResourceSchema().setFields(level0);
        ResourceSchema.ResourceFieldSchema[] level2 = new ResourceSchema.ResourceFieldSchema[]{new ResourceSchema.ResourceFieldSchema().setName("t2").setType((byte)120).setSchema(rSchema0)};
    }

    @Test
    public void testResourceSchemaWithInvalidPigSchema() throws FrontendException {
        String[] aliases = new String[]{"f1", "f2"};
        byte[] types = new byte[]{55, 10};
        Schema level0 = TypeCheckingTestUtil.genFlatSchema(aliases, types);
        Schema.FieldSchema fld0 = new Schema.FieldSchema("f0", level0, 120);
        Schema level1 = new Schema(fld0);
        Schema genSchema = Schema.getPigSchema((ResourceSchema)new ResourceSchema(level1));
        Assert.assertTrue((boolean)this.CheckTwoLevelAccess(genSchema));
    }

    @Test
    public void testResourceSchemaWithInvalidPigSchema2() throws FrontendException {
        String[] aliases = new String[]{"f1"};
        byte[] types = new byte[]{10};
        Schema level0 = TypeCheckingTestUtil.genFlatSchema(aliases, types);
        Schema.FieldSchema fld0 = new Schema.FieldSchema("f0", level0, 120);
        Schema level1 = new Schema(fld0);
        Schema genSchema = Schema.getPigSchema((ResourceSchema)new ResourceSchema(level1));
        Assert.assertTrue((boolean)this.CheckTwoLevelAccess(genSchema));
    }
}

