/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.apache.pig.ExecType;
import org.apache.pig.PigServer;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.MapReduceOper;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.SampleOptimizer;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.plans.MROperPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLoad;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.test.MiniCluster;
import org.apache.pig.test.Util;
import org.apache.pig.test.utils.LogicalPlanTester;
import org.junit.Assert;
import org.junit.Test;

public class TestSampleOptimizer {
    static PigContext pc = new PigContext(ExecType.MAPREDUCE, MiniCluster.buildCluster().getProperties());

    @Test
    public void testOptimizerFired() throws Exception {
        LogicalPlanTester planTester = new LogicalPlanTester();
        planTester.buildPlan(" A = load 'input' using PigStorage('\t');");
        planTester.buildPlan(" B = order A by $0;");
        LogicalPlan lp = planTester.buildPlan("store B into '/tmp';");
        PhysicalPlan pp = Util.buildPhysicalPlan(lp, pc);
        MROperPlan mrPlan = Util.buildMRPlan(pp, pc);
        int count = 1;
        MapReduceOper mrOper = (MapReduceOper)mrPlan.getRoots().get(0);
        while (mrPlan.getSuccessors((Operator)mrOper) != null) {
            mrOper = (MapReduceOper)mrPlan.getSuccessors((Operator)mrOper).get(0);
            ++count;
        }
        Assert.assertEquals((long)3L, (long)count);
        SampleOptimizer so = new SampleOptimizer(mrPlan);
        so.visit();
        count = 1;
        mrOper = (MapReduceOper)mrPlan.getRoots().get(0);
        while (mrPlan.getSuccessors((Operator)mrOper) != null) {
            mrOper = (MapReduceOper)mrPlan.getSuccessors((Operator)mrOper).get(0);
            ++count;
        }
        Assert.assertEquals((long)2L, (long)count);
        mrOper = (MapReduceOper)mrPlan.getRoots().get(0);
        List phyOps = mrOper.mapPlan.getRoots();
        Assert.assertEquals((long)1L, (long)phyOps.size());
        Assert.assertTrue((boolean)(phyOps.get(0) instanceof POLoad));
        Assert.assertTrue((boolean)((POLoad)phyOps.get(0)).getLFile().getFuncName().equals("org.apache.pig.impl.builtin.RandomSampleLoader"));
        phyOps = ((MapReduceOper)mrPlan.getSuccessors((Operator)mrOper).get((int)0)).mapPlan.getRoots();
        Assert.assertEquals((long)1L, (long)phyOps.size());
        Assert.assertTrue((boolean)(phyOps.get(0) instanceof POLoad));
        Assert.assertFalse((boolean)((POLoad)phyOps.get(0)).getLFile().getFuncName().equals("org.apache.pig.impl.builtin.RandomSampleLoader"));
    }

    @Test
    public void testOptimizerNotFired() throws Exception {
        LogicalPlanTester planTester = new LogicalPlanTester();
        planTester.buildPlan(" A = load 'input' using PigStorage('\t');");
        planTester.buildPlan("B = group A by $0;");
        planTester.buildPlan(" C = order B by $0;");
        LogicalPlan lp = planTester.buildPlan("store C into 'output';");
        PhysicalPlan pp = Util.buildPhysicalPlan(lp, pc);
        MROperPlan mrPlan = Util.buildMRPlan(pp, pc);
        int count = 1;
        MapReduceOper mrOper = (MapReduceOper)mrPlan.getRoots().get(0);
        while (mrPlan.getSuccessors((Operator)mrOper) != null) {
            mrOper = (MapReduceOper)mrPlan.getSuccessors((Operator)mrOper).get(0);
            ++count;
        }
        Assert.assertEquals((long)3L, (long)count);
        SampleOptimizer so = new SampleOptimizer(mrPlan);
        so.visit();
        count = 1;
        mrOper = (MapReduceOper)mrPlan.getRoots().get(0);
        while (mrPlan.getSuccessors((Operator)mrOper) != null) {
            mrOper = (MapReduceOper)mrPlan.getSuccessors((Operator)mrOper).get(0);
            ++count;
        }
        Assert.assertEquals((long)3L, (long)count);
        mrOper = (MapReduceOper)mrPlan.getRoots().get(0);
        List phyOps = mrOper.mapPlan.getRoots();
        Assert.assertEquals((long)1L, (long)phyOps.size());
        Assert.assertTrue((boolean)(phyOps.get(0) instanceof POLoad));
        Assert.assertFalse((boolean)((POLoad)phyOps.get(0)).getLFile().getFuncName().equals("org.apache.pig.impl.builtin.RandomSampleLoader"));
        phyOps = ((MapReduceOper)mrPlan.getSuccessors((Operator)mrOper).get((int)0)).mapPlan.getRoots();
        Assert.assertEquals((long)1L, (long)phyOps.size());
        Assert.assertTrue((boolean)(phyOps.get(0) instanceof POLoad));
        Assert.assertTrue((boolean)((POLoad)phyOps.get(0)).getLFile().getFuncName().equals("org.apache.pig.impl.builtin.RandomSampleLoader"));
    }

    @Test
    public void testEndToEnd() throws Exception {
        PigServer pigServer = new PigServer(pc);
        int LOOP_COUNT = 40;
        File tmpFile = File.createTempFile("test", "txt");
        PrintStream ps = new PrintStream(new FileOutputStream(tmpFile));
        Random r = new Random(3L);
        for (int i = 0; i < LOOP_COUNT; ++i) {
            int rand = r.nextInt(100);
            ps.println(rand);
        }
        ps.close();
        pigServer.registerQuery("A = LOAD '" + Util.generateURI(tmpFile.toString(), pigServer.getPigContext()) + "' using PigStorage() AS (num:int);");
        pigServer.registerQuery("B = order A by num desc;");
        Iterator result = pigServer.openIterator("B");
        Integer prevNum = null;
        while (result.hasNext()) {
            Integer curNum = (Integer)((Tuple)result.next()).get(0);
            if (null != prevNum) {
                Assert.assertTrue((curNum.compareTo(prevNum) <= 0 ? 1 : 0) != 0);
            }
            prevNum = curNum;
        }
        tmpFile.delete();
    }

    @Test
    public void testPoissonSampleOptimizer() throws Exception {
        LogicalPlanTester planTester = new LogicalPlanTester();
        planTester.buildPlan(" A = load 'input' using PigStorage('\t');");
        planTester.buildPlan("B = load 'input' using PigStorage('\t');");
        planTester.buildPlan(" C = join A by $0, B by $0 using \"skewed\";");
        LogicalPlan lp = planTester.buildPlan("store C into 'output';");
        PhysicalPlan pp = Util.buildPhysicalPlan(lp, pc);
        MROperPlan mrPlan = Util.buildMRPlan(pp, pc);
        int count = 1;
        MapReduceOper mrOper = (MapReduceOper)mrPlan.getRoots().get(0);
        while (mrPlan.getSuccessors((Operator)mrOper) != null) {
            mrOper = (MapReduceOper)mrPlan.getSuccessors((Operator)mrOper).get(0);
            ++count;
        }
        Assert.assertEquals((long)3L, (long)count);
        SampleOptimizer so = new SampleOptimizer(mrPlan);
        so.visit();
        count = 1;
        mrOper = (MapReduceOper)mrPlan.getRoots().get(0);
        while (mrPlan.getSuccessors((Operator)mrOper) != null) {
            mrOper = (MapReduceOper)mrPlan.getSuccessors((Operator)mrOper).get(0);
            ++count;
        }
        Assert.assertEquals((long)2L, (long)count);
    }

    static {
        try {
            pc.connect();
        }
        catch (ExecException e) {
            e.printStackTrace();
        }
    }
}

