/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.pig.ExecType;
import org.apache.pig.PigServer;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.logicalLayer.schema.SchemaMergeException;
import org.apache.pig.test.MiniCluster;
import org.apache.pig.test.Util;
import org.junit.Test;

public class TestSchema
extends TestCase {
    @Test
    public void testSchemaEqual1() {
        ArrayList<Schema.FieldSchema> innerList1 = new ArrayList<Schema.FieldSchema>();
        innerList1.add(new Schema.FieldSchema("11a", 10));
        innerList1.add(new Schema.FieldSchema("11b", 15));
        ArrayList<Schema.FieldSchema> innerList2 = new ArrayList<Schema.FieldSchema>();
        innerList2.add(new Schema.FieldSchema("11a", 10));
        innerList2.add(new Schema.FieldSchema("11b", 15));
        Schema innerSchema1 = new Schema(innerList1);
        Schema innerSchema2 = new Schema(innerList2);
        ArrayList<Schema.FieldSchema> list1 = new ArrayList<Schema.FieldSchema>();
        list1.add(new Schema.FieldSchema("1a", 50));
        list1.add(new Schema.FieldSchema("1b", innerSchema1));
        list1.add(new Schema.FieldSchema("1c", 10));
        ArrayList<Schema.FieldSchema> list2 = new ArrayList<Schema.FieldSchema>();
        list2.add(new Schema.FieldSchema("1a", 50));
        list2.add(new Schema.FieldSchema("1b", innerSchema2));
        list2.add(new Schema.FieldSchema("1c", 10));
        Schema schema1 = new Schema(list1);
        Schema schema2 = new Schema(list2);
        Assert.assertTrue((boolean)Schema.equals((Schema)schema1, (Schema)schema2, (boolean)false, (boolean)false));
        ((Schema.FieldSchema)innerList2.get((int)1)).alias = "pi";
        Assert.assertFalse((boolean)Schema.equals((Schema)schema1, (Schema)schema2, (boolean)false, (boolean)false));
        Assert.assertTrue((boolean)Schema.equals((Schema)schema1, (Schema)schema2, (boolean)false, (boolean)true));
        ((Schema.FieldSchema)innerList2.get((int)1)).alias = "11b";
        ((Schema.FieldSchema)innerList2.get((int)1)).type = (byte)50;
        Assert.assertFalse((boolean)Schema.equals((Schema)schema1, (Schema)schema2, (boolean)false, (boolean)false));
        Assert.assertTrue((boolean)Schema.equals((Schema)schema1, (Schema)schema2, (boolean)true, (boolean)false));
        ((Schema.FieldSchema)innerList2.get((int)1)).type = (byte)15;
        Assert.assertTrue((boolean)Schema.equals((Schema)schema1, (Schema)schema2, (boolean)false, (boolean)false));
        ((Schema.FieldSchema)list2.get((int)0)).type = (byte)55;
        Assert.assertFalse((boolean)Schema.equals((Schema)schema1, (Schema)schema2, (boolean)false, (boolean)false));
    }

    @Test
    public void testSchemaEqualWithNullSchema1() {
        Schema dummySchema;
        ArrayList<Schema.FieldSchema> list1 = new ArrayList<Schema.FieldSchema>();
        list1.add(new Schema.FieldSchema("1a", 50));
        list1.add(new Schema.FieldSchema("1b", null));
        list1.add(new Schema.FieldSchema("1c", 10));
        ArrayList<Schema.FieldSchema> list2 = new ArrayList<Schema.FieldSchema>();
        list2.add(new Schema.FieldSchema("1a", 50));
        list2.add(new Schema.FieldSchema("1b", null));
        list2.add(new Schema.FieldSchema("1c", 10));
        Schema schema1 = new Schema(list1);
        Schema schema2 = new Schema(list2);
        Assert.assertTrue((boolean)Schema.equals((Schema)schema1, (Schema)schema2, (boolean)false, (boolean)false));
        ArrayList dummyList = new ArrayList();
        ((Schema.FieldSchema)list2.get((int)1)).schema = dummySchema = new Schema(dummyList);
        Assert.assertFalse((boolean)Schema.equals((Schema)schema1, (Schema)schema2, (boolean)false, (boolean)false));
    }

    @Test
    public void testNormalNestedMerge1() {
        ArrayList<Schema.FieldSchema> innerList1 = new ArrayList<Schema.FieldSchema>();
        innerList1.add(new Schema.FieldSchema("11a", 10));
        innerList1.add(new Schema.FieldSchema("11b", 20));
        ArrayList<Schema.FieldSchema> innerList2 = new ArrayList<Schema.FieldSchema>();
        innerList2.add(new Schema.FieldSchema("22a", 25));
        innerList2.add(new Schema.FieldSchema(null, 15));
        Schema innerSchema1 = new Schema(innerList1);
        Schema innerSchema2 = new Schema(innerList2);
        ArrayList<Schema.FieldSchema> list1 = new ArrayList<Schema.FieldSchema>();
        list1.add(new Schema.FieldSchema("1a", 50));
        list1.add(new Schema.FieldSchema("1b", innerSchema1));
        list1.add(new Schema.FieldSchema("1c", 15));
        ArrayList<Schema.FieldSchema> list2 = new ArrayList<Schema.FieldSchema>();
        list2.add(new Schema.FieldSchema("2a", 50));
        list2.add(new Schema.FieldSchema("2b", innerSchema2));
        list2.add(new Schema.FieldSchema("2c", 10));
        Schema schema1 = new Schema(list1);
        Schema schema2 = new Schema(list2);
        Schema mergedSchema = schema1.merge(schema2, true);
        ArrayList<Schema.FieldSchema> expectedInnerList = new ArrayList<Schema.FieldSchema>();
        expectedInnerList.add(new Schema.FieldSchema("22a", 25));
        expectedInnerList.add(new Schema.FieldSchema("11b", 20));
        Schema expectedInner = new Schema(expectedInnerList);
        ArrayList<Schema.FieldSchema> expectedList = new ArrayList<Schema.FieldSchema>();
        expectedList.add(new Schema.FieldSchema("2a", 50));
        expectedList.add(new Schema.FieldSchema("2b", expectedInner));
        expectedList.add(new Schema.FieldSchema("2c", 15));
        Schema expected = new Schema(expectedList);
        Assert.assertTrue((boolean)Schema.equals((Schema)mergedSchema, (Schema)expected, (boolean)false, (boolean)false));
    }

    @Test
    public void testMergeNullSchemas1() throws Throwable {
        ArrayList<Schema.FieldSchema> innerList2 = new ArrayList<Schema.FieldSchema>();
        innerList2.add(new Schema.FieldSchema("22a", 25));
        innerList2.add(new Schema.FieldSchema(null, 15));
        Schema innerSchema2 = new Schema(innerList2);
        ArrayList<Schema.FieldSchema> list1 = new ArrayList<Schema.FieldSchema>();
        list1.add(new Schema.FieldSchema("1a", 50));
        list1.add(new Schema.FieldSchema("1b", null));
        list1.add(new Schema.FieldSchema("1c", 15));
        ArrayList<Schema.FieldSchema> list2 = new ArrayList<Schema.FieldSchema>();
        list2.add(new Schema.FieldSchema("2a", 50));
        list2.add(new Schema.FieldSchema("2b", innerSchema2));
        list2.add(new Schema.FieldSchema("2c", 10));
        Schema schema1 = new Schema(list1);
        Schema schema2 = new Schema(list2);
        Schema mergedSchema = Schema.mergeSchema((Schema)schema1, (Schema)schema2, (boolean)true, (boolean)false, (boolean)true);
        ArrayList<Schema.FieldSchema> expectedList = new ArrayList<Schema.FieldSchema>();
        expectedList.add(new Schema.FieldSchema("2a", 50));
        expectedList.add(new Schema.FieldSchema("2b", null));
        expectedList.add(new Schema.FieldSchema("2c", 15));
        Schema expected = new Schema(expectedList);
        Assert.assertTrue((boolean)Schema.equals((Schema)mergedSchema, (Schema)expected, (boolean)false, (boolean)false));
    }

    @Test
    public void testMergeNullSchemas2() throws Throwable {
        Schema innerInner = new Schema(new ArrayList());
        ArrayList<Schema.FieldSchema> innerList1 = new ArrayList<Schema.FieldSchema>();
        innerList1.add(new Schema.FieldSchema("11a", innerInner));
        innerList1.add(new Schema.FieldSchema("11b", 20));
        ArrayList<Schema.FieldSchema> innerList2 = new ArrayList<Schema.FieldSchema>();
        innerList2.add(new Schema.FieldSchema("22a", null));
        innerList2.add(new Schema.FieldSchema(null, 15));
        Schema innerSchema1 = new Schema(innerList1);
        Schema innerSchema2 = new Schema(innerList2);
        ArrayList<Schema.FieldSchema> list1 = new ArrayList<Schema.FieldSchema>();
        list1.add(new Schema.FieldSchema("1a", 50));
        list1.add(new Schema.FieldSchema("1b", innerSchema1));
        list1.add(new Schema.FieldSchema("1c", 15));
        ArrayList<Schema.FieldSchema> list2 = new ArrayList<Schema.FieldSchema>();
        list2.add(new Schema.FieldSchema("2a", 50));
        list2.add(new Schema.FieldSchema("2b", innerSchema2));
        list2.add(new Schema.FieldSchema("2c", 10));
        Schema schema1 = new Schema(list1);
        Schema schema2 = new Schema(list2);
        Schema mergedSchema = Schema.mergeSchema((Schema)schema1, (Schema)schema2, (boolean)true, (boolean)false, (boolean)true);
        ArrayList<Schema.FieldSchema> expectedInnerList = new ArrayList<Schema.FieldSchema>();
        expectedInnerList.add(new Schema.FieldSchema("22a", null));
        expectedInnerList.add(new Schema.FieldSchema("11b", 20));
        Schema expectedInner = new Schema(expectedInnerList);
        ArrayList<Schema.FieldSchema> expectedList = new ArrayList<Schema.FieldSchema>();
        expectedList.add(new Schema.FieldSchema("2a", 50));
        expectedList.add(new Schema.FieldSchema("2b", expectedInner));
        expectedList.add(new Schema.FieldSchema("2c", 15));
        Schema expected = new Schema(expectedList);
        Assert.assertTrue((boolean)Schema.equals((Schema)mergedSchema, (Schema)expected, (boolean)false, (boolean)false));
    }

    @Test
    public void testMergeDifferentSize1() throws Throwable {
        ArrayList<Schema.FieldSchema> innerList1 = new ArrayList<Schema.FieldSchema>();
        innerList1.add(new Schema.FieldSchema("11a", 10));
        innerList1.add(new Schema.FieldSchema("11b", 20));
        innerList1.add(new Schema.FieldSchema("11c", 55));
        ArrayList<Schema.FieldSchema> innerList2 = new ArrayList<Schema.FieldSchema>();
        innerList2.add(new Schema.FieldSchema("22a", 25));
        innerList2.add(new Schema.FieldSchema(null, 15));
        Schema innerSchema1 = new Schema(innerList1);
        Schema innerSchema2 = new Schema(innerList2);
        ArrayList<Schema.FieldSchema> list1 = new ArrayList<Schema.FieldSchema>();
        list1.add(new Schema.FieldSchema("1a", 50));
        list1.add(new Schema.FieldSchema("1b", innerSchema1));
        list1.add(new Schema.FieldSchema("1c", 15));
        ArrayList<Schema.FieldSchema> list2 = new ArrayList<Schema.FieldSchema>();
        list2.add(new Schema.FieldSchema("2a", 50));
        list2.add(new Schema.FieldSchema("2b", innerSchema2));
        list2.add(new Schema.FieldSchema("2c", 10));
        list2.add(new Schema.FieldSchema("2d", 100));
        Schema schema1 = new Schema(list1);
        Schema schema2 = new Schema(list2);
        Schema mergedSchema = Schema.mergeSchema((Schema)schema1, (Schema)schema2, (boolean)true, (boolean)true, (boolean)false);
        ArrayList<Schema.FieldSchema> expectedInnerList = new ArrayList<Schema.FieldSchema>();
        expectedInnerList.add(new Schema.FieldSchema("22a", 25));
        expectedInnerList.add(new Schema.FieldSchema("11b", 20));
        expectedInnerList.add(new Schema.FieldSchema("11c", 55));
        Schema expectedInner = new Schema(expectedInnerList);
        ArrayList<Schema.FieldSchema> expectedList = new ArrayList<Schema.FieldSchema>();
        expectedList.add(new Schema.FieldSchema("2a", 50));
        expectedList.add(new Schema.FieldSchema("2b", expectedInner));
        expectedList.add(new Schema.FieldSchema("2c", 15));
        expectedList.add(new Schema.FieldSchema("2d", 100));
        Schema expected = new Schema(expectedList);
        Assert.assertTrue((boolean)Schema.equals((Schema)mergedSchema, (Schema)expected, (boolean)false, (boolean)false));
    }

    @Test
    public void testMergeDifferentSize2() throws Throwable {
        ArrayList<Schema.FieldSchema> list1 = new ArrayList<Schema.FieldSchema>();
        list1.add(new Schema.FieldSchema("1a", 50));
        list1.add(new Schema.FieldSchema("1b", 50));
        list1.add(new Schema.FieldSchema("1c", 15));
        ArrayList<Schema.FieldSchema> list2 = new ArrayList<Schema.FieldSchema>();
        list2.add(new Schema.FieldSchema("2a", 50));
        list2.add(new Schema.FieldSchema("2b", 50));
        list2.add(new Schema.FieldSchema("2c", 10));
        list2.add(new Schema.FieldSchema("2d", 100));
        Schema schema1 = new Schema(list1);
        Schema schema2 = new Schema(list2);
        try {
            Schema mergedSchema = Schema.mergeSchema((Schema)schema1, (Schema)schema2, (boolean)true, (boolean)false, (boolean)false);
            TestSchema.fail((String)"Expect Error Here!");
        }
        catch (SchemaMergeException sme) {
            // empty catch block
        }
    }

    @Test
    public void testMergeMismatchType1() throws Throwable {
        ArrayList<Schema.FieldSchema> innerList1 = new ArrayList<Schema.FieldSchema>();
        innerList1.add(new Schema.FieldSchema("11a", 55));
        innerList1.add(new Schema.FieldSchema("11b", 20));
        ArrayList<Schema.FieldSchema> innerList2 = new ArrayList<Schema.FieldSchema>();
        innerList2.add(new Schema.FieldSchema("22a", 25));
        innerList2.add(new Schema.FieldSchema(null, 15));
        Schema innerSchema1 = new Schema(innerList1);
        Schema innerSchema2 = new Schema(innerList2);
        ArrayList<Schema.FieldSchema> list1 = new ArrayList<Schema.FieldSchema>();
        list1.add(new Schema.FieldSchema("1a", 50));
        list1.add(new Schema.FieldSchema("1b", innerSchema1));
        list1.add(new Schema.FieldSchema("1c", 100));
        ArrayList<Schema.FieldSchema> list2 = new ArrayList<Schema.FieldSchema>();
        list2.add(new Schema.FieldSchema("2a", 50));
        list2.add(new Schema.FieldSchema("2b", innerSchema2));
        list2.add(new Schema.FieldSchema("2c", 10));
        Schema schema1 = new Schema(list1);
        Schema schema2 = new Schema(list2);
        Schema mergedSchema = Schema.mergeSchema((Schema)schema1, (Schema)schema2, (boolean)true, (boolean)false, (boolean)true);
        ArrayList<Schema.FieldSchema> expectedInnerList = new ArrayList<Schema.FieldSchema>();
        expectedInnerList.add(new Schema.FieldSchema("22a", 50));
        expectedInnerList.add(new Schema.FieldSchema("11b", 20));
        Schema expectedInner = new Schema(expectedInnerList);
        ArrayList<Schema.FieldSchema> expectedList = new ArrayList<Schema.FieldSchema>();
        expectedList.add(new Schema.FieldSchema("2a", 50));
        expectedList.add(new Schema.FieldSchema("2b", expectedInner));
        expectedList.add(new Schema.FieldSchema("2c", 50));
        Schema expected = new Schema(expectedList);
        Assert.assertTrue((boolean)Schema.equals((Schema)mergedSchema, (Schema)expected, (boolean)false, (boolean)false));
    }

    @Test
    public void testMergeMismatchType2() throws Throwable {
        ArrayList<Schema.FieldSchema> innerList1 = new ArrayList<Schema.FieldSchema>();
        innerList1.add(new Schema.FieldSchema("11a", 55));
        innerList1.add(new Schema.FieldSchema("11b", 20));
        Schema innerSchema1 = new Schema(innerList1);
        ArrayList<Schema.FieldSchema> list1 = new ArrayList<Schema.FieldSchema>();
        list1.add(new Schema.FieldSchema("1a", 50));
        list1.add(new Schema.FieldSchema("1b", innerSchema1));
        list1.add(new Schema.FieldSchema("1c", 100));
        ArrayList<Schema.FieldSchema> list2 = new ArrayList<Schema.FieldSchema>();
        list2.add(new Schema.FieldSchema("2a", 50));
        list2.add(new Schema.FieldSchema("2b", 50));
        list2.add(new Schema.FieldSchema("2c", 10));
        Schema schema1 = new Schema(list1);
        Schema schema2 = new Schema(list2);
        Schema mergedSchema = Schema.mergeSchema((Schema)schema1, (Schema)schema2, (boolean)true, (boolean)false, (boolean)true);
        ArrayList<Schema.FieldSchema> expectedList = new ArrayList<Schema.FieldSchema>();
        expectedList.add(new Schema.FieldSchema("2a", 50));
        expectedList.add(new Schema.FieldSchema("2b", 110));
        expectedList.add(new Schema.FieldSchema("2c", 50));
        Schema expected = new Schema(expectedList);
        Assert.assertTrue((boolean)Schema.equals((Schema)mergedSchema, (Schema)expected, (boolean)false, (boolean)false));
    }

    @Test
    public void testMergeMismatchType3() {
        ArrayList<Schema.FieldSchema> innerList1 = new ArrayList<Schema.FieldSchema>();
        innerList1.add(new Schema.FieldSchema("11a", 55));
        innerList1.add(new Schema.FieldSchema("11b", 20));
        ArrayList<Schema.FieldSchema> innerList2 = new ArrayList<Schema.FieldSchema>();
        innerList2.add(new Schema.FieldSchema("22a", 25));
        innerList2.add(new Schema.FieldSchema(null, 15));
        Schema innerSchema1 = new Schema(innerList1);
        Schema innerSchema2 = new Schema(innerList2);
        ArrayList<Schema.FieldSchema> list1 = new ArrayList<Schema.FieldSchema>();
        list1.add(new Schema.FieldSchema("1a", 50));
        list1.add(new Schema.FieldSchema("1b", innerSchema1));
        list1.add(new Schema.FieldSchema("1c", 100));
        ArrayList<Schema.FieldSchema> list2 = new ArrayList<Schema.FieldSchema>();
        list2.add(new Schema.FieldSchema("2a", 50));
        list2.add(new Schema.FieldSchema("2b", innerSchema2));
        list2.add(new Schema.FieldSchema("2c", 100));
        Schema schema1 = new Schema(list1);
        Schema schema2 = new Schema(list2);
        try {
            Schema mergedSchema = Schema.mergeSchema((Schema)schema1, (Schema)schema2, (boolean)true, (boolean)false, (boolean)false);
            TestSchema.fail((String)"Expect error here!");
        }
        catch (SchemaMergeException e) {
            // empty catch block
        }
    }

    @Test
    public void testMergeDifferentSizeAndTypeMismatch1() throws Throwable {
        ArrayList<Schema.FieldSchema> innerList1 = new ArrayList<Schema.FieldSchema>();
        innerList1.add(new Schema.FieldSchema("11a", 10));
        innerList1.add(new Schema.FieldSchema("11b", 20));
        innerList1.add(new Schema.FieldSchema("11c", 55));
        ArrayList<Schema.FieldSchema> innerList2 = new ArrayList<Schema.FieldSchema>();
        innerList2.add(new Schema.FieldSchema("22a", 55));
        innerList2.add(new Schema.FieldSchema(null, 15));
        Schema innerSchema1 = new Schema(innerList1);
        Schema innerSchema2 = new Schema(innerList2);
        ArrayList<Schema.FieldSchema> list1 = new ArrayList<Schema.FieldSchema>();
        list1.add(new Schema.FieldSchema("1a", 10));
        list1.add(new Schema.FieldSchema("1b", innerSchema1));
        list1.add(new Schema.FieldSchema("1c", 15));
        ArrayList<Schema.FieldSchema> list2 = new ArrayList<Schema.FieldSchema>();
        list2.add(new Schema.FieldSchema("2a", 55));
        list2.add(new Schema.FieldSchema("2b", innerSchema2));
        list2.add(new Schema.FieldSchema("2c", 10));
        list2.add(new Schema.FieldSchema("2d", 100));
        Schema schema1 = new Schema(list1);
        Schema schema2 = new Schema(list2);
        Schema mergedSchema = Schema.mergeSchema((Schema)schema1, (Schema)schema2, (boolean)true, (boolean)true, (boolean)true);
        ArrayList<Schema.FieldSchema> expectedInnerList = new ArrayList<Schema.FieldSchema>();
        expectedInnerList.add(new Schema.FieldSchema("22a", 50));
        expectedInnerList.add(new Schema.FieldSchema("11b", 20));
        expectedInnerList.add(new Schema.FieldSchema("11c", 55));
        Schema expectedInner = new Schema(expectedInnerList);
        ArrayList<Schema.FieldSchema> expectedList = new ArrayList<Schema.FieldSchema>();
        expectedList.add(new Schema.FieldSchema("2a", 50));
        expectedList.add(new Schema.FieldSchema("2b", expectedInner));
        expectedList.add(new Schema.FieldSchema("2c", 15));
        expectedList.add(new Schema.FieldSchema("2d", 100));
        Schema expected = new Schema(expectedList);
        Assert.assertTrue((boolean)Schema.equals((Schema)mergedSchema, (Schema)expected, (boolean)false, (boolean)false));
    }

    @Test
    public void testSchemaEqualTwoLevelAccess() throws Exception {
        ArrayList<Schema.FieldSchema> innerList1 = new ArrayList<Schema.FieldSchema>();
        innerList1.add(new Schema.FieldSchema("11a", 10));
        innerList1.add(new Schema.FieldSchema("11b", 15));
        ArrayList<Schema.FieldSchema> innerList2 = new ArrayList<Schema.FieldSchema>();
        innerList2.add(new Schema.FieldSchema("11a", 10));
        innerList2.add(new Schema.FieldSchema("11b", 15));
        Schema innerSchema1 = new Schema(innerList1);
        Schema innerSchema2 = new Schema(innerList2);
        ArrayList<Schema.FieldSchema> list1 = new ArrayList<Schema.FieldSchema>();
        list1.add(new Schema.FieldSchema("1a", 50));
        list1.add(new Schema.FieldSchema("1b", innerSchema1));
        list1.add(new Schema.FieldSchema("1c", 10));
        ArrayList<Schema.FieldSchema> list2 = new ArrayList<Schema.FieldSchema>();
        list2.add(new Schema.FieldSchema("1a", 50));
        list2.add(new Schema.FieldSchema("1b", innerSchema2));
        list2.add(new Schema.FieldSchema("1c", 10));
        Schema schema1 = new Schema(list1);
        Schema schema2 = new Schema(list2);
        Schema.FieldSchema bagFs1 = new Schema.FieldSchema("b", schema1, 120);
        Schema bagSchema1 = new Schema(bagFs1);
        Schema.FieldSchema tupleFs = new Schema.FieldSchema("t", schema2, 110);
        Schema bagSchema = new Schema(tupleFs);
        bagSchema.setTwoLevelAccessRequired(true);
        Schema.FieldSchema bagFs2 = new Schema.FieldSchema("b", bagSchema, 120);
        Schema bagSchema2 = new Schema(bagFs2);
        Assert.assertTrue((boolean)Schema.equals((Schema)bagSchema1, (Schema)bagSchema2, (boolean)false, (boolean)false));
        ((Schema.FieldSchema)innerList2.get((int)1)).alias = "pi";
        Assert.assertFalse((boolean)Schema.equals((Schema)bagSchema1, (Schema)bagSchema2, (boolean)false, (boolean)false));
        Assert.assertTrue((boolean)Schema.equals((Schema)bagSchema1, (Schema)bagSchema2, (boolean)false, (boolean)true));
        ((Schema.FieldSchema)innerList2.get((int)1)).alias = "11b";
        ((Schema.FieldSchema)innerList2.get((int)1)).type = (byte)50;
        Assert.assertFalse((boolean)Schema.equals((Schema)bagSchema1, (Schema)bagSchema2, (boolean)false, (boolean)false));
        Assert.assertTrue((boolean)Schema.equals((Schema)bagSchema1, (Schema)bagSchema2, (boolean)true, (boolean)false));
        ((Schema.FieldSchema)innerList2.get((int)1)).type = (byte)15;
        Assert.assertTrue((boolean)Schema.equals((Schema)bagSchema1, (Schema)bagSchema2, (boolean)false, (boolean)false));
        ((Schema.FieldSchema)list2.get((int)0)).type = (byte)55;
        Assert.assertFalse((boolean)Schema.equals((Schema)bagSchema1, (Schema)bagSchema2, (boolean)false, (boolean)false));
    }

    public void testCharArray2Numeric() {
        byte[] numbericTypes = new byte[]{25, 20, 15, 10};
        Schema.FieldSchema inputFieldSchema = new Schema.FieldSchema("", 55);
        for (byte type : numbericTypes) {
            Schema.FieldSchema castFieldSchema = new Schema.FieldSchema("", type);
            Assert.assertTrue((boolean)Schema.FieldSchema.castable((Schema.FieldSchema)castFieldSchema, (Schema.FieldSchema)inputFieldSchema));
        }
    }

    public void testSchemaSerialization() throws IOException {
        MiniCluster cluster = MiniCluster.buildCluster();
        PigServer pigServer = new PigServer(ExecType.MAPREDUCE, cluster.getProperties());
        String inputFileName = "testSchemaSerialization-input.txt";
        String[] inputData = new String[]{"foo\t1", "hello\t2"};
        Util.createInputFile(cluster, inputFileName, inputData);
        String script = "a = load '" + inputFileName + "' as (f1:chararray, f2:int);" + " b = group a all; c = foreach b generate org.apache.pig.test.InputSchemaUDF(a);";
        Util.registerMultiLineQuery(pigServer, script);
        Iterator it = pigServer.openIterator("c");
        while (it.hasNext()) {
            Tuple t = (Tuple)it.next();
            TestSchema.assertEquals((Object)"{a: {f1: chararray,f2: int}}", (Object)t.get(0));
        }
    }
}

