/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.util.Arrays;
import junit.framework.TestCase;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.logicalLayer.schema.SchemaUtil;

public class TestSchemaUtil
extends TestCase {
    public void testTupleSchema() {
        try {
            String tupleName = "mytuple";
            String[] fieldNames = new String[]{"field_0", "field_1"};
            Byte[] dataTypes = new Byte[]{(byte)15, (byte)55};
            String expected = "{mytuple: (field_0: long,field_1: chararray)}";
            Schema tupleSchema = SchemaUtil.newTupleSchema((String)tupleName, (String[])fieldNames, (Byte[])dataTypes);
            TestSchemaUtil.assertEquals((String)expected, (String)tupleSchema.toString());
            tupleSchema = SchemaUtil.newTupleSchema((String)tupleName, Arrays.asList(fieldNames), Arrays.asList(dataTypes));
            TestSchemaUtil.assertEquals((String)expected, (String)tupleSchema.toString());
            expected = "{t: (field_0: long,field_1: chararray)}";
            tupleSchema = SchemaUtil.newTupleSchema((String[])fieldNames, (Byte[])dataTypes);
            TestSchemaUtil.assertEquals((String)expected, (String)tupleSchema.toString());
            tupleSchema = SchemaUtil.newTupleSchema(Arrays.asList(fieldNames), Arrays.asList(dataTypes));
            TestSchemaUtil.assertEquals((String)expected, (String)tupleSchema.toString());
            expected = "{t: (f0: long,f1: chararray)}";
            tupleSchema = SchemaUtil.newTupleSchema((Byte[])dataTypes);
            TestSchemaUtil.assertEquals((String)expected, (String)tupleSchema.toString());
            tupleSchema = SchemaUtil.newTupleSchema(Arrays.asList(dataTypes));
            TestSchemaUtil.assertEquals((String)expected, (String)tupleSchema.toString());
        }
        catch (FrontendException e) {
            TestSchemaUtil.fail();
        }
    }

    public void testBagSchema() {
        try {
            String bagName = "mybag";
            String tupleName = "mytuple";
            String[] fieldNames = new String[]{"field_0", "field_1"};
            Byte[] dataTypes = new Byte[]{(byte)15, (byte)55};
            String expected = "{mybag: {mytuple: (field_0: long,field_1: chararray)}}";
            Schema bagSchema = SchemaUtil.newBagSchema((String)bagName, (String)tupleName, (String[])fieldNames, (Byte[])dataTypes);
            TestSchemaUtil.assertEquals((String)expected, (String)bagSchema.toString());
            bagSchema = SchemaUtil.newBagSchema((String)bagName, (String)tupleName, Arrays.asList(fieldNames), Arrays.asList(dataTypes));
            TestSchemaUtil.assertEquals((String)expected, (String)bagSchema.toString());
            expected = "{b: {t: (field_0: long,field_1: chararray)}}";
            bagSchema = SchemaUtil.newBagSchema((String[])fieldNames, (Byte[])dataTypes);
            TestSchemaUtil.assertEquals((String)expected, (String)bagSchema.toString());
            bagSchema = SchemaUtil.newBagSchema(Arrays.asList(fieldNames), Arrays.asList(dataTypes));
            TestSchemaUtil.assertEquals((String)expected, (String)bagSchema.toString());
            expected = "{b: {t: (f0: long,f1: chararray)}}";
            bagSchema = SchemaUtil.newBagSchema((Byte[])dataTypes);
            TestSchemaUtil.assertEquals((String)expected, (String)bagSchema.toString());
            bagSchema = SchemaUtil.newBagSchema(Arrays.asList(dataTypes));
            TestSchemaUtil.assertEquals((String)expected, (String)bagSchema.toString());
        }
        catch (FrontendException e) {
            TestSchemaUtil.fail();
        }
    }
}

