/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.pig.ExecType;
import org.apache.pig.PigServer;
import org.apache.pig.ResourceSchema;
import org.apache.pig.ResourceStatistics;
import org.apache.pig.StoreMetadata;
import org.apache.pig.backend.datastorage.DataStorage;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.datastorage.ConfigurationUtil;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.MapReduceLauncher;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POProject;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStore;
import org.apache.pig.builtin.BinStorage;
import org.apache.pig.builtin.PigStorage;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataType;
import org.apache.pig.data.DefaultBagFactory;
import org.apache.pig.data.DefaultTuple;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.logicalLayer.LOStore;
import org.apache.pig.impl.logicalLayer.LogicalOperator;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.logicalLayer.LogicalPlanBuilder;
import org.apache.pig.impl.logicalLayer.parser.ParseException;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.logicalLayer.validators.InputOutputFileVisitor;
import org.apache.pig.impl.plan.CompilationMessageCollector;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.impl.plan.PlanValidationException;
import org.apache.pig.pen.physicalOperators.POCounter;
import org.apache.pig.test.MiniCluster;
import org.apache.pig.test.Util;
import org.apache.pig.test.utils.GenRandomData;
import org.apache.pig.test.utils.LogicalPlanTester;
import org.apache.pig.test.utils.TestHelper;
import org.apache.pig.tools.pigstats.PigStats;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestStore
extends TestCase {
    POStore st;
    DataBag inpDB;
    static MiniCluster cluster = MiniCluster.buildCluster();
    PigContext pc;
    POProject proj;
    PigServer pig;
    POCounter pcount;
    String inputFileName;
    String outputFileName;

    @Before
    public void setUp() throws Exception {
        this.pig = new PigServer(ExecType.MAPREDUCE, cluster.getProperties());
        this.pc = this.pig.getPigContext();
        this.inputFileName = "/tmp/TestStore-" + new Random().nextLong() + ".txt";
        this.outputFileName = "/tmp/TestStore-output-" + new Random().nextLong() + ".txt";
    }

    @After
    public void tearDown() throws Exception {
        Util.deleteFile(cluster, this.inputFileName);
        Util.deleteFile(cluster, this.outputFileName);
        new File(this.outputFileName).delete();
    }

    private void storeAndCopyLocally(DataBag inpDB) throws Exception {
        this.setUpInputFileOnCluster(inpDB);
        String script = "a = load '" + this.inputFileName + "'; " + "store a into '" + this.outputFileName + "' using PigStorage(':');" + "fs -ls /tmp";
        this.pig.setBatchOn();
        Util.registerMultiLineQuery(this.pig, script);
        this.pig.executeBatch();
        Util.copyFromClusterToLocal(cluster, this.outputFileName + "/part-m-00000", this.outputFileName);
    }

    private PigStats store() throws Exception {
        PhysicalPlan pp = new PhysicalPlan();
        pp.add((Operator)this.proj);
        pp.add((Operator)this.st);
        pp.add((Operator)this.pcount);
        pp.connect((PhysicalOperator)this.proj, (PhysicalOperator)this.pcount);
        pp.connect((PhysicalOperator)this.pcount, (PhysicalOperator)this.st);
        this.pc.setExecType(ExecType.LOCAL);
        return new MapReduceLauncher().launchPig(pp, "TestStore", this.pc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testValidation() throws Exception {
        String outputFileName = "test-output.txt";
        try {
            LogicalPlanTester lpt = new LogicalPlanTester();
            lpt.buildPlan("a = load '" + this.inputFileName + "' as (c:chararray, " + "i:int,d:double);");
            LogicalPlan lp = lpt.buildPlan("store a into '" + outputFileName + "' using " + "PigStorage();");
            InputOutputFileVisitor visitor = new InputOutputFileVisitor(lp, null, this.pig.getPigContext());
            visitor.visit();
        }
        catch (PlanValidationException e) {
            TestStore.fail((String)"Store validation test failed.");
        }
        finally {
            Util.deleteFile(this.pig.getPigContext(), outputFileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testValidationFailure() throws Exception {
        String[] input = new String[]{"some data"};
        String outputFileName = "test-output.txt";
        boolean sawException = false;
        try {
            Util.createInputFile(this.pig.getPigContext(), outputFileName, input);
            LogicalPlanTester lpt = new LogicalPlanTester(this.pig.getPigContext());
            lpt.buildPlan("a = load '" + this.inputFileName + "' as (c:chararray, " + "i:int,d:double);");
            LogicalPlan lp = lpt.buildPlan("store a into '" + outputFileName + "' using PigStorage();");
            InputOutputFileVisitor visitor = new InputOutputFileVisitor(lp, new CompilationMessageCollector(), this.pig.getPigContext());
            visitor.visit();
        }
        catch (PlanValidationException pve) {
            TestStore.assertEquals((int)6000, (int)pve.getErrorCode());
            TestStore.assertEquals((byte)16, (byte)pve.getErrorSource());
            TestStore.assertTrue((boolean)(pve.getCause() instanceof IOException));
            sawException = true;
        }
        finally {
            TestStore.assertTrue((boolean)sawException);
            Util.deleteFile(this.pig.getPigContext(), outputFileName);
        }
    }

    @Test
    public void testStore() throws Exception {
        this.inpDB = GenRandomData.genRandSmallTupDataBag(new Random(), 10, 100);
        this.storeAndCopyLocally(this.inpDB);
        int size = 0;
        BufferedReader br = new BufferedReader(new FileReader(this.outputFileName));
        String line = br.readLine();
        while (line != null) {
            String[] flds = line.split(":", -1);
            DefaultTuple t = new DefaultTuple();
            t.append(flds[0].compareTo("") != 0 ? flds[0] : null);
            t.append(flds[1].compareTo("") != 0 ? Integer.valueOf(Integer.parseInt(flds[1])) : null);
            System.err.println("Simple data: ");
            System.err.println(line);
            System.err.println("t: ");
            System.err.println(t);
            TestStore.assertEquals((boolean)true, (boolean)TestHelper.bagContains(this.inpDB, (Tuple)t));
            ++size;
            line = br.readLine();
        }
        TestStore.assertEquals((boolean)true, ((long)size == this.inpDB.size() ? 1 : 0) != 0);
    }

    private void setUpInputFileOnCluster(DataBag inpD) throws IOException {
        String[] data = new String[(int)inpD.size()];
        int i = 0;
        for (Tuple tuple : inpD) {
            data[i] = this.toDelimitedString(tuple, "\t");
            ++i;
        }
        Util.createInputFile(cluster, this.inputFileName, data);
    }

    private String toDelimitedString(Tuple t, String delim) throws ExecException {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < t.size(); ++i) {
            Object field = t.get(i);
            if (field == null) {
                buf.append("");
            } else if (field instanceof Map) {
                Map m = (Map)field;
                buf.append(DataType.mapToString((Map)m));
            } else {
                buf.append(field.toString());
            }
            if (i == t.size() - 1) continue;
            buf.append(delim);
        }
        return buf.toString();
    }

    @Test
    public void testStoreComplexData() throws Exception {
        this.inpDB = GenRandomData.genRandFullTupTextDataBag(new Random(), 10, 100);
        this.storeAndCopyLocally(this.inpDB);
        PigStorage ps = new PigStorage(":");
        int size = 0;
        BufferedReader br = new BufferedReader(new FileReader(this.outputFileName));
        String line = br.readLine();
        while (line != null) {
            String[] flds = line.split(":", -1);
            DefaultTuple t = new DefaultTuple();
            ResourceSchema.ResourceFieldSchema bagfs = GenRandomData.getSmallTupDataBagFieldSchema();
            ResourceSchema.ResourceFieldSchema tuplefs = GenRandomData.getSmallTupleFieldSchema();
            t.append(flds[0].compareTo("") != 0 ? ps.getLoadCaster().bytesToBag(flds[0].getBytes(), bagfs) : null);
            t.append(flds[1].compareTo("") != 0 ? ps.getLoadCaster().bytesToCharArray(flds[1].getBytes()) : null);
            t.append(flds[2].compareTo("") != 0 ? ps.getLoadCaster().bytesToCharArray(flds[2].getBytes()) : null);
            t.append(flds[3].compareTo("") != 0 ? ps.getLoadCaster().bytesToDouble(flds[3].getBytes()) : null);
            t.append(flds[4].compareTo("") != 0 ? ps.getLoadCaster().bytesToFloat(flds[4].getBytes()) : null);
            t.append(flds[5].compareTo("") != 0 ? ps.getLoadCaster().bytesToInteger(flds[5].getBytes()) : null);
            t.append(flds[6].compareTo("") != 0 ? ps.getLoadCaster().bytesToLong(flds[6].getBytes()) : null);
            t.append(flds[7].compareTo("") != 0 ? ps.getLoadCaster().bytesToMap(flds[7].getBytes()) : null);
            t.append(flds[8].compareTo("") != 0 ? ps.getLoadCaster().bytesToTuple(flds[8].getBytes(), tuplefs) : null);
            TestStore.assertEquals((boolean)true, (boolean)TestHelper.bagContains(this.inpDB, (Tuple)t));
            ++size;
            line = br.readLine();
        }
        TestStore.assertEquals((boolean)true, ((long)size == this.inpDB.size() ? 1 : 0) != 0);
    }

    @Test
    public void testStoreComplexDataWithNull() throws Exception {
        Tuple inputTuple = GenRandomData.genRandSmallBagTextTupleWithNulls(new Random(), 10, 100);
        this.inpDB = DefaultBagFactory.getInstance().newDefaultBag();
        this.inpDB.add(inputTuple);
        this.storeAndCopyLocally(this.inpDB);
        PigStorage ps = new PigStorage(":");
        int size = 0;
        BufferedReader br = new BufferedReader(new FileReader(this.outputFileName));
        String line = br.readLine();
        while (line != null) {
            System.err.println("Complex data: ");
            System.err.println(line);
            String[] flds = line.split(":", -1);
            DefaultTuple t = new DefaultTuple();
            ResourceSchema.ResourceFieldSchema stringfs = new ResourceSchema.ResourceFieldSchema();
            stringfs.setType((byte)55);
            ResourceSchema.ResourceFieldSchema intfs = new ResourceSchema.ResourceFieldSchema();
            intfs.setType((byte)10);
            ResourceSchema tupleSchema = new ResourceSchema();
            tupleSchema.setFields(new ResourceSchema.ResourceFieldSchema[]{stringfs, intfs});
            ResourceSchema.ResourceFieldSchema tuplefs = new ResourceSchema.ResourceFieldSchema();
            tuplefs.setSchema(tupleSchema);
            tuplefs.setType((byte)110);
            ResourceSchema bagSchema = new ResourceSchema();
            bagSchema.setFields(new ResourceSchema.ResourceFieldSchema[]{tuplefs});
            ResourceSchema.ResourceFieldSchema bagfs = new ResourceSchema.ResourceFieldSchema();
            bagfs.setSchema(bagSchema);
            bagfs.setType((byte)120);
            t.append(flds[0].compareTo("") != 0 ? ps.getLoadCaster().bytesToBag(flds[0].getBytes(), bagfs) : null);
            t.append(flds[1].compareTo("") != 0 ? ps.getLoadCaster().bytesToCharArray(flds[1].getBytes()) : null);
            t.append(flds[2].compareTo("") != 0 ? ps.getLoadCaster().bytesToCharArray(flds[2].getBytes()) : null);
            t.append(flds[3].compareTo("") != 0 ? ps.getLoadCaster().bytesToDouble(flds[3].getBytes()) : null);
            t.append(flds[4].compareTo("") != 0 ? ps.getLoadCaster().bytesToFloat(flds[4].getBytes()) : null);
            t.append(flds[5].compareTo("") != 0 ? ps.getLoadCaster().bytesToInteger(flds[5].getBytes()) : null);
            t.append(flds[6].compareTo("") != 0 ? ps.getLoadCaster().bytesToLong(flds[6].getBytes()) : null);
            t.append(flds[7].compareTo("") != 0 ? ps.getLoadCaster().bytesToMap(flds[7].getBytes()) : null);
            t.append(flds[8].compareTo("") != 0 ? ps.getLoadCaster().bytesToTuple(flds[8].getBytes(), tuplefs) : null);
            t.append(flds[9].compareTo("") != 0 ? ps.getLoadCaster().bytesToCharArray(flds[9].getBytes()) : null);
            TestStore.assertTrue((boolean)TestHelper.tupleEquals(inputTuple, (Tuple)t));
            ++size;
            line = br.readLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBinStorageGetSchema() throws IOException, ParseException {
        String[] input = new String[]{"hello\t1\t10.1", "bye\t2\t20.2"};
        String inputFileName = "testGetSchema-input.txt";
        String outputFileName = "testGetSchema-output.txt";
        try {
            Util.createInputFile(this.pig.getPigContext(), inputFileName, input);
            String query = "a = load '" + inputFileName + "' as (c:chararray, " + "i:int,d:double);store a into '" + outputFileName + "' using " + "BinStorage();";
            this.pig.setBatchOn();
            Util.registerMultiLineQuery(this.pig, query);
            this.pig.executeBatch();
            ResourceSchema rs = new BinStorage().getSchema(outputFileName, new Job(ConfigurationUtil.toConfiguration((Properties)this.pig.getPigContext().getProperties())));
            Schema expectedSchema = Util.getSchemaFromString("c:chararray,i:int,d:double");
            Assert.assertTrue((String)"Checking binstorage getSchema output", (boolean)Schema.equals((Schema)expectedSchema, (Schema)Schema.getPigSchema((ResourceSchema)rs), (boolean)true, (boolean)true));
        }
        finally {
            Util.deleteFile(this.pig.getPigContext(), inputFileName);
            Util.deleteFile(this.pig.getPigContext(), outputFileName);
        }
    }

    private static void randomizeBytes(byte[] data, int offset, int length) {
        Random random = new Random();
        for (int i = offset + length - 1; i >= offset; --i) {
            data[i] = (byte)random.nextInt(256);
        }
    }

    @Test
    public void testStoreRemoteRel() throws Exception {
        this.checkStorePath("test", "/tmp/test");
    }

    @Test
    public void testStoreRemoteAbs() throws Exception {
        this.checkStorePath("/tmp/test", "/tmp/test");
    }

    @Test
    public void testStoreRemoteRelScheme() throws Exception {
        this.checkStorePath("test", "/tmp/test");
    }

    @Test
    public void testStoreRemoteAbsScheme() throws Exception {
        this.checkStorePath("hdfs:/tmp/test", "/tmp/test");
    }

    @Test
    public void testStoreRemoteAbsAuth() throws Exception {
        this.checkStorePath("hdfs://localhost:9000/test", "/test");
    }

    @Test
    public void testStoreRemoteNormalize() throws Exception {
        this.checkStorePath("/tmp/foo/../././", "/tmp");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetStoreSchema() throws Exception {
        PigServer ps = null;
        String storeSchemaOutputFile = this.outputFileName + "_storeSchema_test";
        try {
            ExecType[] modes = new ExecType[]{ExecType.MAPREDUCE, ExecType.LOCAL};
            String[] inputData = new String[]{"hello\tworld", "bye\tworld"};
            String script = "a = load '" + this.inputFileName + "';" + "store a into '" + this.outputFileName + "' using " + DummyStore.class.getName() + "();";
            for (ExecType execType : modes) {
                if (execType == ExecType.MAPREDUCE) {
                    ps = new PigServer(ExecType.MAPREDUCE, cluster.getProperties());
                    Util.deleteFile(ps.getPigContext(), this.inputFileName);
                    Util.deleteFile(ps.getPigContext(), this.outputFileName);
                    Util.deleteFile(ps.getPigContext(), storeSchemaOutputFile);
                } else {
                    Properties props = new Properties();
                    props.setProperty("fs.default.name", "file:///");
                    ps = new PigServer(ExecType.LOCAL, props);
                    Util.deleteFile(ps.getPigContext(), this.inputFileName);
                    Util.deleteFile(ps.getPigContext(), this.outputFileName);
                    Util.deleteFile(ps.getPigContext(), storeSchemaOutputFile);
                }
                ps.setBatchOn();
                Util.createInputFile(ps.getPigContext(), this.inputFileName, inputData);
                Util.registerMultiLineQuery(ps, script);
                ps.executeBatch();
                TestStore.assertEquals((String)("Checking if file indicating that storeSchema was called exists in " + execType + " mode"), (boolean)true, (boolean)Util.exists(ps.getPigContext(), storeSchemaOutputFile));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Exception encountered - hence failing:" + e));
        }
        finally {
            Util.deleteFile(ps.getPigContext(), this.inputFileName);
            Util.deleteFile(ps.getPigContext(), this.outputFileName);
            Util.deleteFile(ps.getPigContext(), storeSchemaOutputFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCleanupOnFailure() throws Exception {
        PigServer ps = null;
        String cleanupSuccessFile = this.outputFileName + "_cleanupOnFailure_succeeded";
        String cleanupFailFile = this.outputFileName + "_cleanupOnFailure_failed";
        try {
            ExecType[] modes = new ExecType[]{ExecType.LOCAL, ExecType.MAPREDUCE};
            String[] inputData = new String[]{"hello\tworld", "bye\tworld"};
            String script = "a = load '" + this.inputFileName + "';" + "store a into '" + this.outputFileName + "' using " + DummyStore.class.getName() + "('true');";
            for (ExecType execType : modes) {
                if (execType == ExecType.MAPREDUCE) {
                    ps = new PigServer(ExecType.MAPREDUCE, cluster.getProperties());
                } else {
                    Properties props = new Properties();
                    props.setProperty("fs.default.name", "file:///");
                    ps = new PigServer(ExecType.LOCAL, props);
                }
                Util.deleteFile(ps.getPigContext(), this.inputFileName);
                Util.deleteFile(ps.getPigContext(), this.outputFileName);
                Util.deleteFile(ps.getPigContext(), cleanupFailFile);
                Util.deleteFile(ps.getPigContext(), cleanupSuccessFile);
                ps.setBatchOn();
                Util.createInputFile(ps.getPigContext(), this.inputFileName, inputData);
                Util.registerMultiLineQuery(ps, script);
                ps.executeBatch();
                TestStore.assertEquals((String)("Checking if file indicating that cleanupOnFailure failed  does not exists in " + execType + " mode"), (boolean)false, (boolean)Util.exists(ps.getPigContext(), cleanupFailFile));
                TestStore.assertEquals((String)("Checking if file indicating that cleanupOnFailure was successfully called exists in " + execType + " mode"), (boolean)true, (boolean)Util.exists(ps.getPigContext(), cleanupSuccessFile));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Exception encountered - hence failing:" + e));
        }
        finally {
            Util.deleteFile(ps.getPigContext(), this.inputFileName);
            Util.deleteFile(ps.getPigContext(), this.outputFileName);
            Util.deleteFile(ps.getPigContext(), cleanupFailFile);
            Util.deleteFile(ps.getPigContext(), cleanupSuccessFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCleanupOnFailureMultiStore() throws Exception {
        PigServer ps = null;
        String outputFileName1 = "/tmp/TestStore-output-" + new Random().nextLong() + ".txt";
        String outputFileName2 = "/tmp/TestStore-output-" + new Random().nextLong() + ".txt";
        String cleanupSuccessFile1 = outputFileName1 + "_cleanupOnFailure_succeeded1";
        String cleanupFailFile1 = outputFileName1 + "_cleanupOnFailure_failed1";
        String cleanupSuccessFile2 = outputFileName2 + "_cleanupOnFailure_succeeded2";
        String cleanupFailFile2 = outputFileName2 + "_cleanupOnFailure_failed2";
        try {
            ExecType[] modes = new ExecType[]{ExecType.MAPREDUCE};
            String[] inputData = new String[]{"hello\tworld", "bye\tworld"};
            String script = "a = load '" + this.inputFileName + "';" + "store a into '" + outputFileName1 + "' using " + DummyStore.class.getName() + "('true', '1');" + "store a into '" + outputFileName2 + "' using " + DummyStore.class.getName() + "('false', '2');";
            for (ExecType execType : modes) {
                if (execType == ExecType.MAPREDUCE) {
                    ps = new PigServer(ExecType.MAPREDUCE, cluster.getProperties());
                } else {
                    Properties props = new Properties();
                    props.setProperty("fs.default.name", "file:///");
                    ps = new PigServer(ExecType.LOCAL, props);
                }
                Util.deleteFile(ps.getPigContext(), this.inputFileName);
                Util.deleteFile(ps.getPigContext(), outputFileName1);
                Util.deleteFile(ps.getPigContext(), outputFileName2);
                Util.deleteFile(ps.getPigContext(), cleanupFailFile1);
                Util.deleteFile(ps.getPigContext(), cleanupSuccessFile1);
                Util.deleteFile(ps.getPigContext(), cleanupFailFile2);
                Util.deleteFile(ps.getPigContext(), cleanupSuccessFile2);
                ps.setBatchOn();
                Util.createInputFile(ps.getPigContext(), this.inputFileName, inputData);
                Util.registerMultiLineQuery(ps, script);
                ps.executeBatch();
                TestStore.assertEquals((String)("Checking if file indicating that cleanupOnFailure failed  does not exists in " + execType + " mode"), (boolean)false, (boolean)Util.exists(ps.getPigContext(), cleanupFailFile1));
                TestStore.assertEquals((String)("Checking if file indicating that cleanupOnFailure failed  does not exists in " + execType + " mode"), (boolean)false, (boolean)Util.exists(ps.getPigContext(), cleanupFailFile2));
                TestStore.assertEquals((String)("Checking if file indicating that cleanupOnFailure was successfully called exists in " + execType + " mode"), (boolean)true, (boolean)Util.exists(ps.getPigContext(), cleanupSuccessFile1));
                TestStore.assertEquals((String)("Checking if file indicating that cleanupOnFailure was successfully called exists in " + execType + " mode"), (boolean)true, (boolean)Util.exists(ps.getPigContext(), cleanupSuccessFile2));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Exception encountered - hence failing:" + e));
        }
        finally {
            Util.deleteFile(ps.getPigContext(), this.inputFileName);
            Util.deleteFile(ps.getPigContext(), outputFileName1);
            Util.deleteFile(ps.getPigContext(), outputFileName2);
            Util.deleteFile(ps.getPigContext(), cleanupFailFile1);
            Util.deleteFile(ps.getPigContext(), cleanupSuccessFile1);
            Util.deleteFile(ps.getPigContext(), cleanupFailFile2);
            Util.deleteFile(ps.getPigContext(), cleanupSuccessFile2);
        }
    }

    private void checkStorePath(String orig, String expected) throws Exception {
        this.checkStorePath(orig, expected, false);
    }

    private void checkStorePath(String orig, String expected, boolean isTmp) throws Exception {
        this.pc.getProperties().setProperty("opt.multiquery", "true");
        DataStorage dfs = this.pc.getDfs();
        dfs.setActiveContainer(dfs.asContainer("/tmp"));
        HashMap aliases = new HashMap();
        HashMap logicalOpTable = new HashMap();
        HashMap aliasOp = new HashMap();
        HashMap fileNameMap = new HashMap();
        LogicalPlanBuilder builder = new LogicalPlanBuilder(this.pc);
        String query = "a = load 'foo';";
        LogicalPlan lp = builder.parse("Test-Store", query, aliases, logicalOpTable, aliasOp, fileNameMap);
        query = "store a into '" + orig + "';";
        lp = builder.parse("Test-Store", query, aliases, logicalOpTable, aliasOp, fileNameMap);
        Assert.assertTrue((lp.size() > 1 ? 1 : 0) != 0);
        LogicalOperator op = (LogicalOperator)lp.getLeaves().get(0);
        Assert.assertTrue((boolean)(op instanceof LOStore));
        LOStore store = (LOStore)op;
        String p = store.getOutputFile().getFileName();
        p = p.replaceAll("hdfs://[0-9a-zA-Z:\\.]*/", "/");
        if (isTmp) {
            Assert.assertTrue((boolean)p.matches("/tmp.*"));
        } else {
            Assert.assertEquals((String)p, (String)expected);
        }
    }

    public static class DummyStore
    extends PigStorage
    implements StoreMetadata {
        private boolean failInPutNext = false;
        private String outputFileSuffix = "";

        public DummyStore(String failInPutNextStr) {
            this.failInPutNext = Boolean.parseBoolean(failInPutNextStr);
        }

        public DummyStore(String failInPutNextStr, String outputFileSuffix) {
            this.failInPutNext = Boolean.parseBoolean(failInPutNextStr);
            this.outputFileSuffix = outputFileSuffix;
        }

        public DummyStore() {
        }

        public void putNext(Tuple t) throws IOException {
            if (this.failInPutNext) {
                throw new IOException("Failing in putNext");
            }
            super.putNext(t);
        }

        public void storeSchema(ResourceSchema schema, String location, Job job) throws IOException {
            FileSystem fs = FileSystem.get((Configuration)job.getConfiguration());
            fs.create(new Path(location + "_storeSchema_test"), false);
        }

        public void cleanupOnFailure(String location, Job job) throws IOException {
            super.cleanupOnFailure(location, job);
            Configuration conf = job.getConfiguration();
            FileSystem fs = FileSystem.get((Configuration)conf);
            if (fs.exists(new Path(location))) {
                fs.create(new Path(location + "_cleanupOnFailure_failed" + this.outputFileSuffix), false);
            }
            fs.create(new Path(location + "_cleanupOnFailure_succeeded" + this.outputFileSuffix), false);
        }

        public void storeStatistics(ResourceStatistics stats, String location, Job job) throws IOException {
        }
    }
}

