/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.IOException;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.ResourceSchema;
import org.apache.pig.builtin.PigStorage;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DefaultBagFactory;
import org.apache.pig.data.DefaultTupleFactory;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.junit.Test;

public class TestTextDataParser
extends TestCase {
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private TupleFactory tupleFactory = DefaultTupleFactory.getInstance();
    private BagFactory bagFactory = DefaultBagFactory.getInstance();
    PigStorage ps = new PigStorage();

    ResourceSchema.ResourceFieldSchema getTupleFieldSchema() throws IOException {
        ResourceSchema.ResourceFieldSchema stringfs = new ResourceSchema.ResourceFieldSchema();
        stringfs.setType((byte)55);
        ResourceSchema.ResourceFieldSchema intfs = new ResourceSchema.ResourceFieldSchema();
        intfs.setType((byte)10);
        ResourceSchema tupleSchema = new ResourceSchema();
        tupleSchema.setFields(new ResourceSchema.ResourceFieldSchema[]{intfs, stringfs});
        ResourceSchema.ResourceFieldSchema tuplefs = new ResourceSchema.ResourceFieldSchema();
        tuplefs.setSchema(tupleSchema);
        tuplefs.setType((byte)110);
        return tuplefs;
    }

    public ResourceSchema.ResourceFieldSchema getBagFieldSchema() throws IOException {
        ResourceSchema.ResourceFieldSchema tuplefs = this.getTupleFieldSchema();
        ResourceSchema outBagSchema = new ResourceSchema();
        outBagSchema.setFields(new ResourceSchema.ResourceFieldSchema[]{tuplefs});
        ResourceSchema.ResourceFieldSchema outBagfs = new ResourceSchema.ResourceFieldSchema();
        outBagfs.setSchema(outBagSchema);
        outBagfs.setType((byte)120);
        return outBagfs;
    }

    ResourceSchema.ResourceFieldSchema getLongFieldSchema() {
        ResourceSchema.ResourceFieldSchema longfs = new ResourceSchema.ResourceFieldSchema();
        longfs.setType((byte)15);
        return longfs;
    }

    @Test
    public void testInteger() throws Exception {
        String myInteger = "1";
        Integer i = this.ps.getLoadCaster().bytesToInteger(myInteger.getBytes());
        TestTextDataParser.assertTrue((boolean)i.equals(1));
    }

    @Test
    public void testLong() throws Exception {
        String myLong = "1l";
        Long l = this.ps.getLoadCaster().bytesToLong(myLong.getBytes());
        TestTextDataParser.assertTrue((boolean)l.equals(1L));
    }

    @Test
    public void testFloat() throws Exception {
        String myFloat = "0.1f";
        Float f = this.ps.getLoadCaster().bytesToFloat(myFloat.getBytes());
        TestTextDataParser.assertTrue((boolean)f.equals(Float.valueOf(0.1f)));
    }

    @Test
    public void testDouble() throws Exception {
        String myDouble = "0.1";
        Double d = this.ps.getLoadCaster().bytesToDouble(myDouble.getBytes());
        TestTextDataParser.assertTrue((boolean)d.equals(0.1));
    }

    @Test
    public void testString() throws Exception {
        String myString = "1a";
        String s = this.ps.getLoadCaster().bytesToCharArray(myString.getBytes());
        TestTextDataParser.assertTrue((boolean)s.equals(myString));
    }

    @Test
    public void testMapStringValueType() throws Exception {
        String myMap = "[key1#value1]";
        Map map = this.ps.getLoadCaster().bytesToMap(myMap.getBytes());
        String key = (String)map.keySet().iterator().next();
        Object v = map.get("key1");
        TestTextDataParser.assertTrue((boolean)key.equals("key1"));
        TestTextDataParser.assertTrue((boolean)(v instanceof DataByteArray));
        String value = new String(((DataByteArray)v).get());
        TestTextDataParser.assertTrue((boolean)value.equals("value1"));
    }

    @Test
    public void testMapIntegerValueType() throws Exception {
        String myMap = "[key1#1]";
        Map map = this.ps.getLoadCaster().bytesToMap(myMap.getBytes());
        String key = (String)map.keySet().iterator().next();
        Object v = map.get("key1");
        TestTextDataParser.assertTrue((boolean)key.equals("key1"));
        TestTextDataParser.assertTrue((boolean)(v instanceof DataByteArray));
        String value = new String(((DataByteArray)v).get());
        TestTextDataParser.assertTrue((boolean)value.equals("1"));
    }

    @Test
    public void testMapLongValueType() throws Exception {
        String myMap = "[key1#1l]";
        Map map = this.ps.getLoadCaster().bytesToMap(myMap.getBytes());
        String key = (String)map.keySet().iterator().next();
        Object v = map.get("key1");
        TestTextDataParser.assertTrue((boolean)key.equals("key1"));
        TestTextDataParser.assertTrue((boolean)(v instanceof DataByteArray));
        String value = new String(((DataByteArray)v).get());
        TestTextDataParser.assertTrue((boolean)value.equals("1l"));
    }

    @Test
    public void testMapFloatValueType() throws Exception {
        String myMap = "[key1#0.1f]";
        Map map = this.ps.getLoadCaster().bytesToMap(myMap.getBytes());
        String key = (String)map.keySet().iterator().next();
        Object v = map.get("key1");
        TestTextDataParser.assertTrue((boolean)key.equals("key1"));
        TestTextDataParser.assertTrue((boolean)(v instanceof DataByteArray));
        String value = new String(((DataByteArray)v).get());
        TestTextDataParser.assertTrue((boolean)value.equals("0.1f"));
    }

    @Test
    public void testMapDoubleValueType() throws Exception {
        String myMap = "[key1#0.1]";
        Map map = this.ps.getLoadCaster().bytesToMap(myMap.getBytes());
        String key = (String)map.keySet().iterator().next();
        Object v = map.get("key1");
        TestTextDataParser.assertTrue((boolean)key.equals("key1"));
        TestTextDataParser.assertTrue((boolean)(v instanceof DataByteArray));
        String value = new String(((DataByteArray)v).get());
        TestTextDataParser.assertTrue((boolean)value.equals("0.1"));
    }

    @Test
    public void testTuple() throws Exception {
        String myTuple = "(1,a)";
        Tuple o = this.ps.getLoadCaster().bytesToTuple(myTuple.getBytes(), this.getTupleFieldSchema());
        TestTextDataParser.assertTrue((boolean)(o instanceof Tuple));
        Tuple t = o;
        Tuple expectedTuple = this.tupleFactory.newTuple(2);
        expectedTuple.set(0, (Object)1);
        expectedTuple.set(1, (Object)"a");
        TestTextDataParser.assertTrue((boolean)t.equals(expectedTuple));
    }

    @Test
    public void testBag() throws Exception {
        String myBag = "{(1,a),(2,b)}";
        DataBag o = this.ps.getLoadCaster().bytesToBag(myBag.getBytes(), this.getBagFieldSchema());
        TestTextDataParser.assertTrue((boolean)(o instanceof DataBag));
        DataBag b = o;
        DataBag expectedBag = this.bagFactory.newDefaultBag();
        Tuple expectedTuple = this.tupleFactory.newTuple(2);
        expectedTuple.set(0, (Object)1);
        expectedTuple.set(1, (Object)"a");
        expectedBag.add(expectedTuple);
        expectedTuple = this.tupleFactory.newTuple(2);
        expectedTuple.set(0, (Object)2);
        expectedTuple.set(1, (Object)"b");
        expectedBag.add(expectedTuple);
        TestTextDataParser.assertTrue((boolean)b.equals(expectedBag));
    }

    @Test
    public void testEmptyBag() throws Exception {
        String myBag = "{}";
        DataBag o = this.ps.getLoadCaster().bytesToBag(myBag.getBytes(), this.getBagFieldSchema());
        TestTextDataParser.assertTrue((boolean)(o instanceof DataBag));
        DataBag b = o;
        TestTextDataParser.assertTrue((b.size() == 0L ? 1 : 0) != 0);
    }
}

