/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.apache.pig.EvalFunc;
import org.apache.pig.ExecType;
import org.apache.pig.FuncSpec;
import org.apache.pig.PigServer;
import org.apache.pig.builtin.PigStorage;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.io.FileSpec;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.LOAdd;
import org.apache.pig.impl.logicalLayer.LOAnd;
import org.apache.pig.impl.logicalLayer.LOBinCond;
import org.apache.pig.impl.logicalLayer.LOCast;
import org.apache.pig.impl.logicalLayer.LOCogroup;
import org.apache.pig.impl.logicalLayer.LOConst;
import org.apache.pig.impl.logicalLayer.LOCross;
import org.apache.pig.impl.logicalLayer.LODistinct;
import org.apache.pig.impl.logicalLayer.LODivide;
import org.apache.pig.impl.logicalLayer.LOEqual;
import org.apache.pig.impl.logicalLayer.LOFilter;
import org.apache.pig.impl.logicalLayer.LOForEach;
import org.apache.pig.impl.logicalLayer.LOGreaterThan;
import org.apache.pig.impl.logicalLayer.LOLesserThanEqual;
import org.apache.pig.impl.logicalLayer.LOLoad;
import org.apache.pig.impl.logicalLayer.LOMapLookup;
import org.apache.pig.impl.logicalLayer.LOMod;
import org.apache.pig.impl.logicalLayer.LOMultiply;
import org.apache.pig.impl.logicalLayer.LONegative;
import org.apache.pig.impl.logicalLayer.LONot;
import org.apache.pig.impl.logicalLayer.LONotEqual;
import org.apache.pig.impl.logicalLayer.LOProject;
import org.apache.pig.impl.logicalLayer.LORegexp;
import org.apache.pig.impl.logicalLayer.LOSort;
import org.apache.pig.impl.logicalLayer.LOSplit;
import org.apache.pig.impl.logicalLayer.LOSplitOutput;
import org.apache.pig.impl.logicalLayer.LOSubtract;
import org.apache.pig.impl.logicalLayer.LOUnion;
import org.apache.pig.impl.logicalLayer.LOVisitor;
import org.apache.pig.impl.logicalLayer.LogicalOperator;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.logicalLayer.validators.TypeCheckingValidator;
import org.apache.pig.impl.plan.CompilationMessageCollector;
import org.apache.pig.impl.plan.DepthFirstWalker;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.impl.plan.OperatorPlan;
import org.apache.pig.impl.plan.PlanValidationException;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.MultiMap;
import org.apache.pig.test.Util;
import org.apache.pig.test.utils.LogicalPlanTester;
import org.apache.pig.test.utils.TypeCheckingTestUtil;
import org.junit.Test;

public class TestTypeCheckingValidator
extends TestCase {
    LogicalPlanTester planTester;
    private static final String simpleEchoStreamingCommand = System.getProperty("os.name").toUpperCase().startsWith("WINDOWS") ? "perl -ne 'print \\\"$_\\\"'" : "perl -ne 'print \"$_\"'";

    protected void setUp() throws Exception {
        this.planTester = new LogicalPlanTester();
    }

    @Test
    public void testExpressionTypeChecking1() throws Throwable {
        LogicalPlan plan = new LogicalPlan();
        LOConst constant1 = new LOConst(plan, TypeCheckingTestUtil.genNewOperatorKey(), (Object)10);
        constant1.setType((byte)10);
        LOConst constant2 = new LOConst(plan, TypeCheckingTestUtil.genNewOperatorKey(), (Object)20.0);
        constant2.setType((byte)25);
        LOConst constant3 = new LOConst(plan, TypeCheckingTestUtil.genNewOperatorKey(), (Object)Float.valueOf(123.0f));
        constant3.setType((byte)20);
        LOAdd add1 = new LOAdd(plan, TypeCheckingTestUtil.genNewOperatorKey());
        LOCast cast1 = new LOCast(plan, TypeCheckingTestUtil.genNewOperatorKey(), 25);
        LOMultiply mul1 = new LOMultiply(plan, TypeCheckingTestUtil.genNewOperatorKey());
        plan.add((Operator)constant1);
        plan.add((Operator)constant2);
        plan.add((Operator)constant3);
        plan.add((Operator)cast1);
        plan.add((Operator)add1);
        plan.add((Operator)mul1);
        plan.connect((Operator)constant1, (Operator)add1);
        plan.connect((Operator)constant2, (Operator)add1);
        plan.connect((Operator)add1, (Operator)mul1);
        plan.connect((Operator)constant3, (Operator)cast1);
        plan.connect((Operator)cast1, (Operator)mul1);
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        if (collector.hasError()) {
            throw new Exception("Error during type checking");
        }
        TestTypeCheckingValidator.assertEquals((byte)25, (byte)add1.getType());
        TestTypeCheckingValidator.assertEquals((byte)25, (byte)mul1.getType());
        TestTypeCheckingValidator.assertEquals((byte)25, (byte)add1.getLhsOperand().getType());
        TestTypeCheckingValidator.assertEquals((byte)25, (byte)mul1.getRhsOperand().getType());
    }

    @Test
    public void testExpressionTypeCheckingFail1() throws Throwable {
        LogicalPlan plan = new LogicalPlan();
        LOConst constant1 = new LOConst(plan, TypeCheckingTestUtil.genNewOperatorKey(), (Object)10);
        constant1.setType((byte)10);
        LOConst constant2 = new LOConst(plan, TypeCheckingTestUtil.genNewOperatorKey(), (Object)20.0);
        constant2.setType((byte)25);
        LOConst constant3 = new LOConst(plan, TypeCheckingTestUtil.genNewOperatorKey(), (Object)"123");
        constant3.setType((byte)55);
        LOAdd add1 = new LOAdd(plan, TypeCheckingTestUtil.genNewOperatorKey());
        LOCast cast1 = new LOCast(plan, TypeCheckingTestUtil.genNewOperatorKey(), 50);
        LOMultiply mul1 = new LOMultiply(plan, TypeCheckingTestUtil.genNewOperatorKey());
        plan.add((Operator)constant1);
        plan.add((Operator)constant2);
        plan.add((Operator)constant3);
        plan.add((Operator)cast1);
        plan.add((Operator)add1);
        plan.add((Operator)mul1);
        plan.connect((Operator)constant1, (Operator)add1);
        plan.connect((Operator)constant2, (Operator)add1);
        plan.connect((Operator)add1, (Operator)mul1);
        plan.connect((Operator)constant3, (Operator)cast1);
        plan.connect((Operator)cast1, (Operator)mul1);
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        try {
            typeValidator.validate(plan, collector);
            TestTypeCheckingValidator.fail((String)"Exception expected");
        }
        catch (PlanValidationException pve) {
            // empty catch block
        }
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        if (!collector.hasError()) {
            throw new Exception("Error during type checking");
        }
    }

    @Test
    public void testExpressionTypeChecking2() throws Throwable {
        LogicalPlan plan = new LogicalPlan();
        LOConst constant1 = new LOConst(plan, TypeCheckingTestUtil.genNewOperatorKey(), (Object)10);
        constant1.setType((byte)10);
        LOConst constant2 = new LOConst(plan, TypeCheckingTestUtil.genNewOperatorKey(), (Object)new DataByteArray());
        constant2.setType((byte)50);
        LOConst constant3 = new LOConst(plan, TypeCheckingTestUtil.genNewOperatorKey(), (Object)123L);
        constant3.setType((byte)15);
        LOConst constant4 = new LOConst(plan, TypeCheckingTestUtil.genNewOperatorKey(), (Object)true);
        constant4.setType((byte)5);
        LOSubtract sub1 = new LOSubtract(plan, TypeCheckingTestUtil.genNewOperatorKey());
        LOGreaterThan gt1 = new LOGreaterThan(plan, TypeCheckingTestUtil.genNewOperatorKey());
        LOAnd and1 = new LOAnd(plan, TypeCheckingTestUtil.genNewOperatorKey());
        LONot not1 = new LONot(plan, TypeCheckingTestUtil.genNewOperatorKey());
        plan.add((Operator)constant1);
        plan.add((Operator)constant2);
        plan.add((Operator)constant3);
        plan.add((Operator)constant4);
        plan.add((Operator)sub1);
        plan.add((Operator)gt1);
        plan.add((Operator)and1);
        plan.add((Operator)not1);
        plan.connect((Operator)constant1, (Operator)sub1);
        plan.connect((Operator)constant2, (Operator)sub1);
        plan.connect((Operator)sub1, (Operator)gt1);
        plan.connect((Operator)constant3, (Operator)gt1);
        plan.connect((Operator)gt1, (Operator)and1);
        plan.connect((Operator)constant4, (Operator)and1);
        plan.connect((Operator)and1, (Operator)not1);
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        if (collector.hasError()) {
            throw new Exception("Error not expected during type checking");
        }
        TestTypeCheckingValidator.assertEquals((byte)10, (byte)sub1.getType());
        TestTypeCheckingValidator.assertEquals((byte)5, (byte)gt1.getType());
        TestTypeCheckingValidator.assertEquals((byte)5, (byte)and1.getType());
        TestTypeCheckingValidator.assertEquals((byte)5, (byte)not1.getType());
        TestTypeCheckingValidator.assertEquals((byte)10, (byte)sub1.getRhsOperand().getType());
        TestTypeCheckingValidator.assertEquals((byte)15, (byte)gt1.getLhsOperand().getType());
    }

    @Test
    public void testExpressionTypeChecking3() throws Throwable {
        LogicalPlan plan = new LogicalPlan();
        LOConst constant1 = new LOConst(plan, TypeCheckingTestUtil.genNewOperatorKey(), (Object)10);
        constant1.setType((byte)10);
        LOConst constant2 = new LOConst(plan, TypeCheckingTestUtil.genNewOperatorKey(), (Object)20L);
        constant2.setType((byte)15);
        LOConst constant3 = new LOConst(plan, TypeCheckingTestUtil.genNewOperatorKey(), (Object)123);
        constant3.setType((byte)10);
        LOMod mod1 = new LOMod(plan, TypeCheckingTestUtil.genNewOperatorKey());
        LOEqual equal1 = new LOEqual(plan, TypeCheckingTestUtil.genNewOperatorKey());
        plan.add((Operator)constant1);
        plan.add((Operator)constant2);
        plan.add((Operator)constant3);
        plan.add((Operator)equal1);
        plan.add((Operator)mod1);
        plan.connect((Operator)constant1, (Operator)mod1);
        plan.connect((Operator)constant2, (Operator)mod1);
        plan.connect((Operator)mod1, (Operator)equal1);
        plan.connect((Operator)constant3, (Operator)equal1);
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        if (collector.hasError()) {
            throw new Exception("Error during type checking");
        }
        TestTypeCheckingValidator.assertEquals((byte)15, (byte)mod1.getType());
        TestTypeCheckingValidator.assertEquals((byte)5, (byte)equal1.getType());
        TestTypeCheckingValidator.assertEquals((byte)15, (byte)mod1.getLhsOperand().getType());
        TestTypeCheckingValidator.assertEquals((byte)15, (byte)equal1.getRhsOperand().getType());
    }

    @Test
    public void testExpressionTypeChecking4() throws Throwable {
        LogicalPlan plan = new LogicalPlan();
        LOConst constant1 = new LOConst(plan, TypeCheckingTestUtil.genNewOperatorKey(), (Object)10);
        constant1.setType((byte)10);
        LOConst constant2 = new LOConst(plan, TypeCheckingTestUtil.genNewOperatorKey(), (Object)20.0);
        constant2.setType((byte)25);
        LOConst constant3 = new LOConst(plan, TypeCheckingTestUtil.genNewOperatorKey(), (Object)Float.valueOf(123.0f));
        constant3.setType((byte)20);
        LODivide div1 = new LODivide(plan, TypeCheckingTestUtil.genNewOperatorKey());
        LOCast cast1 = new LOCast(plan, TypeCheckingTestUtil.genNewOperatorKey(), 25);
        LONotEqual notequal1 = new LONotEqual(plan, TypeCheckingTestUtil.genNewOperatorKey());
        plan.add((Operator)constant1);
        plan.add((Operator)constant2);
        plan.add((Operator)constant3);
        plan.add((Operator)div1);
        plan.add((Operator)cast1);
        plan.add((Operator)notequal1);
        plan.connect((Operator)constant1, (Operator)div1);
        plan.connect((Operator)constant2, (Operator)div1);
        plan.connect((Operator)constant3, (Operator)cast1);
        plan.connect((Operator)div1, (Operator)notequal1);
        plan.connect((Operator)cast1, (Operator)notequal1);
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        if (collector.hasError()) {
            throw new Exception("Error during type checking");
        }
        TestTypeCheckingValidator.assertEquals((byte)25, (byte)div1.getType());
        TestTypeCheckingValidator.assertEquals((byte)5, (byte)notequal1.getType());
        TestTypeCheckingValidator.assertEquals((byte)25, (byte)div1.getLhsOperand().getType());
        TestTypeCheckingValidator.assertEquals((byte)25, (byte)notequal1.getRhsOperand().getType());
    }

    @Test
    public void testExpressionTypeCheckingFail4() throws Throwable {
        LogicalPlan plan = new LogicalPlan();
        LOConst constant1 = new LOConst(plan, TypeCheckingTestUtil.genNewOperatorKey(), (Object)10);
        constant1.setType((byte)10);
        LOConst constant2 = new LOConst(plan, TypeCheckingTestUtil.genNewOperatorKey(), (Object)20.0);
        constant2.setType((byte)25);
        LOConst constant3 = new LOConst(plan, TypeCheckingTestUtil.genNewOperatorKey(), (Object)"123");
        constant3.setType((byte)55);
        LODivide div1 = new LODivide(plan, TypeCheckingTestUtil.genNewOperatorKey());
        LOCast cast1 = new LOCast(plan, TypeCheckingTestUtil.genNewOperatorKey(), 50);
        LONotEqual notequal1 = new LONotEqual(plan, TypeCheckingTestUtil.genNewOperatorKey());
        plan.add((Operator)constant1);
        plan.add((Operator)constant2);
        plan.add((Operator)constant3);
        plan.add((Operator)div1);
        plan.add((Operator)cast1);
        plan.add((Operator)notequal1);
        plan.connect((Operator)constant1, (Operator)div1);
        plan.connect((Operator)constant2, (Operator)div1);
        plan.connect((Operator)constant3, (Operator)cast1);
        plan.connect((Operator)div1, (Operator)notequal1);
        plan.connect((Operator)cast1, (Operator)notequal1);
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        try {
            typeValidator.validate(plan, collector);
            TestTypeCheckingValidator.fail((String)"Exception expected");
        }
        catch (PlanValidationException pve) {
            // empty catch block
        }
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        if (!collector.hasError()) {
            throw new Exception("Error during type checking");
        }
    }

    @Test
    public void testExpressionTypeChecking5() throws Throwable {
        LogicalPlan plan = new LogicalPlan();
        LOConst constant1 = new LOConst(plan, TypeCheckingTestUtil.genNewOperatorKey(), (Object)Float.valueOf(10.0f));
        constant1.setType((byte)20);
        LOConst constant2 = new LOConst(plan, TypeCheckingTestUtil.genNewOperatorKey(), (Object)20L);
        constant2.setType((byte)15);
        LOConst constant3 = new LOConst(plan, TypeCheckingTestUtil.genNewOperatorKey(), (Object)Float.valueOf(123.0f));
        constant3.setType((byte)20);
        LOConst constant4 = new LOConst(plan, TypeCheckingTestUtil.genNewOperatorKey(), (Object)123.0);
        constant4.setType((byte)25);
        LOLesserThanEqual lesser1 = new LOLesserThanEqual(plan, TypeCheckingTestUtil.genNewOperatorKey());
        LOBinCond bincond1 = new LOBinCond(plan, TypeCheckingTestUtil.genNewOperatorKey());
        plan.add((Operator)constant1);
        plan.add((Operator)constant2);
        plan.add((Operator)constant3);
        plan.add((Operator)constant4);
        plan.add((Operator)lesser1);
        plan.add((Operator)bincond1);
        plan.connect((Operator)constant1, (Operator)lesser1);
        plan.connect((Operator)constant2, (Operator)lesser1);
        plan.connect((Operator)lesser1, (Operator)bincond1);
        plan.connect((Operator)constant3, (Operator)bincond1);
        plan.connect((Operator)constant4, (Operator)bincond1);
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        if (collector.hasError()) {
            throw new Exception("Error during type checking");
        }
        TestTypeCheckingValidator.assertEquals((byte)5, (byte)lesser1.getType());
        TestTypeCheckingValidator.assertEquals((byte)25, (byte)bincond1.getType());
        TestTypeCheckingValidator.assertEquals((byte)20, (byte)lesser1.getLhsOperand().getType());
        TestTypeCheckingValidator.assertEquals((byte)20, (byte)lesser1.getRhsOperand().getType());
        TestTypeCheckingValidator.assertEquals((byte)25, (byte)bincond1.getLhsOp().getType());
        TestTypeCheckingValidator.assertEquals((byte)25, (byte)bincond1.getRhsOp().getType());
    }

    @Test
    public void testExpressionTypeChecking6() throws Throwable {
        LogicalPlan plan = new LogicalPlan();
        LOConst constant1 = new LOConst(plan, TypeCheckingTestUtil.genNewOperatorKey(), (Object)"10");
        constant1.setType((byte)55);
        LOConst constant2 = new LOConst(plan, TypeCheckingTestUtil.genNewOperatorKey(), (Object)20L);
        constant2.setType((byte)15);
        LOAdd add1 = new LOAdd(plan, TypeCheckingTestUtil.genNewOperatorKey());
        plan.add((Operator)constant1);
        plan.add((Operator)constant2);
        plan.add((Operator)add1);
        plan.connect((Operator)constant1, (Operator)add1);
        plan.connect((Operator)constant2, (Operator)add1);
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        try {
            typeValidator.validate(plan, collector);
            TestTypeCheckingValidator.fail((String)"Exception expected");
        }
        catch (PlanValidationException pve) {
            // empty catch block
        }
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        if (!collector.hasError()) {
            throw new AssertionError((Object)"Error expected");
        }
    }

    @Test
    public void testExpressionTypeChecking7() throws Throwable {
        LogicalPlan plan = new LogicalPlan();
        LOConst constant1 = new LOConst(plan, TypeCheckingTestUtil.genNewOperatorKey(), (Object)10);
        constant1.setType((byte)10);
        LOConst constant2 = new LOConst(plan, TypeCheckingTestUtil.genNewOperatorKey(), (Object)20.0);
        constant2.setType((byte)50);
        LOConst constant3 = new LOConst(plan, TypeCheckingTestUtil.genNewOperatorKey(), (Object)123L);
        constant3.setType((byte)15);
        LOGreaterThan gt1 = new LOGreaterThan(plan, TypeCheckingTestUtil.genNewOperatorKey());
        LOEqual equal1 = new LOEqual(plan, TypeCheckingTestUtil.genNewOperatorKey());
        plan.add((Operator)constant1);
        plan.add((Operator)constant2);
        plan.add((Operator)constant3);
        plan.add((Operator)gt1);
        plan.add((Operator)equal1);
        plan.connect((Operator)constant1, (Operator)gt1);
        plan.connect((Operator)constant2, (Operator)gt1);
        plan.connect((Operator)gt1, (Operator)equal1);
        plan.connect((Operator)constant3, (Operator)equal1);
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        try {
            typeValidator.validate(plan, collector);
            TestTypeCheckingValidator.fail((String)"Exception expected");
        }
        catch (PlanValidationException pve) {
            // empty catch block
        }
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        if (!collector.hasError()) {
            throw new AssertionError((Object)"Error expected");
        }
    }

    @Test
    public void testExpressionTypeChecking8() throws Throwable {
        LogicalPlan plan = new LogicalPlan();
        TupleFactory tupleFactory = TupleFactory.getInstance();
        ArrayList<Integer> innerObjList = new ArrayList<Integer>();
        ArrayList<Object> objList = new ArrayList<Object>();
        innerObjList.add(10);
        innerObjList.add(3);
        innerObjList.add(7);
        innerObjList.add(17);
        Tuple innerTuple = tupleFactory.newTuple(innerObjList);
        objList.add("World");
        objList.add(42);
        objList.add(innerTuple);
        Tuple tuple = tupleFactory.newTuple(objList);
        ArrayList<Schema.FieldSchema> innerFss = new ArrayList<Schema.FieldSchema>();
        ArrayList<Schema.FieldSchema> fss = new ArrayList<Schema.FieldSchema>();
        ArrayList<Schema.FieldSchema> castFss = new ArrayList<Schema.FieldSchema>();
        Schema.FieldSchema stringFs = new Schema.FieldSchema(null, 55);
        Schema.FieldSchema intFs = new Schema.FieldSchema(null, 10);
        for (int i = 0; i < innerObjList.size(); ++i) {
            innerFss.add(intFs);
        }
        Schema innerTupleSchema = new Schema(innerFss);
        fss.add(stringFs);
        fss.add(intFs);
        fss.add(new Schema.FieldSchema(null, innerTupleSchema, 110));
        Schema tupleSchema = new Schema(fss);
        for (int i = 0; i < 3; ++i) {
            castFss.add(stringFs);
        }
        Schema castSchema = new Schema(castFss);
        LOConst constant1 = new LOConst(plan, TypeCheckingTestUtil.genNewOperatorKey(), (Object)innerTuple);
        constant1.setType((byte)110);
        constant1.setFieldSchema(new Schema.FieldSchema(null, innerTupleSchema, 110));
        LOConst constant2 = new LOConst(plan, TypeCheckingTestUtil.genNewOperatorKey(), (Object)tuple);
        constant2.setType((byte)110);
        constant2.setFieldSchema(new Schema.FieldSchema(null, tupleSchema, 110));
        LOCast cast1 = new LOCast(plan, TypeCheckingTestUtil.genNewOperatorKey(), 110);
        cast1.setFieldSchema(new Schema.FieldSchema(null, castSchema, 110));
        LOEqual equal1 = new LOEqual(plan, TypeCheckingTestUtil.genNewOperatorKey());
        plan.add((Operator)constant1);
        plan.add((Operator)constant2);
        plan.add((Operator)cast1);
        plan.add((Operator)equal1);
        plan.connect((Operator)constant1, (Operator)cast1);
        plan.connect((Operator)cast1, (Operator)equal1);
        plan.connect((Operator)constant2, (Operator)equal1);
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        if (collector.hasError()) {
            throw new Exception("Error during type checking");
        }
        TestTypeCheckingValidator.assertEquals((byte)5, (byte)equal1.getType());
        TestTypeCheckingValidator.assertEquals((byte)110, (byte)equal1.getRhsOperand().getType());
        TestTypeCheckingValidator.assertEquals((byte)110, (byte)equal1.getLhsOperand().getType());
    }

    @Test
    public void testExpressionTypeChecking9() throws Throwable {
        LogicalPlan plan = new LogicalPlan();
        TupleFactory tupleFactory = TupleFactory.getInstance();
        ArrayList<Object> innerObjList = new ArrayList<Object>();
        ArrayList<Object> objList = new ArrayList<Object>();
        innerObjList.add("10");
        innerObjList.add("3");
        innerObjList.add(7);
        innerObjList.add("17");
        Tuple innerTuple = tupleFactory.newTuple(innerObjList);
        objList.add("World");
        objList.add(42);
        objList.add(innerTuple);
        Tuple tuple = tupleFactory.newTuple(objList);
        ArrayList<Schema.FieldSchema> innerFss = new ArrayList<Schema.FieldSchema>();
        ArrayList<Schema.FieldSchema> fss = new ArrayList<Schema.FieldSchema>();
        ArrayList<Schema.FieldSchema> castFss = new ArrayList<Schema.FieldSchema>();
        Schema.FieldSchema stringFs = new Schema.FieldSchema(null, 55);
        Schema.FieldSchema intFs = new Schema.FieldSchema(null, 10);
        Schema.FieldSchema doubleFs = new Schema.FieldSchema(null, 25);
        innerFss.add(stringFs);
        innerFss.add(stringFs);
        innerFss.add(intFs);
        innerFss.add(stringFs);
        Schema innerTupleSchema = new Schema(innerFss);
        fss.add(stringFs);
        fss.add(intFs);
        fss.add(new Schema.FieldSchema(null, innerTupleSchema, 110));
        Schema tupleSchema = new Schema(fss);
        castFss.add(stringFs);
        castFss.add(stringFs);
        castFss.add(doubleFs);
        castFss.add(intFs);
        Schema castSchema = new Schema(castFss);
        LOConst constant1 = new LOConst(plan, TypeCheckingTestUtil.genNewOperatorKey(), (Object)innerTuple);
        constant1.setType((byte)110);
        constant1.setFieldSchema(new Schema.FieldSchema(null, innerTupleSchema, 110));
        LOConst constant2 = new LOConst(plan, TypeCheckingTestUtil.genNewOperatorKey(), (Object)tuple);
        constant2.setType((byte)110);
        constant2.setFieldSchema(new Schema.FieldSchema(null, tupleSchema, 110));
        LOCast cast1 = new LOCast(plan, TypeCheckingTestUtil.genNewOperatorKey(), 110);
        cast1.setFieldSchema(new Schema.FieldSchema(null, castSchema, 110));
        LOEqual equal1 = new LOEqual(plan, TypeCheckingTestUtil.genNewOperatorKey());
        plan.add((Operator)constant1);
        plan.add((Operator)constant2);
        plan.add((Operator)cast1);
        plan.add((Operator)equal1);
        plan.connect((Operator)constant1, (Operator)cast1);
        plan.connect((Operator)cast1, (Operator)equal1);
        plan.connect((Operator)constant2, (Operator)equal1);
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        try {
            typeValidator.validate(plan, collector);
        }
        catch (PlanValidationException pve) {
            TestTypeCheckingValidator.fail((String)"Exception expected");
        }
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        if (collector.hasError()) {
            throw new Exception("Error expected");
        }
    }

    @Test
    public void testArithmeticOpCastInsert1() throws Throwable {
        LogicalPlan plan = new LogicalPlan();
        LOConst constant1 = new LOConst(plan, TypeCheckingTestUtil.genNewOperatorKey(), (Object)10);
        constant1.setType((byte)10);
        LOConst constant2 = new LOConst(plan, TypeCheckingTestUtil.genNewOperatorKey(), (Object)20.0);
        constant2.setType((byte)25);
        LOMultiply mul1 = new LOMultiply(plan, TypeCheckingTestUtil.genNewOperatorKey());
        plan.add((Operator)constant1);
        plan.add((Operator)constant2);
        plan.add((Operator)mul1);
        plan.connect((Operator)constant1, (Operator)mul1);
        plan.connect((Operator)constant2, (Operator)mul1);
        System.out.println(DataType.findTypeName((byte)mul1.getType()));
        TestTypeCheckingValidator.assertEquals((byte)25, (byte)mul1.getType());
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        System.out.println(DataType.findTypeName((byte)mul1.getType()));
        TestTypeCheckingValidator.assertEquals((byte)25, (byte)mul1.getType());
    }

    @Test
    public void testArithmeticOpCastInsert2() throws Throwable {
        LogicalPlan plan = new LogicalPlan();
        LOConst constant1 = new LOConst(plan, TypeCheckingTestUtil.genNewOperatorKey(), (Object)10);
        constant1.setType((byte)10);
        LOConst constant2 = new LOConst(plan, TypeCheckingTestUtil.genNewOperatorKey(), (Object)20L);
        constant2.setType((byte)15);
        LONegative neg1 = new LONegative(plan, TypeCheckingTestUtil.genNewOperatorKey());
        LOSubtract subtract1 = new LOSubtract(plan, TypeCheckingTestUtil.genNewOperatorKey());
        plan.add((Operator)constant1);
        plan.add((Operator)neg1);
        plan.add((Operator)constant2);
        plan.add((Operator)subtract1);
        plan.connect((Operator)constant1, (Operator)neg1);
        plan.connect((Operator)neg1, (Operator)subtract1);
        plan.connect((Operator)constant2, (Operator)subtract1);
        TestTypeCheckingValidator.assertEquals((byte)15, (byte)subtract1.getType());
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        System.out.println(DataType.findTypeName((byte)subtract1.getType()));
        TestTypeCheckingValidator.assertEquals((byte)15, (byte)subtract1.getType());
        TestTypeCheckingValidator.assertTrue((boolean)(subtract1.getLhsOperand() instanceof LOCast));
        TestTypeCheckingValidator.assertEquals((byte)((LOCast)subtract1.getLhsOperand()).getType(), (byte)15);
        TestTypeCheckingValidator.assertTrue((((LOCast)subtract1.getLhsOperand()).getExpression() == neg1 ? 1 : 0) != 0);
    }

    @Test
    public void testModCastInsert1() throws Throwable {
        LogicalPlan plan = new LogicalPlan();
        LOConst constant1 = new LOConst(plan, TypeCheckingTestUtil.genNewOperatorKey(), (Object)10);
        constant1.setType((byte)50);
        LOConst constant2 = new LOConst(plan, TypeCheckingTestUtil.genNewOperatorKey(), (Object)20L);
        constant2.setType((byte)15);
        LOMod mod1 = new LOMod(plan, TypeCheckingTestUtil.genNewOperatorKey());
        plan.add((Operator)constant1);
        plan.add((Operator)constant2);
        plan.add((Operator)mod1);
        plan.connect((Operator)constant1, (Operator)mod1);
        plan.connect((Operator)constant2, (Operator)mod1);
        TestTypeCheckingValidator.assertEquals((byte)15, (byte)mod1.getType());
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        System.out.println(DataType.findTypeName((byte)mod1.getType()));
        TestTypeCheckingValidator.assertEquals((byte)15, (byte)mod1.getType());
        TestTypeCheckingValidator.assertTrue((boolean)(mod1.getLhsOperand() instanceof LOCast));
        TestTypeCheckingValidator.assertEquals((byte)((LOCast)mod1.getLhsOperand()).getType(), (byte)15);
        TestTypeCheckingValidator.assertTrue((((LOCast)mod1.getLhsOperand()).getExpression() == constant1 ? 1 : 0) != 0);
    }

    @Test
    public void testRegexTypeChecking1() throws Throwable {
        LogicalPlan plan = new LogicalPlan();
        LOConst constant1 = new LOConst(plan, TypeCheckingTestUtil.genNewOperatorKey(), (Object)"10");
        LOConst constant2 = new LOConst(plan, TypeCheckingTestUtil.genNewOperatorKey(), (Object)"Regex");
        constant1.setType((byte)55);
        LORegexp regex = new LORegexp(plan, TypeCheckingTestUtil.genNewOperatorKey());
        plan.add((Operator)constant1);
        plan.add((Operator)constant2);
        plan.add((Operator)regex);
        plan.connect((Operator)constant1, (Operator)regex);
        plan.connect((Operator)constant2, (Operator)regex);
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        System.out.println(DataType.findTypeName((byte)regex.getType()));
        TestTypeCheckingValidator.assertEquals((byte)5, (byte)regex.getType());
    }

    @Test
    public void testRegexTypeChecking2() throws Throwable {
        LogicalPlan plan = new LogicalPlan();
        LOConst constant1 = new LOConst(plan, TypeCheckingTestUtil.genNewOperatorKey(), (Object)new DataByteArray());
        LOConst constant2 = new LOConst(plan, TypeCheckingTestUtil.genNewOperatorKey(), (Object)"Regex");
        constant1.setType((byte)50);
        LORegexp regex = new LORegexp(plan, TypeCheckingTestUtil.genNewOperatorKey());
        plan.add((Operator)constant1);
        plan.add((Operator)constant2);
        plan.add((Operator)regex);
        plan.connect((Operator)constant1, (Operator)regex);
        plan.connect((Operator)constant2, (Operator)regex);
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        if (collector.hasError()) {
            throw new Exception("Error not expected during type checking");
        }
        System.out.println(DataType.findTypeName((byte)regex.getType()));
        TestTypeCheckingValidator.assertEquals((byte)5, (byte)regex.getType());
        LOCast cast = (LOCast)regex.getOperand();
        TestTypeCheckingValidator.assertEquals((byte)cast.getType(), (byte)55);
        TestTypeCheckingValidator.assertEquals((Object)cast.getExpression(), (Object)constant1);
    }

    @Test
    public void testRegexTypeChecking3() throws Throwable {
        LogicalPlan plan = new LogicalPlan();
        LOConst constant1 = new LOConst(plan, TypeCheckingTestUtil.genNewOperatorKey(), (Object)10);
        LOConst constant2 = new LOConst(plan, TypeCheckingTestUtil.genNewOperatorKey(), (Object)"Regex");
        constant1.setType((byte)10);
        LORegexp regex = new LORegexp(plan, TypeCheckingTestUtil.genNewOperatorKey());
        plan.add((Operator)constant1);
        plan.add((Operator)constant2);
        plan.add((Operator)regex);
        plan.connect((Operator)constant1, (Operator)regex);
        plan.connect((Operator)constant2, (Operator)regex);
        try {
            CompilationMessageCollector collector = new CompilationMessageCollector();
            TypeCheckingValidator typeValidator = new TypeCheckingValidator();
            typeValidator.validate(plan, collector);
            TypeCheckingTestUtil.printMessageCollector(collector);
            TestTypeCheckingValidator.fail((String)"Exception expected");
        }
        catch (PlanValidationException pve) {
            // empty catch block
        }
    }

    @Test
    public void testUnionCastingInsert1() throws Throwable {
        TypeCheckingTestUtil.printCurrentMethodName();
        LogicalPlan plan = new LogicalPlan();
        String pigStorage = PigStorage.class.getName();
        LOLoad load1 = new LOLoad(plan, TypeCheckingTestUtil.genNewOperatorKey(), new FileSpec("pi", new FuncSpec(pigStorage)), null);
        LOLoad load2 = new LOLoad(plan, TypeCheckingTestUtil.genNewOperatorKey(), new FileSpec("pi", new FuncSpec(pigStorage)), null);
        Schema inputSchema1 = null;
        ArrayList<Schema.FieldSchema> fsList1 = new ArrayList<Schema.FieldSchema>();
        fsList1.add(new Schema.FieldSchema("field1a", 10));
        fsList1.add(new Schema.FieldSchema("field2a", 15));
        fsList1.add(new Schema.FieldSchema(null, 50));
        fsList1.add(new Schema.FieldSchema(null, 55));
        inputSchema1 = new Schema(fsList1);
        Schema inputSchema2 = null;
        ArrayList<Schema.FieldSchema> fsList2 = new ArrayList<Schema.FieldSchema>();
        fsList2.add(new Schema.FieldSchema("field1b", 25));
        fsList2.add(new Schema.FieldSchema(null, 10));
        fsList2.add(new Schema.FieldSchema("field3b", 20));
        fsList2.add(new Schema.FieldSchema("field4b", 55));
        inputSchema2 = new Schema(fsList2);
        load1.setEnforcedSchema(inputSchema1);
        load2.setEnforcedSchema(inputSchema2);
        ArrayList<LOLoad> inputList = new ArrayList<LOLoad>();
        inputList.add(load1);
        inputList.add(load2);
        LOUnion union = new LOUnion(plan, TypeCheckingTestUtil.genNewOperatorKey());
        plan.add((Operator)load1);
        plan.add((Operator)load2);
        plan.add((Operator)union);
        plan.connect((Operator)load1, (Operator)union);
        plan.connect((Operator)load2, (Operator)union);
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        Schema outputSchema = union.getSchema();
        Schema expectedSchema = null;
        ArrayList<Schema.FieldSchema> fsListExpected = new ArrayList<Schema.FieldSchema>();
        fsListExpected.add(new Schema.FieldSchema("field1a", 25));
        fsListExpected.add(new Schema.FieldSchema("field2a", 15));
        fsListExpected.add(new Schema.FieldSchema("field3b", 20));
        fsListExpected.add(new Schema.FieldSchema("field4b", 55));
        expectedSchema = new Schema(fsListExpected);
        TestTypeCheckingValidator.assertTrue((boolean)Schema.equals((Schema)outputSchema, (Schema)expectedSchema, (boolean)true, (boolean)false));
        TypeCheckingTestUtil.printTypeGraph(plan);
        List sucList1 = plan.getSuccessors((Operator)load1);
        TestTypeCheckingValidator.assertEquals((int)sucList1.size(), (int)1);
        LOForEach foreach = (LOForEach)sucList1.get(0);
        TestTypeCheckingValidator.assertTrue((boolean)(foreach instanceof LOForEach));
        List sucList2 = plan.getSuccessors((Operator)foreach);
        TestTypeCheckingValidator.assertEquals((int)sucList2.size(), (int)1);
        TestTypeCheckingValidator.assertTrue((boolean)(sucList2.get(0) instanceof LOUnion));
        this.checkForEachCasting(foreach, 0, true, (byte)25);
        this.checkForEachCasting(foreach, 1, false, (byte)0);
        this.checkForEachCasting(foreach, 2, true, (byte)20);
        this.checkForEachCasting(foreach, 3, false, (byte)0);
        sucList1 = plan.getSuccessors((Operator)load2);
        TestTypeCheckingValidator.assertEquals((int)sucList1.size(), (int)1);
        foreach = (LOForEach)sucList1.get(0);
        TestTypeCheckingValidator.assertTrue((boolean)(foreach instanceof LOForEach));
        sucList2 = plan.getSuccessors((Operator)foreach);
        TestTypeCheckingValidator.assertEquals((int)sucList2.size(), (int)1);
        TestTypeCheckingValidator.assertTrue((boolean)(sucList2.get(0) instanceof LOUnion));
        this.checkForEachCasting(foreach, 0, false, (byte)0);
        this.checkForEachCasting(foreach, 1, true, (byte)15);
        this.checkForEachCasting(foreach, 2, false, (byte)0);
        this.checkForEachCasting(foreach, 3, false, (byte)0);
    }

    @Test
    public void testUnionCastingInsert2() throws Throwable {
        TypeCheckingTestUtil.printCurrentMethodName();
        LogicalPlan plan = new LogicalPlan();
        String pigStorage = PigStorage.class.getName();
        LOLoad load1 = new LOLoad(plan, TypeCheckingTestUtil.genNewOperatorKey(), new FileSpec("pi", new FuncSpec(pigStorage)), null);
        LOLoad load2 = new LOLoad(plan, TypeCheckingTestUtil.genNewOperatorKey(), new FileSpec("pi", new FuncSpec(pigStorage)), null);
        Schema inputSchema1 = null;
        ArrayList<Schema.FieldSchema> fsList1 = new ArrayList<Schema.FieldSchema>();
        fsList1.add(new Schema.FieldSchema("field1a", 10));
        fsList1.add(new Schema.FieldSchema("field2a", 50));
        inputSchema1 = new Schema(fsList1);
        Schema inputSchema2 = null;
        ArrayList<Schema.FieldSchema> fsList2 = new ArrayList<Schema.FieldSchema>();
        fsList2.add(new Schema.FieldSchema("field1b", 25));
        fsList2.add(new Schema.FieldSchema("field2b", 25));
        inputSchema2 = new Schema(fsList2);
        load1.setEnforcedSchema(inputSchema1);
        load2.setEnforcedSchema(inputSchema2);
        ArrayList<LOLoad> inputList = new ArrayList<LOLoad>();
        inputList.add(load1);
        inputList.add(load2);
        LOUnion union = new LOUnion(plan, TypeCheckingTestUtil.genNewOperatorKey());
        plan.add((Operator)load1);
        plan.add((Operator)load2);
        plan.add((Operator)union);
        plan.connect((Operator)load1, (Operator)union);
        plan.connect((Operator)load2, (Operator)union);
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        Schema outputSchema = union.getSchema();
        Schema expectedSchema = null;
        ArrayList<Schema.FieldSchema> fsListExpected = new ArrayList<Schema.FieldSchema>();
        fsListExpected.add(new Schema.FieldSchema("field1a", 25));
        fsListExpected.add(new Schema.FieldSchema("field2a", 25));
        expectedSchema = new Schema(fsListExpected);
        TestTypeCheckingValidator.assertTrue((boolean)Schema.equals((Schema)outputSchema, (Schema)expectedSchema, (boolean)true, (boolean)false));
        TypeCheckingTestUtil.printTypeGraph(plan);
        List sucList1 = plan.getSuccessors((Operator)load1);
        TestTypeCheckingValidator.assertEquals((int)sucList1.size(), (int)1);
        LOForEach foreach = (LOForEach)sucList1.get(0);
        TestTypeCheckingValidator.assertTrue((boolean)(foreach instanceof LOForEach));
        List sucList2 = plan.getSuccessors((Operator)foreach);
        TestTypeCheckingValidator.assertEquals((int)sucList2.size(), (int)1);
        TestTypeCheckingValidator.assertTrue((boolean)(sucList2.get(0) instanceof LOUnion));
        this.checkForEachCasting(foreach, 0, true, (byte)25);
        this.checkForEachCasting(foreach, 1, true, (byte)25);
        sucList1 = plan.getSuccessors((Operator)load2);
        TestTypeCheckingValidator.assertEquals((int)sucList1.size(), (int)1);
        TestTypeCheckingValidator.assertTrue((boolean)(sucList1.get(0) instanceof LOUnion));
    }

    @Test
    public void testDistinct1() throws Throwable {
        TypeCheckingTestUtil.printCurrentMethodName();
        LogicalPlan plan = new LogicalPlan();
        String pigStorage = PigStorage.class.getName();
        LOLoad load1 = new LOLoad(plan, TypeCheckingTestUtil.genNewOperatorKey(), new FileSpec("pi", new FuncSpec(pigStorage)), null);
        Schema inputSchema1 = null;
        ArrayList<Schema.FieldSchema> innerList = new ArrayList<Schema.FieldSchema>();
        innerList.add(new Schema.FieldSchema("innerfield1", 120));
        innerList.add(new Schema.FieldSchema("innerfield2", 20));
        Schema innerSchema = new Schema(innerList);
        ArrayList<Schema.FieldSchema> fsList1 = new ArrayList<Schema.FieldSchema>();
        fsList1.add(new Schema.FieldSchema("field1", 10));
        fsList1.add(new Schema.FieldSchema("field2", 50));
        fsList1.add(new Schema.FieldSchema("field3", innerSchema));
        fsList1.add(new Schema.FieldSchema("field4", 120));
        inputSchema1 = new Schema(fsList1);
        load1.setEnforcedSchema(inputSchema1);
        ArrayList<LOLoad> inputList = new ArrayList<LOLoad>();
        inputList.add(load1);
        LODistinct distinct1 = new LODistinct(plan, TypeCheckingTestUtil.genNewOperatorKey());
        plan.add((Operator)load1);
        plan.add((Operator)distinct1);
        plan.connect((Operator)load1, (Operator)distinct1);
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        Schema outputSchema = distinct1.getSchema();
        TestTypeCheckingValidator.assertTrue((boolean)Schema.equals((Schema)load1.getSchema(), (Schema)outputSchema, (boolean)false, (boolean)false));
    }

    @Test
    public void testFilterWithInnerPlan1() throws Throwable {
        this.testFilterWithInnerPlan((byte)10, (byte)15);
    }

    @Test
    public void testFilterWithInnerPlan2() throws Throwable {
        this.testFilterWithInnerPlan((byte)10, (byte)50);
    }

    public void testFilterWithInnerPlan(byte field1Type, byte field2Type) throws Throwable {
        TypeCheckingTestUtil.printCurrentMethodName();
        LogicalPlan plan = new LogicalPlan();
        String pigStorage = PigStorage.class.getName();
        LOLoad load1 = new LOLoad(plan, TypeCheckingTestUtil.genNewOperatorKey(), new FileSpec("pi", new FuncSpec(pigStorage)), null);
        Schema inputSchema1 = null;
        ArrayList<Schema.FieldSchema> fsList1 = new ArrayList<Schema.FieldSchema>();
        fsList1.add(new Schema.FieldSchema("field1", field1Type));
        fsList1.add(new Schema.FieldSchema("field2", field2Type));
        inputSchema1 = new Schema(fsList1);
        load1.setEnforcedSchema(inputSchema1);
        LogicalPlan innerPlan = new LogicalPlan();
        LOProject project1 = new LOProject(innerPlan, TypeCheckingTestUtil.genNewOperatorKey(), (LogicalOperator)load1, Integer.valueOf(0));
        project1.setSentinel(true);
        LOProject project2 = new LOProject(innerPlan, TypeCheckingTestUtil.genNewOperatorKey(), (LogicalOperator)load1, Integer.valueOf(1));
        project2.setSentinel(true);
        LOGreaterThan gt1 = new LOGreaterThan(innerPlan, TypeCheckingTestUtil.genNewOperatorKey());
        innerPlan.add((Operator)project1);
        innerPlan.add((Operator)project2);
        innerPlan.add((Operator)gt1);
        innerPlan.connect((Operator)project1, (Operator)gt1);
        innerPlan.connect((Operator)project2, (Operator)gt1);
        LOFilter filter1 = new LOFilter(plan, TypeCheckingTestUtil.genNewOperatorKey(), innerPlan);
        plan.add((Operator)load1);
        plan.add((Operator)filter1);
        plan.connect((Operator)load1, (Operator)filter1);
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no error");
        }
        Schema endResultSchema = filter1.getSchema();
        TestTypeCheckingValidator.assertEquals((byte)endResultSchema.getField((int)0).type, (byte)field1Type);
        TestTypeCheckingValidator.assertEquals((byte)endResultSchema.getField((int)1).type, (byte)field2Type);
    }

    @Test
    public void testFilterWithInnerPlan3() throws Throwable {
        TypeCheckingTestUtil.printCurrentMethodName();
        LogicalPlan plan = new LogicalPlan();
        String pigStorage = PigStorage.class.getName();
        LOLoad load1 = new LOLoad(plan, TypeCheckingTestUtil.genNewOperatorKey(), new FileSpec("pi", new FuncSpec(pigStorage)), null);
        Schema inputSchema1 = null;
        ArrayList<Schema.FieldSchema> fsList1 = new ArrayList<Schema.FieldSchema>();
        fsList1.add(new Schema.FieldSchema("field1", 10));
        fsList1.add(new Schema.FieldSchema("field2", 15));
        inputSchema1 = new Schema(fsList1);
        load1.setEnforcedSchema(inputSchema1);
        LogicalPlan innerPlan = new LogicalPlan();
        LOProject project1 = new LOProject(innerPlan, TypeCheckingTestUtil.genNewOperatorKey(), (LogicalOperator)load1, Integer.valueOf(0));
        project1.setSentinel(true);
        LOProject project2 = new LOProject(innerPlan, TypeCheckingTestUtil.genNewOperatorKey(), (LogicalOperator)load1, Integer.valueOf(1));
        project2.setSentinel(true);
        LOAdd add1 = new LOAdd(innerPlan, TypeCheckingTestUtil.genNewOperatorKey());
        innerPlan.add((Operator)project1);
        innerPlan.add((Operator)project2);
        innerPlan.add((Operator)add1);
        innerPlan.connect((Operator)project1, (Operator)add1);
        innerPlan.connect((Operator)project2, (Operator)add1);
        LOFilter filter1 = new LOFilter(plan, TypeCheckingTestUtil.genNewOperatorKey(), innerPlan);
        plan.add((Operator)load1);
        plan.add((Operator)filter1);
        plan.connect((Operator)load1, (Operator)filter1);
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        try {
            typeValidator.validate(plan, collector);
            TestTypeCheckingValidator.fail((String)"Error expected");
        }
        catch (Exception t) {
            // empty catch block
        }
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        if (!collector.hasError()) {
            throw new AssertionError((Object)"Expect error");
        }
    }

    @Test
    public void testSortWithInnerPlan1() throws Throwable {
        TypeCheckingTestUtil.printCurrentMethodName();
        LogicalPlan plan = new LogicalPlan();
        String pigStorage = PigStorage.class.getName();
        LOLoad load1 = new LOLoad(plan, TypeCheckingTestUtil.genNewOperatorKey(), new FileSpec("pi", new FuncSpec(pigStorage)), null);
        Schema inputSchema1 = null;
        ArrayList<Schema.FieldSchema> fsList1 = new ArrayList<Schema.FieldSchema>();
        fsList1.add(new Schema.FieldSchema("field1", 15));
        fsList1.add(new Schema.FieldSchema("field2", 10));
        inputSchema1 = new Schema(fsList1);
        load1.setEnforcedSchema(inputSchema1);
        LogicalPlan innerPlan1 = new LogicalPlan();
        LOProject project1 = new LOProject(innerPlan1, TypeCheckingTestUtil.genNewOperatorKey(), (LogicalOperator)load1, Integer.valueOf(1));
        project1.setSentinel(true);
        innerPlan1.add((Operator)project1);
        LogicalPlan innerPlan2 = new LogicalPlan();
        LOProject project2 = new LOProject(innerPlan2, TypeCheckingTestUtil.genNewOperatorKey(), (LogicalOperator)load1, Integer.valueOf(0));
        project1.setSentinel(true);
        innerPlan2.add((Operator)project2);
        ArrayList<LogicalPlan> innerPlans = new ArrayList<LogicalPlan>();
        innerPlans.add(innerPlan1);
        innerPlans.add(innerPlan2);
        ArrayList<Boolean> ascList = new ArrayList<Boolean>();
        ascList.add(true);
        ascList.add(true);
        LOSort sort1 = new LOSort(plan, TypeCheckingTestUtil.genNewOperatorKey(), innerPlans, ascList, null);
        plan.add((Operator)load1);
        plan.add((Operator)sort1);
        plan.connect((Operator)load1, (Operator)sort1);
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no error");
        }
        Schema endResultSchema = sort1.getSchema();
        TestTypeCheckingValidator.assertEquals((byte)endResultSchema.getField((int)0).type, (byte)15);
        TestTypeCheckingValidator.assertEquals((byte)endResultSchema.getField((int)1).type, (byte)10);
        TestTypeCheckingValidator.assertEquals((byte)innerPlan1.getSingleLeafPlanOutputType(), (byte)10);
        TestTypeCheckingValidator.assertEquals((byte)innerPlan2.getSingleLeafPlanOutputType(), (byte)15);
    }

    @Test
    public void testSortWithInnerPlan2() throws Throwable {
        TypeCheckingTestUtil.printCurrentMethodName();
        LogicalPlan plan = new LogicalPlan();
        String pigStorage = PigStorage.class.getName();
        LOLoad load1 = new LOLoad(plan, TypeCheckingTestUtil.genNewOperatorKey(), new FileSpec("pi", new FuncSpec(pigStorage)), null);
        Schema inputSchema1 = null;
        ArrayList<Schema.FieldSchema> fsList1 = new ArrayList<Schema.FieldSchema>();
        fsList1.add(new Schema.FieldSchema("field1", 50));
        fsList1.add(new Schema.FieldSchema("field2", 10));
        inputSchema1 = new Schema(fsList1);
        load1.setEnforcedSchema(inputSchema1);
        LogicalPlan innerPlan1 = new LogicalPlan();
        LOProject project11 = new LOProject(innerPlan1, TypeCheckingTestUtil.genNewOperatorKey(), (LogicalOperator)load1, Integer.valueOf(0));
        project11.setSentinel(true);
        LOProject project12 = new LOProject(innerPlan1, TypeCheckingTestUtil.genNewOperatorKey(), (LogicalOperator)load1, Integer.valueOf(1));
        project11.setSentinel(true);
        LOMultiply mul1 = new LOMultiply(innerPlan1, TypeCheckingTestUtil.genNewOperatorKey());
        innerPlan1.add((Operator)project11);
        innerPlan1.add((Operator)project12);
        innerPlan1.add((Operator)mul1);
        innerPlan1.connect((Operator)project11, (Operator)mul1);
        innerPlan1.connect((Operator)project12, (Operator)mul1);
        LogicalPlan innerPlan2 = new LogicalPlan();
        LOProject project21 = new LOProject(innerPlan2, TypeCheckingTestUtil.genNewOperatorKey(), (LogicalOperator)load1, Integer.valueOf(0));
        project21.setSentinel(true);
        LOConst const21 = new LOConst(innerPlan2, TypeCheckingTestUtil.genNewOperatorKey(), (Object)26L);
        const21.setType((byte)15);
        LOMod mod21 = new LOMod(innerPlan2, TypeCheckingTestUtil.genNewOperatorKey());
        innerPlan2.add((Operator)project21);
        innerPlan2.add((Operator)const21);
        innerPlan2.add((Operator)mod21);
        innerPlan2.connect((Operator)project21, (Operator)mod21);
        innerPlan2.connect((Operator)const21, (Operator)mod21);
        ArrayList<LogicalPlan> innerPlans = new ArrayList<LogicalPlan>();
        innerPlans.add(innerPlan1);
        innerPlans.add(innerPlan2);
        ArrayList<Boolean> ascList = new ArrayList<Boolean>();
        ascList.add(true);
        ascList.add(true);
        LOSort sort1 = new LOSort(plan, TypeCheckingTestUtil.genNewOperatorKey(), innerPlans, ascList, null);
        plan.add((Operator)load1);
        plan.add((Operator)sort1);
        plan.connect((Operator)load1, (Operator)sort1);
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no error");
        }
        Schema endResultSchema = sort1.getSchema();
        TestTypeCheckingValidator.assertEquals((byte)endResultSchema.getField((int)0).type, (byte)50);
        TestTypeCheckingValidator.assertEquals((byte)endResultSchema.getField((int)1).type, (byte)10);
        TestTypeCheckingValidator.assertEquals((byte)innerPlan1.getSingleLeafPlanOutputType(), (byte)10);
        TestTypeCheckingValidator.assertEquals((byte)innerPlan2.getSingleLeafPlanOutputType(), (byte)15);
    }

    @Test
    public void testSortWithInnerPlan3() throws Throwable {
        TypeCheckingTestUtil.printCurrentMethodName();
        LogicalPlan plan = new LogicalPlan();
        String pigStorage = PigStorage.class.getName();
        LOLoad load1 = new LOLoad(plan, TypeCheckingTestUtil.genNewOperatorKey(), new FileSpec("pi", new FuncSpec(pigStorage)), null);
        Schema inputSchema1 = null;
        ArrayList<Schema.FieldSchema> fsList1 = new ArrayList<Schema.FieldSchema>();
        fsList1.add(new Schema.FieldSchema("field1", 50));
        fsList1.add(new Schema.FieldSchema("field2", 10));
        inputSchema1 = new Schema(fsList1);
        load1.setEnforcedSchema(inputSchema1);
        LogicalPlan innerPlan1 = new LogicalPlan();
        LOProject project11 = new LOProject(innerPlan1, TypeCheckingTestUtil.genNewOperatorKey(), (LogicalOperator)load1, Integer.valueOf(0));
        project11.setSentinel(true);
        LOProject project12 = new LOProject(innerPlan1, TypeCheckingTestUtil.genNewOperatorKey(), (LogicalOperator)load1, Integer.valueOf(1));
        project11.setSentinel(true);
        LOMultiply mul1 = new LOMultiply(innerPlan1, TypeCheckingTestUtil.genNewOperatorKey());
        innerPlan1.add((Operator)project11);
        innerPlan1.add((Operator)project12);
        innerPlan1.add((Operator)mul1);
        innerPlan1.connect((Operator)project11, (Operator)mul1);
        innerPlan1.connect((Operator)project12, (Operator)mul1);
        LogicalPlan innerPlan2 = new LogicalPlan();
        LOProject project21 = new LOProject(innerPlan2, TypeCheckingTestUtil.genNewOperatorKey(), (LogicalOperator)load1, Integer.valueOf(0));
        project21.setSentinel(true);
        LOConst const21 = new LOConst(innerPlan2, TypeCheckingTestUtil.genNewOperatorKey(), (Object)"26");
        const21.setType((byte)55);
        LOMod mod21 = new LOMod(innerPlan2, TypeCheckingTestUtil.genNewOperatorKey());
        innerPlan2.add((Operator)project21);
        innerPlan2.add((Operator)const21);
        innerPlan2.add((Operator)mod21);
        innerPlan2.connect((Operator)project21, (Operator)mod21);
        innerPlan2.connect((Operator)const21, (Operator)mod21);
        ArrayList<LogicalPlan> innerPlans = new ArrayList<LogicalPlan>();
        innerPlans.add(innerPlan1);
        innerPlans.add(innerPlan2);
        ArrayList<Boolean> ascList = new ArrayList<Boolean>();
        ascList.add(true);
        ascList.add(true);
        LOSort sort1 = new LOSort(plan, TypeCheckingTestUtil.genNewOperatorKey(), innerPlans, ascList, null);
        plan.add((Operator)load1);
        plan.add((Operator)sort1);
        plan.connect((Operator)load1, (Operator)sort1);
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        try {
            typeValidator.validate(plan, collector);
            TestTypeCheckingValidator.fail((String)"Error expected");
        }
        catch (Exception t) {
            // empty catch block
        }
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        if (!collector.hasError()) {
            throw new AssertionError((Object)"Error expected");
        }
    }

    @Test
    public void testSplitWithInnerPlan1() throws Throwable {
        TypeCheckingTestUtil.printCurrentMethodName();
        LogicalPlan plan = new LogicalPlan();
        String pigStorage = PigStorage.class.getName();
        LOLoad load1 = new LOLoad(plan, TypeCheckingTestUtil.genNewOperatorKey(), new FileSpec("pi", new FuncSpec(pigStorage)), null);
        Schema inputSchema1 = null;
        ArrayList<Schema.FieldSchema> fsList1 = new ArrayList<Schema.FieldSchema>();
        fsList1.add(new Schema.FieldSchema("field1", 50));
        fsList1.add(new Schema.FieldSchema("field2", 10));
        inputSchema1 = new Schema(fsList1);
        load1.setEnforcedSchema(inputSchema1);
        LogicalPlan innerPlan1 = new LogicalPlan();
        LOProject project11 = new LOProject(innerPlan1, TypeCheckingTestUtil.genNewOperatorKey(), (LogicalOperator)load1, Integer.valueOf(0));
        project11.setSentinel(true);
        LOProject project12 = new LOProject(innerPlan1, TypeCheckingTestUtil.genNewOperatorKey(), (LogicalOperator)load1, Integer.valueOf(1));
        project11.setSentinel(true);
        LONotEqual notequal1 = new LONotEqual(innerPlan1, TypeCheckingTestUtil.genNewOperatorKey());
        innerPlan1.add((Operator)project11);
        innerPlan1.add((Operator)project12);
        innerPlan1.add((Operator)notequal1);
        innerPlan1.connect((Operator)project11, (Operator)notequal1);
        innerPlan1.connect((Operator)project12, (Operator)notequal1);
        LogicalPlan innerPlan2 = new LogicalPlan();
        LOProject project21 = new LOProject(innerPlan2, TypeCheckingTestUtil.genNewOperatorKey(), (LogicalOperator)load1, Integer.valueOf(0));
        project21.setSentinel(true);
        LOConst const21 = new LOConst(innerPlan2, TypeCheckingTestUtil.genNewOperatorKey(), (Object)26);
        const21.setType((byte)15);
        LOLesserThanEqual lesser21 = new LOLesserThanEqual(innerPlan2, TypeCheckingTestUtil.genNewOperatorKey());
        innerPlan2.add((Operator)project21);
        innerPlan2.add((Operator)const21);
        innerPlan2.add((Operator)lesser21);
        innerPlan2.connect((Operator)project21, (Operator)lesser21);
        innerPlan2.connect((Operator)const21, (Operator)lesser21);
        ArrayList<LogicalPlan> innerPlans = new ArrayList<LogicalPlan>();
        innerPlans.add(innerPlan1);
        innerPlans.add(innerPlan2);
        LOSplit split1 = new LOSplit(plan, TypeCheckingTestUtil.genNewOperatorKey(), new ArrayList());
        LOSplitOutput splitOutput1 = new LOSplitOutput(plan, TypeCheckingTestUtil.genNewOperatorKey(), 0, innerPlan1);
        split1.addOutput((LogicalOperator)splitOutput1);
        LOSplitOutput splitOutput2 = new LOSplitOutput(plan, TypeCheckingTestUtil.genNewOperatorKey(), 1, innerPlan2);
        split1.addOutput((LogicalOperator)splitOutput2);
        plan.add((Operator)load1);
        plan.add((Operator)split1);
        plan.add((Operator)splitOutput1);
        plan.add((Operator)splitOutput2);
        plan.connect((Operator)load1, (Operator)split1);
        plan.connect((Operator)split1, (Operator)splitOutput1);
        plan.connect((Operator)split1, (Operator)splitOutput2);
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no error");
        }
        Schema endResultSchema1 = split1.getSchema();
        TestTypeCheckingValidator.assertEquals((byte)endResultSchema1.getField((int)0).type, (byte)50);
        TestTypeCheckingValidator.assertEquals((byte)endResultSchema1.getField((int)1).type, (byte)10);
        endResultSchema1 = splitOutput1.getSchema();
        TestTypeCheckingValidator.assertEquals((byte)endResultSchema1.getField((int)0).type, (byte)50);
        TestTypeCheckingValidator.assertEquals((byte)endResultSchema1.getField((int)1).type, (byte)10);
        Schema endResultSchema2 = splitOutput2.getSchema();
        TestTypeCheckingValidator.assertEquals((byte)endResultSchema2.getField((int)0).type, (byte)50);
        TestTypeCheckingValidator.assertEquals((byte)endResultSchema2.getField((int)1).type, (byte)10);
        TestTypeCheckingValidator.assertEquals((byte)innerPlan1.getSingleLeafPlanOutputType(), (byte)5);
        TestTypeCheckingValidator.assertEquals((byte)innerPlan2.getSingleLeafPlanOutputType(), (byte)5);
    }

    @Test
    public void testSplitWithInnerPlan2() throws Throwable {
        TypeCheckingTestUtil.printCurrentMethodName();
        LogicalPlan plan = new LogicalPlan();
        String pigStorage = PigStorage.class.getName();
        LOLoad load1 = new LOLoad(plan, TypeCheckingTestUtil.genNewOperatorKey(), new FileSpec("pi", new FuncSpec(pigStorage)), null);
        Schema inputSchema1 = null;
        ArrayList<Schema.FieldSchema> fsList1 = new ArrayList<Schema.FieldSchema>();
        fsList1.add(new Schema.FieldSchema("field1", 50));
        fsList1.add(new Schema.FieldSchema("field2", 10));
        inputSchema1 = new Schema(fsList1);
        load1.setEnforcedSchema(inputSchema1);
        LogicalPlan innerPlan1 = new LogicalPlan();
        LOProject project11 = new LOProject(innerPlan1, TypeCheckingTestUtil.genNewOperatorKey(), (LogicalOperator)load1, Integer.valueOf(0));
        project11.setSentinel(true);
        LOProject project12 = new LOProject(innerPlan1, TypeCheckingTestUtil.genNewOperatorKey(), (LogicalOperator)load1, Integer.valueOf(1));
        project11.setSentinel(true);
        LONotEqual notequal1 = new LONotEqual(innerPlan1, TypeCheckingTestUtil.genNewOperatorKey());
        innerPlan1.add((Operator)project11);
        innerPlan1.add((Operator)project12);
        innerPlan1.add((Operator)notequal1);
        innerPlan1.connect((Operator)project11, (Operator)notequal1);
        innerPlan1.connect((Operator)project12, (Operator)notequal1);
        LogicalPlan innerPlan2 = new LogicalPlan();
        LOProject project21 = new LOProject(innerPlan2, TypeCheckingTestUtil.genNewOperatorKey(), (LogicalOperator)load1, Integer.valueOf(0));
        project21.setSentinel(true);
        LOConst const21 = new LOConst(innerPlan2, TypeCheckingTestUtil.genNewOperatorKey(), (Object)26);
        const21.setType((byte)15);
        LOSubtract subtract21 = new LOSubtract(innerPlan2, TypeCheckingTestUtil.genNewOperatorKey());
        innerPlan2.add((Operator)project21);
        innerPlan2.add((Operator)const21);
        innerPlan2.add((Operator)subtract21);
        innerPlan2.connect((Operator)project21, (Operator)subtract21);
        innerPlan2.connect((Operator)const21, (Operator)subtract21);
        ArrayList<LogicalPlan> innerPlans = new ArrayList<LogicalPlan>();
        innerPlans.add(innerPlan1);
        innerPlans.add(innerPlan2);
        LOSplit split1 = new LOSplit(plan, TypeCheckingTestUtil.genNewOperatorKey(), new ArrayList());
        LOSplitOutput splitOutput1 = new LOSplitOutput(plan, TypeCheckingTestUtil.genNewOperatorKey(), 0, innerPlan1);
        split1.addOutput((LogicalOperator)splitOutput1);
        LOSplitOutput splitOutput2 = new LOSplitOutput(plan, TypeCheckingTestUtil.genNewOperatorKey(), 1, innerPlan2);
        split1.addOutput((LogicalOperator)splitOutput2);
        plan.add((Operator)load1);
        plan.add((Operator)split1);
        plan.add((Operator)splitOutput1);
        plan.add((Operator)splitOutput2);
        plan.connect((Operator)load1, (Operator)split1);
        plan.connect((Operator)split1, (Operator)splitOutput1);
        plan.connect((Operator)split1, (Operator)splitOutput2);
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        try {
            typeValidator.validate(plan, collector);
        }
        catch (Exception t) {
            // empty catch block
        }
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        if (!collector.hasError()) {
            throw new AssertionError((Object)"Error expected");
        }
    }

    @Test
    public void testCOGroupWithInnerPlan1GroupByTuple1() throws Throwable {
        TypeCheckingTestUtil.printCurrentMethodName();
        LogicalPlan plan = new LogicalPlan();
        String pigStorage = PigStorage.class.getName();
        LOLoad load1 = new LOLoad(plan, TypeCheckingTestUtil.genNewOperatorKey(), new FileSpec("pi", new FuncSpec(pigStorage)), null);
        LOLoad load2 = new LOLoad(plan, TypeCheckingTestUtil.genNewOperatorKey(), new FileSpec("pi", new FuncSpec(pigStorage)), null);
        Schema inputSchema1 = null;
        ArrayList<Schema.FieldSchema> fsList1 = new ArrayList<Schema.FieldSchema>();
        fsList1.add(new Schema.FieldSchema("field1a", 10));
        fsList1.add(new Schema.FieldSchema("field2a", 15));
        inputSchema1 = new Schema(fsList1);
        Schema inputSchema2 = null;
        ArrayList<Schema.FieldSchema> fsList2 = new ArrayList<Schema.FieldSchema>();
        fsList2.add(new Schema.FieldSchema("field1b", 25));
        fsList2.add(new Schema.FieldSchema(null, 10));
        inputSchema2 = new Schema(fsList2);
        load1.setEnforcedSchema(inputSchema1);
        load2.setEnforcedSchema(inputSchema2);
        LogicalPlan innerPlan11 = new LogicalPlan();
        LOProject project111 = new LOProject(innerPlan11, TypeCheckingTestUtil.genNewOperatorKey(), (LogicalOperator)load1, Integer.valueOf(0));
        project111.setSentinel(true);
        LOConst const111 = new LOConst(innerPlan11, TypeCheckingTestUtil.genNewOperatorKey(), (Object)Float.valueOf(26.0f));
        const111.setType((byte)20);
        LOSubtract subtract111 = new LOSubtract(innerPlan11, TypeCheckingTestUtil.genNewOperatorKey());
        innerPlan11.add((Operator)project111);
        innerPlan11.add((Operator)const111);
        innerPlan11.add((Operator)subtract111);
        innerPlan11.connect((Operator)project111, (Operator)subtract111);
        innerPlan11.connect((Operator)const111, (Operator)subtract111);
        LogicalPlan innerPlan21 = new LogicalPlan();
        LOProject project211 = new LOProject(innerPlan21, TypeCheckingTestUtil.genNewOperatorKey(), (LogicalOperator)load1, Integer.valueOf(0));
        project211.setSentinel(true);
        LOProject project212 = new LOProject(innerPlan21, TypeCheckingTestUtil.genNewOperatorKey(), (LogicalOperator)load1, Integer.valueOf(1));
        project212.setSentinel(true);
        LOAdd add211 = new LOAdd(innerPlan21, TypeCheckingTestUtil.genNewOperatorKey());
        innerPlan21.add((Operator)project211);
        innerPlan21.add((Operator)project212);
        innerPlan21.add((Operator)add211);
        innerPlan21.connect((Operator)project211, (Operator)add211);
        innerPlan21.connect((Operator)project212, (Operator)add211);
        LogicalPlan innerPlan12 = new LogicalPlan();
        LOProject project121 = new LOProject(innerPlan12, TypeCheckingTestUtil.genNewOperatorKey(), (LogicalOperator)load2, Integer.valueOf(0));
        project121.setSentinel(true);
        LOConst const121 = new LOConst(innerPlan12, TypeCheckingTestUtil.genNewOperatorKey(), (Object)26);
        const121.setType((byte)10);
        LOSubtract subtract121 = new LOSubtract(innerPlan12, TypeCheckingTestUtil.genNewOperatorKey());
        innerPlan12.add((Operator)project121);
        innerPlan12.add((Operator)const121);
        innerPlan12.add((Operator)subtract121);
        innerPlan12.connect((Operator)project121, (Operator)subtract121);
        innerPlan12.connect((Operator)const121, (Operator)subtract121);
        LogicalPlan innerPlan22 = new LogicalPlan();
        LOConst const122 = new LOConst(innerPlan22, TypeCheckingTestUtil.genNewOperatorKey(), (Object)26);
        const122.setType((byte)10);
        innerPlan22.add((Operator)const122);
        ArrayList<LOLoad> inputs = new ArrayList<LOLoad>();
        inputs.add(load1);
        inputs.add(load2);
        MultiMap maps = new MultiMap();
        maps.put((Object)load1, (Object)innerPlan11);
        maps.put((Object)load1, (Object)innerPlan21);
        maps.put((Object)load2, (Object)innerPlan12);
        maps.put((Object)load2, (Object)innerPlan22);
        boolean[] isInner = new boolean[inputs.size()];
        for (int i = 0; i < isInner.length; ++i) {
            isInner[i] = false;
        }
        LOCogroup cogroup1 = new LOCogroup(plan, TypeCheckingTestUtil.genNewOperatorKey(), maps, isInner);
        plan.add((Operator)load1);
        plan.add((Operator)load2);
        plan.add((Operator)cogroup1);
        plan.connect((Operator)load1, (Operator)cogroup1);
        plan.connect((Operator)load2, (Operator)cogroup1);
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no error");
        }
        Schema endResultSchema = cogroup1.getSchema();
        TestTypeCheckingValidator.assertEquals((byte)endResultSchema.getField((int)0).type, (byte)110);
        TestTypeCheckingValidator.assertEquals((byte)endResultSchema.getField((int)0).schema.getField((int)0).type, (byte)25);
        TestTypeCheckingValidator.assertEquals((byte)endResultSchema.getField((int)0).schema.getField((int)1).type, (byte)15);
        TestTypeCheckingValidator.assertEquals((byte)endResultSchema.getField((int)1).type, (byte)120);
        TestTypeCheckingValidator.assertEquals((byte)endResultSchema.getField((int)2).type, (byte)120);
        Schema innerSchema1 = endResultSchema.getField((int)1).schema;
        TestTypeCheckingValidator.assertEquals((byte)innerSchema1.getField((int)0).type, (byte)10);
        TestTypeCheckingValidator.assertEquals((byte)innerSchema1.getField((int)1).type, (byte)15);
        Schema innerSchema2 = endResultSchema.getField((int)2).schema;
        TestTypeCheckingValidator.assertEquals((byte)innerSchema2.getField((int)0).type, (byte)25);
        TestTypeCheckingValidator.assertEquals((byte)innerSchema2.getField((int)1).type, (byte)10);
        TestTypeCheckingValidator.assertEquals((byte)innerPlan11.getSingleLeafPlanOutputType(), (byte)25);
        TestTypeCheckingValidator.assertEquals((byte)innerPlan21.getSingleLeafPlanOutputType(), (byte)15);
        TestTypeCheckingValidator.assertEquals((byte)innerPlan12.getSingleLeafPlanOutputType(), (byte)25);
        TestTypeCheckingValidator.assertEquals((byte)innerPlan22.getSingleLeafPlanOutputType(), (byte)15);
    }

    @Test
    public void testCOGroupWithInnerPlan1GroupByAtom1() throws Throwable {
        TypeCheckingTestUtil.printCurrentMethodName();
        LogicalPlan plan = new LogicalPlan();
        String pigStorage = PigStorage.class.getName();
        LOLoad load1 = new LOLoad(plan, TypeCheckingTestUtil.genNewOperatorKey(), new FileSpec("pi", new FuncSpec(pigStorage)), null);
        LOLoad load2 = new LOLoad(plan, TypeCheckingTestUtil.genNewOperatorKey(), new FileSpec("pi", new FuncSpec(pigStorage)), null);
        Schema inputSchema1 = null;
        ArrayList<Schema.FieldSchema> fsList1 = new ArrayList<Schema.FieldSchema>();
        fsList1.add(new Schema.FieldSchema("field1a", 10));
        fsList1.add(new Schema.FieldSchema("field2a", 15));
        inputSchema1 = new Schema(fsList1);
        Schema inputSchema2 = null;
        ArrayList<Schema.FieldSchema> fsList2 = new ArrayList<Schema.FieldSchema>();
        fsList2.add(new Schema.FieldSchema("field1b", 25));
        fsList2.add(new Schema.FieldSchema(null, 10));
        inputSchema2 = new Schema(fsList2);
        load1.setEnforcedSchema(inputSchema1);
        load2.setEnforcedSchema(inputSchema2);
        LogicalPlan innerPlan11 = new LogicalPlan();
        LOProject project111 = new LOProject(innerPlan11, TypeCheckingTestUtil.genNewOperatorKey(), (LogicalOperator)load1, Integer.valueOf(0));
        project111.setSentinel(true);
        LOConst const111 = new LOConst(innerPlan11, TypeCheckingTestUtil.genNewOperatorKey(), (Object)Float.valueOf(26.0f));
        const111.setType((byte)20);
        LOSubtract subtract111 = new LOSubtract(innerPlan11, TypeCheckingTestUtil.genNewOperatorKey());
        innerPlan11.add((Operator)project111);
        innerPlan11.add((Operator)const111);
        innerPlan11.add((Operator)subtract111);
        innerPlan11.connect((Operator)project111, (Operator)subtract111);
        innerPlan11.connect((Operator)const111, (Operator)subtract111);
        LogicalPlan innerPlan12 = new LogicalPlan();
        LOProject project121 = new LOProject(innerPlan12, TypeCheckingTestUtil.genNewOperatorKey(), (LogicalOperator)load2, Integer.valueOf(0));
        project121.setSentinel(true);
        LOConst const121 = new LOConst(innerPlan12, TypeCheckingTestUtil.genNewOperatorKey(), (Object)26);
        const121.setType((byte)10);
        LOSubtract subtract121 = new LOSubtract(innerPlan12, TypeCheckingTestUtil.genNewOperatorKey());
        innerPlan12.add((Operator)project121);
        innerPlan12.add((Operator)const121);
        innerPlan12.add((Operator)subtract121);
        innerPlan12.connect((Operator)project121, (Operator)subtract121);
        innerPlan12.connect((Operator)const121, (Operator)subtract121);
        ArrayList<LOLoad> inputs = new ArrayList<LOLoad>();
        inputs.add(load1);
        inputs.add(load2);
        MultiMap maps = new MultiMap();
        maps.put((Object)load1, (Object)innerPlan11);
        maps.put((Object)load2, (Object)innerPlan12);
        boolean[] isInner = new boolean[inputs.size()];
        for (int i = 0; i < isInner.length; ++i) {
            isInner[i] = false;
        }
        LOCogroup cogroup1 = new LOCogroup(plan, TypeCheckingTestUtil.genNewOperatorKey(), maps, isInner);
        plan.add((Operator)load1);
        plan.add((Operator)load2);
        plan.add((Operator)cogroup1);
        plan.connect((Operator)load1, (Operator)cogroup1);
        plan.connect((Operator)load2, (Operator)cogroup1);
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no error");
        }
        Schema endResultSchema = cogroup1.getSchema();
        TestTypeCheckingValidator.assertEquals((byte)endResultSchema.getField((int)0).type, (byte)25);
        TestTypeCheckingValidator.assertEquals((byte)endResultSchema.getField((int)1).type, (byte)120);
        TestTypeCheckingValidator.assertEquals((byte)endResultSchema.getField((int)2).type, (byte)120);
        Schema innerSchema1 = endResultSchema.getField((int)1).schema;
        TestTypeCheckingValidator.assertEquals((byte)innerSchema1.getField((int)0).type, (byte)10);
        TestTypeCheckingValidator.assertEquals((byte)innerSchema1.getField((int)1).type, (byte)15);
        Schema innerSchema2 = endResultSchema.getField((int)2).schema;
        TestTypeCheckingValidator.assertEquals((byte)innerSchema2.getField((int)0).type, (byte)25);
        TestTypeCheckingValidator.assertEquals((byte)innerSchema2.getField((int)1).type, (byte)10);
        TestTypeCheckingValidator.assertEquals((byte)innerPlan11.getSingleLeafPlanOutputType(), (byte)25);
        TestTypeCheckingValidator.assertEquals((byte)innerPlan12.getSingleLeafPlanOutputType(), (byte)25);
    }

    @Test
    public void testCOGroupWithInnerPlan1GroupByIncompatibleAtom1() throws Throwable {
        TypeCheckingTestUtil.printCurrentMethodName();
        LogicalPlan plan = new LogicalPlan();
        String pigStorage = PigStorage.class.getName();
        LOLoad load1 = new LOLoad(plan, TypeCheckingTestUtil.genNewOperatorKey(), new FileSpec("pi", new FuncSpec(pigStorage)), null);
        LOLoad load2 = new LOLoad(plan, TypeCheckingTestUtil.genNewOperatorKey(), new FileSpec("pi", new FuncSpec(pigStorage)), null);
        Schema inputSchema1 = null;
        ArrayList<Schema.FieldSchema> fsList1 = new ArrayList<Schema.FieldSchema>();
        fsList1.add(new Schema.FieldSchema("field1a", 10));
        fsList1.add(new Schema.FieldSchema("field2a", 15));
        inputSchema1 = new Schema(fsList1);
        Schema inputSchema2 = null;
        ArrayList<Schema.FieldSchema> fsList2 = new ArrayList<Schema.FieldSchema>();
        fsList2.add(new Schema.FieldSchema("field1b", 25));
        fsList2.add(new Schema.FieldSchema(null, 10));
        inputSchema2 = new Schema(fsList2);
        load1.setEnforcedSchema(inputSchema1);
        load2.setEnforcedSchema(inputSchema2);
        LogicalPlan innerPlan11 = new LogicalPlan();
        LOProject project111 = new LOProject(innerPlan11, TypeCheckingTestUtil.genNewOperatorKey(), (LogicalOperator)load1, Integer.valueOf(0));
        project111.setSentinel(true);
        LOConst const111 = new LOConst(innerPlan11, TypeCheckingTestUtil.genNewOperatorKey(), (Object)Float.valueOf(26.0f));
        const111.setType((byte)20);
        LOSubtract subtract111 = new LOSubtract(innerPlan11, TypeCheckingTestUtil.genNewOperatorKey());
        innerPlan11.add((Operator)project111);
        innerPlan11.add((Operator)const111);
        innerPlan11.add((Operator)subtract111);
        innerPlan11.connect((Operator)project111, (Operator)subtract111);
        innerPlan11.connect((Operator)const111, (Operator)subtract111);
        LogicalPlan innerPlan12 = new LogicalPlan();
        LOConst const121 = new LOConst(innerPlan12, TypeCheckingTestUtil.genNewOperatorKey(), (Object)26);
        const121.setType((byte)10);
        innerPlan12.add((Operator)const121);
        ArrayList<LOLoad> inputs = new ArrayList<LOLoad>();
        inputs.add(load1);
        inputs.add(load2);
        MultiMap maps = new MultiMap();
        maps.put((Object)load1, (Object)innerPlan11);
        maps.put((Object)load2, (Object)innerPlan12);
        boolean[] isInner = new boolean[inputs.size()];
        for (int i = 0; i < isInner.length; ++i) {
            isInner[i] = false;
        }
        LOCogroup cogroup1 = new LOCogroup(plan, TypeCheckingTestUtil.genNewOperatorKey(), maps, isInner);
        plan.add((Operator)load1);
        plan.add((Operator)load2);
        plan.add((Operator)cogroup1);
        plan.connect((Operator)load1, (Operator)cogroup1);
        plan.connect((Operator)load2, (Operator)cogroup1);
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no error");
        }
        Schema endResultSchema = cogroup1.getSchema();
        TestTypeCheckingValidator.assertEquals((byte)endResultSchema.getField((int)0).type, (byte)20);
        TestTypeCheckingValidator.assertEquals((byte)endResultSchema.getField((int)1).type, (byte)120);
        TestTypeCheckingValidator.assertEquals((byte)endResultSchema.getField((int)2).type, (byte)120);
        Schema innerSchema1 = endResultSchema.getField((int)1).schema;
        TestTypeCheckingValidator.assertEquals((byte)innerSchema1.getField((int)0).type, (byte)10);
        TestTypeCheckingValidator.assertEquals((byte)innerSchema1.getField((int)1).type, (byte)15);
        Schema innerSchema2 = endResultSchema.getField((int)2).schema;
        TestTypeCheckingValidator.assertEquals((byte)innerSchema2.getField((int)0).type, (byte)25);
        TestTypeCheckingValidator.assertEquals((byte)innerSchema2.getField((int)1).type, (byte)10);
        TestTypeCheckingValidator.assertEquals((byte)innerPlan11.getSingleLeafPlanOutputType(), (byte)20);
        TestTypeCheckingValidator.assertEquals((byte)innerPlan12.getSingleLeafPlanOutputType(), (byte)20);
    }

    @Test
    public void testForEachGenerate1() throws Throwable {
        TypeCheckingTestUtil.printCurrentMethodName();
        LogicalPlan plan = new LogicalPlan();
        LOLoad load1 = TypeCheckingTestUtil.genDummyLOLoad(plan);
        Schema inputSchema1 = null;
        ArrayList<Schema.FieldSchema> fsList1 = new ArrayList<Schema.FieldSchema>();
        fsList1.add(new Schema.FieldSchema("field1a", 10));
        fsList1.add(new Schema.FieldSchema("field2a", 15));
        inputSchema1 = new Schema(fsList1);
        load1.setEnforcedSchema(inputSchema1);
        LogicalPlan innerPlan1 = new LogicalPlan();
        LOProject project11 = new LOProject(innerPlan1, TypeCheckingTestUtil.genNewOperatorKey(), (LogicalOperator)load1, Integer.valueOf(0));
        project11.setSentinel(true);
        LOConst const11 = new LOConst(innerPlan1, TypeCheckingTestUtil.genNewOperatorKey(), (Object)Float.valueOf(26.0f));
        const11.setType((byte)20);
        LOSubtract subtract11 = new LOSubtract(innerPlan1, TypeCheckingTestUtil.genNewOperatorKey());
        innerPlan1.add((Operator)project11);
        innerPlan1.add((Operator)const11);
        innerPlan1.add((Operator)subtract11);
        innerPlan1.connect((Operator)project11, (Operator)subtract11);
        innerPlan1.connect((Operator)const11, (Operator)subtract11);
        LogicalPlan innerPlan2 = new LogicalPlan();
        LOProject project21 = new LOProject(innerPlan2, TypeCheckingTestUtil.genNewOperatorKey(), (LogicalOperator)load1, Integer.valueOf(0));
        project21.setSentinel(true);
        LOProject project22 = new LOProject(innerPlan2, TypeCheckingTestUtil.genNewOperatorKey(), (LogicalOperator)load1, Integer.valueOf(1));
        project21.setSentinel(true);
        LOAdd add21 = new LOAdd(innerPlan2, TypeCheckingTestUtil.genNewOperatorKey());
        innerPlan2.add((Operator)project21);
        innerPlan2.add((Operator)project22);
        innerPlan2.add((Operator)add21);
        innerPlan2.connect((Operator)project21, (Operator)add21);
        innerPlan2.connect((Operator)project22, (Operator)add21);
        ArrayList<LogicalPlan> generatePlans = new ArrayList<LogicalPlan>();
        generatePlans.add(innerPlan1);
        generatePlans.add(innerPlan2);
        ArrayList<Boolean> flattens = new ArrayList<Boolean>();
        flattens.add(true);
        flattens.add(false);
        LOForEach foreach1 = new LOForEach(plan, TypeCheckingTestUtil.genNewOperatorKey(), generatePlans, flattens);
        plan.add((Operator)load1);
        plan.add((Operator)foreach1);
        plan.connect((Operator)load1, (Operator)foreach1);
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no error");
        }
        Schema endResultSchema = foreach1.getSchema();
        TestTypeCheckingValidator.assertEquals((byte)endResultSchema.getField((int)0).type, (byte)20);
        TestTypeCheckingValidator.assertEquals((byte)endResultSchema.getField((int)1).type, (byte)15);
    }

    @Test
    public void testForEachGenerate2() throws Throwable {
        TypeCheckingTestUtil.printCurrentMethodName();
        LogicalPlan plan = new LogicalPlan();
        LOLoad load1 = TypeCheckingTestUtil.genDummyLOLoad(plan);
        Schema inputSchema1 = null;
        ArrayList<Schema.FieldSchema> fsList1 = new ArrayList<Schema.FieldSchema>();
        fsList1.add(new Schema.FieldSchema("field1a", 10));
        fsList1.add(new Schema.FieldSchema("field2a", 15));
        inputSchema1 = new Schema(fsList1);
        load1.setEnforcedSchema(inputSchema1);
        LogicalPlan innerPlan1 = new LogicalPlan();
        LOProject project11 = new LOProject(innerPlan1, TypeCheckingTestUtil.genNewOperatorKey(), (LogicalOperator)load1, Integer.valueOf(0));
        project11.setSentinel(true);
        LOConst const11 = new LOConst(innerPlan1, TypeCheckingTestUtil.genNewOperatorKey(), (Object)"26F");
        const11.setType((byte)55);
        LOSubtract subtract11 = new LOSubtract(innerPlan1, TypeCheckingTestUtil.genNewOperatorKey());
        innerPlan1.add((Operator)project11);
        innerPlan1.add((Operator)const11);
        innerPlan1.add((Operator)subtract11);
        innerPlan1.connect((Operator)project11, (Operator)subtract11);
        innerPlan1.connect((Operator)const11, (Operator)subtract11);
        LogicalPlan innerPlan2 = new LogicalPlan();
        LOProject project21 = new LOProject(innerPlan2, TypeCheckingTestUtil.genNewOperatorKey(), (LogicalOperator)load1, Integer.valueOf(0));
        project21.setSentinel(true);
        LOProject project22 = new LOProject(innerPlan2, TypeCheckingTestUtil.genNewOperatorKey(), (LogicalOperator)load1, Integer.valueOf(1));
        project21.setSentinel(true);
        LOAdd add21 = new LOAdd(innerPlan2, TypeCheckingTestUtil.genNewOperatorKey());
        innerPlan2.add((Operator)project21);
        innerPlan2.add((Operator)project22);
        innerPlan2.add((Operator)add21);
        innerPlan2.connect((Operator)project21, (Operator)add21);
        innerPlan2.connect((Operator)project22, (Operator)add21);
        ArrayList<LogicalPlan> generatePlans = new ArrayList<LogicalPlan>();
        generatePlans.add(innerPlan1);
        generatePlans.add(innerPlan2);
        ArrayList<Boolean> flattens = new ArrayList<Boolean>();
        flattens.add(true);
        flattens.add(false);
        LOForEach foreach1 = new LOForEach(plan, TypeCheckingTestUtil.genNewOperatorKey(), generatePlans, flattens);
        plan.add((Operator)load1);
        plan.add((Operator)foreach1);
        plan.connect((Operator)load1, (Operator)foreach1);
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        try {
            typeValidator.validate(plan, collector);
            TestTypeCheckingValidator.fail((String)"Exception expected");
        }
        catch (PlanValidationException pve) {
            // empty catch block
        }
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        if (!collector.hasError()) {
            throw new AssertionError((Object)"Expect error");
        }
    }

    @Test
    public void testForEachGenerate4() throws Throwable {
        TypeCheckingTestUtil.printCurrentMethodName();
        LogicalPlan plan = new LogicalPlan();
        LOLoad load1 = TypeCheckingTestUtil.genDummyLOLoad(plan);
        String[] aliases = new String[]{"a", "b", "c"};
        byte[] types = new byte[]{10, 15, 50};
        Schema innerSchema1 = TypeCheckingTestUtil.genFlatSchema(aliases, types);
        Schema inputSchema1 = null;
        ArrayList<Schema.FieldSchema> fsList1 = new ArrayList<Schema.FieldSchema>();
        fsList1.add(new Schema.FieldSchema("field1a", 10));
        fsList1.add(new Schema.FieldSchema("field2a", 15));
        fsList1.add(new Schema.FieldSchema("field3a", innerSchema1, 120));
        inputSchema1 = new Schema(fsList1);
        load1.setEnforcedSchema(inputSchema1);
        LogicalPlan innerPlan1 = new LogicalPlan();
        LOProject project11 = new LOProject(innerPlan1, TypeCheckingTestUtil.genNewOperatorKey(), (LogicalOperator)load1, Integer.valueOf(2));
        project11.setSentinel(true);
        ArrayList<Integer> projections1 = new ArrayList<Integer>();
        projections1.add(1);
        projections1.add(2);
        LOProject project12 = new LOProject(innerPlan1, TypeCheckingTestUtil.genNewOperatorKey(), (LogicalOperator)project11, projections1);
        project12.setSentinel(false);
        innerPlan1.add((Operator)project12);
        LogicalPlan innerPlan2 = new LogicalPlan();
        LOProject project21 = new LOProject(innerPlan2, TypeCheckingTestUtil.genNewOperatorKey(), (LogicalOperator)load1, Integer.valueOf(0));
        project21.setSentinel(true);
        LOProject project22 = new LOProject(innerPlan2, TypeCheckingTestUtil.genNewOperatorKey(), (LogicalOperator)load1, Integer.valueOf(1));
        project21.setSentinel(true);
        LOAdd add21 = new LOAdd(innerPlan2, TypeCheckingTestUtil.genNewOperatorKey());
        innerPlan2.add((Operator)project21);
        innerPlan2.add((Operator)project22);
        innerPlan2.add((Operator)add21);
        innerPlan2.connect((Operator)project21, (Operator)add21);
        innerPlan2.connect((Operator)project22, (Operator)add21);
        ArrayList<LogicalPlan> generatePlans = new ArrayList<LogicalPlan>();
        generatePlans.add(innerPlan1);
        generatePlans.add(innerPlan2);
        ArrayList<Boolean> flattens = new ArrayList<Boolean>();
        flattens.add(true);
        flattens.add(false);
        LOForEach foreach1 = new LOForEach(plan, TypeCheckingTestUtil.genNewOperatorKey(), generatePlans, flattens);
        plan.add((Operator)load1);
        plan.add((Operator)foreach1);
        plan.connect((Operator)load1, (Operator)foreach1);
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no  error");
        }
        Schema endResultSchema = foreach1.getSchema();
        TestTypeCheckingValidator.assertEquals((byte)endResultSchema.getField((int)0).type, (byte)15);
        TestTypeCheckingValidator.assertEquals((byte)endResultSchema.getField((int)1).type, (byte)50);
        TestTypeCheckingValidator.assertEquals((byte)endResultSchema.getField((int)2).type, (byte)15);
    }

    @Test
    public void testCross1() throws Throwable {
        TypeCheckingTestUtil.printCurrentMethodName();
        LogicalPlan plan = new LogicalPlan();
        LOLoad load1 = TypeCheckingTestUtil.genDummyLOLoad(plan);
        LOLoad load2 = TypeCheckingTestUtil.genDummyLOLoad(plan);
        String[] aliases1 = new String[]{"a", "b", "c"};
        byte[] types1 = new byte[]{10, 15, 50};
        Schema schema1 = TypeCheckingTestUtil.genFlatSchema(aliases1, types1);
        String[] aliases2 = new String[]{"e", "f"};
        byte[] types2 = new byte[]{20, 25};
        Schema schema2 = TypeCheckingTestUtil.genFlatSchema(aliases2, types2);
        load1.setEnforcedSchema(schema1);
        load2.setEnforcedSchema(schema2);
        ArrayList<LOLoad> inputList = new ArrayList<LOLoad>();
        inputList.add(load1);
        inputList.add(load2);
        LOCross cross = new LOCross(plan, TypeCheckingTestUtil.genNewOperatorKey());
        plan.add((Operator)load1);
        plan.add((Operator)load2);
        plan.add((Operator)cross);
        plan.connect((Operator)load1, (Operator)cross);
        plan.connect((Operator)load2, (Operator)cross);
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        TestTypeCheckingValidator.assertEquals((int)cross.getSchema().size(), (int)5);
        TestTypeCheckingValidator.assertEquals((byte)cross.getSchema().getField((int)0).type, (byte)10);
        TestTypeCheckingValidator.assertEquals((byte)cross.getSchema().getField((int)1).type, (byte)15);
        TestTypeCheckingValidator.assertEquals((byte)cross.getSchema().getField((int)2).type, (byte)50);
        TestTypeCheckingValidator.assertEquals((byte)cross.getSchema().getField((int)3).type, (byte)20);
        TestTypeCheckingValidator.assertEquals((byte)cross.getSchema().getField((int)4).type, (byte)25);
    }

    @Test
    public void testLineage1() throws Throwable {
        LOCast cast;
        this.planTester.buildPlan("a = load 'a' as (field1: int, field2: float, field3: chararray );");
        LogicalPlan plan = this.planTester.buildPlan("b = foreach a generate field1 + 1.0 ;");
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        this.planTester.printPlan(plan, TypeCheckingTestUtil.getCurrentMethodName());
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no  error");
        }
        LOForEach foreach = (LOForEach)plan.getLeaves().get(0);
        LogicalPlan foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(0);
        LogicalOperator exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        TestTypeCheckingValidator.assertTrue(((cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0)).getLoadFuncSpec() == null ? 1 : 0) != 0);
    }

    @Test
    public void testLineage1NoSchema() throws Throwable {
        this.planTester.buildPlan("a = load 'a';");
        LogicalPlan plan = this.planTester.buildPlan("b = foreach a generate $1 + 1.0 ;");
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        this.planTester.printPlan(plan, TypeCheckingTestUtil.getCurrentMethodName());
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no  error");
        }
        LOForEach foreach = (LOForEach)plan.getLeaves().get(0);
        LogicalPlan foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(0);
        LogicalOperator exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        LOCast cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("org.apache.pig.builtin.PigStorage"));
    }

    @Test
    public void testLineage2() throws Throwable {
        this.planTester.buildPlan("a = load 'a' as (field1, field2: float, field3: chararray );");
        LogicalPlan plan = this.planTester.buildPlan("b = foreach a generate field1 + 1.0 ;");
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        this.planTester.printPlan(plan, TypeCheckingTestUtil.getCurrentMethodName());
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no  error");
        }
        LOForEach foreach = (LOForEach)plan.getLeaves().get(0);
        LogicalPlan foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(0);
        LogicalOperator exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        LOCast cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("org.apache.pig.builtin.PigStorage"));
    }

    @Test
    public void testGroupLineage() throws Throwable {
        this.planTester.buildPlan("a = load 'a' using BinStorage() as (field1, field2: float, field3: chararray );");
        this.planTester.buildPlan("b = group a by field1 ;");
        this.planTester.buildPlan("c = foreach b generate flatten(a) ;");
        LogicalPlan plan = this.planTester.buildPlan("d = foreach c generate field1 + 1.0 ;");
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no  error");
        }
        LOForEach foreach = (LOForEach)plan.getLeaves().get(0);
        LogicalPlan foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(0);
        this.planTester.printPlan(plan, TypeCheckingTestUtil.getCurrentMethodName());
        LogicalOperator exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        LOCast cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("BinStorage"));
    }

    @Test
    public void testGroupLineageNoSchema() throws Throwable {
        this.planTester.buildPlan("a = load 'a' using BinStorage() ;");
        this.planTester.buildPlan("b = group a by $0 ;");
        this.planTester.buildPlan("c = foreach b generate flatten(a) ;");
        LogicalPlan plan = this.planTester.buildPlan("d = foreach c generate $0 + 1.0 ;");
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        this.planTester.printPlan(plan, TypeCheckingTestUtil.getCurrentMethodName());
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no  error");
        }
        LOForEach foreach = (LOForEach)plan.getLeaves().get(0);
        LogicalPlan foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(0);
        LogicalOperator exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        LOCast cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("BinStorage"));
    }

    @Test
    public void testGroupLineage2() throws Throwable {
        this.planTester.buildPlan("a = load 'a' using BinStorage() as (field1, field2: float, field3: chararray );");
        this.planTester.buildPlan("b = group a by field1 ;");
        LogicalPlan plan = this.planTester.buildPlan("c = foreach b generate group + 1.0 ;");
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        this.planTester.printPlan(plan, TypeCheckingTestUtil.getCurrentMethodName());
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no  error");
        }
        LOForEach foreach = (LOForEach)plan.getLeaves().get(0);
        LogicalPlan foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(0);
        LogicalOperator exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        LOCast cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("BinStorage"));
    }

    @Test
    public void testGroupLineage2NoSchema() throws Throwable {
        this.planTester.buildPlan("a = load 'a' using BinStorage() ;");
        this.planTester.buildPlan("b = group a by $0 ;");
        LogicalPlan plan = this.planTester.buildPlan("c = foreach b generate group + 1.0 ;");
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        this.planTester.printPlan(plan, TypeCheckingTestUtil.getCurrentMethodName());
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no  error");
        }
        LOForEach foreach = (LOForEach)plan.getLeaves().get(0);
        LogicalPlan foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(0);
        LogicalOperator exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        LOCast cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("BinStorage"));
    }

    @Test
    public void testGroupLineageStar() throws Throwable {
        this.planTester.buildPlan("a = load 'a' using BinStorage() as (name, age, gpa);");
        this.planTester.buildPlan("b = group a by *;");
        this.planTester.buildPlan("c = foreach b generate flatten(group);");
        LogicalPlan plan = this.planTester.buildPlan("d = foreach c generate $0 + 1;");
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        this.planTester.printPlan(plan, TypeCheckingTestUtil.getCurrentMethodName());
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no  error");
        }
        LOForEach foreach = (LOForEach)plan.getLeaves().get(0);
        LogicalPlan foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(0);
        LogicalOperator exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        LOCast cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("BinStorage"));
    }

    @Test
    public void testGroupLineageStarNoSchema() throws Throwable {
        this.planTester.buildPlan("a = load 'a' using BinStorage() ;");
        this.planTester.buildPlan("b = group a by *;");
        this.planTester.buildPlan("c = foreach b generate flatten(group);");
        LogicalPlan plan = this.planTester.buildPlan("d = foreach c generate $0 + 1;");
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        this.planTester.printPlan(plan, TypeCheckingTestUtil.getCurrentMethodName());
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no  error");
        }
        LOForEach foreach = (LOForEach)plan.getLeaves().get(0);
        LogicalPlan foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(0);
        LogicalOperator exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        LOCast cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("BinStorage"));
    }

    @Test
    public void testCogroupLineage() throws Throwable {
        this.planTester.buildPlan("a = load 'a' using BinStorage() as (field1, field2: float, field3: chararray );");
        this.planTester.buildPlan("b = load 'a' using PigStorage() as (field4, field5, field6: chararray );");
        this.planTester.buildPlan("c = cogroup a by field1, b by field4 ;");
        this.planTester.buildPlan("d = foreach c generate group, flatten(a), flatten(b)  ;");
        LogicalPlan plan = this.planTester.buildPlan("e = foreach d generate group, field1 + 1, field4 + 2.0  ;");
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        this.planTester.printPlan(plan, TypeCheckingTestUtil.getCurrentMethodName());
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no  error");
        }
        LOForEach foreach = (LOForEach)plan.getLeaves().get(0);
        LogicalPlan foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(1);
        LogicalOperator exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        LOCast cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("BinStorage"));
        foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(2);
        exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("PigStorage"));
    }

    @Test
    public void testCogroupMapLookupLineage() throws Throwable {
        this.planTester.buildPlan("a = load 'a' using BinStorage() as (field1, field2: float, field3: chararray );");
        this.planTester.buildPlan("b = load 'a' using PigStorage() as (field4, field5, field6: chararray );");
        this.planTester.buildPlan("c = cogroup a by field1, b by field4 ;");
        this.planTester.buildPlan("d = foreach c generate group, flatten(a), flatten(b)  ;");
        LogicalPlan plan = this.planTester.buildPlan("e = foreach d generate group, field1#'key' + 1, field4 + 2.0  ;");
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        this.planTester.printPlan(plan, TypeCheckingTestUtil.getCurrentMethodName());
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no  error");
        }
        LOForEach foreach = (LOForEach)plan.getLeaves().get(0);
        LogicalPlan foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(1);
        LogicalOperator exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        LOCast cast1 = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        LOMapLookup map = (LOMapLookup)foreachPlan.getSuccessors((Operator)cast1).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast1.getLoadFuncSpec().getClassName().startsWith("BinStorage"));
        LOCast cast2 = (LOCast)foreachPlan.getSuccessors((Operator)map).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast2.getLoadFuncSpec().getClassName().startsWith("BinStorage"));
        foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(2);
        exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        LOCast cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("PigStorage"));
    }

    @Test
    public void testCogroupStarLineage() throws Throwable {
        this.planTester.buildPlan("a = load 'a' using BinStorage() as (field1, field2: float, field3: chararray );");
        this.planTester.buildPlan("b = load 'b' using PigStorage() as (field4, field5, field6: chararray );");
        this.planTester.buildPlan("c = cogroup a by *, b by * ;");
        this.planTester.buildPlan("d = foreach c generate group, flatten($1), flatten($2);");
        LogicalPlan plan = this.planTester.buildPlan("e = foreach d generate group, field1 + 1, field4 + 2.0;");
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        try {
            typeValidator.validate(plan, collector);
        }
        catch (PlanValidationException pve) {
            // empty catch block
        }
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        this.planTester.printPlan(plan, TypeCheckingTestUtil.getCurrentMethodName());
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no  error");
        }
        LOForEach foreach = (LOForEach)plan.getLeaves().get(0);
        LogicalPlan foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(1);
        LogicalOperator exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        LOCast cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("BinStorage"));
        foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(2);
        exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("PigStorage"));
    }

    @Test
    public void testCogroupStarLineageFail() throws Throwable {
        this.planTester.buildPlan("a = load 'a' using BinStorage() as (field1, field2: float, field3: chararray );");
        this.planTester.buildPlan("b = load 'b' using PigStorage() as (field4, field5, field6: chararray );");
        this.planTester.buildPlan("c = cogroup a by *, b by * ;");
        this.planTester.buildPlan("d = foreach c generate group, flatten($1), flatten($2);");
        LogicalPlan plan = this.planTester.buildPlan("e = foreach d generate group + 1, field1 + 1, field4 + 2.0;");
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        try {
            typeValidator.validate(plan, collector);
            TestTypeCheckingValidator.fail((String)"Exception expected");
        }
        catch (PlanValidationException pve) {
            // empty catch block
        }
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        this.planTester.printPlan(plan, TypeCheckingTestUtil.getCurrentMethodName());
        if (!collector.hasError()) {
            throw new AssertionError((Object)"Expect error");
        }
    }

    @Test
    public void testCogroupStarLineage1() throws Throwable {
        this.planTester.buildPlan("a = load 'a' using PigStorage() as (field1, field2: float, field3: chararray );");
        this.planTester.buildPlan("b = load 'b' using PigStorage() as (field4, field5, field6: chararray );");
        this.planTester.buildPlan("c = cogroup a by *, b by * ;");
        this.planTester.buildPlan("d = foreach c generate flatten(group), flatten($1), flatten($2);");
        LogicalPlan plan = this.planTester.buildPlan("e = foreach d generate $0 + 1, a::field1 + 1, field4 + 2.0;");
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        try {
            typeValidator.validate(plan, collector);
        }
        catch (PlanValidationException pve) {
            // empty catch block
        }
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        this.planTester.printPlan(plan, TypeCheckingTestUtil.getCurrentMethodName());
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no  error");
        }
        LOForEach foreach = (LOForEach)plan.getLeaves().get(0);
        LogicalPlan foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(0);
        LogicalOperator exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        LOCast cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("PigStorage"));
        foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(1);
        exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("PigStorage"));
        foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(2);
        exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("PigStorage"));
    }

    @Test
    public void testCogroupStarLineageNoSchemaFail() throws Throwable {
        this.planTester.buildPlan("a = load 'a' using BinStorage() ;");
        this.planTester.buildPlan("b = load 'b' using PigStorage() ;");
        boolean exceptionThrown = false;
        try {
            LogicalPlan lp = this.planTester.buildPlan("c = cogroup a by *, b by *;");
        }
        catch (AssertionFailedError e) {
            TestTypeCheckingValidator.assertTrue((boolean)e.getMessage().contains("Cogroup/Group by * is only allowed if the input has a schema"));
            exceptionThrown = true;
        }
        TestTypeCheckingValidator.assertTrue((boolean)exceptionThrown);
    }

    @Test
    public void testCogroupMultiColumnProjectLineage() throws Throwable {
        this.planTester.buildPlan("a = load 'a' using BinStorage() as (field1, field2: float, field3: chararray );");
        this.planTester.buildPlan("b = load 'b' using PigStorage() as (field4, field5, field6: chararray );");
        this.planTester.buildPlan("c = cogroup a by field1, b by field4 ;");
        this.planTester.buildPlan("d = foreach c generate group, a.(field1, field2), b.(field4);");
        this.planTester.buildPlan("e = foreach d generate group, flatten($1), flatten($2);");
        LogicalPlan plan = this.planTester.buildPlan("f = foreach e generate group, field1 + 1, field4 + 2.0;");
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        try {
            typeValidator.validate(plan, collector);
        }
        catch (PlanValidationException pve) {
            // empty catch block
        }
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        this.planTester.printPlan(plan, TypeCheckingTestUtil.getCurrentMethodName());
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no  error");
        }
        LOForEach foreach = (LOForEach)plan.getLeaves().get(0);
        LogicalPlan foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(1);
        LogicalOperator exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        LOCast cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("BinStorage"));
        foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(2);
        exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("PigStorage"));
    }

    @Test
    public void testCogroupProjectStarLineage() throws Throwable {
        this.planTester.buildPlan("a = load 'a' using BinStorage() as (field1, field2: float, field3: chararray );");
        this.planTester.buildPlan("b = load 'b' using PigStorage() as (field4, field5, field6: chararray );");
        this.planTester.buildPlan("c = cogroup a by field1, b by field4 ;");
        this.planTester.buildPlan("d = foreach c generate * ;");
        this.planTester.buildPlan("f = foreach d generate group, flatten(a), flatten(b)  ;");
        LogicalPlan plan = this.planTester.buildPlan("g = foreach f generate group, field1 + 1, field4 + 2.0  ;");
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        try {
            typeValidator.validate(plan, collector);
        }
        catch (PlanValidationException pve) {
            // empty catch block
        }
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        this.planTester.printPlan(plan, TypeCheckingTestUtil.getCurrentMethodName());
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no  error");
        }
        LOForEach foreach = (LOForEach)plan.getLeaves().get(0);
        LogicalPlan foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(1);
        LogicalOperator exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        LOCast cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("BinStorage"));
        foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(2);
        exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("PigStorage"));
    }

    @Test
    public void testCogroupProjectStarLineageNoSchema() throws Throwable {
        this.planTester.buildPlan("a = load 'a' using BinStorage() ;");
        this.planTester.buildPlan("b = load 'b' using PigStorage() ;");
        this.planTester.buildPlan("c = cogroup a by $0, b by $0 ;");
        this.planTester.buildPlan("d = foreach c generate * ;");
        this.planTester.buildPlan("f = foreach d generate group, flatten(a), flatten(b)  ;");
        LogicalPlan plan = this.planTester.buildPlan("g = foreach f generate group, $1 + 1, $2 + 2.0  ;");
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        try {
            typeValidator.validate(plan, collector);
        }
        catch (PlanValidationException pve) {
            // empty catch block
        }
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        this.planTester.printPlan(plan, TypeCheckingTestUtil.getCurrentMethodName());
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no error");
        }
        LOForEach foreach = (LOForEach)plan.getLeaves().get(0);
        LogicalPlan foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(1);
        LogicalOperator exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        LOCast cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("BinStorage"));
        foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(2);
        exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("PigStorage"));
    }

    @Test
    public void testCogroupProjectStarLineageMixSchema() throws Throwable {
        this.planTester.buildPlan("a = load 'a' using BinStorage() as (field1, field2: float, field3: chararray );");
        this.planTester.buildPlan("b = load 'b' using PigStorage() ;");
        this.planTester.buildPlan("c = cogroup a by field1, b by $0 ;");
        this.planTester.buildPlan("d = foreach c generate * ;");
        this.planTester.buildPlan("f = foreach d generate group, flatten(a), flatten(b)  ;");
        LogicalPlan plan = this.planTester.buildPlan("g = foreach f generate group, field1 + 1, $4 + 2.0  ;");
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        try {
            typeValidator.validate(plan, collector);
        }
        catch (PlanValidationException pve) {
            // empty catch block
        }
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        this.planTester.printPlan(plan, TypeCheckingTestUtil.getCurrentMethodName());
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no error");
        }
        LOForEach foreach = (LOForEach)plan.getLeaves().get(0);
        LogicalPlan foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(1);
        LogicalOperator exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        LOCast cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("BinStorage"));
        foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(2);
        exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("PigStorage"));
    }

    @Test
    public void testCogroupLineageFail() throws Throwable {
        this.planTester.buildPlan("a = load 'a' using BinStorage() as (field1, field2: float, field3: chararray );");
        this.planTester.buildPlan("b = load 'a' using PigStorage() as (field4, field5, field6: chararray );");
        this.planTester.buildPlan("c = cogroup a by field1, b by field4 ;");
        this.planTester.buildPlan("d = foreach c generate group, flatten(a), flatten(b)  ;");
        LogicalPlan plan = this.planTester.buildPlan("e = foreach d generate group + 1, field1 + 1, field4 + 2.0  ;");
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        try {
            typeValidator.validate(plan, collector);
            TestTypeCheckingValidator.fail((String)"Exception expected");
        }
        catch (PlanValidationException pve) {
            // empty catch block
        }
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        this.planTester.printPlan(plan, TypeCheckingTestUtil.getCurrentMethodName());
        if (!collector.hasError()) {
            throw new AssertionError((Object)"Expect error");
        }
    }

    @Test
    public void testCogroupLineage2NoSchema() throws Throwable {
        this.planTester.buildPlan("a = load 'a' using BinStorage() ;");
        this.planTester.buildPlan("b = load 'a' using PigStorage() ;");
        this.planTester.buildPlan("c = cogroup a by $0, b by $0 ;");
        this.planTester.buildPlan("d = foreach c generate group, flatten(a), flatten(b)  ;");
        LogicalPlan plan = this.planTester.buildPlan("e = foreach d generate group, $1 + 1, $2 + 2.0  ;");
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        this.planTester.printPlan(plan, TypeCheckingTestUtil.getCurrentMethodName());
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no  error");
        }
        LOForEach foreach = (LOForEach)plan.getLeaves().get(0);
        LogicalPlan foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(1);
        LogicalOperator exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        LOCast cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("BinStorage"));
        foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(2);
        exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("PigStorage"));
    }

    @Test
    public void testUnionLineage() throws Throwable {
        LOCast cast;
        this.planTester.buildPlan("a = load 'a' using BinStorage() as (field1, field2: float, field3: chararray );");
        this.planTester.buildPlan("b = load 'a' using PigStorage() as (field4, field5, field6: chararray );");
        this.planTester.buildPlan("c = union a , b ;");
        LogicalPlan plan = this.planTester.buildPlan("d = foreach c generate field2 + 2.0  ;");
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        this.planTester.printPlan(plan, TypeCheckingTestUtil.getCurrentMethodName());
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no  error");
        }
        LOForEach foreach = (LOForEach)plan.getLeaves().get(0);
        LogicalPlan foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(0);
        LogicalOperator exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        TestTypeCheckingValidator.assertTrue(((cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0)).getLoadFuncSpec() == null ? 1 : 0) != 0);
    }

    @Test
    public void testUnionLineageFail() throws Throwable {
        this.planTester.buildPlan("a = load 'a' using BinStorage() as (field1, field2: float, field3: chararray );");
        this.planTester.buildPlan("b = load 'a' using PigStorage() as (field4, field5, field6: chararray );");
        this.planTester.buildPlan("c = union a , b ;");
        LogicalPlan plan = this.planTester.buildPlan("d = foreach c generate field1 + 2.0  ;");
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        try {
            typeValidator.validate(plan, collector);
            TestTypeCheckingValidator.fail((String)"Exception expected");
        }
        catch (PlanValidationException pve) {
            // empty catch block
        }
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        this.planTester.printPlan(plan, TypeCheckingTestUtil.getCurrentMethodName());
        if (!collector.hasError()) {
            throw new AssertionError((Object)"Expect error");
        }
    }

    @Test
    public void testUnionLineageNoSchema() throws Throwable {
        this.planTester.buildPlan("a = load 'a' using BinStorage() ;");
        this.planTester.buildPlan("b = load 'a' using BinStorage() ;");
        this.planTester.buildPlan("c = union a , b ;");
        LogicalPlan plan = this.planTester.buildPlan("d = foreach c generate $1 + 2.0  ;");
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        try {
            typeValidator.validate(plan, collector);
        }
        catch (PlanValidationException pve) {
            // empty catch block
        }
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        this.planTester.printPlan(plan, TypeCheckingTestUtil.getCurrentMethodName());
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no  error");
        }
        LOForEach foreach = (LOForEach)plan.getLeaves().get(0);
        LogicalPlan foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(0);
        LogicalOperator exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        LOCast cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("BinStorage"));
    }

    @Test
    public void testUnionLineageNoSchemaFail() throws Throwable {
        this.planTester.buildPlan("a = load 'a' using BinStorage() ;");
        this.planTester.buildPlan("b = load 'a' using PigStorage() ;");
        this.planTester.buildPlan("c = union a , b ;");
        LogicalPlan plan = this.planTester.buildPlan("d = foreach c generate $1 + 2.0  ;");
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        try {
            typeValidator.validate(plan, collector);
            TestTypeCheckingValidator.fail((String)"Exception expected");
        }
        catch (PlanValidationException pve) {
            // empty catch block
        }
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        this.planTester.printPlan(plan, TypeCheckingTestUtil.getCurrentMethodName());
        if (!collector.hasError()) {
            throw new AssertionError((Object)"Expect error");
        }
    }

    @Test
    public void testUnionLineageDifferentSchema() throws Throwable {
        this.planTester.buildPlan("a = load 'a' using PigStorage() as (field1, field2: float, field3: chararray );");
        this.planTester.buildPlan("b = load 'a' using PigStorage() as (field4, field5, field6: chararray, field7 );");
        this.planTester.buildPlan("c = union a , b ;");
        LogicalPlan plan = this.planTester.buildPlan("d = foreach c generate $3 + 2.0  ;");
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        this.planTester.printPlan(plan, TypeCheckingTestUtil.getCurrentMethodName());
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no  error");
        }
        LOForEach foreach = (LOForEach)plan.getLeaves().get(0);
        LogicalPlan foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(0);
        LogicalOperator exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        LOCast cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("PigStorage"));
    }

    @Test
    public void testUnionLineageDifferentSchemaFail() throws Throwable {
        this.planTester.buildPlan("a = load 'a' using BinStorage() as (field1, field2: float, field3: chararray );");
        this.planTester.buildPlan("b = load 'a' using PigStorage() as (field4, field5, field6: chararray, field7 );");
        this.planTester.buildPlan("c = union a , b ;");
        LogicalPlan plan = this.planTester.buildPlan("d = foreach c generate $3 + 2.0  ;");
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        try {
            typeValidator.validate(plan, collector);
            TestTypeCheckingValidator.fail((String)"Exception expected");
        }
        catch (PlanValidationException pve) {
            // empty catch block
        }
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        this.planTester.printPlan(plan, TypeCheckingTestUtil.getCurrentMethodName());
        if (!collector.hasError()) {
            throw new AssertionError((Object)"Expect error");
        }
    }

    @Test
    public void testUnionLineageMixSchema() throws Throwable {
        this.planTester.buildPlan("a = load 'a' using PigStorage() as (field1, field2: float, field3: chararray );");
        this.planTester.buildPlan("b = load 'a' using PigStorage() ;");
        this.planTester.buildPlan("c = union a , b ;");
        LogicalPlan plan = this.planTester.buildPlan("d = foreach c generate $3 + 2.0  ;");
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        this.planTester.printPlan(plan, TypeCheckingTestUtil.getCurrentMethodName());
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no  error");
        }
        LOForEach foreach = (LOForEach)plan.getLeaves().get(0);
        LogicalPlan foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(0);
        LogicalOperator exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        LOCast cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("PigStorage"));
    }

    @Test
    public void testUnionLineageMixSchemaFail() throws Throwable {
        this.planTester.buildPlan("a = load 'a' using BinStorage() as (field1, field2: float, field3: chararray );");
        this.planTester.buildPlan("b = load 'a' using PigStorage() ;");
        this.planTester.buildPlan("c = union a , b ;");
        LogicalPlan plan = this.planTester.buildPlan("d = foreach c generate $3 + 2.0  ;");
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        try {
            typeValidator.validate(plan, collector);
            TestTypeCheckingValidator.fail((String)"Exception expected");
        }
        catch (PlanValidationException pve) {
            // empty catch block
        }
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        this.planTester.printPlan(plan, TypeCheckingTestUtil.getCurrentMethodName());
        if (!collector.hasError()) {
            throw new AssertionError((Object)"Expect error");
        }
    }

    @Test
    public void testFilterLineage() throws Throwable {
        this.planTester.buildPlan("a = load 'a' as (field1, field2: float, field3: chararray );");
        LogicalPlan plan = this.planTester.buildPlan("b = filter a by field1 > 1.0 ;");
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        this.planTester.printPlan(plan, TypeCheckingTestUtil.getCurrentMethodName());
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no  error");
        }
        LOFilter filter = (LOFilter)plan.getLeaves().get(0);
        LogicalPlan filterPlan = filter.getComparisonPlan();
        LogicalOperator exOp = (LogicalOperator)filterPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)filterPlan.getRoots().get(1);
        }
        LOCast cast = (LOCast)filterPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("org.apache.pig.builtin.PigStorage"));
    }

    @Test
    public void testFilterLineageNoSchema() throws Throwable {
        this.planTester.buildPlan("a = load 'a' ;");
        LogicalPlan plan = this.planTester.buildPlan("b = filter a by $0 > 1.0 ;");
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        this.planTester.printPlan(plan, TypeCheckingTestUtil.getCurrentMethodName());
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no  error");
        }
        LOFilter filter = (LOFilter)plan.getLeaves().get(0);
        LogicalPlan filterPlan = filter.getComparisonPlan();
        LogicalOperator exOp = (LogicalOperator)filterPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)filterPlan.getRoots().get(1);
        }
        LOCast cast = (LOCast)filterPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("org.apache.pig.builtin.PigStorage"));
    }

    @Test
    public void testFilterLineage1() throws Throwable {
        this.planTester.buildPlan("a = load 'a' as (field1, field2: float, field3: chararray );");
        this.planTester.buildPlan("b = filter a by field2 > 1.0 ;");
        LogicalPlan plan = this.planTester.buildPlan("c = foreach b generate field1 + 1.0 ;");
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        this.planTester.printPlan(plan, TypeCheckingTestUtil.getCurrentMethodName());
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no  error");
        }
        LOForEach foreach = (LOForEach)plan.getLeaves().get(0);
        LogicalPlan foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(0);
        LogicalOperator exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        LOCast cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("org.apache.pig.builtin.PigStorage"));
    }

    @Test
    public void testFilterLineage1NoSchema() throws Throwable {
        this.planTester.buildPlan("a = load 'a' ;");
        this.planTester.buildPlan("b = filter a by $0 > 1.0 ;");
        LogicalPlan plan = this.planTester.buildPlan("c = foreach b generate $1 + 1.0 ;");
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        this.planTester.printPlan(plan, TypeCheckingTestUtil.getCurrentMethodName());
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no  error");
        }
        LOForEach foreach = (LOForEach)plan.getLeaves().get(0);
        LogicalPlan foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(0);
        LogicalOperator exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        LOCast cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("org.apache.pig.builtin.PigStorage"));
    }

    @Test
    public void testCogroupFilterLineage() throws Throwable {
        this.planTester.buildPlan("a = load 'a' using BinStorage() as (field1, field2: float, field3: chararray );");
        this.planTester.buildPlan("b = load 'a' using PigStorage() as (field4, field5, field6: chararray );");
        this.planTester.buildPlan("c = cogroup a by field1, b by field4 ;");
        this.planTester.buildPlan("d = foreach c generate group, flatten(a), flatten(b)  ;");
        this.planTester.buildPlan("e = filter d by field4 > 5;");
        LogicalPlan plan = this.planTester.buildPlan("f = foreach e generate group, field1 + 1, field4 + 2.0  ;");
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        this.planTester.printPlan(plan, TypeCheckingTestUtil.getCurrentMethodName());
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no  error");
        }
        LOForEach foreach = (LOForEach)plan.getLeaves().get(0);
        LogicalPlan foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(1);
        LogicalOperator exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        LOCast cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("BinStorage"));
        foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(2);
        exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("PigStorage"));
    }

    @Test
    public void testCogroupFilterLineageNoSchema() throws Throwable {
        this.planTester.buildPlan("a = load 'a' using BinStorage() ;");
        this.planTester.buildPlan("b = load 'a' using PigStorage() ;");
        this.planTester.buildPlan("c = cogroup a by $0, b by $0 ;");
        this.planTester.buildPlan("d = foreach c generate group, flatten(a), flatten(b)  ;");
        this.planTester.buildPlan("e = filter d by $2 > 5;");
        LogicalPlan plan = this.planTester.buildPlan("f = foreach e generate group, $1 + 1, $2 + 2.0  ;");
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        this.planTester.printPlan(plan, TypeCheckingTestUtil.getCurrentMethodName());
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no  error");
        }
        LOForEach foreach = (LOForEach)plan.getLeaves().get(0);
        LogicalPlan foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(1);
        LogicalOperator exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        LOCast cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("BinStorage"));
        foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(2);
        exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("PigStorage"));
    }

    @Test
    public void testSplitLineage() throws Throwable {
        this.planTester.buildPlan("a = load 'a' as (field1, field2: float, field3: chararray );");
        LogicalPlan plan = this.planTester.buildPlan("split a into b if field1 > 1.0, c if field1 <= 1.0 ;");
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        this.planTester.printPlan(plan, TypeCheckingTestUtil.getCurrentMethodName());
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no  error");
        }
        LOSplitOutput splitOutputB = (LOSplitOutput)plan.getLeaves().get(0);
        LogicalPlan bPlan = splitOutputB.getConditionPlan();
        LogicalOperator exOp = (LogicalOperator)bPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)bPlan.getRoots().get(1);
        }
        LOCast cast = (LOCast)bPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("org.apache.pig.builtin.PigStorage"));
        LOSplitOutput splitOutputC = (LOSplitOutput)plan.getLeaves().get(0);
        LogicalPlan cPlan = splitOutputC.getConditionPlan();
        exOp = (LogicalOperator)cPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)cPlan.getRoots().get(1);
        }
        cast = (LOCast)cPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("org.apache.pig.builtin.PigStorage"));
    }

    @Test
    public void testSplitLineageNoSchema() throws Throwable {
        this.planTester.buildPlan("a = load 'a' ;");
        LogicalPlan plan = this.planTester.buildPlan("split a into b if $0 > 1.0, c if $1 <= 1.0 ;");
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        this.planTester.printPlan(plan, TypeCheckingTestUtil.getCurrentMethodName());
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no  error");
        }
        LOSplitOutput splitOutputB = (LOSplitOutput)plan.getLeaves().get(0);
        LogicalPlan bPlan = splitOutputB.getConditionPlan();
        LogicalOperator exOp = (LogicalOperator)bPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)bPlan.getRoots().get(1);
        }
        LOCast cast = (LOCast)bPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("org.apache.pig.builtin.PigStorage"));
        LOSplitOutput splitOutputC = (LOSplitOutput)plan.getLeaves().get(0);
        LogicalPlan cPlan = splitOutputC.getConditionPlan();
        exOp = (LogicalOperator)cPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)cPlan.getRoots().get(1);
        }
        cast = (LOCast)cPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("org.apache.pig.builtin.PigStorage"));
    }

    @Test
    public void testSplitLineage1() throws Throwable {
        this.planTester.buildPlan("a = load 'a' as (field1, field2: float, field3: chararray );");
        this.planTester.buildPlan("split a into b if field2 > 1.0, c if field2 <= 1.0 ;");
        LogicalPlan plan = this.planTester.buildPlan("c = foreach b generate field1 + 1.0 ;");
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        this.planTester.printPlan(plan, TypeCheckingTestUtil.getCurrentMethodName());
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no  error");
        }
        LOForEach foreach = (LOForEach)plan.getLeaves().get(0);
        LogicalPlan foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(0);
        LogicalOperator exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        LOCast cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("org.apache.pig.builtin.PigStorage"));
    }

    @Test
    public void testSplitLineage1NoSchema() throws Throwable {
        this.planTester.buildPlan("a = load 'a' ;");
        this.planTester.buildPlan("split a into b if $0 > 1.0, c if $1 <= 1.0 ;");
        LogicalPlan plan = this.planTester.buildPlan("c = foreach b generate $1 + 1.0 ;");
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        this.planTester.printPlan(plan, TypeCheckingTestUtil.getCurrentMethodName());
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no  error");
        }
        LOForEach foreach = (LOForEach)plan.getLeaves().get(0);
        LogicalPlan foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(0);
        LogicalOperator exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        LOCast cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("org.apache.pig.builtin.PigStorage"));
    }

    @Test
    public void testCogroupSplitLineage() throws Throwable {
        this.planTester.buildPlan("a = load 'a' using BinStorage() as (field1, field2: float, field3: chararray );");
        this.planTester.buildPlan("b = load 'a' using PigStorage() as (field4, field5, field6: chararray );");
        this.planTester.buildPlan("c = cogroup a by field1, b by field4 ;");
        this.planTester.buildPlan("d = foreach c generate group, flatten(a), flatten(b)  ;");
        this.planTester.buildPlan("split d into e if field4 > 'm', f if field6 > 'm'  ;");
        LogicalPlan plan = this.planTester.buildPlan("g = foreach e generate group, field1 + 1, field4 + 2.0  ;");
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        this.planTester.printPlan(plan, TypeCheckingTestUtil.getCurrentMethodName());
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no  error");
        }
        LOForEach foreach = (LOForEach)plan.getLeaves().get(0);
        LogicalPlan foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(1);
        LogicalOperator exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        LOCast cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("BinStorage"));
        foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(2);
        exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("PigStorage"));
    }

    @Test
    public void testCogroupSplitLineageNoSchema() throws Throwable {
        this.planTester.buildPlan("a = load 'a' using BinStorage() ;");
        this.planTester.buildPlan("b = load 'a' using PigStorage() ;");
        this.planTester.buildPlan("c = cogroup a by $0, b by $0 ;");
        this.planTester.buildPlan("d = foreach c generate group, flatten(a), flatten(b)  ;");
        this.planTester.buildPlan("split d into e if $1 > 'm', f if $1 > 'm'  ;");
        LogicalPlan plan = this.planTester.buildPlan("g = foreach e generate group, $1 + 1, $2 + 2.0  ;");
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        this.planTester.printPlan(plan, TypeCheckingTestUtil.getCurrentMethodName());
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no  error");
        }
        LOForEach foreach = (LOForEach)plan.getLeaves().get(0);
        LogicalPlan foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(1);
        LogicalOperator exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        LOCast cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("BinStorage"));
        foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(2);
        exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("PigStorage"));
    }

    @Test
    public void testDistinctLineage() throws Throwable {
        this.planTester.buildPlan("a = load 'a' as (field1, field2: float, field3: chararray );");
        this.planTester.buildPlan("b = distinct a;");
        LogicalPlan plan = this.planTester.buildPlan("c = foreach b generate field1 + 1.0 ;");
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        this.planTester.printPlan(plan, TypeCheckingTestUtil.getCurrentMethodName());
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no  error");
        }
        LOForEach foreach = (LOForEach)plan.getLeaves().get(0);
        LogicalPlan foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(0);
        LogicalOperator exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        LOCast cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("org.apache.pig.builtin.PigStorage"));
    }

    @Test
    public void testDistinctLineageNoSchema() throws Throwable {
        this.planTester.buildPlan("a = load 'a' ;");
        this.planTester.buildPlan("b = distinct a;");
        LogicalPlan plan = this.planTester.buildPlan("c = foreach b generate $1 + 1.0 ;");
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        this.planTester.printPlan(plan, TypeCheckingTestUtil.getCurrentMethodName());
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no  error");
        }
        LOForEach foreach = (LOForEach)plan.getLeaves().get(0);
        LogicalPlan foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(0);
        LogicalOperator exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        LOCast cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("org.apache.pig.builtin.PigStorage"));
    }

    @Test
    public void testCogroupDistinctLineage() throws Throwable {
        this.planTester.buildPlan("a = load 'a' using BinStorage() as (field1, field2: float, field3: chararray );");
        this.planTester.buildPlan("b = load 'a' using PigStorage() as (field4, field5, field6: chararray );");
        this.planTester.buildPlan("c = cogroup a by field1, b by field4 ;");
        this.planTester.buildPlan("d = foreach c generate group, flatten(a), flatten(b)  ;");
        this.planTester.buildPlan("e = distinct d ;");
        LogicalPlan plan = this.planTester.buildPlan("f = foreach e generate group, field1 + 1, field4 + 2.0  ;");
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        this.planTester.printPlan(plan, TypeCheckingTestUtil.getCurrentMethodName());
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no  error");
        }
        LOForEach foreach = (LOForEach)plan.getLeaves().get(0);
        LogicalPlan foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(1);
        LogicalOperator exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        LOCast cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("BinStorage"));
        foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(2);
        exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("PigStorage"));
    }

    @Test
    public void testCogroupDistinctLineageNoSchema() throws Throwable {
        this.planTester.buildPlan("a = load 'a' using BinStorage() ;");
        this.planTester.buildPlan("b = load 'a' using PigStorage() ;");
        this.planTester.buildPlan("c = cogroup a by $0, b by $0 ;");
        this.planTester.buildPlan("d = foreach c generate group, flatten(a), flatten(b)  ;");
        this.planTester.buildPlan("e = distinct d ;");
        LogicalPlan plan = this.planTester.buildPlan("f = foreach e generate group, $1 + 1, $2 + 2.0  ;");
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        this.planTester.printPlan(plan, TypeCheckingTestUtil.getCurrentMethodName());
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no  error");
        }
        LOForEach foreach = (LOForEach)plan.getLeaves().get(0);
        LogicalPlan foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(1);
        LogicalOperator exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        LOCast cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("BinStorage"));
        foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(2);
        exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("PigStorage"));
    }

    @Test
    public void testSortLineage() throws Throwable {
        this.planTester.buildPlan("a = load 'a' as (field1, field2: float, field3: chararray );");
        this.planTester.buildPlan("b = order a by field1;");
        LogicalPlan plan = this.planTester.buildPlan("c = foreach b generate field1 + 1.0 ;");
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        this.planTester.printPlan(plan, TypeCheckingTestUtil.getCurrentMethodName());
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no  error");
        }
        LOForEach foreach = (LOForEach)plan.getLeaves().get(0);
        LogicalPlan foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(0);
        LogicalOperator exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        LOCast cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("org.apache.pig.builtin.PigStorage"));
    }

    @Test
    public void testSortLineageNoSchema() throws Throwable {
        this.planTester.buildPlan("a = load 'a' ;");
        this.planTester.buildPlan("b = order a by $1;");
        LogicalPlan plan = this.planTester.buildPlan("c = foreach b generate $1 + 1.0 ;");
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        this.planTester.printPlan(plan, TypeCheckingTestUtil.getCurrentMethodName());
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no  error");
        }
        LOForEach foreach = (LOForEach)plan.getLeaves().get(0);
        LogicalPlan foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(0);
        LogicalOperator exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        LOCast cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("org.apache.pig.builtin.PigStorage"));
    }

    @Test
    public void testCogroupSortLineage() throws Throwable {
        this.planTester.buildPlan("a = load 'a' using BinStorage() as (field1, field2: float, field3: chararray );");
        this.planTester.buildPlan("b = load 'a' using PigStorage() as (field4, field5, field6: chararray );");
        this.planTester.buildPlan("c = cogroup a by field1, b by field4 ;");
        this.planTester.buildPlan("d = foreach c generate group, flatten(a), flatten(b)  ;");
        this.planTester.buildPlan("e = order d by field4 desc;");
        LogicalPlan plan = this.planTester.buildPlan("f = foreach e generate group, field1 + 1, field4 + 2.0  ;");
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        this.planTester.printPlan(plan, TypeCheckingTestUtil.getCurrentMethodName());
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no  error");
        }
        LOForEach foreach = (LOForEach)plan.getLeaves().get(0);
        LogicalPlan foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(1);
        LogicalOperator exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        LOCast cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("BinStorage"));
        foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(2);
        exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("PigStorage"));
    }

    @Test
    public void testCogroupSortLineageNoSchema() throws Throwable {
        this.planTester.buildPlan("a = load 'a' using BinStorage() ;");
        this.planTester.buildPlan("b = load 'a' using PigStorage() ;");
        this.planTester.buildPlan("c = cogroup a by $0, b by $0 ;");
        this.planTester.buildPlan("d = foreach c generate group, flatten(a), flatten(b)  ;");
        this.planTester.buildPlan("e = order d by $2 desc;");
        LogicalPlan plan = this.planTester.buildPlan("f = foreach e generate group, $1 + 1, $2 + 2.0  ;");
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        this.planTester.printPlan(plan, TypeCheckingTestUtil.getCurrentMethodName());
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no  error");
        }
        LOForEach foreach = (LOForEach)plan.getLeaves().get(0);
        LogicalPlan foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(1);
        LogicalOperator exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        LOCast cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("BinStorage"));
        foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(2);
        exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("PigStorage"));
    }

    @Test
    public void testCogroupSortStarLineage() throws Throwable {
        this.planTester.buildPlan("a = load 'a' using BinStorage() as (field1, field2: float, field3: chararray );");
        this.planTester.buildPlan("b = load 'a' using PigStorage() as (field4, field5, field6: chararray );");
        this.planTester.buildPlan("c = cogroup a by field1, b by field4 ;");
        this.planTester.buildPlan("d = foreach c generate group, flatten(a), flatten(b)  ;");
        this.planTester.buildPlan("e = order d by * desc;");
        LogicalPlan plan = this.planTester.buildPlan("f = foreach e generate group, field1 + 1, field4 + 2.0  ;");
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        this.planTester.printPlan(plan, TypeCheckingTestUtil.getCurrentMethodName());
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no  error");
        }
        LOForEach foreach = (LOForEach)plan.getLeaves().get(0);
        LogicalPlan foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(1);
        LogicalOperator exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        LOCast cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("BinStorage"));
        foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(2);
        exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("PigStorage"));
    }

    @Test
    public void testCogroupSortStarLineageNoSchema() throws Throwable {
        this.planTester.buildPlan("a = load 'a' using BinStorage() ;");
        this.planTester.buildPlan("b = load 'a' using PigStorage() ;");
        this.planTester.buildPlan("c = cogroup a by $0, b by $0 ;");
        this.planTester.buildPlan("d = foreach c generate group, flatten(a), flatten(b)  ;");
        this.planTester.buildPlan("e = order d by * desc;");
        LogicalPlan plan = this.planTester.buildPlan("f = foreach e generate group, $1 + 1, $2 + 2.0  ;");
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        this.planTester.printPlan(plan, TypeCheckingTestUtil.getCurrentMethodName());
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no  error");
        }
        LOForEach foreach = (LOForEach)plan.getLeaves().get(0);
        LogicalPlan foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(1);
        LogicalOperator exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        LOCast cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("BinStorage"));
        foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(2);
        exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("PigStorage"));
    }

    @Test
    public void testCrossLineage() throws Throwable {
        this.planTester.buildPlan("a = load 'a' using BinStorage() as (field1, field2: float, field3: chararray );");
        this.planTester.buildPlan("b = load 'a' using PigStorage() as (field4, field5, field6: chararray );");
        this.planTester.buildPlan("c = cross a, b ;");
        LogicalPlan plan = this.planTester.buildPlan("d = foreach c generate field1 + 1, field4 + 2.0  ;");
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        this.planTester.printPlan(plan, TypeCheckingTestUtil.getCurrentMethodName());
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no  error");
        }
        LOForEach foreach = (LOForEach)plan.getLeaves().get(0);
        LogicalPlan foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(0);
        LogicalOperator exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        LOCast cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("BinStorage"));
        foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(1);
        exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("PigStorage"));
    }

    @Test
    public void testCrossLineageNoSchema() throws Throwable {
        this.planTester.buildPlan("a = load 'a' using BinStorage() ;");
        this.planTester.buildPlan("b = load 'a' using BinStorage() ;");
        this.planTester.buildPlan("c = cross a , b ;");
        LogicalPlan plan = this.planTester.buildPlan("d = foreach c generate $1 + 2.0  ;");
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        try {
            typeValidator.validate(plan, collector);
        }
        catch (PlanValidationException pve) {
            // empty catch block
        }
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        this.planTester.printPlan(plan, TypeCheckingTestUtil.getCurrentMethodName());
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no  error");
        }
        LOForEach foreach = (LOForEach)plan.getLeaves().get(0);
        LogicalPlan foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(0);
        LogicalOperator exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        LOCast cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("BinStorage"));
    }

    @Test
    public void testCrossLineageNoSchemaFail() throws Throwable {
        this.planTester.buildPlan("a = load 'a' using BinStorage() ;");
        this.planTester.buildPlan("b = load 'a' using PigStorage() ;");
        this.planTester.buildPlan("c = cross a , b ;");
        LogicalPlan plan = this.planTester.buildPlan("d = foreach c generate $1 + 2.0  ;");
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        try {
            typeValidator.validate(plan, collector);
            TestTypeCheckingValidator.fail((String)"Exception expected");
        }
        catch (PlanValidationException pve) {
            // empty catch block
        }
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        this.planTester.printPlan(plan, TypeCheckingTestUtil.getCurrentMethodName());
        if (!collector.hasError()) {
            throw new AssertionError((Object)"Expect error");
        }
    }

    @Test
    public void testCrossLineageMixSchema() throws Throwable {
        this.planTester.buildPlan("a = load 'a' using PigStorage() as (field1, field2: float, field3: chararray );");
        this.planTester.buildPlan("b = load 'a' using PigStorage() ;");
        this.planTester.buildPlan("c = cross a , b ;");
        LogicalPlan plan = this.planTester.buildPlan("d = foreach c generate $3 + 2.0  ;");
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        this.planTester.printPlan(plan, TypeCheckingTestUtil.getCurrentMethodName());
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no  error");
        }
        LOForEach foreach = (LOForEach)plan.getLeaves().get(0);
        LogicalPlan foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(0);
        LogicalOperator exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        LOCast cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("PigStorage"));
    }

    @Test
    public void testCrossLineageMixSchemaFail() throws Throwable {
        this.planTester.buildPlan("a = load 'a' using BinStorage() as (field1, field2: float, field3: chararray );");
        this.planTester.buildPlan("b = load 'a' using PigStorage() ;");
        this.planTester.buildPlan("c = cross a , b ;");
        LogicalPlan plan = this.planTester.buildPlan("d = foreach c generate $3 + 2.0  ;");
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        try {
            typeValidator.validate(plan, collector);
            TestTypeCheckingValidator.fail((String)"Exception expected");
        }
        catch (PlanValidationException pve) {
            // empty catch block
        }
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        this.planTester.printPlan(plan, TypeCheckingTestUtil.getCurrentMethodName());
        if (!collector.hasError()) {
            throw new AssertionError((Object)"Expect error");
        }
    }

    @Test
    public void testJoinLineage() throws Throwable {
        this.planTester.buildPlan("a = load 'a' using BinStorage() as (field1, field2: float, field3: chararray );");
        this.planTester.buildPlan("b = load 'a' using PigStorage() as (field4, field5, field6: chararray );");
        this.planTester.buildPlan("c = join a by field1, b by field4 ;");
        LogicalPlan plan = this.planTester.buildPlan("d = foreach c generate field1 + 1, field4 + 2.0  ;");
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        this.planTester.printPlan(plan, TypeCheckingTestUtil.getCurrentMethodName());
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no  error");
        }
        LOForEach foreach = (LOForEach)plan.getLeaves().get(0);
        LogicalPlan foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(0);
        LogicalOperator exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        LOCast cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("BinStorage"));
        foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(1);
        exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("PigStorage"));
    }

    @Test
    public void testJoinLineageNoSchema() throws Throwable {
        this.planTester.buildPlan("a = load 'a' using BinStorage() ;");
        this.planTester.buildPlan("b = load 'a' using BinStorage() ;");
        this.planTester.buildPlan("c = join a by $0, b by $0 ;");
        LogicalPlan plan = this.planTester.buildPlan("d = foreach c generate $1 + 2.0  ;");
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        try {
            typeValidator.validate(plan, collector);
        }
        catch (PlanValidationException pve) {
            // empty catch block
        }
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        this.planTester.printPlan(plan, TypeCheckingTestUtil.getCurrentMethodName());
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no  error");
        }
        LOForEach foreach = (LOForEach)plan.getLeaves().get(0);
        LogicalPlan foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(0);
        LogicalOperator exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        LOCast cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("BinStorage"));
    }

    @Test
    public void testJoinLineageNoSchemaFail() throws Throwable {
        this.planTester.buildPlan("a = load 'a' using BinStorage() ;");
        this.planTester.buildPlan("b = load 'a' using PigStorage() ;");
        this.planTester.buildPlan("c = join a by $0, b by $0 ;");
        LogicalPlan plan = this.planTester.buildPlan("d = foreach c generate $1 + 2.0  ;");
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        try {
            typeValidator.validate(plan, collector);
        }
        catch (PlanValidationException pve) {
            // empty catch block
        }
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        this.planTester.printPlan(plan, TypeCheckingTestUtil.getCurrentMethodName());
        TestTypeCheckingValidator.assertTrue((boolean)collector.hasError());
    }

    @Test
    public void testJoinLineageMixSchema() throws Throwable {
        this.planTester.buildPlan("a = load 'a' using PigStorage() as (field1, field2: float, field3: chararray );");
        this.planTester.buildPlan("b = load 'a' using PigStorage() ;");
        this.planTester.buildPlan("c = join a by field1, b by $0 ;");
        LogicalPlan plan = this.planTester.buildPlan("d = foreach c generate $3 + 2.0  ;");
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        this.planTester.printPlan(plan, TypeCheckingTestUtil.getCurrentMethodName());
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no  error");
        }
        LOForEach foreach = (LOForEach)plan.getLeaves().get(0);
        LogicalPlan foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(0);
        LogicalOperator exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        LOCast cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("PigStorage"));
    }

    @Test
    public void testJoinLineageMixSchemaFail() throws Throwable {
        this.planTester.buildPlan("a = load 'a' using BinStorage() as (field1, field2: float, field3: chararray );");
        this.planTester.buildPlan("b = load 'a' using PigStorage() ;");
        this.planTester.buildPlan("c = join a by field1, b by $0 ;");
        LogicalPlan plan = this.planTester.buildPlan("d = foreach c generate $3 + 2.0  ;");
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        try {
            typeValidator.validate(plan, collector);
        }
        catch (PlanValidationException pve) {
            // empty catch block
        }
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        this.planTester.printPlan(plan, TypeCheckingTestUtil.getCurrentMethodName());
        TestTypeCheckingValidator.assertTrue((boolean)collector.hasError());
    }

    @Test
    public void testLimitLineage() throws Throwable {
        this.planTester.buildPlan("a = load 'a' as (field1, field2: float, field3: chararray );");
        this.planTester.buildPlan("b = limit a 100;");
        LogicalPlan plan = this.planTester.buildPlan("c = foreach b generate field1 + 1.0 ;");
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        this.planTester.printPlan(plan, TypeCheckingTestUtil.getCurrentMethodName());
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no  error");
        }
        LOForEach foreach = (LOForEach)plan.getLeaves().get(0);
        LogicalPlan foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(0);
        LogicalOperator exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        LOCast cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("org.apache.pig.builtin.PigStorage"));
    }

    @Test
    public void testLimitLineageNoSchema() throws Throwable {
        this.planTester.buildPlan("a = load 'a' ;");
        this.planTester.buildPlan("b = limit a 100;");
        LogicalPlan plan = this.planTester.buildPlan("c = foreach b generate $1 + 1.0 ;");
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        this.planTester.printPlan(plan, TypeCheckingTestUtil.getCurrentMethodName());
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no  error");
        }
        LOForEach foreach = (LOForEach)plan.getLeaves().get(0);
        LogicalPlan foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(0);
        LogicalOperator exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        LOCast cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("org.apache.pig.builtin.PigStorage"));
    }

    @Test
    public void testCogroupLimitLineage() throws Throwable {
        this.planTester.buildPlan("a = load 'a' using BinStorage() as (field1, field2: float, field3: chararray );");
        this.planTester.buildPlan("b = load 'a' using PigStorage() as (field4, field5, field6: chararray );");
        this.planTester.buildPlan("c = cogroup a by field1, b by field4 ;");
        this.planTester.buildPlan("d = foreach c generate group, flatten(a), flatten(b)  ;");
        this.planTester.buildPlan("e = limit d 100;");
        LogicalPlan plan = this.planTester.buildPlan("f = foreach e generate group, field1 + 1, field4 + 2.0  ;");
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        this.planTester.printPlan(plan, TypeCheckingTestUtil.getCurrentMethodName());
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no  error");
        }
        LOForEach foreach = (LOForEach)plan.getLeaves().get(0);
        LogicalPlan foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(1);
        LogicalOperator exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        LOCast cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("BinStorage"));
        foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(2);
        exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("PigStorage"));
    }

    @Test
    public void testCogroupLimitLineageNoSchema() throws Throwable {
        this.planTester.buildPlan("a = load 'a' using BinStorage() ;");
        this.planTester.buildPlan("b = load 'a' using PigStorage() ;");
        this.planTester.buildPlan("c = cogroup a by $0, b by $0 ;");
        this.planTester.buildPlan("d = foreach c generate group, flatten(a), flatten(b)  ;");
        this.planTester.buildPlan("e = limit d 100;");
        LogicalPlan plan = this.planTester.buildPlan("f = foreach e generate group, $1 + 1, $2 + 2.0  ;");
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        this.planTester.printPlan(plan, TypeCheckingTestUtil.getCurrentMethodName());
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no  error");
        }
        LOForEach foreach = (LOForEach)plan.getLeaves().get(0);
        LogicalPlan foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(1);
        LogicalOperator exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        LOCast cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("BinStorage"));
        foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(2);
        exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("PigStorage"));
    }

    @Test
    public void testCogroupTopKLineage() throws Throwable {
        this.planTester.buildPlan("a = load 'a' using BinStorage() as (field1, field2: float, field3: chararray );");
        this.planTester.buildPlan("b = load 'a' using PigStorage() as (field4, field5, field6: chararray );");
        this.planTester.buildPlan("c = cogroup a by field1, b by field4 ;");
        this.planTester.buildPlan("d = foreach c generate group, flatten(a), flatten(b)  ;");
        this.planTester.buildPlan("e = order d by field1 desc;");
        this.planTester.buildPlan("f = limit e 100;");
        LogicalPlan plan = this.planTester.buildPlan("g = foreach f generate group, field1 + 1, field4 + 2.0  ;");
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        this.planTester.printPlan(plan, TypeCheckingTestUtil.getCurrentMethodName());
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no  error");
        }
        LOForEach foreach = (LOForEach)plan.getLeaves().get(0);
        LogicalPlan foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(1);
        LogicalOperator exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        LOCast cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("BinStorage"));
        foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(2);
        exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("PigStorage"));
    }

    @Test
    public void testCogroupTopKLineageNoSchema() throws Throwable {
        this.planTester.buildPlan("a = load 'a' using BinStorage() ;");
        this.planTester.buildPlan("b = load 'a' using PigStorage() ;");
        this.planTester.buildPlan("c = cogroup a by $0, b by $0 ;");
        this.planTester.buildPlan("d = foreach c generate group, flatten(a), flatten(b)  ;");
        this.planTester.buildPlan("e = order d by $2 desc;");
        this.planTester.buildPlan("f = limit e 100;");
        LogicalPlan plan = this.planTester.buildPlan("g = foreach f generate group, $1 + 1, $2 + 2.0  ;");
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        this.planTester.printPlan(plan, TypeCheckingTestUtil.getCurrentMethodName());
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no  error");
        }
        LOForEach foreach = (LOForEach)plan.getLeaves().get(0);
        LogicalPlan foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(1);
        LogicalOperator exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        LOCast cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("BinStorage"));
        foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(2);
        exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("PigStorage"));
    }

    @Test
    public void testStreamingLineage1() throws Throwable {
        this.planTester.buildPlan("a = load 'a' using BinStorage() as (field1: int, field2: float, field3: chararray );");
        this.planTester.buildPlan("b = stream a through `" + simpleEchoStreamingCommand + "`;");
        LogicalPlan plan = this.planTester.buildPlan("c = foreach b generate $1 + 1.0 ;");
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        this.planTester.printPlan(plan, TypeCheckingTestUtil.getCurrentMethodName());
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no  error");
        }
        LOForEach foreach = (LOForEach)plan.getLeaves().get(0);
        LogicalPlan foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(0);
        LogicalOperator exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        LOCast cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("org.apache.pig.builtin.PigStreaming"));
    }

    @Test
    public void testStreamingLineage2() throws Throwable {
        this.planTester.buildPlan("a = load 'a' using BinStorage() as (field1: int, field2: float, field3: chararray );");
        this.planTester.buildPlan("b = stream a through `" + simpleEchoStreamingCommand + "` as (f1, f2: float);");
        LogicalPlan plan = this.planTester.buildPlan("c = foreach b generate f1 + 1.0, f2 + 4 ;");
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        this.planTester.printPlan(plan, TypeCheckingTestUtil.getCurrentMethodName());
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no  error");
        }
        LOForEach foreach = (LOForEach)plan.getLeaves().get(0);
        LogicalPlan foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(0);
        LogicalOperator exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        LOCast cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("org.apache.pig.builtin.PigStreaming"));
        foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(1);
        exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        TestTypeCheckingValidator.assertTrue((boolean)(foreachPlan.getSuccessors((Operator)exOp).get(0) instanceof LOAdd));
    }

    @Test
    public void testCogroupStreamingLineage() throws Throwable {
        this.planTester.buildPlan("a = load 'a' using BinStorage() as (field1, field2: float, field3: chararray );");
        this.planTester.buildPlan("b = stream a through `" + simpleEchoStreamingCommand + "` as (field4, field5, field6: chararray);");
        this.planTester.buildPlan("c = cogroup a by field1, b by field4 ;");
        this.planTester.buildPlan("d = foreach c generate group, flatten(a), flatten(b)  ;");
        LogicalPlan plan = this.planTester.buildPlan("e = foreach d generate group, field1 + 1, field4 + 2.0  ;");
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        this.planTester.printPlan(plan, TypeCheckingTestUtil.getCurrentMethodName());
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no  error");
        }
        LOForEach foreach = (LOForEach)plan.getLeaves().get(0);
        LogicalPlan foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(1);
        LogicalOperator exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        LOCast cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("BinStorage"));
        foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(2);
        exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("org.apache.pig.builtin.PigStreaming"));
    }

    @Test
    public void testCogroupStreamingLineageNoSchema() throws Throwable {
        this.planTester.buildPlan("a = load 'a' using BinStorage() ;");
        this.planTester.buildPlan("b = stream a through `" + simpleEchoStreamingCommand + "` ;");
        this.planTester.buildPlan("c = cogroup a by $0, b by $0 ;");
        this.planTester.buildPlan("d = foreach c generate group, flatten(a), flatten(b)  ;");
        LogicalPlan plan = this.planTester.buildPlan("e = foreach d generate group, $1 + 1, $2 + 2.0  ;");
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        this.planTester.printPlan(plan, TypeCheckingTestUtil.getCurrentMethodName());
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no  error");
        }
        LOForEach foreach = (LOForEach)plan.getLeaves().get(0);
        LogicalPlan foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(1);
        LogicalOperator exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        LOCast cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("BinStorage"));
        foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(2);
        exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        cast = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("org.apache.pig.builtin.PigStreaming"));
    }

    @Test
    public void testMapLookupLineage() throws Throwable {
        this.planTester.buildPlan("a = load 'a' using BinStorage() as (field1, field2: float, field3: chararray );");
        this.planTester.buildPlan("b = foreach a generate field1#'key1' as map1;");
        LogicalPlan plan = this.planTester.buildPlan("c = foreach b generate map1#'key2' + 1 ;");
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        this.planTester.printPlan(plan, TypeCheckingTestUtil.getCurrentMethodName());
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no  error");
        }
        LOForEach foreach = (LOForEach)plan.getLeaves().get(0);
        LogicalPlan foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(0);
        LogicalOperator exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        LOCast cast1 = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast1.getLoadFuncSpec().getClassName().startsWith("BinStorage"));
        LOMapLookup map = (LOMapLookup)foreachPlan.getSuccessors((Operator)cast1).get(0);
        LOCast cast = (LOCast)foreachPlan.getSuccessors((Operator)map).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("BinStorage"));
    }

    @Test
    public void testMapLookupLineageNoSchema() throws Throwable {
        this.planTester.buildPlan("a = load 'a' using BinStorage() ;");
        this.planTester.buildPlan("b = foreach a generate $0#'key1';");
        LogicalPlan plan = this.planTester.buildPlan("c = foreach b generate $0#'key2' + 1 ;");
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        this.planTester.printPlan(plan, TypeCheckingTestUtil.getCurrentMethodName());
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no  error");
        }
        LOForEach foreach = (LOForEach)plan.getLeaves().get(0);
        LogicalPlan foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(0);
        LogicalOperator exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        if (!(exOp instanceof LOProject)) {
            exOp = (LogicalOperator)foreachPlan.getRoots().get(1);
        }
        LOCast cast1 = (LOCast)foreachPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast1.getLoadFuncSpec().getClassName().startsWith("BinStorage"));
        LOMapLookup map = (LOMapLookup)foreachPlan.getSuccessors((Operator)cast1).get(0);
        LOCast cast = (LOCast)foreachPlan.getSuccessors((Operator)map).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("BinStorage"));
    }

    @Test
    public void testMapLookupLineage2() throws Throwable {
        this.planTester.buildPlan("a = load 'a' as (s, m, l);");
        this.planTester.buildPlan("b = foreach a generate s#'x' as f1, s#'y' as f2, s#'z' as f3;");
        this.planTester.buildPlan("c = group b by f1;");
        LogicalPlan plan = this.planTester.buildPlan("d = foreach c {fil = filter b by f2 == 1; generate flatten(group), SUM(fil.f3);};");
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        this.planTester.printPlan(plan, TypeCheckingTestUtil.getCurrentMethodName());
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no  error");
        }
        LOForEach foreach = (LOForEach)plan.getLeaves().get(0);
        LogicalPlan foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(1);
        LogicalOperator exOp = (LogicalOperator)foreachPlan.getRoots().get(0);
        LOFilter filter = (LOFilter)foreachPlan.getSuccessors((Operator)exOp).get(0);
        LogicalPlan filterPlan = filter.getComparisonPlan();
        if (!((exOp = (LogicalOperator)filterPlan.getRoots().get(0)) instanceof LOProject)) {
            exOp = (LogicalOperator)filterPlan.getRoots().get(1);
        }
        LOCast cast = (LOCast)filterPlan.getSuccessors((Operator)exOp).get(0);
        TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith("org.apache.pig.builtin.PigStorage"));
    }

    @Test
    public void testMapLookupLineage3() throws Throwable {
        this.planTester.buildPlan("a = load 'a' as (s, m, l);");
        this.planTester.buildPlan("b = foreach a generate flatten(l#'viewinfo') as viewinfo ;");
        LogicalPlan plan = this.planTester.buildPlan("c = foreach b generate (chararray)viewinfo#'pos' as position;");
        this.runTypeCheckingValidator(plan);
        this.checkLoaderInCasts(plan, "org.apache.pig.builtin.PigStorage");
    }

    @Test
    public void testTwolevelMapLookupLineage() throws Exception {
        ArrayList<String[]> queries = new ArrayList<String[]>();
        queries.add(new String[]{"sds = LOAD '/my/data/location' AS (simpleFields:map[], mapFields:map[], listMapFields:map[]);", "queries = FILTER sds BY mapFields#'page_params'#'query' is NOT NULL;", "queries_rand = FOREACH queries GENERATE (CHARARRAY) (mapFields#'page_params'#'query') AS query_string;", "queries_limit = LIMIT queries_rand 100;", "STORE queries_limit INTO 'out';"});
        queries.add(new String[]{"sds = LOAD '/my/data/location'  AS (simpleFields:map[], mapFields:map[], listMapFields:map[]);", "queries_rand = FOREACH sds GENERATE (CHARARRAY) (mapFields#'page_params'#'query') AS query_string;", "queries = FILTER queries_rand BY query_string IS NOT null;", "queries_limit = LIMIT queries 100;", "STORE queries_limit INTO 'out';"});
        queries.add(new String[]{"sds = LOAD '/my/data/location'  AS (simpleFields:map[], mapFields:map[], listMapFields:map[]);", "params = FOREACH sds GENERATE (map[]) (mapFields#'page_params') AS params;", "queries = FOREACH params GENERATE (CHARARRAY) (params#'query') AS query_string;", "queries_filtered = FILTER queries BY query_string IS NOT null;", "queries_limit = LIMIT queries_filtered 100;", "STORE queries_limit INTO 'out';"});
        queries.add(new String[]{"sds = LOAD '/my/data/location'  AS (simpleFields:map[], mapFields:map[], listMapFields:map[]);", "params = FOREACH sds GENERATE (map[]) (mapFields#'page_params') AS params;", "queries = FOREACH params GENERATE (CHARARRAY) (params#'query') AS query_string;", "queries_limit = LIMIT queries 100;", "STORE queries_limit INTO 'out';"});
        queries.add(new String[]{"sds = LOAD '/my/data/location'  AS (simpleFields:map[], mapFields:map[], listMapFields:map[]);", "params = FOREACH sds GENERATE (map[]) (mapFields#'page_params') AS params;", "queries = FOREACH params GENERATE (CHARARRAY) (params#'query') AS query_string;", "rand_queries = FOREACH queries GENERATE query_string as query;", "queries_limit = LIMIT rand_queries 100;", "STORE rand_queries INTO 'out';"});
        for (String[] query : queries) {
            LogicalPlan lp = null;
            for (String queryLine : query) {
                lp = this.planTester.buildPlan(queryLine);
            }
            this.runTypeCheckingValidator(lp);
            this.checkLoaderInCasts(lp, "org.apache.pig.builtin.PigStorage");
        }
    }

    private void runTypeCheckingValidator(LogicalPlan plan) throws PlanValidationException {
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        this.planTester.printPlan(plan, TypeCheckingTestUtil.getCurrentMethodName());
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no  error");
        }
    }

    private void checkLoaderInCasts(LogicalPlan plan, String loaderClassName) throws VisitorException {
        CastFinder cf = new CastFinder(plan);
        cf.visit();
        List<LOCast> casts = cf.casts;
        for (LOCast cast : casts) {
            TestTypeCheckingValidator.assertTrue((boolean)cast.getLoadFuncSpec().getClassName().startsWith(loaderClassName));
        }
    }

    @Test
    public void testBincond() throws Throwable {
        this.planTester.buildPlan("a = load 'a' as (name: chararray, age: int, gpa: float);");
        this.planTester.buildPlan("b = group a by name;");
        LogicalPlan plan = this.planTester.buildPlan("c = foreach b generate (IsEmpty(a) ? " + TestBinCondFieldSchema.class.getName() + "(*): a) ;");
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        this.planTester.printPlan(plan, TypeCheckingTestUtil.getCurrentMethodName());
        if (collector.hasError()) {
            throw new AssertionError((Object)"Did not expect an error");
        }
        LOForEach foreach = (LOForEach)plan.getLeaves().get(0);
        Schema.FieldSchema charFs = new Schema.FieldSchema(null, 55);
        Schema.FieldSchema intFs = new Schema.FieldSchema(null, 10);
        Schema.FieldSchema floatFs = new Schema.FieldSchema(null, 20);
        Schema bagSchema = new Schema();
        bagSchema.add(charFs);
        bagSchema.add(intFs);
        bagSchema.add(floatFs);
        Schema.FieldSchema bagFs = null;
        try {
            bagFs = new Schema.FieldSchema(null, bagSchema, 120);
        }
        catch (FrontendException fee) {
            TestTypeCheckingValidator.fail((String)"Did not expect an error");
        }
        Schema expectedSchema = new Schema(bagFs);
        TestTypeCheckingValidator.assertTrue((boolean)Schema.equals((Schema)foreach.getSchema(), (Schema)expectedSchema, (boolean)false, (boolean)true));
    }

    @Test
    public void testBinCondForOuterJoin() throws Throwable {
        this.planTester.buildPlan("a = LOAD 'student_data' AS (name: chararray, age: int, gpa: float);");
        this.planTester.buildPlan("b = LOAD 'voter_data' AS (name: chararray, age: int, registration: chararray, contributions: float);");
        this.planTester.buildPlan("c = COGROUP a BY name, b BY name;");
        LogicalPlan plan = this.planTester.buildPlan("d = FOREACH c GENERATE group, flatten((not IsEmpty(a) ? a : (bag{tuple(chararray, int, float)}){(null, null, null)})), flatten((not IsEmpty(b) ? b : (bag{tuple(chararray, int, chararray, float)}){(null,null,null, null)}));");
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        this.planTester.printPlan(plan, TypeCheckingTestUtil.getCurrentMethodName());
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no  error");
        }
        LOForEach foreach = (LOForEach)plan.getLeaves().get(0);
        String expectedSchemaString = "mygroup: chararray,A::name: chararray,A::age: int,A::gpa: float,B::name: chararray,B::age: int,B::registration: chararray,B::contributions: float";
        Schema expectedSchema = Util.getSchemaFromString(expectedSchemaString);
        TestTypeCheckingValidator.assertTrue((boolean)Schema.equals((Schema)foreach.getSchema(), (Schema)expectedSchema, (boolean)false, (boolean)true));
    }

    @Test
    public void testMapLookupCast() throws Exception {
        String[] input = new String[]{"[k1#hello,k2#bye]", "[k1#good,k2#morning]"};
        File f = Util.createInputFile("test", ".txt", input);
        String inputFileName = f.getAbsolutePath();
        this.planTester.buildPlan("a = load 'file://" + inputFileName + "' as (m);");
        LogicalPlan lp = this.planTester.buildPlan("b = foreach a generate m#'k1';");
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(lp, collector);
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        LogicalPlan innerPlan = (LogicalPlan)foreach.getForEachPlans().get(0);
        LOMapLookup mapLookup = (LOMapLookup)innerPlan.getLeaves().get(0);
        TestTypeCheckingValidator.assertEquals(LOCast.class, mapLookup.getMap().getClass());
        TestTypeCheckingValidator.assertEquals((byte)100, (byte)((LOCast)mapLookup.getMap()).getType());
        this.planTester.buildPlan("a = load 'file://" + inputFileName + "' as (m:[]);");
        lp = this.planTester.buildPlan("b = foreach a generate m#'k1';");
        collector = new CompilationMessageCollector();
        typeValidator = new TypeCheckingValidator();
        typeValidator.validate(lp, collector);
        foreach = (LOForEach)lp.getLeaves().get(0);
        innerPlan = (LogicalPlan)foreach.getForEachPlans().get(0);
        mapLookup = (LOMapLookup)innerPlan.getLeaves().get(0);
        TestTypeCheckingValidator.assertEquals(LOProject.class, mapLookup.getMap().getClass());
        PigServer ps = new PigServer(ExecType.LOCAL);
        ps.registerQuery("a = load 'file://" + inputFileName + "' as (m);");
        ps.registerQuery("b = foreach a generate m#'k1';");
        Iterator it = ps.openIterator("b");
        String[] expectedResults = new String[]{"(hello)", "(good)"};
        int i = 0;
        while (it.hasNext()) {
            TestTypeCheckingValidator.assertEquals((String)expectedResults[i++], (String)((Tuple)it.next()).toString());
        }
        ps.registerQuery("a = load 'file://" + inputFileName + "' as (m:[]);");
        ps.registerQuery("b = foreach a generate m#'k1';");
        it = ps.openIterator("b");
        expectedResults = new String[]{"(hello)", "(good)"};
        i = 0;
        while (it.hasNext()) {
            TestTypeCheckingValidator.assertEquals((String)expectedResults[i++], (String)((Tuple)it.next()).toString());
        }
    }

    private void checkForEachCasting(LOForEach foreach, int idx, boolean isCast, byte toType) {
        LogicalPlan plan = (LogicalPlan)foreach.getForEachPlans().get(idx);
        if (isCast) {
            List leaveList = plan.getLeaves();
            TestTypeCheckingValidator.assertEquals((int)leaveList.size(), (int)1);
            TestTypeCheckingValidator.assertTrue((boolean)(leaveList.get(0) instanceof LOCast));
            TestTypeCheckingValidator.assertTrue((((LogicalOperator)leaveList.get(0)).getType() == toType ? 1 : 0) != 0);
        } else {
            List leaveList = plan.getLeaves();
            TestTypeCheckingValidator.assertEquals((int)leaveList.size(), (int)1);
            TestTypeCheckingValidator.assertTrue((boolean)(leaveList.get(0) instanceof LOProject));
        }
    }

    static {
        File fileA = new File("a");
        File fileB = new File("b");
        try {
            fileA.delete();
            fileB.delete();
            if (!fileA.createNewFile() || !fileB.createNewFile()) {
                TestTypeCheckingValidator.fail((String)"Unable to create input files");
            }
        }
        catch (IOException e) {
            TestTypeCheckingValidator.fail((String)("Unable to create input files:" + e.getMessage()));
        }
        fileA.deleteOnExit();
        fileB.deleteOnExit();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TestBinCondFieldSchema
    extends EvalFunc<DataBag> {
        public DataBag exec(Tuple input) {
            return null;
        }

        public Schema outputSchema(Schema input) {
            Schema.FieldSchema bagFs;
            Schema.FieldSchema charFs = new Schema.FieldSchema(null, 55);
            Schema.FieldSchema intFs = new Schema.FieldSchema(null, 10);
            Schema.FieldSchema floatFs = new Schema.FieldSchema(null, 20);
            Schema bagSchema = new Schema();
            bagSchema.add(charFs);
            bagSchema.add(intFs);
            bagSchema.add(floatFs);
            try {
                bagFs = new Schema.FieldSchema(null, bagSchema, 120);
            }
            catch (FrontendException fee) {
                return null;
            }
            return new Schema(bagFs);
        }
    }

    class CastFinder
    extends LOVisitor {
        List<LOCast> casts;

        public CastFinder(LogicalPlan lp) {
            super(lp, (PlanWalker)new DepthFirstWalker((OperatorPlan)lp));
            this.casts = new ArrayList<LOCast>();
        }

        protected void visit(LOCast cast) throws VisitorException {
            this.casts.add(cast);
        }
    }
}

