/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.pig.ExecType;
import org.apache.pig.PigServer;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.io.FileLocalizer;
import org.apache.pig.test.MiniCluster;
import org.apache.pig.test.Util;
import org.apache.pig.test.utils.MyUDFReturnMap;
import org.junit.Test;

public class TestUDFReturnMap
extends TestCase {
    static String[] ScriptStatement = new String[]{"A = LOAD 'test/org/apache/pig/test/data/passwd' USING PigStorage();", "B = FOREACH A GENERATE org.apache.pig.test.utils.MyUDFReturnMap(1);"};
    static File TempScriptFile = null;
    static MiniCluster cluster = MiniCluster.buildCluster();

    protected void setUp() throws Exception {
        TempScriptFile = File.createTempFile("temp_jira_851", ".pig");
        FileWriter writer = new FileWriter(TempScriptFile);
        for (String line : ScriptStatement) {
            writer.write(line + "\n");
        }
        writer.close();
    }

    @Test
    public void testUDFReturnMap_LocalMode() {
        try {
            PigServer pig = new PigServer(ExecType.LOCAL);
            pig.registerScript(TempScriptFile.getAbsolutePath());
            Iterator iterator = pig.openIterator("B");
            int index = 0;
            while (iterator.hasNext()) {
                Tuple tuple = (Tuple)iterator.next();
                ++index;
                Map result = (Map)tuple.get(0);
                TestUDFReturnMap.assertEquals((Object)result, MyUDFReturnMap.map);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            TestUDFReturnMap.fail();
        }
    }

    @Test
    public void testUDFReturnMap_MapReduceMode() {
        try {
            Util.createInputFile(cluster, "a.txt", new String[]{"dummy", "dummy"});
            FileLocalizer.deleteTempFiles();
            PigServer pig = new PigServer(ExecType.MAPREDUCE, cluster.getProperties());
            pig.registerQuery("A = LOAD 'a.txt';");
            pig.registerQuery("B = FOREACH A GENERATE org.apache.pig.test.utils.MyUDFReturnMap();");
            Iterator iterator = pig.openIterator("B");
            int index = 0;
            while (iterator.hasNext()) {
                Tuple tuple = (Tuple)iterator.next();
                ++index;
                Map result = (Map)tuple.get(0);
                TestUDFReturnMap.assertEquals((Object)result, MyUDFReturnMap.map);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            TestUDFReturnMap.fail();
        }
    }

    protected void tearDown() throws Exception {
        TempScriptFile.delete();
    }
}

