/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import junit.framework.TestCase;
import org.apache.pig.ExecType;
import org.apache.pig.PigServer;
import org.apache.pig.data.Tuple;

public class TestUDFWithoutParameter
extends TestCase {
    static String[] ScriptStatement = new String[]{"A = LOAD 'test/org/apache/pig/test/data/passwd' USING PigStorage();", "B = FOREACH A GENERATE org.apache.pig.test.utils.MyUDFWithoutParameter();"};
    static File TempScriptFile = null;

    protected void setUp() throws Exception {
        TempScriptFile = File.createTempFile("temp_jira_753", ".pig");
        FileWriter writer = new FileWriter(TempScriptFile);
        for (String line : ScriptStatement) {
            writer.write(line + "\n");
        }
        writer.close();
    }

    public void testUDFWithoutParameter() {
        try {
            PigServer pig = new PigServer(ExecType.LOCAL);
            pig.registerScript(TempScriptFile.getAbsolutePath());
            Iterator iterator = pig.openIterator("B");
            int index = 0;
            while (iterator.hasNext()) {
                Tuple tuple = (Tuple)iterator.next();
                int result = (Integer)tuple.get(0);
                TestUDFWithoutParameter.assertEquals((int)result, (int)(++index));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            TestUDFWithoutParameter.fail();
        }
    }

    protected void tearDown() throws Exception {
        TempScriptFile.delete();
    }
}

