/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import junit.framework.TestCase;
import org.apache.pig.ExecType;
import org.apache.pig.PigServer;
import org.apache.pig.builtin.PigStorage;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.test.MiniCluster;
import org.apache.pig.test.Util;
import org.apache.pig.tools.grunt.Grunt;
import org.apache.pig.tools.parameters.ParameterSubstitutionPreprocessor;
import org.junit.Before;
import org.junit.Test;

public class TestUTF8
extends TestCase {
    MiniCluster cluster = MiniCluster.buildCluster();
    private PigServer pigServer;

    @Before
    public void setUp() throws Exception {
        this.pigServer = new PigServer(ExecType.MAPREDUCE, this.cluster.getProperties());
    }

    @Test
    public void testPigStorage() throws Exception {
        File f1 = File.createTempFile("tmp", "");
        PrintWriter pw = new PrintWriter(f1, "UTF-8");
        pw.println("\u4e2d\u6587");
        pw.println("\u306b\u307b\u3093\u3054");
        pw.println("\ud55c\uad6d\uc5b4");
        pw.println("\u0e20\u0e32\u0e29\u0e32\u0e44\u0e17\u0e22");
        pw.close();
        this.pigServer.registerQuery("a = load '" + Util.generateURI(f1.toString(), this.pigServer.getPigContext()) + "' using " + PigStorage.class.getName() + "();");
        Iterator iter = this.pigServer.openIterator("a");
        TestUTF8.assertEquals((String)DataType.toString((Object)((Tuple)iter.next()).get(0)), (String)"\u4e2d\u6587");
        TestUTF8.assertEquals((String)DataType.toString((Object)((Tuple)iter.next()).get(0)), (String)"\u306b\u307b\u3093\u3054");
        TestUTF8.assertEquals((String)DataType.toString((Object)((Tuple)iter.next()).get(0)), (String)"\ud55c\uad6d\uc5b4");
        TestUTF8.assertEquals((String)DataType.toString((Object)((Tuple)iter.next()).get(0)), (String)"\u0e20\u0e32\u0e29\u0e32\u0e44\u0e17\u0e22");
        f1.delete();
    }

    @Test
    public void testScriptParser() throws Throwable {
        String strCmd = "--\u4e2d\u6587\n";
        ByteArrayInputStream cmd = new ByteArrayInputStream(strCmd.getBytes("UTF-8"));
        InputStreamReader reader = new InputStreamReader(cmd);
        Grunt grunt = new Grunt(new BufferedReader(reader), this.pigServer.getPigContext());
        grunt.exec();
    }

    @Test
    public void testQueryParser() throws Exception {
        File f1 = File.createTempFile("tmp", "");
        PrintWriter pw = new PrintWriter(f1, "UTF-8");
        pw.println("\u4e2d\u6587");
        pw.close();
        this.pigServer.registerQuery("a = load '" + Util.generateURI(f1.toString(), this.pigServer.getPigContext()) + "' using " + PigStorage.class.getName() + "();");
        this.pigServer.registerQuery("b =  filter a by $0 == '\u4e2d\u6587';");
        Iterator iter = this.pigServer.openIterator("a");
        TestUTF8.assertEquals((String)DataType.toString((Object)((Tuple)iter.next()).get(0)), (String)"\u4e2d\u6587");
        f1.delete();
    }

    @Test
    public void testParamSubstitution() throws Exception {
        File queryFile = File.createTempFile("query", "");
        PrintWriter ps = new PrintWriter(queryFile);
        ps.println("b = filter a by $0 == '$querystring';");
        ps.close();
        String[] arg = new String[]{"querystring='\u4e2d\u6587'"};
        ParameterSubstitutionPreprocessor psp = new ParameterSubstitutionPreprocessor(50);
        BufferedReader pigIStream = new BufferedReader(new FileReader(queryFile.toString()));
        StringWriter pigOStream = new StringWriter();
        psp.genSubstitutedFile(pigIStream, (Writer)pigOStream, arg, null);
        TestUTF8.assertTrue((boolean)pigOStream.toString().contains("\u4e2d\u6587"));
        queryFile.delete();
    }
}

