/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import junit.framework.TestCase;
import org.apache.pig.ExecType;
import org.apache.pig.FuncSpec;
import org.apache.pig.PigServer;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POFilter;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POForEach;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLoad;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POUnion;
import org.apache.pig.builtin.PigStorage;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DefaultBagFactory;
import org.apache.pig.data.DefaultTuple;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.io.FileLocalizer;
import org.apache.pig.impl.io.FileSpec;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.test.MiniCluster;
import org.apache.pig.test.Util;
import org.apache.pig.test.utils.GenPhyOp;
import org.apache.pig.test.utils.TestHelper;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestUnion
extends TestCase {
    POUnion sp;
    DataBag expBag;
    MiniCluster cluster = MiniCluster.buildCluster();
    PigContext pc = new PigContext();

    @Before
    public void setUp() throws Exception {
        this.pc.connect();
        GenPhyOp.setPc(this.pc);
        POLoad ld1 = GenPhyOp.topLoadOp();
        String curDir = System.getProperty("user.dir");
        String inpDir = curDir + File.separatorChar + "test/org/apache/pig/test/data/InputFiles/";
        FileSpec fSpec = new FileSpec("file:" + inpDir + "passwd", new FuncSpec(PigStorage.class.getName(), new String[]{":"}));
        ld1.setLFile(fSpec);
        POLoad ld2 = GenPhyOp.topLoadOp();
        ld2.setLFile(fSpec);
        POFilter fl1 = GenPhyOp.topFilterOpWithProj(1, 50, (byte)3);
        POFilter fl2 = GenPhyOp.topFilterOpWithProj(1, 50, (byte)2);
        int[] flds = new int[]{0, 2};
        DefaultTuple sample = new DefaultTuple();
        sample.append((Object)new String("S"));
        sample.append((Object)new String("x"));
        sample.append((Object)new Integer("10"));
        sample.append((Object)new Integer("20"));
        sample.append((Object)new String("S"));
        sample.append((Object)new String("x"));
        sample.append((Object)new String("S"));
        sample.append((Object)new String("x"));
        POForEach fe1 = GenPhyOp.topForEachOPWithPlan(flds, (Tuple)sample);
        POForEach fe2 = GenPhyOp.topForEachOPWithPlan(flds, (Tuple)sample);
        this.sp = GenPhyOp.topUnionOp();
        PhysicalPlan plan = new PhysicalPlan();
        plan.add((Operator)ld1);
        plan.add((Operator)ld2);
        plan.add((Operator)fl1);
        plan.add((Operator)fl2);
        plan.add((Operator)fe1);
        plan.add((Operator)fe2);
        plan.add((Operator)this.sp);
        plan.connect((PhysicalOperator)ld1, (PhysicalOperator)fe1);
        plan.connect((PhysicalOperator)fe1, (PhysicalOperator)fl1);
        plan.connect((PhysicalOperator)ld2, (PhysicalOperator)fe2);
        plan.connect((PhysicalOperator)fe2, (PhysicalOperator)fl2);
        plan.connect((PhysicalOperator)fl1, (PhysicalOperator)this.sp);
        plan.connect((PhysicalOperator)fl2, (PhysicalOperator)this.sp);
        POLoad ld3 = GenPhyOp.topLoadOp();
        ld3.setLFile(fSpec);
        DataBag fullBag = DefaultBagFactory.getInstance().newDefaultBag();
        Tuple t = null;
        Result res = ld3.getNext(t);
        while (res.returnStatus != 3) {
            fullBag.add((Tuple)res.result);
            res = ld3.getNext(t);
        }
        int[] fields = new int[]{0, 2};
        this.expBag = TestHelper.projectBag(fullBag, fields);
    }

    @After
    public void tearDown() throws Exception {
    }

    private Tuple castToDBA(Tuple in) throws ExecException {
        DefaultTuple res = new DefaultTuple();
        for (int i = 0; i < in.size(); ++i) {
            DataByteArray dba = new DataByteArray(in.get(i).toString());
            res.append((Object)dba);
        }
        return res;
    }

    @Test
    public void testGetNextTuple() throws ExecException, IOException {
        Tuple t = null;
        DataBag outBag = DefaultBagFactory.getInstance().newDefaultBag();
        Result res = this.sp.getNext(t);
        while (res.returnStatus != 3) {
            outBag.add(this.castToDBA((Tuple)res.result));
            res = this.sp.getNext(t);
        }
        TestUnion.assertEquals((boolean)true, (boolean)TestHelper.compareBags(this.expBag, outBag));
    }

    @Test
    public void testGetNextNullInput() throws Exception {
        Util.createInputFile(this.cluster, "a.txt", new String[]{"1\t2\t3", "4\t5\t6"});
        Util.createInputFile(this.cluster, "b.txt", new String[]{"7\t8\t9", "1\t200\t300"});
        Util.createInputFile(this.cluster, "c.txt", new String[]{"1\t20\t30"});
        FileLocalizer.deleteTempFiles();
        PigServer pig = new PigServer(ExecType.MAPREDUCE, this.cluster.getProperties());
        pig.registerQuery("a = load 'a.txt' ;");
        pig.registerQuery("b = load 'b.txt';");
        pig.registerQuery("c = union a, b;");
        pig.registerQuery("d = load 'c.txt' ;");
        pig.registerQuery("e = cogroup c by $0 inner, d by $0 inner;");
        pig.explain("e", System.err);
        DefaultTuple expectedResult = new DefaultTuple();
        expectedResult.append((Object)new DataByteArray("1"));
        DefaultTuple[] secondFieldContents = new DefaultTuple[]{Util.createTuple(Util.toDataByteArrays(new String[]{"1", "2", "3"})), Util.createTuple(Util.toDataByteArrays(new String[]{"1", "200", "300"}))};
        DataBag secondField = Util.createBag((Tuple[])secondFieldContents);
        expectedResult.append((Object)secondField);
        DataBag thirdField = Util.createBag(new Tuple[]{Util.createTuple(Util.toDataByteArrays(new String[]{"1", "20", "30"}))});
        expectedResult.append((Object)thirdField);
        Iterator it = pig.openIterator("e");
        TestUnion.assertEquals((Object)expectedResult, it.next());
        TestUnion.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testSchemaMergeWithBag() throws Exception {
        Util.createInputFile(this.cluster, "input1.txt", new String[]{"dummy"});
        Util.createInputFile(this.cluster, "input2.txt", new String[]{"dummy"});
        PigServer pig = new PigServer(ExecType.MAPREDUCE, this.cluster.getProperties());
        Util.registerMultiLineQuery(pig, "a = load 'input1.txt';b = load 'input2.txt';c = foreach a generate 1, {(1, 'str1')};d = foreach b generate 2, {(2, 'str2')};e = union c,d;");
        Iterator it = pig.openIterator("e");
        Object[] expected = new Object[]{Util.getPigConstant("(1, {(1, 'str1')})"), Util.getPigConstant("(2, {(2, 'str2')})")};
        Object[] results = new Object[2];
        int i = 0;
        while (it.hasNext()) {
            Tuple t;
            if (i == 2) {
                TestUnion.fail((String)"Got more tuples than expected!");
            }
            if ((t = (Tuple)it.next()).get(0).equals(1)) {
                results[0] = t;
            } else {
                results[1] = t;
            }
            ++i;
        }
        for (int j = 0; j < expected.length; ++j) {
            TestUnion.assertTrue((boolean)expected[j].equals(results[j]));
        }
    }
}

