/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.util.ArrayList;
import java.util.List;
import org.apache.pig.data.DataType;
import org.apache.pig.impl.logicalLayer.BinaryExpressionOperator;
import org.apache.pig.impl.logicalLayer.ExpressionOperator;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.LOAdd;
import org.apache.pig.impl.logicalLayer.LOAnd;
import org.apache.pig.impl.logicalLayer.LOBinCond;
import org.apache.pig.impl.logicalLayer.LOCast;
import org.apache.pig.impl.logicalLayer.LOCogroup;
import org.apache.pig.impl.logicalLayer.LOConst;
import org.apache.pig.impl.logicalLayer.LOCross;
import org.apache.pig.impl.logicalLayer.LODistinct;
import org.apache.pig.impl.logicalLayer.LODivide;
import org.apache.pig.impl.logicalLayer.LOEqual;
import org.apache.pig.impl.logicalLayer.LOFilter;
import org.apache.pig.impl.logicalLayer.LOForEach;
import org.apache.pig.impl.logicalLayer.LOGreaterThan;
import org.apache.pig.impl.logicalLayer.LOGreaterThanEqual;
import org.apache.pig.impl.logicalLayer.LOIsNull;
import org.apache.pig.impl.logicalLayer.LOLesserThan;
import org.apache.pig.impl.logicalLayer.LOLesserThanEqual;
import org.apache.pig.impl.logicalLayer.LOLoad;
import org.apache.pig.impl.logicalLayer.LOMapLookup;
import org.apache.pig.impl.logicalLayer.LOMod;
import org.apache.pig.impl.logicalLayer.LOMultiply;
import org.apache.pig.impl.logicalLayer.LONegative;
import org.apache.pig.impl.logicalLayer.LONot;
import org.apache.pig.impl.logicalLayer.LONotEqual;
import org.apache.pig.impl.logicalLayer.LOOr;
import org.apache.pig.impl.logicalLayer.LOProject;
import org.apache.pig.impl.logicalLayer.LORegexp;
import org.apache.pig.impl.logicalLayer.LOSort;
import org.apache.pig.impl.logicalLayer.LOSplit;
import org.apache.pig.impl.logicalLayer.LOStore;
import org.apache.pig.impl.logicalLayer.LOSubtract;
import org.apache.pig.impl.logicalLayer.LOUnion;
import org.apache.pig.impl.logicalLayer.LOUserFunc;
import org.apache.pig.impl.logicalLayer.LOVisitor;
import org.apache.pig.impl.logicalLayer.LogicalOperator;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.logicalLayer.UnaryExpressionOperator;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.plan.DependencyOrderWalker;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.impl.plan.OperatorPlan;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;

public class TypeGraphPrinter
extends LOVisitor {
    private StringBuilder sb = new StringBuilder();
    private int currentTabCount = 0;

    public TypeGraphPrinter(LogicalPlan plan) {
        super(plan, (PlanWalker)new DependencyOrderWalker((OperatorPlan)plan));
    }

    private void printTabs() {
        for (int i = 0; i < this.currentTabCount; ++i) {
            this.sb.append("\t");
        }
    }

    protected void visit(LogicalOperator op) {
        this.appendOp(op);
    }

    protected void visit(ExpressionOperator op) {
        this.appendOp((LogicalOperator)op);
    }

    protected void visit(BinaryExpressionOperator op) {
        this.appendOp((LogicalOperator)op);
    }

    protected void visit(UnaryExpressionOperator op) {
        this.appendOp((LogicalOperator)op);
    }

    public void visit(LOGreaterThan op) throws VisitorException {
        this.appendOp((LogicalOperator)op);
    }

    public void visit(LOLesserThan op) throws VisitorException {
        this.appendOp((LogicalOperator)op);
    }

    public void visit(LOGreaterThanEqual op) throws VisitorException {
        this.appendOp((LogicalOperator)op);
    }

    public void visit(LOLesserThanEqual op) throws VisitorException {
        this.appendOp((LogicalOperator)op);
    }

    public void visit(LOEqual op) throws VisitorException {
        this.appendOp((LogicalOperator)op);
    }

    public void visit(LONotEqual op) throws VisitorException {
        this.appendOp((LogicalOperator)op);
    }

    public void visit(LOAdd op) throws VisitorException {
        this.appendOp((LogicalOperator)op);
    }

    public void visit(LOSubtract op) throws VisitorException {
        this.appendOp((LogicalOperator)op);
    }

    public void visit(LOMultiply op) throws VisitorException {
        this.appendOp((LogicalOperator)op);
    }

    public void visit(LODivide op) throws VisitorException {
        this.appendOp((LogicalOperator)op);
    }

    public void visit(LOMod op) throws VisitorException {
        this.appendOp((LogicalOperator)op);
    }

    public void visit(LONegative op) throws VisitorException {
        this.appendOp((LogicalOperator)op);
    }

    public void visit(LOMapLookup op) throws VisitorException {
        this.appendOp((LogicalOperator)op);
    }

    public void visit(LOAnd op) throws VisitorException {
        this.appendOp((LogicalOperator)op);
    }

    public void visit(LOOr op) throws VisitorException {
        this.appendOp((LogicalOperator)op);
    }

    public void visit(LONot op) throws VisitorException {
        this.appendOp((LogicalOperator)op);
    }

    public void visit(LOIsNull op) throws VisitorException {
        this.appendOp((LogicalOperator)op);
    }

    protected void visit(LOCogroup op) throws VisitorException {
        this.appendOp((LogicalOperator)op);
        List inputs = op.getInputs();
        if (inputs != null) {
            for (LogicalOperator input : inputs) {
                ArrayList plans = new ArrayList(op.getGroupByPlans().get((Object)input));
                if (plans == null) continue;
                for (LogicalPlan plan : plans) {
                    ++this.currentTabCount;
                    this.printTabs();
                    this.sb.append("<COGroup Inner Plan>\n");
                    this.pushWalker(this.mCurrentWalker.spawnChildWalker((OperatorPlan)plan));
                    this.visit();
                    this.popWalker();
                    --this.currentTabCount;
                }
            }
        }
    }

    protected void visit(LOForEach op) throws VisitorException {
        this.appendOp((LogicalOperator)op);
        ArrayList plans = op.getForEachPlans();
        if (plans != null) {
            for (LogicalPlan plan : plans) {
                ++this.currentTabCount;
                this.printTabs();
                this.sb.append("<ForEach Inner Plan>\n");
                this.pushWalker(this.mCurrentWalker.spawnChildWalker((OperatorPlan)plan));
                this.visit();
                this.popWalker();
                --this.currentTabCount;
            }
        }
    }

    protected void visit(LOSort op) {
        this.appendOp((LogicalOperator)op);
    }

    protected void visit(LOFilter op) throws VisitorException {
        this.appendOp((LogicalOperator)op);
        if (op.getComparisonPlan() != null) {
            ++this.currentTabCount;
            this.printTabs();
            this.sb.append("<Filter Inner Plan>\n");
            this.pushWalker(this.mCurrentWalker.spawnChildWalker((OperatorPlan)op.getComparisonPlan()));
            this.visit();
            this.popWalker();
            --this.currentTabCount;
        }
    }

    protected void visit(LOSplit op) {
        this.appendOp((LogicalOperator)op);
    }

    protected void visit(LOUserFunc op) {
        this.appendOp((LogicalOperator)op);
    }

    protected void visit(LOBinCond op) {
        this.appendOp((LogicalOperator)op);
    }

    protected void visit(LOCross op) {
        this.appendOp((LogicalOperator)op);
    }

    protected void visit(LOUnion op) {
        this.appendOp((LogicalOperator)op);
    }

    protected void visit(LOCast op) {
        this.appendOp((LogicalOperator)op);
    }

    protected void visit(LOLoad op) {
        this.appendOp((LogicalOperator)op);
    }

    protected void visit(LOStore op) {
        this.appendOp((LogicalOperator)op);
    }

    protected void visit(LOConst op) {
        this.appendOp((LogicalOperator)op);
    }

    protected void visit(LORegexp op) {
        this.appendOp((LogicalOperator)op);
    }

    protected void visit(LOProject op) {
        this.appendOp((LogicalOperator)op);
    }

    protected void visit(LODistinct op) {
        this.appendOp((LogicalOperator)op);
    }

    private void appendOp(LogicalOperator op) {
        this.printTabs();
        this.sb.append("(");
        this.sb.append(op.getOperatorKey().getId());
        this.sb.append(":");
        this.sb.append(op.getClass().getSimpleName());
        this.sb.append("=");
        Schema schema = null;
        if (!DataType.isSchemaType((byte)op.getType())) {
            this.sb.append(DataType.findTypeName((byte)op.getType()));
        } else {
            try {
                if (op instanceof ExpressionOperator) {
                    ExpressionOperator eOp = (ExpressionOperator)op;
                    Schema.FieldSchema fs = eOp.getFieldSchema();
                    Schema.stringifySchema((StringBuilder)this.sb, (Schema)fs.schema, (byte)110);
                } else {
                    schema = op.getSchema();
                    Schema.stringifySchema((StringBuilder)this.sb, (Schema)schema, (byte)op.getType());
                }
            }
            catch (FrontendException fe) {
                throw new RuntimeException("PROBLEM PRINTING SCHEMA");
            }
        }
        this.sb.append("==>");
        List list = ((LogicalPlan)this.mCurrentWalker.getPlan()).getSuccessors((Operator)op);
        if (list != null) {
            boolean isFirst = true;
            for (LogicalOperator tmp : list) {
                if (!isFirst) {
                    this.sb.append(",");
                } else {
                    isFirst = false;
                }
                this.sb.append(tmp.getOperatorKey().getId());
            }
        } else {
            this.sb.append("TERMINAL");
        }
        this.sb.append(")");
        this.sb.append("\n");
    }

    public String printToString() {
        try {
            this.visit();
        }
        catch (VisitorException vse) {
            throw new AssertionError((Object)"Error while transforming type graph to text");
        }
        return this.sb.toString();
    }
}

