/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.pig.FilterFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.datastorage.ConfigurationUtil;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigMapReduce;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.io.FileLocalizer;

public class FILTERFROMFILE
extends FilterFunc {
    private String FilterFileName = "";
    Map<String, Boolean> lookupTable = null;

    public FILTERFROMFILE() {
    }

    public FILTERFROMFILE(String FilterFileName) {
        this.FilterFileName = FilterFileName;
    }

    private void init() throws IOException {
        String line;
        this.lookupTable = new HashMap<String, Boolean>();
        Properties props = ConfigurationUtil.toProperties((Configuration)PigMapReduce.sJobConf);
        InputStream is = FileLocalizer.openDFSFile((String)this.FilterFileName, (Properties)props);
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        while ((line = reader.readLine()) != null) {
            String FilterField = line.split("\t")[0];
            this.lookupTable.put(FilterField, Boolean.TRUE);
        }
    }

    public Boolean exec(Tuple input) throws IOException {
        String s;
        if (this.lookupTable == null) {
            this.init();
        }
        try {
            s = input.get(0).toString();
        }
        catch (ExecException e) {
            IOException ioe = new IOException("Error getting data");
            ioe.initCause(e);
            throw ioe;
        }
        boolean matched = this.lookupTable.containsKey(s);
        return matched;
    }
}

