/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test.utils;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.apache.pig.ResourceSchema;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DefaultBagFactory;
import org.apache.pig.data.DefaultTuple;
import org.apache.pig.data.DefaultTupleFactory;
import org.apache.pig.data.Tuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenRandomData {
    public static Map<String, Object> genRandMap(Random r, int numEnt) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        if (r == null) {
            ret.put("random", "RANDOM");
            return ret;
        }
        for (int i = 0; i < numEnt; ++i) {
            ret.put(GenRandomData.genRandString(r), new DataByteArray(GenRandomData.genRandString(r).getBytes()));
        }
        return ret;
    }

    public static String genRandString(Random r) {
        if (r == null) {
            return "RANDOM";
        }
        char[] chars = new char[10];
        for (int i = 0; i < 10; ++i) {
            chars[i] = (char)(r.nextInt(26) + 65);
        }
        return new String(chars);
    }

    public static String genRandLargeString(Random r, int size) {
        if (r == null) {
            return "RANDOM";
        }
        if (size <= 10) {
            return GenRandomData.genRandString(r);
        }
        char[] chars = new char[size];
        for (int i = 0; i < size; ++i) {
            chars[i] = (char)(r.nextInt(26) + 65);
        }
        return new String(chars);
    }

    public static DataByteArray genRandDBA(Random r) {
        if (r == null) {
            return new DataByteArray("RANDOM".getBytes());
        }
        byte[] bytes = new byte[10];
        r.nextBytes(bytes);
        return new DataByteArray(bytes);
    }

    public static DataByteArray genRandTextDBA(Random r) {
        if (r == null) {
            return new DataByteArray("RANDOM".getBytes());
        }
        return new DataByteArray(GenRandomData.genRandString(r).getBytes());
    }

    public static ResourceSchema.ResourceFieldSchema getSmallTupleFieldSchema() throws IOException {
        ResourceSchema.ResourceFieldSchema stringfs = new ResourceSchema.ResourceFieldSchema();
        stringfs.setType((byte)55);
        ResourceSchema.ResourceFieldSchema intfs = new ResourceSchema.ResourceFieldSchema();
        intfs.setType((byte)10);
        ResourceSchema tupleSchema = new ResourceSchema();
        tupleSchema.setFields(new ResourceSchema.ResourceFieldSchema[]{stringfs, intfs});
        ResourceSchema.ResourceFieldSchema tuplefs = new ResourceSchema.ResourceFieldSchema();
        tuplefs.setSchema(tupleSchema);
        tuplefs.setType((byte)110);
        return tuplefs;
    }

    public static Tuple genRandSmallTuple(Random r, int limit) {
        if (r == null) {
            DefaultTuple t = new DefaultTuple();
            t.append((Object)"RANDOM");
            return t;
        }
        DefaultTuple t = new DefaultTuple();
        t.append((Object)GenRandomData.genRandString(r));
        t.append((Object)r.nextInt(limit));
        return t;
    }

    public static Tuple genRandSmallTuple(String s, Integer value) {
        DefaultTuple t = new DefaultTuple();
        t.append((Object)s);
        t.append((Object)value);
        return t;
    }

    public static DataBag genRandSmallTupDataBagWithNulls(Random r, int num, int limit) {
        if (r == null) {
            DataBag db = DefaultBagFactory.getInstance().newDefaultBag();
            DefaultTuple t = new DefaultTuple();
            t.append((Object)"RANDOM");
            db.add((Tuple)t);
            return db;
        }
        DataBag db = DefaultBagFactory.getInstance().newDefaultBag();
        for (int i = 0; i < num; ++i) {
            if (i == 0) {
                db.add(GenRandomData.genRandSmallTuple(r, limit));
                continue;
            }
            int rand = r.nextInt(num);
            if ((double)rand <= 0.2 * (double)num) {
                db.add(GenRandomData.genRandSmallTuple((String)null, (Integer)rand));
                continue;
            }
            if ((double)rand > 0.2 * (double)num && (double)rand <= 0.4 * (double)num) {
                db.add(GenRandomData.genRandSmallTuple(GenRandomData.genRandString(r), null));
                continue;
            }
            if ((double)rand > 0.4 * (double)num && (double)rand <= 0.6 * (double)num) {
                db.add(GenRandomData.genRandSmallTuple(null, null));
                continue;
            }
            db.add(GenRandomData.genRandSmallTuple(r, limit));
        }
        return db;
    }

    public static ResourceSchema.ResourceFieldSchema getSmallTupDataBagFieldSchema() throws IOException {
        ResourceSchema.ResourceFieldSchema tuplefs = GenRandomData.getSmallTupleFieldSchema();
        ResourceSchema bagSchema = new ResourceSchema();
        bagSchema.setFields(new ResourceSchema.ResourceFieldSchema[]{tuplefs});
        ResourceSchema.ResourceFieldSchema bagfs = new ResourceSchema.ResourceFieldSchema();
        bagfs.setSchema(bagSchema);
        bagfs.setType((byte)120);
        return bagfs;
    }

    public static DataBag genRandSmallTupDataBag(Random r, int num, int limit) {
        if (r == null) {
            DataBag db = DefaultBagFactory.getInstance().newDefaultBag();
            DefaultTuple t = new DefaultTuple();
            t.append((Object)"RANDOM");
            db.add((Tuple)t);
            return db;
        }
        DataBag db = DefaultBagFactory.getInstance().newDefaultBag();
        for (int i = 0; i < num; ++i) {
            db.add(GenRandomData.genRandSmallTuple(r, limit));
        }
        return db;
    }

    public static Tuple genRandSmallBagTuple(Random r, int num, int limit) {
        if (r == null) {
            DefaultTuple t = new DefaultTuple();
            t.append((Object)"RANDOM");
            return t;
        }
        DefaultTuple t = new DefaultTuple();
        t.append((Object)GenRandomData.genRandSmallTupDataBag(r, num, limit));
        t.append((Object)r.nextBoolean());
        t.append((Object)GenRandomData.genRandDBA(r));
        t.append((Object)GenRandomData.genRandString(r));
        t.append((Object)r.nextDouble());
        t.append((Object)Float.valueOf(r.nextFloat()));
        t.append((Object)r.nextInt());
        t.append((Object)r.nextLong());
        t.append(GenRandomData.genRandMap(r, num));
        t.append((Object)GenRandomData.genRandSmallTuple(r, 100));
        return t;
    }

    public static ResourceSchema.ResourceFieldSchema getSmallBagTextTupleFieldSchema() throws IOException {
        ResourceSchema.ResourceFieldSchema stringfs = new ResourceSchema.ResourceFieldSchema();
        stringfs.setType((byte)55);
        ResourceSchema.ResourceFieldSchema intfs = new ResourceSchema.ResourceFieldSchema();
        intfs.setType((byte)10);
        ResourceSchema.ResourceFieldSchema bagfs = GenRandomData.getSmallTupDataBagFieldSchema();
        ResourceSchema.ResourceFieldSchema floatfs = new ResourceSchema.ResourceFieldSchema();
        floatfs.setType((byte)20);
        ResourceSchema.ResourceFieldSchema doublefs = new ResourceSchema.ResourceFieldSchema();
        doublefs.setType((byte)25);
        ResourceSchema.ResourceFieldSchema longfs = new ResourceSchema.ResourceFieldSchema();
        longfs.setType((byte)15);
        ResourceSchema.ResourceFieldSchema mapfs = new ResourceSchema.ResourceFieldSchema();
        mapfs.setType((byte)100);
        ResourceSchema.ResourceFieldSchema tuplefs = GenRandomData.getSmallTupleFieldSchema();
        ResourceSchema outSchema = new ResourceSchema();
        outSchema.setFields(new ResourceSchema.ResourceFieldSchema[]{bagfs, stringfs, stringfs, doublefs, floatfs, intfs, longfs, mapfs, tuplefs});
        ResourceSchema.ResourceFieldSchema outfs = new ResourceSchema.ResourceFieldSchema();
        outfs.setSchema(outSchema);
        outfs.setType((byte)110);
        return outfs;
    }

    public static Tuple genRandSmallBagTextTuple(Random r, int num, int limit) {
        if (r == null) {
            DefaultTuple t = new DefaultTuple();
            t.append((Object)"RANDOM");
            return t;
        }
        DefaultTuple t = new DefaultTuple();
        t.append((Object)GenRandomData.genRandSmallTupDataBag(r, num, limit));
        t.append((Object)new Boolean(r.nextBoolean()).toString());
        t.append((Object)GenRandomData.genRandString(r));
        t.append((Object)r.nextDouble());
        t.append((Object)Float.valueOf(r.nextFloat()));
        t.append((Object)r.nextInt());
        t.append((Object)r.nextLong());
        t.append(GenRandomData.genRandMap(r, num));
        t.append((Object)GenRandomData.genRandSmallTuple(r, 100));
        return t;
    }

    public static DataBag genRandFullTupDataBag(Random r, int num, int limit) {
        if (r == null) {
            DataBag db = DefaultBagFactory.getInstance().newDefaultBag();
            DefaultTuple t = new DefaultTuple();
            t.append((Object)"RANDOM");
            db.add((Tuple)t);
            return db;
        }
        DataBag db = DefaultBagFactory.getInstance().newDefaultBag();
        for (int i = 0; i < num; ++i) {
            db.add(GenRandomData.genRandSmallBagTuple(r, num, limit));
        }
        return db;
    }

    public static ResourceSchema.ResourceFieldSchema getFullTupTextDataBagFieldSchema() throws IOException {
        ResourceSchema.ResourceFieldSchema tuplefs = GenRandomData.getSmallBagTextTupleFieldSchema();
        ResourceSchema outBagSchema = new ResourceSchema();
        outBagSchema.setFields(new ResourceSchema.ResourceFieldSchema[]{tuplefs});
        ResourceSchema.ResourceFieldSchema outBagfs = new ResourceSchema.ResourceFieldSchema();
        outBagfs.setSchema(outBagSchema);
        outBagfs.setType((byte)120);
        return outBagfs;
    }

    public static DataBag genRandFullTupTextDataBag(Random r, int num, int limit) {
        if (r == null) {
            DataBag db = DefaultBagFactory.getInstance().newDefaultBag();
            DefaultTuple t = new DefaultTuple();
            t.append((Object)"RANDOM");
            db.add((Tuple)t);
            return db;
        }
        DataBag db = DefaultBagFactory.getInstance().newDefaultBag();
        for (int i = 0; i < num; ++i) {
            db.add(GenRandomData.genRandSmallBagTextTuple(r, num, limit));
        }
        return db;
    }

    public static Tuple genRandSmallBagTupleWithNulls(Random r, int num, int limit) {
        if (r == null) {
            DefaultTuple t = new DefaultTuple();
            t.append((Object)"RANDOM");
            return t;
        }
        DefaultTuple t = new DefaultTuple();
        t.append((Object)GenRandomData.genRandSmallTupDataBag(r, num, limit));
        t.append((Object)r.nextBoolean());
        t.append((Object)GenRandomData.genRandDBA(r));
        t.append((Object)GenRandomData.genRandString(r));
        t.append((Object)r.nextDouble());
        t.append((Object)Float.valueOf(r.nextFloat()));
        t.append((Object)r.nextInt());
        t.append((Object)r.nextLong());
        t.append(GenRandomData.genRandMap(r, num));
        t.append((Object)GenRandomData.genRandSmallTuple(r, 100));
        t.append(null);
        return t;
    }

    public static Tuple genRandSmallBagTextTupleWithNulls(Random r, int num, int limit) {
        if (r == null) {
            DefaultTuple t = new DefaultTuple();
            t.append((Object)"RANDOM");
            return t;
        }
        DefaultTuple t = new DefaultTuple();
        t.append((Object)GenRandomData.genRandSmallTupDataBag(r, num, limit));
        t.append((Object)new Boolean(r.nextBoolean()).toString());
        t.append((Object)GenRandomData.genRandString(r));
        t.append((Object)r.nextDouble());
        t.append((Object)Float.valueOf(r.nextFloat()));
        t.append((Object)r.nextInt());
        t.append((Object)r.nextLong());
        t.append(GenRandomData.genRandMap(r, num));
        t.append((Object)GenRandomData.genRandSmallTuple(r, 100));
        t.append(null);
        return t;
    }

    public static DataBag genFloatDataBag(Random r, int column, int row) {
        DataBag db = DefaultBagFactory.getInstance().newDefaultBag();
        for (int i = 0; i < row; ++i) {
            Tuple t = DefaultTupleFactory.getInstance().newTuple();
            for (int j = 0; j < column; ++j) {
                t.append((Object)Float.valueOf(r.nextFloat() * 1000.0f));
            }
            db.add(t);
        }
        return db;
    }

    public static ResourceSchema.ResourceFieldSchema getFloatDataBagFieldSchema(int column) throws IOException {
        ResourceSchema.ResourceFieldSchema intfs = new ResourceSchema.ResourceFieldSchema();
        intfs.setType((byte)10);
        ResourceSchema tupleSchema = new ResourceSchema();
        ResourceSchema.ResourceFieldSchema[] fss = new ResourceSchema.ResourceFieldSchema[column];
        for (int i = 0; i < column; ++i) {
            fss[i] = intfs;
        }
        tupleSchema.setFields(fss);
        ResourceSchema.ResourceFieldSchema tuplefs = new ResourceSchema.ResourceFieldSchema();
        tuplefs.setSchema(tupleSchema);
        tuplefs.setType((byte)110);
        ResourceSchema bagSchema = new ResourceSchema();
        bagSchema.setFields(new ResourceSchema.ResourceFieldSchema[]{tuplefs});
        ResourceSchema.ResourceFieldSchema bagfs = new ResourceSchema.ResourceFieldSchema();
        bagfs.setSchema(bagSchema);
        bagfs.setType((byte)120);
        return bagfs;
    }

    public static Tuple genMixedTupleToConvert(Random r) {
        Tuple t = DefaultTupleFactory.getInstance().newTuple();
        t.append((Object)r.nextInt());
        t.append((Object)r.nextInt());
        long l = 0L;
        while (l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE) {
            l = r.nextLong();
        }
        t.append((Object)l);
        t.append((Object)Float.valueOf(r.nextFloat() * 1000.0f));
        t.append((Object)(r.nextDouble() * 10000.0));
        t.append((Object)GenRandomData.genRandString(r));
        t.append((Object)("K" + GenRandomData.genRandString(r)));
        t.append((Object)("K" + GenRandomData.genRandString(r)));
        t.append((Object)("K" + GenRandomData.genRandString(r)));
        if ((double)r.nextFloat() > 0.5) {
            t.append((Object)"true");
        } else {
            t.append((Object)"false");
        }
        return t;
    }

    public static ResourceSchema.ResourceFieldSchema getMixedTupleToConvertFieldSchema() throws IOException {
        ResourceSchema.ResourceFieldSchema stringfs = new ResourceSchema.ResourceFieldSchema();
        stringfs.setType((byte)55);
        ResourceSchema.ResourceFieldSchema intfs = new ResourceSchema.ResourceFieldSchema();
        intfs.setType((byte)10);
        ResourceSchema.ResourceFieldSchema longfs = new ResourceSchema.ResourceFieldSchema();
        longfs.setType((byte)15);
        ResourceSchema.ResourceFieldSchema floatfs = new ResourceSchema.ResourceFieldSchema();
        floatfs.setType((byte)20);
        ResourceSchema.ResourceFieldSchema doublefs = new ResourceSchema.ResourceFieldSchema();
        doublefs.setType((byte)25);
        ResourceSchema.ResourceFieldSchema booleanfs = new ResourceSchema.ResourceFieldSchema();
        booleanfs.setType((byte)5);
        ResourceSchema tupleSchema = new ResourceSchema();
        tupleSchema.setFields(new ResourceSchema.ResourceFieldSchema[]{stringfs, longfs, intfs, doublefs, floatfs, stringfs, intfs, doublefs, floatfs, booleanfs});
        ResourceSchema.ResourceFieldSchema tuplefs = new ResourceSchema.ResourceFieldSchema();
        tuplefs.setSchema(tupleSchema);
        tuplefs.setType((byte)110);
        return tuplefs;
    }
}

