/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test.utils;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import junit.framework.Assert;
import org.apache.pig.ExecType;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.logicalLayer.LOPrinter;
import org.apache.pig.impl.logicalLayer.LogicalOperator;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.logicalLayer.LogicalPlanBuilder;
import org.apache.pig.impl.logicalLayer.PlanSetter;
import org.apache.pig.impl.logicalLayer.ProjectionMapCalculator;
import org.apache.pig.impl.logicalLayer.ProjectionMapRemover;
import org.apache.pig.impl.logicalLayer.optimizer.LogicalOptimizer;
import org.apache.pig.impl.logicalLayer.optimizer.SchemaCalculator;
import org.apache.pig.impl.logicalLayer.optimizer.SchemaRemover;
import org.apache.pig.impl.logicalLayer.parser.ParseException;
import org.apache.pig.impl.logicalLayer.validators.TypeCheckingValidator;
import org.apache.pig.impl.plan.CompilationMessageCollector;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.PlanValidationException;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.plan.optimizer.OptimizerException;
import org.apache.pig.test.utils.TypeCheckingTestUtil;
import org.apache.pig.test.utils.dotGraph.DotGraph;
import org.apache.pig.test.utils.dotGraph.DotGraphReader;
import org.apache.pig.test.utils.dotGraph.LogicalPlanLoader;
import org.apache.pig.test.utils.planComparer.LogicalPlanComparer;

public class LogicalPlanTester {
    static final String SCOPE = "scope";
    private Map<LogicalOperator, LogicalPlan> aliases = null;
    private Map<OperatorKey, LogicalOperator> logicalOpTable = null;
    private Map<String, LogicalOperator> aliasOp = null;
    private Map<String, String> fileNameMap = null;
    private PigContext pigContext;

    public LogicalPlanTester() {
        this(new PigContext(ExecType.MAPREDUCE, new Properties()));
    }

    public LogicalPlanTester(PigContext pc) {
        this.pigContext = pc;
        this.reset();
    }

    public void reset() {
        this.aliases = new HashMap<LogicalOperator, LogicalPlan>();
        this.logicalOpTable = new HashMap<OperatorKey, LogicalOperator>();
        this.aliasOp = new HashMap<String, LogicalOperator>();
        this.fileNameMap = new HashMap<String, String>();
        NodeIdGenerator.reset((String)SCOPE);
    }

    public LogicalPlan buildPlan(String query) {
        return this.buildPlan(query, LogicalPlanBuilder.class.getClassLoader());
    }

    public LogicalPlan buildPlanThrowExceptionOnError(String query) throws Exception {
        return this.buildPlanThrowExceptionOnError(query, LogicalPlanBuilder.class.getClassLoader());
    }

    public void typeCheckPlan(LogicalPlan plan) throws PlanValidationException {
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        System.out.println("Actual plan after type check:");
        TypeCheckingTestUtil.printTypeGraph(plan);
    }

    public void optimizePlan(LogicalPlan plan) throws OptimizerException {
        LogicalOptimizer optimizer = new LogicalOptimizer(plan);
        optimizer.optimize();
        System.out.println("Actual plan after after optimization:");
        TypeCheckingTestUtil.printTypeGraph(plan);
    }

    public void typeCheckAgainstDotFile(LogicalPlan plan, String file) throws PlanValidationException, OptimizerException {
        this.typeCheckAgainstDotFile(plan, file, false);
    }

    public void typeCheckAgainstDotFile(LogicalPlan plan, String file, boolean optimize) throws PlanValidationException, OptimizerException {
        this.typeCheckPlan(plan);
        if (optimize) {
            this.optimizePlan(plan);
        }
        LogicalPlanLoader planLoader = new LogicalPlanLoader();
        LogicalPlan expectedPlan = planLoader.loadFromFile(file, LogicalPlan.class);
        System.out.println("Expected plan:");
        TypeCheckingTestUtil.printTypeGraph(expectedPlan);
        LogicalPlanComparer comparer = new LogicalPlanComparer();
        StringBuilder errMsg = new StringBuilder();
        boolean result = comparer.structurallyEquals(plan, expectedPlan, errMsg);
        System.out.println(errMsg.toString());
        Assert.assertTrue((String)"The expected plan is different", (boolean)result);
        System.out.println("Checking DONE!");
    }

    public void typeCheckUsingDotFile(String file) throws PlanValidationException, OptimizerException {
        this.typeCheckUsingDotFile(file, false);
    }

    public void typeCheckUsingDotFile(String file, boolean optimize) throws PlanValidationException, OptimizerException {
        DotGraphReader reader = new DotGraphReader();
        DotGraph graph = reader.loadFromFile(file);
        if (!graph.attributes.containsKey("pigScript")) {
            throw new AssertionError((Object)"pigScript attribute doesn't exist in Dot file");
        }
        String script = graph.attributes.get("pigScript");
        String[] queries = script.split(";");
        LogicalPlan plan = null;
        for (String query : queries) {
            if (query.trim().equals("")) continue;
            plan = this.buildPlan(query + ";");
        }
        this.typeCheckAgainstDotFile(plan, file, optimize);
    }

    public void printPlan(LogicalPlan lp, String title) {
        try {
            System.err.println(title);
            LOPrinter lv = new LOPrinter(System.err, lp);
            lv.visit();
            System.err.println();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private LogicalPlan buildPlan(String query, ClassLoader cldr) {
        LogicalPlanBuilder.classloader = LogicalPlanTester.class.getClassLoader();
        try {
            this.pigContext.connect();
        }
        catch (ExecException e1) {
            Assert.fail((String)(((Object)((Object)e1)).getClass().getName() + ": " + e1.getMessage() + " -- " + query));
        }
        LogicalPlanBuilder builder = new LogicalPlanBuilder(this.pigContext);
        try {
            return this.parse(query, builder);
        }
        catch (IOException e) {
            Assert.fail((String)("IOException: " + e.getMessage()));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)(e.getClass().getName() + ": " + e.getMessage() + " -- " + query));
        }
        return null;
    }

    private LogicalPlan parse(String query, LogicalPlanBuilder builder) throws IOException, ParseException {
        LogicalPlan lp = builder.parse(SCOPE, query, this.aliases, this.logicalOpTable, this.aliasOp, this.fileNameMap);
        List roots = lp.getRoots();
        if (roots.size() > 0) {
            if (this.logicalOpTable.get(roots.get(0)) instanceof LogicalOperator) {
                System.out.println(query);
                System.out.println(this.logicalOpTable.get(roots.get(0)));
            }
            if (((LogicalOperator)roots.get(0)).getAlias() != null) {
                this.aliases.put((LogicalOperator)roots.get(0), lp);
            }
        }
        Assert.assertTrue((lp != null ? 1 : 0) != 0);
        return lp;
    }

    private LogicalPlan buildPlanThrowExceptionOnError(String query, ClassLoader cldr) throws IOException, ParseException {
        LogicalPlanBuilder.classloader = LogicalPlanTester.class.getClassLoader();
        try {
            this.pigContext.connect();
        }
        catch (ExecException e1) {
            Assert.fail((String)(((Object)((Object)e1)).getClass().getName() + ": " + e1.getMessage() + " -- " + query));
        }
        LogicalPlanBuilder builder = new LogicalPlanBuilder(this.pigContext);
        return this.parse(query, builder);
    }

    public void setPlan(LogicalPlan lp) throws VisitorException {
        PlanSetter ps = new PlanSetter(lp);
        ps.visit();
    }

    public void setProjectionMap(LogicalPlan lp) throws VisitorException {
        ProjectionMapCalculator pmc = new ProjectionMapCalculator(lp);
        pmc.visit();
    }

    public void rebuildProjectionMap(LogicalPlan lp) throws VisitorException {
        ProjectionMapRemover pmr = new ProjectionMapRemover(lp);
        pmr.visit();
        ProjectionMapCalculator pmc = new ProjectionMapCalculator(lp);
        pmc.visit();
    }

    public void rebuildSchema(LogicalPlan lp) throws VisitorException {
        SchemaRemover sr = new SchemaRemover(lp);
        sr.visit();
        SchemaCalculator sc = new SchemaCalculator(lp);
        sc.visit();
    }
}

