/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test.utils.dotGraph;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.apache.pig.test.utils.dotGraph.DotGraph;
import org.apache.pig.test.utils.dotGraph.parser.DOTParser;
import org.apache.pig.test.utils.dotGraph.parser.ParseException;

public class DotGraphReader {
    public DotGraph load(String dotContent) {
        ByteArrayInputStream stream = new ByteArrayInputStream(dotContent.getBytes());
        DOTParser dotParser = new DOTParser(stream);
        DotGraph graph = null;
        try {
            graph = dotParser.Parse();
        }
        catch (ParseException pe) {
            System.out.println(pe.getMessage());
            throw new RuntimeException("Bad Dot file");
        }
        return graph;
    }

    public DotGraph loadFromFile(String file) {
        StringBuilder sb = new StringBuilder();
        BufferedReader br = null;
        try {
            String str;
            br = new BufferedReader(new FileReader(file));
            while ((str = br.readLine()) != null) {
                sb.append(str);
                sb.append("\n");
            }
        }
        catch (FileNotFoundException fnfe) {
            throw new RuntimeException("file:" + file + " not found!");
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error while reading from:" + file);
        }
        return this.load(sb.toString());
    }
}

