/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test.utils.dotGraph;

import java.util.Iterator;
import org.apache.pig.impl.logicalLayer.BinaryExpressionOperator;
import org.apache.pig.impl.logicalLayer.ExpressionOperator;
import org.apache.pig.impl.logicalLayer.LOAdd;
import org.apache.pig.impl.logicalLayer.LOAnd;
import org.apache.pig.impl.logicalLayer.LOBinCond;
import org.apache.pig.impl.logicalLayer.LOCast;
import org.apache.pig.impl.logicalLayer.LOCogroup;
import org.apache.pig.impl.logicalLayer.LOConst;
import org.apache.pig.impl.logicalLayer.LOCross;
import org.apache.pig.impl.logicalLayer.LODistinct;
import org.apache.pig.impl.logicalLayer.LODivide;
import org.apache.pig.impl.logicalLayer.LOEqual;
import org.apache.pig.impl.logicalLayer.LOFilter;
import org.apache.pig.impl.logicalLayer.LOForEach;
import org.apache.pig.impl.logicalLayer.LOGreaterThan;
import org.apache.pig.impl.logicalLayer.LOGreaterThanEqual;
import org.apache.pig.impl.logicalLayer.LOLesserThan;
import org.apache.pig.impl.logicalLayer.LOLesserThanEqual;
import org.apache.pig.impl.logicalLayer.LOLoad;
import org.apache.pig.impl.logicalLayer.LOMapLookup;
import org.apache.pig.impl.logicalLayer.LOMod;
import org.apache.pig.impl.logicalLayer.LOMultiply;
import org.apache.pig.impl.logicalLayer.LONegative;
import org.apache.pig.impl.logicalLayer.LONot;
import org.apache.pig.impl.logicalLayer.LONotEqual;
import org.apache.pig.impl.logicalLayer.LOOr;
import org.apache.pig.impl.logicalLayer.LOProject;
import org.apache.pig.impl.logicalLayer.LORegexp;
import org.apache.pig.impl.logicalLayer.LOSort;
import org.apache.pig.impl.logicalLayer.LOSplit;
import org.apache.pig.impl.logicalLayer.LOSplitOutput;
import org.apache.pig.impl.logicalLayer.LOStore;
import org.apache.pig.impl.logicalLayer.LOSubtract;
import org.apache.pig.impl.logicalLayer.LOUnion;
import org.apache.pig.impl.logicalLayer.LOUserFunc;
import org.apache.pig.impl.logicalLayer.LOVisitor;
import org.apache.pig.impl.logicalLayer.LogicalOperator;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.logicalLayer.UnaryExpressionOperator;
import org.apache.pig.impl.plan.DependencyOrderWalker;
import org.apache.pig.impl.plan.OperatorPlan;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.MultiMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DotGraphVisitor
extends LOVisitor {
    public DotGraphVisitor(LogicalPlan plan, PlanWalker<LogicalOperator, LogicalPlan> walker) {
        super(plan, walker);
    }

    protected void visit(LogicalOperator lOp) throws VisitorException {
    }

    protected void visit(ExpressionOperator eOp) throws VisitorException {
    }

    protected void visit(BinaryExpressionOperator binOp) throws VisitorException {
        binOp.getLhsOperand().visit((LOVisitor)this);
        binOp.getRhsOperand().visit((LOVisitor)this);
    }

    protected void visit(UnaryExpressionOperator uniOp) throws VisitorException {
        uniOp.getOperand().visit((LOVisitor)this);
    }

    protected void visit(LOCogroup cg) throws VisitorException {
        MultiMap mapGByPlans = cg.getGroupByPlans();
        for (LogicalOperator op : cg.getInputs()) {
            for (LogicalPlan lp : mapGByPlans.get((Object)op)) {
                if (null == lp) continue;
                DependencyOrderWalker w = new DependencyOrderWalker((OperatorPlan)lp);
                this.pushWalker((PlanWalker)w);
                for (LogicalOperator logicalOp : lp.getRoots()) {
                    logicalOp.visit((LOVisitor)this);
                }
                this.popWalker();
            }
        }
    }

    protected void visit(LOForEach g) throws VisitorException {
        for (LogicalPlan lp : g.getForEachPlans()) {
            DependencyOrderWalker w = new DependencyOrderWalker((OperatorPlan)lp);
            this.pushWalker((PlanWalker)w);
            for (LogicalOperator logicalOp : lp.getRoots()) {
                logicalOp.visit((LOVisitor)this);
            }
            this.popWalker();
        }
    }

    protected void visit(LOSort s) throws VisitorException {
        for (LogicalPlan lp : s.getSortColPlans()) {
            DependencyOrderWalker w = new DependencyOrderWalker((OperatorPlan)lp);
            this.pushWalker((PlanWalker)w);
            for (LogicalOperator logicalOp : lp.getRoots()) {
                logicalOp.visit((LOVisitor)this);
            }
            this.popWalker();
        }
    }

    protected void visit(LOFilter filter) throws VisitorException {
        DependencyOrderWalker w = new DependencyOrderWalker((OperatorPlan)filter.getComparisonPlan());
        this.pushWalker((PlanWalker)w);
        for (LogicalOperator logicalOp : filter.getComparisonPlan().getRoots()) {
            logicalOp.visit((LOVisitor)this);
        }
        this.popWalker();
    }

    protected void visit(LOSplit split) throws VisitorException {
        for (LogicalOperator logicalOp : split.getOutputs()) {
            logicalOp.visit((LOVisitor)this);
        }
    }

    protected void visit(LOUserFunc func) throws VisitorException {
        Iterator i = func.getArguments().iterator();
        while (i.hasNext()) {
            ((ExpressionOperator)i.next()).visit((LOVisitor)this);
        }
    }

    protected void visit(LOBinCond binCond) throws VisitorException {
        binCond.getCond().visit((LOVisitor)this);
        binCond.getLhsOp().visit((LOVisitor)this);
        binCond.getRhsOp().visit((LOVisitor)this);
    }

    protected void visit(LOCast cast) throws VisitorException {
        cast.getExpression().visit((LOVisitor)this);
    }

    protected void visit(LORegexp regexp) throws VisitorException {
        regexp.getOperand().visit((LOVisitor)this);
    }

    protected void visit(LOLoad load) throws VisitorException {
    }

    protected void visit(LOStore store) throws VisitorException {
    }

    protected void visit(LOConst store) throws VisitorException {
    }

    protected void visit(LOUnion u) throws VisitorException {
    }

    protected void visit(LOSplitOutput sop) throws VisitorException {
        LogicalPlan lp = sop.getConditionPlan();
        if (null != lp) {
            DependencyOrderWalker w = new DependencyOrderWalker((OperatorPlan)lp);
            this.pushWalker((PlanWalker)w);
            for (LogicalOperator logicalOp : lp.getRoots()) {
                logicalOp.visit((LOVisitor)this);
            }
            this.popWalker();
        }
    }

    protected void visit(LODistinct dt) throws VisitorException {
    }

    protected void visit(LOCross cs) throws VisitorException {
    }

    protected void visit(LOProject project) throws VisitorException {
        if (!project.getSentinel()) {
            project.getExpression().visit((LOVisitor)this);
        }
    }

    public void visit(LOGreaterThan op) throws VisitorException {
    }

    public void visit(LOLesserThan op) throws VisitorException {
    }

    public void visit(LOGreaterThanEqual op) throws VisitorException {
    }

    public void visit(LOLesserThanEqual op) throws VisitorException {
    }

    public void visit(LOEqual op) throws VisitorException {
    }

    public void visit(LONotEqual op) throws VisitorException {
    }

    public void visit(LOAdd op) throws VisitorException {
    }

    public void visit(LOSubtract op) throws VisitorException {
    }

    public void visit(LOMultiply op) throws VisitorException {
    }

    public void visit(LODivide op) throws VisitorException {
    }

    public void visit(LOMod op) throws VisitorException {
    }

    public void visit(LONegative op) throws VisitorException {
    }

    public void visit(LOMapLookup op) throws VisitorException {
    }

    public void visit(LOAnd binOp) throws VisitorException {
    }

    public void visit(LOOr binOp) throws VisitorException {
    }

    public void visit(LONot uniOp) throws VisitorException {
    }
}

