/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test.utils.dotGraph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.OperatorPlan;
import org.apache.pig.test.utils.dotGraph.NodeMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncreasingKeyMatcher
implements NodeMatcher<Operator, OperatorPlan<Operator>> {
    @Override
    public Map<OperatorKey, OperatorKey> match(OperatorPlan plan1, OperatorPlan plan2, StringBuilder messages) {
        List<OperatorKey> keyList1 = this.getSortedKeyList(plan1);
        List<OperatorKey> keyList2 = this.getSortedKeyList(plan2);
        if (keyList1.size() != keyList2.size()) {
            messages.append("Two plans have different size");
            return null;
        }
        HashMap<OperatorKey, OperatorKey> outputMap = new HashMap<OperatorKey, OperatorKey>();
        for (int i = 0; i < keyList1.size(); ++i) {
            outputMap.put(keyList1.get(i), keyList2.get(i));
        }
        return outputMap;
    }

    private List<OperatorKey> getSortedKeyList(OperatorPlan plan) {
        ArrayList<OperatorKey> keyList = new ArrayList<OperatorKey>(plan.getKeys().keySet());
        Collections.sort(keyList);
        return keyList;
    }
}

