/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test.utils.dotGraph;

import java.util.HashMap;
import java.util.Map;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.OperatorPlan;
import org.apache.pig.impl.plan.PlanException;
import org.apache.pig.test.utils.dotGraph.DotEdge;
import org.apache.pig.test.utils.dotGraph.DotGraph;
import org.apache.pig.test.utils.dotGraph.DotGraphReader;
import org.apache.pig.test.utils.dotGraph.DotNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OperatorPlanLoader<E extends Operator, P extends OperatorPlan<E>> {
    public P load(String dotContent, Class<P> clazz) {
        DotGraphReader dotReader = new DotGraphReader();
        DotGraph graph = dotReader.load(dotContent);
        return this.constructPlan(graph, clazz);
    }

    public P loadFromFile(String file, Class<P> clazz) {
        DotGraphReader dotReader = new DotGraphReader();
        DotGraph graph = dotReader.loadFromFile(file);
        return this.constructPlan(graph, clazz);
    }

    public PlanAndGraphEntry loadFromFileWithGraph(String file, Class<P> clazz) {
        DotGraphReader dotReader = new DotGraphReader();
        DotGraph graph = dotReader.loadFromFile(file);
        P plan = this.constructPlan(graph, clazz);
        return new PlanAndGraphEntry(this, plan, graph);
    }

    protected abstract E createOperator(DotNode var1, P var2);

    P constructPlan(DotGraph graph, Class<P> clazz) {
        OperatorPlan plan;
        HashMap<String, E> nameMap = new HashMap<String, E>();
        try {
            plan = (OperatorPlan)clazz.newInstance();
        }
        catch (IllegalAccessException iae) {
            throw new AssertionError((Object)"Cannot instantiate a plan");
        }
        catch (InstantiationException ie) {
            throw new AssertionError((Object)"Cannot instantiate a plan");
        }
        for (DotNode node : graph.nodes) {
            E op = this.createOperator(node, plan);
            nameMap.put(node.name, op);
            plan.add(op);
        }
        for (DotEdge edge : graph.edges) {
            Operator fromOp = (Operator)nameMap.get(edge.fromNode);
            Operator toOp = (Operator)nameMap.get(edge.toNode);
            try {
                plan.connect(fromOp, toOp);
            }
            catch (PlanException pe) {
                throw new RuntimeException("Invalid Dot file");
            }
        }
        return (P)plan;
    }

    protected OperatorKey getKey(Map<String, String> attributes) {
        String key = attributes.get("key");
        if (key != null) {
            return new OperatorKey("scope", Long.parseLong(key));
        }
        long newId = NodeIdGenerator.getGenerator().getNextNodeId("scope");
        return new OperatorKey("scope", newId);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PlanAndGraphEntry {
        public P plan;
        public DotGraph dotGraph;
        final /* synthetic */ OperatorPlanLoader this$0;

        public PlanAndGraphEntry(P plan, DotGraph dotGraph) {
            this.this$0 = var1_1;
            this.plan = plan;
            this.dotGraph = dotGraph;
        }
    }
}

