/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test.utils.planComparer;

import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.LogicalOperator;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.test.utils.planComparer.PlanStructuralComparer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogicalPlanComparer
extends PlanStructuralComparer<LogicalOperator, LogicalPlan> {
    @Override
    public boolean structurallyEquals(LogicalPlan plan1, LogicalPlan plan2, StringBuilder messages) {
        if (!super.structurallyEquals(plan1, plan2, messages)) {
            return false;
        }
        if (this.findMismatchNodeType(plan1, plan2, messages) > 0) {
            return false;
        }
        return !this.findMismatchSchema(plan1, plan2, messages);
    }

    private boolean findMismatchSchema(LogicalPlan plan1, LogicalPlan plan2, StringBuilder messages) {
        for (OperatorKey key : plan1.getKeys().keySet()) {
            LogicalOperator op1 = (LogicalOperator)plan1.getOperator(key);
            LogicalOperator op2 = (LogicalOperator)plan2.getOperator((OperatorKey)this.plan1ToPlan2.get(key));
            Schema schema1 = null;
            Schema schema2 = null;
            try {
                schema1 = op1.getSchema();
                schema2 = op2.getSchema();
            }
            catch (FrontendException fe) {
                throw new RuntimeException("Cannot get schema from logical plan");
            }
            if (Schema.equals((Schema)schema1, (Schema)schema2, (boolean)false, (boolean)false)) continue;
            messages.append("Schema mismatch ");
            messages.append(op1.getClass().getSimpleName());
            this.appendOpKey(op1.getOperatorKey(), messages);
            StringBuilder schemaStr1 = new StringBuilder();
            StringBuilder schemaStr2 = new StringBuilder();
            try {
                Schema.stringifySchema((StringBuilder)schemaStr1, (Schema)schema1, (byte)120);
                Schema.stringifySchema((StringBuilder)schemaStr2, (Schema)schema2, (byte)120);
            }
            catch (FrontendException fee) {
                throw new RuntimeException("Cannot stringify schema");
            }
            messages.append(":");
            messages.append(schemaStr1.toString());
            messages.append(" vs ");
            messages.append(schemaStr2.toString());
            messages.append("\n");
            return true;
        }
        return false;
    }

    private int findMismatchNodeType(LogicalPlan plan1, LogicalPlan plan2, StringBuilder messages) {
        int diffCount = 0;
        for (OperatorKey opKey : plan1.getKeys().keySet()) {
            LogicalOperator op1 = (LogicalOperator)plan1.getOperator(opKey);
            LogicalOperator op2 = (LogicalOperator)plan2.getOperator((OperatorKey)this.plan1ToPlan2.get(opKey));
            if (op1.getClass() == op2.getClass()) continue;
            if (messages != null) {
                messages.append("Mismatch type:");
                this.appendOpKey(opKey, messages);
                messages.append(" ");
                messages.append(op1.getClass().getSimpleName());
                messages.append(" vs ");
                messages.append(op2.getClass().getSimpleName());
                messages.append("\n");
            }
            ++diffCount;
        }
        return diffCount;
    }
}

