/*
 * Decompiled with CFR 0.152.
 */
package com.mdimension.jchronic.repeaters;

import com.mdimension.jchronic.repeaters.RepeaterUnit;
import com.mdimension.jchronic.tags.Pointer;
import com.mdimension.jchronic.utils.Span;
import com.mdimension.jchronic.utils.Time;
import java.util.Calendar;

public class RepeaterMinute
extends RepeaterUnit {
    public static final int MINUTE_SECONDS = 60;
    private Calendar _currentMinuteStart;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Span _nextSpan(Pointer.PointerType pointer) {
        if (this._currentMinuteStart == null) {
            if (pointer == Pointer.PointerType.FUTURE) {
                this._currentMinuteStart = Time.cloneAndAdd(Time.ymdhm(this.getNow()), 12, 1L);
                return new Span(this._currentMinuteStart, 13, 60L);
            } else {
                if (pointer != Pointer.PointerType.PAST) throw new IllegalArgumentException("Unable to handle pointer " + (Object)((Object)pointer) + ".");
                this._currentMinuteStart = Time.cloneAndAdd(Time.ymdhm(this.getNow()), 12, -1L);
            }
            return new Span(this._currentMinuteStart, 13, 60L);
        } else {
            int direction = pointer == Pointer.PointerType.FUTURE ? 1 : -1;
            this._currentMinuteStart.add(12, direction);
        }
        return new Span(this._currentMinuteStart, 13, 60L);
    }

    protected Span _thisSpan(Pointer.PointerType pointer) {
        Calendar minuteEnd;
        Calendar minuteBegin;
        if (pointer == Pointer.PointerType.FUTURE) {
            minuteBegin = this.getNow();
            minuteEnd = Time.ymdhm(this.getNow());
        } else if (pointer == Pointer.PointerType.PAST) {
            minuteBegin = Time.ymdhm(this.getNow());
            minuteEnd = this.getNow();
        } else if (pointer == Pointer.PointerType.NONE) {
            minuteBegin = Time.ymdhm(this.getNow());
            minuteEnd = Time.cloneAndAdd(Time.ymdhm(this.getNow()), 13, 60L);
        } else {
            throw new IllegalArgumentException("Unable to handle pointer " + (Object)((Object)pointer) + ".");
        }
        return new Span(minuteBegin, minuteEnd);
    }

    public Span getOffset(Span span, int amount, Pointer.PointerType pointer) {
        int direction = pointer == Pointer.PointerType.FUTURE ? 1 : -1;
        return span.add(direction * amount * 60);
    }

    public int getWidth() {
        return 60;
    }

    public String toString() {
        return String.valueOf(super.toString()) + "-minute";
    }
}

