/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.thrift.protocol;

import com.facebook.thrift.TException;
import com.facebook.thrift.protocol.TField;
import com.facebook.thrift.protocol.TList;
import com.facebook.thrift.protocol.TMap;
import com.facebook.thrift.protocol.TMessage;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.protocol.TProtocolException;
import com.facebook.thrift.protocol.TProtocolFactory;
import com.facebook.thrift.protocol.TSet;
import com.facebook.thrift.protocol.TStruct;
import com.facebook.thrift.transport.TTransport;

public class TBinaryProtocol
extends TProtocol {
    protected static final int VERSION_MASK = -65536;
    protected static final int VERSION_1 = -2147418112;
    protected boolean strictRead_ = false;
    protected boolean strictWrite_ = true;
    private byte[] bout = new byte[1];
    private byte[] i16out = new byte[2];
    private byte[] i32out = new byte[4];
    private byte[] i64out = new byte[8];
    private byte[] bin = new byte[1];
    private byte[] i16rd = new byte[2];
    private byte[] i32rd = new byte[4];
    private byte[] i64rd = new byte[8];

    public TBinaryProtocol(TTransport tTransport) {
        this(tTransport, false, false);
    }

    public TBinaryProtocol(TTransport tTransport, boolean bl, boolean bl2) {
        super(tTransport);
        this.strictRead_ = bl;
        this.strictWrite_ = bl2;
    }

    public void writeMessageBegin(TMessage tMessage) throws TException {
        if (this.strictWrite_) {
            int n = 0x80010000 | tMessage.type;
            this.writeI32(n);
            this.writeString(tMessage.name);
            this.writeI32(tMessage.seqid);
        } else {
            this.writeString(tMessage.name);
            this.writeByte(tMessage.type);
            this.writeI32(tMessage.seqid);
        }
    }

    public void writeMessageEnd() {
    }

    public void writeStructBegin(TStruct tStruct) {
    }

    public void writeStructEnd() {
    }

    public void writeFieldBegin(TField tField) throws TException {
        this.writeByte(tField.type);
        this.writeI16(tField.id);
    }

    public void writeFieldEnd() {
    }

    public void writeFieldStop() throws TException {
        this.writeByte((byte)0);
    }

    public void writeMapBegin(TMap tMap) throws TException {
        this.writeByte(tMap.keyType);
        this.writeByte(tMap.valueType);
        this.writeI32(tMap.size);
    }

    public void writeMapEnd() {
    }

    public void writeListBegin(TList tList) throws TException {
        this.writeByte(tList.elemType);
        this.writeI32(tList.size);
    }

    public void writeListEnd() {
    }

    public void writeSetBegin(TSet tSet) throws TException {
        this.writeByte(tSet.elemType);
        this.writeI32(tSet.size);
    }

    public void writeSetEnd() {
    }

    public void writeBool(boolean bl) throws TException {
        this.writeByte(bl ? (byte)1 : 0);
    }

    public void writeByte(byte by) throws TException {
        this.bout[0] = by;
        this.trans_.write(this.bout, 0, 1);
    }

    public void writeI16(short s) throws TException {
        this.i16out[0] = (byte)(0xFF & s >> 8);
        this.i16out[1] = (byte)(0xFF & s);
        this.trans_.write(this.i16out, 0, 2);
    }

    public void writeI32(int n) throws TException {
        this.i32out[0] = (byte)(0xFF & n >> 24);
        this.i32out[1] = (byte)(0xFF & n >> 16);
        this.i32out[2] = (byte)(0xFF & n >> 8);
        this.i32out[3] = (byte)(0xFF & n);
        this.trans_.write(this.i32out, 0, 4);
    }

    public void writeI64(long l) throws TException {
        this.i64out[0] = (byte)(0xFFL & l >> 56);
        this.i64out[1] = (byte)(0xFFL & l >> 48);
        this.i64out[2] = (byte)(0xFFL & l >> 40);
        this.i64out[3] = (byte)(0xFFL & l >> 32);
        this.i64out[4] = (byte)(0xFFL & l >> 24);
        this.i64out[5] = (byte)(0xFFL & l >> 16);
        this.i64out[6] = (byte)(0xFFL & l >> 8);
        this.i64out[7] = (byte)(0xFFL & l);
        this.trans_.write(this.i64out, 0, 8);
    }

    public void writeDouble(double d) throws TException {
        this.writeI64(Double.doubleToLongBits(d));
    }

    public void writeString(String string) throws TException {
        byte[] byArray = string.getBytes();
        this.writeI32(byArray.length);
        this.trans_.write(byArray, 0, byArray.length);
    }

    public void writeBinary(byte[] byArray) throws TException {
        this.writeI32(byArray.length);
        this.trans_.write(byArray, 0, byArray.length);
    }

    public TMessage readMessageBegin() throws TException {
        TMessage tMessage = new TMessage();
        int n = this.readI32();
        if (n < 0) {
            int n2 = n & 0xFFFF0000;
            if (n2 != -2147418112) {
                throw new TProtocolException(4, "Bad version in readMessageBegin");
            }
            tMessage.type = (byte)(n2 & 0xFF);
            tMessage.name = this.readString();
            tMessage.seqid = this.readI32();
        } else {
            if (this.strictRead_) {
                throw new TProtocolException(4, "Missing version in readMessageBegin, old client?");
            }
            tMessage.name = this.readStringBody(n);
            tMessage.type = this.readByte();
            tMessage.seqid = this.readI32();
        }
        return tMessage;
    }

    public void readMessageEnd() {
    }

    public TStruct readStructBegin() {
        return new TStruct();
    }

    public void readStructEnd() {
    }

    public TField readFieldBegin() throws TException {
        TField tField = new TField();
        tField.type = this.readByte();
        if (tField.type != 0) {
            tField.id = this.readI16();
        }
        return tField;
    }

    public void readFieldEnd() {
    }

    public TMap readMapBegin() throws TException {
        TMap tMap = new TMap();
        tMap.keyType = this.readByte();
        tMap.valueType = this.readByte();
        tMap.size = this.readI32();
        return tMap;
    }

    public void readMapEnd() {
    }

    public TList readListBegin() throws TException {
        TList tList = new TList();
        tList.elemType = this.readByte();
        tList.size = this.readI32();
        return tList;
    }

    public void readListEnd() {
    }

    public TSet readSetBegin() throws TException {
        TSet tSet = new TSet();
        tSet.elemType = this.readByte();
        tSet.size = this.readI32();
        return tSet;
    }

    public void readSetEnd() {
    }

    public boolean readBool() throws TException {
        return this.readByte() == 1;
    }

    public byte readByte() throws TException {
        this.trans_.readAll(this.bin, 0, 1);
        return this.bin[0];
    }

    public short readI16() throws TException {
        this.trans_.readAll(this.i16rd, 0, 2);
        return (short)((this.i16rd[0] & 0xFF) << 8 | this.i16rd[1] & 0xFF);
    }

    public int readI32() throws TException {
        this.trans_.readAll(this.i32rd, 0, 4);
        return (this.i32rd[0] & 0xFF) << 24 | (this.i32rd[1] & 0xFF) << 16 | (this.i32rd[2] & 0xFF) << 8 | this.i32rd[3] & 0xFF;
    }

    public long readI64() throws TException {
        this.trans_.readAll(this.i64rd, 0, 8);
        return (long)(this.i64rd[0] & 0xFF) << 56 | (long)(this.i64rd[1] & 0xFF) << 48 | (long)(this.i64rd[2] & 0xFF) << 40 | (long)(this.i64rd[3] & 0xFF) << 32 | (long)(this.i64rd[4] & 0xFF) << 24 | (long)(this.i64rd[5] & 0xFF) << 16 | (long)(this.i64rd[6] & 0xFF) << 8 | (long)(this.i64rd[7] & 0xFF);
    }

    public double readDouble() throws TException {
        return Double.longBitsToDouble(this.readI64());
    }

    public String readString() throws TException {
        int n = this.readI32();
        return this.readStringBody(n);
    }

    public String readStringBody(int n) throws TException {
        byte[] byArray = new byte[n];
        this.trans_.readAll(byArray, 0, n);
        return new String(byArray);
    }

    public byte[] readBinary() throws TException {
        int n = this.readI32();
        byte[] byArray = new byte[n];
        this.trans_.readAll(byArray, 0, n);
        return byArray;
    }

    public static class Factory
    implements TProtocolFactory {
        protected boolean strictRead_ = false;
        protected boolean strictWrite_ = true;

        public Factory() {
            this(false, false);
        }

        public Factory(boolean bl, boolean bl2) {
            this.strictRead_ = bl;
            this.strictWrite_ = bl2;
        }

        public TProtocol getProtocol(TTransport tTransport) {
            return new TBinaryProtocol(tTransport, this.strictRead_, this.strictWrite_);
        }
    }
}

