/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.thrift.transport;

import com.facebook.thrift.transport.TIOStreamTransport;
import com.facebook.thrift.transport.TTransportException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;

public class TSocket
extends TIOStreamTransport {
    private Socket socket_ = null;
    private String host_ = null;
    private int port_ = 0;
    private int timeout_ = 0;

    public TSocket(Socket socket) throws TTransportException {
        this.socket_ = socket;
        try {
            this.socket_.setSoLinger(false, 0);
            this.socket_.setTcpNoDelay(true);
        }
        catch (SocketException socketException) {
            socketException.printStackTrace();
        }
        if (this.isOpen()) {
            try {
                this.inputStream_ = new BufferedInputStream(this.socket_.getInputStream(), 1024);
                this.outputStream_ = new BufferedOutputStream(this.socket_.getOutputStream(), 1024);
            }
            catch (IOException iOException) {
                this.close();
                throw new TTransportException(1, (Throwable)iOException);
            }
        }
    }

    public TSocket(String string, int n) {
        this(string, n, 0);
    }

    public TSocket(String string, int n, int n2) {
        this.host_ = string;
        this.port_ = n;
        this.timeout_ = n2;
        this.initSocket();
    }

    private void initSocket() {
        this.socket_ = new Socket();
        try {
            this.socket_.setSoLinger(false, 0);
            this.socket_.setTcpNoDelay(true);
            this.socket_.setSoTimeout(this.timeout_);
        }
        catch (SocketException socketException) {
            socketException.printStackTrace();
        }
    }

    public void setTimeout(int n) {
        this.timeout_ = n;
        try {
            this.socket_.setSoTimeout(n);
        }
        catch (SocketException socketException) {
            socketException.printStackTrace();
        }
    }

    public Socket getSocket() {
        if (this.socket_ == null) {
            this.initSocket();
        }
        return this.socket_;
    }

    public boolean isOpen() {
        if (this.socket_ == null) {
            return false;
        }
        return this.socket_.isConnected();
    }

    public void open() throws TTransportException {
        if (this.isOpen()) {
            throw new TTransportException(2, "Socket already connected.");
        }
        if (this.host_.length() == 0) {
            throw new TTransportException(1, "Cannot open null host.");
        }
        if (this.port_ <= 0) {
            throw new TTransportException(1, "Cannot open without port.");
        }
        if (this.socket_ == null) {
            this.initSocket();
        }
        try {
            this.socket_.connect(new InetSocketAddress(this.host_, this.port_));
            this.inputStream_ = new BufferedInputStream(this.socket_.getInputStream(), 1024);
            this.outputStream_ = new BufferedOutputStream(this.socket_.getOutputStream(), 1024);
        }
        catch (IOException iOException) {
            this.close();
            throw new TTransportException(1, (Throwable)iOException);
        }
    }

    public void close() {
        super.close();
        if (this.socket_ != null) {
            try {
                this.socket_.close();
            }
            catch (IOException iOException) {
                System.err.println("WARNING: exception closing socket: " + iOException.getMessage());
            }
            this.socket_ = null;
        }
    }
}

