/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.xtrace;

import java.io.IOException;
import java.math.BigInteger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public final class IoUtil {
    private static final char[] hex = "0123456789ABCDEF".toCharArray();
    private static final Pattern NEWLINES = Pattern.compile("[\r\n]+");

    public static String fastOpIdExtraction(String md) {
        if (md.length() < 18) {
            return "00000000";
        }
        int opidlength = 4;
        int taskidlength = 4;
        byte flag = (byte)Integer.parseInt(md.substring(0, 2), 16);
        if ((flag & 8) != 0) {
            opidlength = 8;
        }
        switch (flag & 3) {
            case 0: {
                taskidlength = 4;
                break;
            }
            case 1: {
                taskidlength = 8;
                break;
            }
            case 2: {
                taskidlength = 12;
                break;
            }
            case 3: {
                taskidlength = 20;
                break;
            }
        }
        return md.substring(2 + 2 * taskidlength, 2 + 2 * taskidlength + 2 * opidlength);
    }

    public static String bytesToString(byte[] bytes) throws IOException {
        return IoUtil.bytesToString(bytes, 0, bytes.length);
    }

    public static String bytesToString(byte[] bytes, int offset, int length) throws IOException {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            byte b = bytes[offset + i];
            buf.append("" + hex[b >> 4 & 0xF] + hex[b & 0xF]);
        }
        return buf.toString();
    }

    public static byte[] stringToBytes(String str) throws IOException {
        if (str.length() % 2 != 0) {
            throw new IOException("Length of " + str + " must be even");
        }
        byte[] bytes = new byte[str.length() / 2];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)Integer.parseInt(str.substring(2 * i, 2 * i + 2), 16);
        }
        return bytes;
    }

    public static boolean validateHexString(String hex) {
        if (hex.length() % 2 != 0) {
            return false;
        }
        boolean isValid = false;
        try {
            isValid = hex.matches("[0-9A-F]*");
        }
        catch (PatternSyntaxException pse) {
            return false;
        }
        return isValid;
    }

    public static String intToString(int i) {
        byte[] b = new byte[]{(byte)(i >>> 24), (byte)(i >>> 16), (byte)(i >>> 8), (byte)i};
        String s = null;
        try {
            s = IoUtil.bytesToString(b);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return s;
    }

    public static String longToString(long l) {
        byte[] b = new byte[]{(byte)(l >>> 56), (byte)(l >>> 48), (byte)(l >>> 40), (byte)(l >>> 32), (byte)(l >>> 24), (byte)(l >>> 16), (byte)(l >>> 8), (byte)l};
        String s = null;
        try {
            s = IoUtil.bytesToString(b);
        }
        catch (IOException e) {
            // empty catch block
        }
        return s;
    }

    public static long hexStringToLong(String s) throws NumberFormatException {
        if (s == null || s.length() < 2) {
            throw new NumberFormatException(s);
        }
        char firstChar = s.charAt(0);
        if (firstChar >= '0' && firstChar <= '7') {
            return Long.parseLong(s, 16);
        }
        BigInteger big = new BigInteger(s, 16);
        return big.longValue();
    }

    public static String escapeNewlines(String str) {
        return NEWLINES.matcher(str).replaceAll("\\\\n");
    }
}

