/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.xtrace;

import edu.berkeley.xtrace.IoUtil;
import edu.berkeley.xtrace.OptionField;
import edu.berkeley.xtrace.TaskID;
import edu.berkeley.xtrace.XTraceMetadata;
import java.io.IOException;
import java.util.Random;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.varia.NullAppender;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MetadataTest {
    private static final int BigStochasticTests = 10000;
    private static final int SmallStochasticTests = 100;
    private byte[][] goodOps;
    private byte[][] badOps;
    private TaskID[] goodTasks;
    private Random rnd;
    private String[] validStrings;
    private byte[][] validBytes;
    private byte[][] goodTaskBytes;
    private String[] invalidStrings;
    private byte[][] invalidBytes;
    private String[] goodOptions;
    private String[] badOptions;

    @Before
    public void setUp() throws Exception {
        int i;
        BasicConfigurator.configure(new NullAppender());
        this.rnd = new Random();
        this.goodOps = new byte[4][];
        this.goodOps[0] = new byte[]{0, 0, 0, 0};
        this.goodOps[1] = new byte[]{1, 2, 3, 4};
        this.goodOps[2] = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
        this.goodOps[3] = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        this.badOps = new byte[4][];
        this.badOps[0] = new byte[]{0, 0, 0};
        this.badOps[1] = new byte[]{0, 1, 2, 3, 4};
        this.badOps[2] = new byte[]{0, 1, 2, 3, 4, 5, 6};
        this.badOps[2] = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
        this.goodTaskBytes = new byte[4][];
        this.goodTaskBytes[0] = IoUtil.stringToBytes("CAFEBABE");
        this.goodTaskBytes[1] = IoUtil.stringToBytes("CAFEBABECAFEBABE");
        this.goodTaskBytes[2] = IoUtil.stringToBytes("CAFEBABECAFEBABECAFEBABE");
        this.goodTaskBytes[3] = IoUtil.stringToBytes("CAFEBABECAFEBABECAFEBABECAFEBABECAFEBABE");
        this.goodTasks = new TaskID[4];
        this.goodTasks[0] = new TaskID(4);
        this.goodTasks[1] = new TaskID(8);
        this.goodTasks[2] = new TaskID(12);
        this.goodTasks[3] = new TaskID(20);
        this.validStrings = new String[8];
        this.validStrings[0] = "10CAFEBABE01020304";
        this.validStrings[1] = "18CAFEBABE0102030405060708";
        this.validStrings[2] = "11CAFEBABECAFEBABE01020304";
        this.validStrings[3] = "19CAFEBABECAFEBABE0102030405060708";
        this.validStrings[4] = "12CAFEBABECAFEBABECAFEBABE01020304";
        this.validStrings[5] = "1ACAFEBABECAFEBABECAFEBABE0102030405060708";
        this.validStrings[6] = "13CAFEBABECAFEBABECAFEBABECAFEBABECAFEBABE01020304";
        this.validStrings[7] = "1BCAFEBABECAFEBABECAFEBABECAFEBABECAFEBABE0102030405060708";
        this.validBytes = new byte[this.validStrings.length][];
        for (i = 0; i < this.validStrings.length; ++i) {
            this.validBytes[i] = IoUtil.stringToBytes(this.validStrings[i]);
        }
        this.invalidStrings = new String[9];
        this.invalidStrings[0] = "10CAFEBA01020304";
        this.invalidStrings[1] = "1001020304";
        this.invalidStrings[2] = "";
        this.invalidStrings[3] = "10";
        this.invalidStrings[4] = "10CAFEBABE";
        this.invalidStrings[5] = "10CAFEBABE0102";
        this.invalidStrings[6] = "11CAFEBABE01020304";
        this.invalidStrings[7] = "14CAFEBABE01020304";
        this.invalidStrings[8] = "18CAFEBABE01020304";
        this.invalidBytes = new byte[this.invalidStrings.length][];
        for (i = 0; i < this.invalidStrings.length; ++i) {
            this.invalidBytes[i] = IoUtil.stringToBytes(this.invalidStrings[i]);
        }
        this.goodOptions = new String[5];
        this.goodOptions[0] = "0002";
        this.goodOptions[1] = "0102";
        this.goodOptions[2] = "02040001";
        this.goodOptions[3] = "030600010203";
        this.goodOptions[4] = "04070001020304";
        this.badOptions = new String[4];
        this.badOptions[0] = "";
        this.badOptions[1] = "00";
        this.badOptions[2] = "0003";
        this.badOptions[3] = "01050001";
    }

    @Test
    public void testMetadata() {
        XTraceMetadata xtr = new XTraceMetadata();
        Assert.assertNotNull(xtr);
        Assert.assertFalse(xtr.isValid());
        Assert.assertNotNull(xtr.getOpId());
        Assert.assertNull(xtr.getOptions());
    }

    @Test
    public void testMetadataXtrTaskIDByteArray() {
        int i;
        for (i = 0; i < this.goodTasks.length; ++i) {
            for (int j = 0; j < this.goodOps.length; ++j) {
                XTraceMetadata md = new XTraceMetadata(this.goodTasks[i], this.goodOps[j]);
                Assert.assertNotNull(md);
                Assert.assertTrue(md.isValid());
            }
        }
        for (i = 0; i < this.goodOps.length; ++i) {
            XTraceMetadata md = new XTraceMetadata(null, this.goodOps[i]);
            Assert.assertNotNull(md);
            Assert.assertFalse(md.isValid());
        }
        for (i = 0; i < this.badOps.length; ++i) {
            XTraceMetadata md = new XTraceMetadata(this.goodTasks[0], this.badOps[i]);
            Assert.assertNotNull(md);
            Assert.assertFalse(md.isValid());
        }
        for (i = 0; i < this.goodOps.length; ++i) {
            XTraceMetadata md = new XTraceMetadata(null, this.goodOps[i]);
            Assert.assertNotNull(md);
            Assert.assertFalse(md.isValid());
        }
    }

    @Test
    public void testMetadataXtrTaskIDInt() {
        for (int i = 0; i < this.goodTasks.length; ++i) {
            for (int j = 0; j < 10000; ++j) {
                XTraceMetadata md = new XTraceMetadata(this.goodTasks[i], this.rnd.nextInt());
                Assert.assertNotNull(md);
                Assert.assertTrue(md.isValid());
            }
        }
        for (int j = 0; j < 100; ++j) {
            XTraceMetadata md = new XTraceMetadata(null, this.rnd.nextInt());
            Assert.assertNotNull(md);
            Assert.assertFalse(md.isValid());
        }
    }

    @Test
    public void testMetadataXtrTaskIDLong() {
        for (int i = 0; i < this.goodTasks.length; ++i) {
            for (int j = 0; j < 10000; ++j) {
                XTraceMetadata md = new XTraceMetadata(this.goodTasks[i], this.rnd.nextLong());
                Assert.assertNotNull(md);
                Assert.assertTrue(md.isValid());
            }
        }
        for (int j = 0; j < 100; ++j) {
            XTraceMetadata md = new XTraceMetadata(null, this.rnd.nextLong());
            Assert.assertNotNull(md);
            Assert.assertFalse(md.isValid());
        }
    }

    @Test
    public void testCreateFromBytes() {
        XTraceMetadata md = XTraceMetadata.createFromBytes(this.validBytes[0], 0, this.validBytes[0].length);
        Assert.assertNotNull(md);
        Assert.assertTrue(md.isValid());
        Assert.assertEquals(md.getTaskId(), TaskID.createFromBytes(this.goodTaskBytes[0], 0, this.goodTaskBytes[0].length));
        Assert.assertEquals(4L, md.getOpIdLength());
        Assert.assertArrayEquals(this.goodOps[1], md.getOpId());
        Assert.assertNull(md.getOptions());
        md = XTraceMetadata.createFromBytes(this.validBytes[1], 0, this.validBytes[1].length);
        Assert.assertNotNull(md);
        Assert.assertTrue(md.isValid());
        Assert.assertEquals(TaskID.createFromBytes(this.goodTaskBytes[0], 0, this.goodTaskBytes[0].length), md.getTaskId());
        Assert.assertEquals(8L, md.getOpIdLength());
        Assert.assertArrayEquals(this.goodOps[3], md.getOpId());
        Assert.assertNull(md.getOptions());
        md = XTraceMetadata.createFromBytes(this.validBytes[2], 0, this.validBytes[2].length);
        Assert.assertNotNull(md);
        Assert.assertTrue(md.isValid());
        Assert.assertEquals(md.getTaskId(), TaskID.createFromBytes(this.goodTaskBytes[1], 0, this.goodTaskBytes[1].length));
        Assert.assertEquals(4L, md.getOpIdLength());
        Assert.assertArrayEquals(this.goodOps[1], md.getOpId());
        Assert.assertNull(md.getOptions());
        md = XTraceMetadata.createFromBytes(this.validBytes[3], 0, this.validBytes[3].length);
        Assert.assertNotNull(md);
        Assert.assertTrue(md.isValid());
        Assert.assertEquals(md.getTaskId(), TaskID.createFromBytes(this.goodTaskBytes[1], 0, this.goodTaskBytes[1].length));
        Assert.assertEquals(8L, md.getOpIdLength());
        Assert.assertArrayEquals(this.goodOps[3], md.getOpId());
        Assert.assertNull(md.getOptions());
        md = XTraceMetadata.createFromBytes(this.validBytes[4], 0, this.validBytes[4].length);
        Assert.assertNotNull(md);
        Assert.assertTrue(md.isValid());
        Assert.assertEquals(md.getTaskId(), TaskID.createFromBytes(this.goodTaskBytes[2], 0, this.goodTaskBytes[2].length));
        Assert.assertEquals(4L, md.getOpIdLength());
        Assert.assertArrayEquals(this.goodOps[1], md.getOpId());
        Assert.assertNull(md.getOptions());
        md = XTraceMetadata.createFromBytes(this.validBytes[5], 0, this.validBytes[5].length);
        Assert.assertNotNull(md);
        Assert.assertTrue(md.isValid());
        Assert.assertEquals(md.getTaskId(), TaskID.createFromBytes(this.goodTaskBytes[2], 0, this.goodTaskBytes[2].length));
        Assert.assertEquals(8L, md.getOpIdLength());
        Assert.assertArrayEquals(this.goodOps[3], md.getOpId());
        Assert.assertNull(md.getOptions());
        md = XTraceMetadata.createFromBytes(this.validBytes[6], 0, this.validBytes[6].length);
        Assert.assertNotNull(md);
        Assert.assertTrue(md.isValid());
        Assert.assertEquals(md.getTaskId(), TaskID.createFromBytes(this.goodTaskBytes[3], 0, this.goodTaskBytes[3].length));
        Assert.assertEquals(4L, md.getOpIdLength());
        Assert.assertArrayEquals(this.goodOps[1], md.getOpId());
        Assert.assertNull(md.getOptions());
        md = XTraceMetadata.createFromBytes(this.validBytes[7], 0, this.validBytes[7].length);
        Assert.assertNotNull(md);
        Assert.assertTrue(md.isValid());
        Assert.assertEquals(md.getTaskId(), TaskID.createFromBytes(this.goodTaskBytes[3], 0, this.goodTaskBytes[3].length));
        Assert.assertEquals(8L, md.getOpIdLength());
        Assert.assertArrayEquals(this.goodOps[3], md.getOpId());
        Assert.assertNull(md.getOptions());
        md = XTraceMetadata.createFromBytes(null, 0, 0);
        Assert.assertNotNull(md);
        Assert.assertFalse(md.isValid());
        Assert.assertNotNull(md.getTaskId());
        for (int i = 0; i < this.invalidBytes.length; ++i) {
            md = XTraceMetadata.createFromBytes(this.invalidBytes[i], 0, this.invalidBytes[i].length);
            Assert.assertNotNull(md);
            Assert.assertFalse(md.isValid());
            Assert.assertNotNull(md.getTaskId());
            Assert.assertNull(md.getOptions());
        }
    }

    @Test
    public void testCreateFromString() {
        XTraceMetadata md = XTraceMetadata.createFromString(this.validStrings[0]);
        Assert.assertNotNull(md);
        Assert.assertTrue(md.isValid());
        Assert.assertEquals(md.getTaskId(), TaskID.createFromBytes(this.goodTaskBytes[0], 0, this.goodTaskBytes[0].length));
        Assert.assertEquals(4L, md.getOpIdLength());
        Assert.assertArrayEquals(this.goodOps[1], md.getOpId());
        Assert.assertNull(md.getOptions());
        md = XTraceMetadata.createFromString(this.validStrings[1]);
        Assert.assertNotNull(md);
        Assert.assertTrue(md.isValid());
        Assert.assertEquals(TaskID.createFromBytes(this.goodTaskBytes[0], 0, this.goodTaskBytes[0].length), md.getTaskId());
        Assert.assertEquals(8L, md.getOpIdLength());
        Assert.assertArrayEquals(this.goodOps[3], md.getOpId());
        Assert.assertNull(md.getOptions());
        md = XTraceMetadata.createFromString(this.validStrings[2]);
        Assert.assertNotNull(md);
        Assert.assertTrue(md.isValid());
        Assert.assertEquals(md.getTaskId(), TaskID.createFromBytes(this.goodTaskBytes[1], 0, this.goodTaskBytes[1].length));
        Assert.assertEquals(4L, md.getOpIdLength());
        Assert.assertArrayEquals(this.goodOps[1], md.getOpId());
        Assert.assertNull(md.getOptions());
        md = XTraceMetadata.createFromString(this.validStrings[3]);
        Assert.assertNotNull(md);
        Assert.assertTrue(md.isValid());
        Assert.assertEquals(md.getTaskId(), TaskID.createFromBytes(this.goodTaskBytes[1], 0, this.goodTaskBytes[1].length));
        Assert.assertEquals(8L, md.getOpIdLength());
        Assert.assertArrayEquals(this.goodOps[3], md.getOpId());
        Assert.assertNull(md.getOptions());
        md = XTraceMetadata.createFromString(this.validStrings[4]);
        Assert.assertNotNull(md);
        Assert.assertTrue(md.isValid());
        Assert.assertEquals(md.getTaskId(), TaskID.createFromBytes(this.goodTaskBytes[2], 0, this.goodTaskBytes[2].length));
        Assert.assertEquals(4L, md.getOpIdLength());
        Assert.assertArrayEquals(this.goodOps[1], md.getOpId());
        Assert.assertNull(md.getOptions());
        md = XTraceMetadata.createFromString(this.validStrings[5]);
        Assert.assertNotNull(md);
        Assert.assertTrue(md.isValid());
        Assert.assertEquals(md.getTaskId(), TaskID.createFromBytes(this.goodTaskBytes[2], 0, this.goodTaskBytes[2].length));
        Assert.assertEquals(8L, md.getOpIdLength());
        Assert.assertArrayEquals(this.goodOps[3], md.getOpId());
        Assert.assertNull(md.getOptions());
        md = XTraceMetadata.createFromString(this.validStrings[6]);
        Assert.assertNotNull(md);
        Assert.assertTrue(md.isValid());
        Assert.assertEquals(md.getTaskId(), TaskID.createFromBytes(this.goodTaskBytes[3], 0, this.goodTaskBytes[3].length));
        Assert.assertEquals(4L, md.getOpIdLength());
        Assert.assertArrayEquals(this.goodOps[1], md.getOpId());
        Assert.assertNull(md.getOptions());
        md = XTraceMetadata.createFromString(this.validStrings[7]);
        Assert.assertNotNull(md);
        Assert.assertTrue(md.isValid());
        Assert.assertEquals(md.getTaskId(), TaskID.createFromBytes(this.goodTaskBytes[3], 0, this.goodTaskBytes[3].length));
        Assert.assertEquals(8L, md.getOpIdLength());
        Assert.assertArrayEquals(this.goodOps[3], md.getOpId());
        Assert.assertNull(md.getOptions());
        md = XTraceMetadata.createFromString(null);
        Assert.assertNotNull(md);
        Assert.assertFalse(md.isValid());
        Assert.assertNotNull(md.getTaskId());
        for (int i = 0; i < this.invalidStrings.length; ++i) {
            md = XTraceMetadata.createFromString(this.invalidStrings[i]);
            Assert.assertNotNull(md);
            Assert.assertFalse(md.isValid());
            Assert.assertNotNull(md.getTaskId());
            Assert.assertNull(md.getOptions());
        }
    }

    @Test
    public void testPack() {
        for (int i = 0; i < this.validBytes.length; ++i) {
            XTraceMetadata md = XTraceMetadata.createFromBytes(this.validBytes[i], 0, this.validBytes[i].length);
            Assert.assertArrayEquals(this.validBytes[i], md.pack());
        }
    }

    @Test
    public void testIsValid() {
        XTraceMetadata md;
        int i;
        Assert.assertFalse(new XTraceMetadata().isValid());
        for (i = 0; i < this.validBytes.length; ++i) {
            md = XTraceMetadata.createFromBytes(this.validBytes[i], 0, this.validBytes[i].length);
            Assert.assertTrue(md.isValid());
        }
        for (i = 0; i < this.invalidBytes.length; ++i) {
            md = XTraceMetadata.createFromBytes(this.invalidBytes[i], 0, this.invalidBytes[i].length);
            Assert.assertFalse(md.isValid());
        }
    }

    @Test
    public void testSizeAsBytes() {
        Assert.assertEquals(9L, XTraceMetadata.createFromString(this.validStrings[0]).sizeAsBytes());
        Assert.assertEquals(13L, XTraceMetadata.createFromString(this.validStrings[1]).sizeAsBytes());
        Assert.assertEquals(13L, XTraceMetadata.createFromString(this.validStrings[2]).sizeAsBytes());
        Assert.assertEquals(17L, XTraceMetadata.createFromString(this.validStrings[3]).sizeAsBytes());
        Assert.assertEquals(17L, XTraceMetadata.createFromString(this.validStrings[4]).sizeAsBytes());
        Assert.assertEquals(21L, XTraceMetadata.createFromString(this.validStrings[5]).sizeAsBytes());
        Assert.assertEquals(25L, XTraceMetadata.createFromString(this.validStrings[6]).sizeAsBytes());
        Assert.assertEquals(29L, XTraceMetadata.createFromString(this.validStrings[7]).sizeAsBytes());
    }

    @Test
    public void testOptions() {
        XTraceMetadata md = new XTraceMetadata();
        Assert.assertNull(md.getOptions());
        md = XTraceMetadata.createFromString(this.validStrings[0]);
        Assert.assertNull(md.getOptions());
        Assert.assertEquals("10CAFEBABE01020304", md.toString());
        OptionField o = new OptionField(0, null);
        md.addOption(o);
        Assert.assertNotNull(md.getOptions());
        Assert.assertEquals(1L, md.getOptions().length);
        Assert.assertEquals(o, md.getOptions()[0]);
        Assert.assertEquals("14CAFEBABE01020304020002", md.toString());
        OptionField o2 = new OptionField(1, null);
        md.addOption(o2);
        Assert.assertNotNull(md.getOptions());
        Assert.assertEquals(2L, md.getOptions().length);
        Assert.assertEquals(o, md.getOptions()[0]);
        Assert.assertEquals(o2, md.getOptions()[1]);
        Assert.assertEquals("14CAFEBABE010203040400020102", md.toString());
        OptionField o3 = new OptionField(2, null);
        md.addOption(o3);
        Assert.assertNotNull(md.getOptions());
        Assert.assertEquals(3L, md.getOptions().length);
        Assert.assertEquals(o, md.getOptions()[0]);
        Assert.assertEquals(o2, md.getOptions()[1]);
        Assert.assertEquals(o3, md.getOptions()[2]);
        Assert.assertEquals("14CAFEBABE0102030406000201020202", md.toString());
        md = XTraceMetadata.createFromString(this.validStrings[0]);
        Assert.assertNull(md.getOptions());
        Assert.assertEquals("10CAFEBABE01020304", md.toString());
        o = new OptionField(0, new byte[]{0, 1, 2, 3});
        md.addOption(o);
        Assert.assertNotNull(md.getOptions());
        Assert.assertEquals(1L, md.getOptions().length);
        Assert.assertEquals(o, md.getOptions()[0]);
        Assert.assertEquals("14CAFEBABE0102030406000600010203", md.toString());
        o2 = new OptionField(1, new byte[]{5, 6});
        md.addOption(o2);
        Assert.assertNotNull(md.getOptions());
        Assert.assertEquals(2L, md.getOptions().length);
        Assert.assertEquals(o, md.getOptions()[0]);
        Assert.assertEquals(o2, md.getOptions()[1]);
        Assert.assertEquals("14CAFEBABE010203040A00060001020301040506", md.toString());
        o3 = new OptionField(2, new byte[]{7});
        md.addOption(o3);
        Assert.assertNotNull(md.getOptions());
        Assert.assertEquals(3L, md.getOptions().length);
        Assert.assertEquals(o, md.getOptions()[0]);
        Assert.assertEquals(o2, md.getOptions()[1]);
        Assert.assertEquals(o3, md.getOptions()[2]);
        Assert.assertEquals("14CAFEBABE010203040D00060001020301040506020307", md.toString());
        md = XTraceMetadata.createFromString(this.validStrings[0]);
        Assert.assertNull(md.getOptions());
        o = new OptionField(0, new byte[]{0, 1, 2, 3});
        md.addOption(o);
        Assert.assertNotNull(md.getOptions());
        Assert.assertEquals(1L, md.getOptions().length);
        Assert.assertEquals(o, md.getOptions()[0]);
        o2 = new OptionField(1, null);
        md.addOption(o2);
        Assert.assertNotNull(md.getOptions());
        Assert.assertEquals(2L, md.getOptions().length);
        Assert.assertEquals(o, md.getOptions()[0]);
        Assert.assertEquals(o2, md.getOptions()[1]);
        o3 = new OptionField(2, new byte[]{7});
        md.addOption(o3);
        Assert.assertNotNull(md.getOptions());
        Assert.assertEquals(3L, md.getOptions().length);
        Assert.assertEquals(o, md.getOptions()[0]);
        Assert.assertEquals(o2, md.getOptions()[1]);
        Assert.assertEquals(o3, md.getOptions()[2]);
    }

    public void testOptionSerialization() {
        for (int i = 0; i < this.goodOptions.length; ++i) {
            OptionField o = OptionField.createFromString(this.goodOptions[i]);
            Assert.assertNotNull(o);
            Assert.assertEquals(this.goodOptions[i], o.toString());
        }
        OptionField o = new OptionField(1, null);
        Assert.assertNotNull(o);
        Assert.assertEquals(1L, o.getType());
        Assert.assertNull(o.getPayload());
        o = new OptionField(2, new byte[]{0, 1, 2, 3});
        Assert.assertNotNull(o);
        Assert.assertEquals(2L, o.getType());
        Assert.assertNotNull(o.getPayload());
        Assert.assertArrayEquals(new byte[]{0, 1, 2, 3}, o.getPayload());
    }

    @Test
    public void testGetVersion() {
        XTraceMetadata md = XTraceMetadata.createFromString(this.validStrings[0]);
        Assert.assertEquals(md.getVersion(), 1L);
    }

    @Test
    public void testGetTaskId() {
        for (int i = 0; i < this.goodTasks.length; ++i) {
            XTraceMetadata md = new XTraceMetadata(this.goodTasks[i], 0);
            Assert.assertEquals(this.goodTasks[i], md.getTaskId());
        }
    }

    @Test
    public void testGetOpIdLength() {
        XTraceMetadata md = new XTraceMetadata(this.goodTasks[0], this.goodOps[0]);
        Assert.assertEquals(4L, md.getOpIdLength());
        md = new XTraceMetadata(this.goodTasks[0], this.goodOps[1]);
        Assert.assertEquals(4L, md.getOpIdLength());
        md = new XTraceMetadata(this.goodTasks[0], this.goodOps[2]);
        Assert.assertEquals(8L, md.getOpIdLength());
        md = new XTraceMetadata(this.goodTasks[0], this.goodOps[3]);
        Assert.assertEquals(8L, md.getOpIdLength());
        md = new XTraceMetadata();
        Assert.assertTrue(md.getOpIdLength() == 4 || md.getOpIdLength() == 8);
    }

    @Test
    public void testGetOpId() {
        for (int i = 0; i < this.goodOps.length; ++i) {
            XTraceMetadata md = new XTraceMetadata(this.goodTasks[0], this.goodOps[i]);
            Assert.assertNotNull(md.getOpId());
            Assert.assertArrayEquals(this.goodOps[i], md.getOpId());
        }
    }

    @Test
    public void testGetOpIdString() {
        for (int i = 0; i < this.goodOps.length; ++i) {
            XTraceMetadata md = new XTraceMetadata(this.goodTasks[0], this.goodOps[i]);
            Assert.assertNotNull(md.getOpId());
            try {
                Assert.assertEquals(IoUtil.bytesToString(this.goodOps[i]), md.getOpIdString());
                continue;
            }
            catch (IOException e) {
                Assert.fail("Internal error");
            }
        }
    }

    @Test
    public void testSetOpId() {
        XTraceMetadata md = new XTraceMetadata(this.goodTasks[0], this.goodOps[0]);
        Assert.assertEquals((Object)this.goodOps[0], (Object)md.getOpId());
        md.setOpId(this.goodOps[1]);
        Assert.assertArrayEquals(this.goodOps[1], md.getOpId());
        md.setOpId(this.goodOps[2]);
        Assert.assertArrayEquals(this.goodOps[2], md.getOpId());
        md.setOpId(8);
        Assert.assertEquals(4L, md.getOpIdLength());
        Assert.assertArrayEquals(new byte[]{0, 0, 0, 8}, md.getOpId());
        md.setOpId(7L);
        Assert.assertEquals(8L, md.getOpIdLength());
        Assert.assertArrayEquals(new byte[]{0, 0, 0, 0, 0, 0, 0, 7}, md.getOpId());
    }

    @Test
    public void testToString() {
        XTraceMetadata md;
        int i;
        for (i = 0; i < this.validStrings.length; ++i) {
            md = XTraceMetadata.createFromString(this.validStrings[i]);
            Assert.assertEquals(this.validStrings[i], md.toString());
        }
        for (i = 0; i < this.invalidStrings.length; ++i) {
            md = XTraceMetadata.createFromString(this.invalidStrings[i]);
            Assert.assertEquals(new XTraceMetadata().toString(), md.toString());
        }
    }

    @Test
    public void testLegacyMetadata() {
        String[] old = new String[]{"0000010203AABBCCDD", "010001020304050607AABBCCDD", "0000010203AABBCCDD0704070001020304"};
        for (int i = 0; i < old.length; ++i) {
            XTraceMetadata m = XTraceMetadata.createFromString(old[i]);
            Assert.assertNotNull(m);
            Assert.assertTrue(m.isValid());
        }
    }
}

