/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.xtrace;

import edu.berkeley.xtrace.IoUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Random;

public final class TaskID
implements Serializable {
    private static volatile Random r = null;
    private byte[] id;

    public TaskID() {
        try {
            this.initialize(4);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Arrays.fill(this.id, (byte)0);
    }

    public TaskID(int length) throws IllegalArgumentException {
        this.initialize(length);
        if (r == null) {
            r = new Random();
        }
        r.nextBytes(this.id);
    }

    public TaskID(byte[] prefix, int length) throws IllegalArgumentException {
        if (prefix.length > length) {
            throw new IllegalArgumentException("Prefix longer than length: " + length);
        }
        this.initialize(length);
        if (r == null) {
            r = new Random();
        }
        byte[] randomBytes = new byte[length - prefix.length];
        r.nextBytes(randomBytes);
        System.arraycopy(prefix, 0, this.id, 0, prefix.length);
        System.arraycopy(randomBytes, 0, this.id, prefix.length, length - prefix.length);
    }

    public TaskID(TaskID taskid) {
        this.id = new byte[taskid.id.length];
        System.arraycopy(taskid.id, 0, this.id, 0, taskid.id.length);
    }

    public static TaskID createFromBytes(byte[] bytes, int offset, int length) throws IndexOutOfBoundsException {
        if (bytes == null) {
            return new TaskID();
        }
        if (offset < 0 || offset >= bytes.length) {
            throw new IndexOutOfBoundsException("offset is negative or points past the given byte array: " + offset);
        }
        if (length < 0 || offset + length > bytes.length) {
            throw new IndexOutOfBoundsException("length is negative or (offset + length) points past given array: " + length);
        }
        if (length == 4 || length == 8 || length == 12 || length == 20) {
            TaskID id = new TaskID();
            id.id = new byte[length];
            System.arraycopy(bytes, offset, id.id, 0, length);
            return id;
        }
        System.err.println("Invalid length for a task: " + length);
        return new TaskID();
    }

    public static TaskID createFromString(String s) {
        byte[] bytes = null;
        try {
            bytes = IoUtil.stringToBytes(s);
        }
        catch (IOException e) {
            System.err.println("Invalid taskid: " + s);
            return new TaskID();
        }
        return TaskID.createFromBytes(bytes, 0, bytes.length);
    }

    private void initialize(int length) throws IllegalArgumentException {
        switch (length) {
            case 4: {
                this.id = new byte[4];
                break;
            }
            case 8: {
                this.id = new byte[8];
                break;
            }
            case 12: {
                this.id = new byte[12];
                break;
            }
            case 20: {
                this.id = new byte[20];
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid length: " + length);
            }
        }
    }

    public byte[] get() {
        return this.id;
    }

    public byte[] pack() {
        return this.id;
    }

    public String toString() {
        String s = null;
        try {
            s = IoUtil.bytesToString(this.id);
        }
        catch (IOException e) {
            s = "00000000";
        }
        return s;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.id);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TaskID other = (TaskID)obj;
        return Arrays.equals(this.id, other.id);
    }
}

