/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.xtrace;

import edu.berkeley.xtrace.IoUtil;
import edu.berkeley.xtrace.OptionField;
import edu.berkeley.xtrace.TaskID;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;

public final class XTraceMetadata {
    private static final byte[] INVALID_ID = new byte[]{0, 0, 0, 0};
    private static final byte MetadataVersion = 1;
    private final TaskID taskid;
    private byte[] opId;
    private OptionField[] options;
    private int numOptions;

    public XTraceMetadata() {
        this.taskid = TaskID.createFromBytes(INVALID_ID, 0, INVALID_ID.length);
        this.opId = new byte[]{0, 0, 0, 0};
        this.options = null;
        this.numOptions = 0;
    }

    public XTraceMetadata(TaskID id, byte[] op) {
        if (id != null && op != null && (op.length == 4 || op.length == 8)) {
            this.taskid = id;
            this.opId = op;
        } else {
            if (id == null || op == null) {
                // empty if block
            }
            this.taskid = TaskID.createFromBytes(INVALID_ID, 0, INVALID_ID.length);
            this.opId = new byte[]{0, 0, 0, 0};
        }
        this.options = null;
        this.numOptions = 0;
    }

    public XTraceMetadata(TaskID id, int opId) {
        if (id != null) {
            this.taskid = id;
            this.opId = ByteBuffer.allocate(4).putInt(opId).array();
        } else {
            this.taskid = TaskID.createFromBytes(INVALID_ID, 0, INVALID_ID.length);
            this.opId = new byte[]{0, 0, 0, 0};
        }
        this.options = null;
        this.numOptions = 0;
    }

    public XTraceMetadata(TaskID id, long opId) {
        if (id != null) {
            this.taskid = id;
            this.opId = ByteBuffer.allocate(8).putLong(opId).array();
        } else {
            this.taskid = TaskID.createFromBytes(INVALID_ID, 0, INVALID_ID.length);
            this.opId = new byte[]{0, 0, 0, 0};
        }
        this.options = null;
        this.numOptions = 0;
    }

    public XTraceMetadata(XTraceMetadata xtr) {
        this.taskid = new TaskID(xtr.taskid);
        this.opId = new byte[xtr.opId.length];
        System.arraycopy(xtr.opId, 0, this.opId, 0, xtr.opId.length);
        this.numOptions = xtr.numOptions;
        this.options = new OptionField[xtr.numOptions];
        for (int i = 0; i < xtr.numOptions; ++i) {
            this.options[i] = xtr.options[i];
        }
    }

    public static XTraceMetadata createFromBytes(byte[] bytes, int offset, int length) {
        if (bytes == null) {
            return new XTraceMetadata();
        }
        if (offset < 0) {
            return new XTraceMetadata();
        }
        if (length < 9) {
            return new XTraceMetadata();
        }
        if (bytes.length - offset < length) {
            return new XTraceMetadata();
        }
        int taskIdLength = 0;
        switch (bytes[0] & 3) {
            case 0: {
                taskIdLength = 4;
                break;
            }
            case 1: {
                taskIdLength = 8;
                break;
            }
            case 2: {
                taskIdLength = 12;
                break;
            }
            case 3: {
                taskIdLength = 20;
                break;
            }
        }
        int opIdLength = (bytes[0] & 8) != 0 ? 8 : 4;
        if (taskIdLength + opIdLength > length) {
            return new XTraceMetadata();
        }
        TaskID taskid = TaskID.createFromBytes(bytes, 1, taskIdLength);
        byte[] opIdBytes = new byte[opIdLength];
        System.arraycopy(bytes, 1 + taskIdLength, opIdBytes, 0, opIdLength);
        XTraceMetadata md = new XTraceMetadata(taskid, opIdBytes);
        if ((bytes[0] & 4) == 0) {
            return md;
        }
        if (length <= 1 + taskIdLength + opIdLength) {
            return new XTraceMetadata();
        }
        int totOptLen = bytes[1 + taskIdLength + opIdLength];
        int optPtr = offset + 1 + taskIdLength + opIdLength + 1;
        while (totOptLen >= 2) {
            byte len;
            byte type = bytes[optPtr++];
            if ((len = bytes[optPtr++]) > totOptLen) break;
            OptionField o = len > 0 ? OptionField.createFromBytes(bytes, optPtr, len) : new OptionField(type, null);
            md.addOption(o);
            totOptLen -= 2 + len;
            optPtr += 2 + len;
        }
        return md;
    }

    public static XTraceMetadata createFromString(String str) {
        byte[] bytes;
        if (str == null) {
            return new XTraceMetadata();
        }
        try {
            bytes = IoUtil.stringToBytes(str);
        }
        catch (IOException e) {
            return new XTraceMetadata();
        }
        return XTraceMetadata.createFromBytes(bytes, 0, bytes.length);
    }

    public byte[] pack() {
        ByteBuffer buf = this.packToBuffer();
        byte[] ar = new byte[buf.limit()];
        buf.get(ar);
        return ar;
    }

    private ByteBuffer packToBuffer() {
        ByteBuffer buf = ByteBuffer.allocate(1024);
        byte flags = 0;
        switch (this.taskid.get().length) {
            case 4: {
                flags = 0;
                break;
            }
            case 8: {
                flags = 1;
                break;
            }
            case 12: {
                flags = 2;
                break;
            }
            case 20: {
                flags = 3;
                break;
            }
        }
        flags = (byte)(flags | 0x10);
        if (this.getOptions() != null && this.getOptions().length > 0) {
            flags = (byte)(flags | 4);
        }
        if (this.opId.length == 8) {
            flags = (byte)(flags | 8);
        }
        buf.put(flags);
        buf.put(this.taskid.pack());
        buf.put(this.opId);
        if (this.getOptions() != null) {
            OptionField[] opts = this.getOptions();
            int optLenPosition = buf.position();
            byte totalOptLength = 0;
            if (opts != null && opts.length > 0) {
                buf.put((byte)0);
            }
            for (int i = 0; opts != null && i < opts.length; ++i) {
                OptionField opt = opts[i];
                byte[] optBytes = opt.pack();
                totalOptLength = (byte)(totalOptLength + optBytes.length);
                buf.put(optBytes);
            }
            buf.put(optLenPosition, totalOptLength);
        }
        buf.flip();
        return buf;
    }

    public boolean isValid() {
        byte[] taskidbytes;
        for (byte element : taskidbytes = this.taskid.get()) {
            if (element == 0) continue;
            return true;
        }
        return false;
    }

    public int sizeAsBytes() {
        return this.packToBuffer().limit();
    }

    public OptionField[] getOptions() {
        if (this.numOptions > 0) {
            return this.options;
        }
        return null;
    }

    public int getNumOptions() {
        return this.numOptions;
    }

    public void addOption(OptionField option) {
        if (this.numOptions == 0) {
            this.options = new OptionField[1];
        } else if (this.numOptions == this.options.length) {
            OptionField[] tmp = this.options;
            this.options = new OptionField[this.options.length + 1];
            System.arraycopy(tmp, 0, this.options, 0, tmp.length);
        }
        this.options[this.numOptions++] = option;
    }

    public int getVersion() {
        return 1;
    }

    public TaskID getTaskId() {
        return this.taskid;
    }

    public int getOpIdLength() {
        return this.opId.length;
    }

    public byte[] getOpId() {
        return this.opId;
    }

    public String getOpIdString() {
        try {
            return IoUtil.bytesToString(this.opId);
        }
        catch (IOException iOException) {
            return "0";
        }
    }

    public void setOpId(byte[] newid) {
        if (newid.length != 4 && newid.length != 8) {
            return;
        }
        this.opId = new byte[newid.length];
        System.arraycopy(newid, 0, this.opId, 0, newid.length);
    }

    public void setOpId(int newid) {
        this.opId = ByteBuffer.allocate(4).putInt(newid).array();
    }

    public void setOpId(long newid) {
        this.opId = ByteBuffer.allocate(8).putLong(newid).array();
    }

    public void setSeverity(int severity) {
        byte type = -50;
        byte[] payload = new byte[]{new Integer(severity).byteValue()};
        if (this.numOptions > 0) {
            for (int i = 0; i < this.numOptions; ++i) {
                if (this.options[i].getType() - -50 != 0) continue;
                this.options[i] = new OptionField(type, payload);
            }
        } else {
            this.addOption(new OptionField(type, payload));
        }
    }

    public String toString() {
        String s = null;
        try {
            s = IoUtil.bytesToString(this.pack());
        }
        catch (IOException e) {
            return "000000000000000000";
        }
        return s;
    }

    public void write(DataOutput out) throws IOException {
        byte[] buf = this.pack();
        out.writeInt(buf.length);
        out.write(buf);
    }

    public static XTraceMetadata read(DataInput in) throws IOException {
        int length = in.readInt();
        if (length <= 0 || length > 4096) {
            throw new IOException("Invalid X-Trace metadata length: " + length);
        }
        byte[] buf = new byte[length];
        in.readFully(buf);
        return XTraceMetadata.createFromBytes(buf, 0, length);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.numOptions;
        result = 31 * result + Arrays.hashCode(this.opId);
        result = 31 * result + Arrays.hashCode(this.options);
        result = 31 * result + (this.taskid == null ? 0 : this.taskid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XTraceMetadata other = (XTraceMetadata)obj;
        if (this.numOptions != other.numOptions) {
            return false;
        }
        if (!Arrays.equals(this.opId, other.opId)) {
            return false;
        }
        if (!Arrays.equals(this.options, other.options)) {
            return false;
        }
        return !(this.taskid == null ? other.taskid != null : !this.taskid.equals(other.taskid));
    }

    public static void write(XTraceMetadata context, DataOutput out) throws IOException {
        if (context != null) {
            context.write(out);
        } else {
            new XTraceMetadata().write(out);
        }
    }
}

