/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.xtrace;

import edu.berkeley.xtrace.TaskID;
import edu.berkeley.xtrace.XTraceContext;
import edu.berkeley.xtrace.XTraceMetadata;
import org.junit.Assert;
import org.junit.Test;

public class XTraceTest {
    @Test
    public void testContext() {
        XTraceContext.setThreadContext(null);
        Assert.assertNull(XTraceContext.getThreadContext());
        XTraceContext.setThreadContext(new XTraceMetadata());
        Assert.assertNull(XTraceContext.getThreadContext());
        TaskID task = new TaskID(4);
        XTraceContext.setThreadContext(new XTraceMetadata(task, 1234));
        Assert.assertNotNull(XTraceContext.getThreadContext());
        Assert.assertEquals(new XTraceMetadata(task, 1234), XTraceContext.getThreadContext());
        TaskID task2 = new TaskID(20);
        XTraceContext.setThreadContext(new XTraceMetadata(task2, 98769876L));
        Assert.assertNotNull(XTraceContext.getThreadContext());
        Assert.assertEquals(new XTraceMetadata(task2, 98769876L), XTraceContext.getThreadContext());
    }

    @Test
    public void testClearContext() {
        XTraceContext.setThreadContext(new XTraceMetadata(new TaskID(12), 1234));
        Assert.assertNotNull(XTraceContext.getThreadContext());
        XTraceContext.clearThreadContext();
        Assert.assertNull(XTraceContext.getThreadContext());
    }

    @Test
    public void testLogEvent() {
    }

    @Test
    public void testCreateEvent() {
    }

    @Test
    public void testIsContextValid() {
        XTraceContext.clearThreadContext();
        Assert.assertFalse(XTraceContext.isValid());
        XTraceContext.setThreadContext(new XTraceMetadata(new TaskID(4), 1234));
        Assert.assertTrue(XTraceContext.isValid());
    }

    @Test
    public void testStartProcess() {
    }
}

