/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.xtrace.reporting;

import edu.berkeley.xtrace.XTraceMetadata;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Report {
    private StringBuilder buf;
    private HashMap<String, List<String>> map;

    public Report() {
        this.buf = new StringBuilder("X-Trace Report ver 1.0\n");
        this.map = null;
    }

    private Report(String s) {
        this.buf = new StringBuilder(s);
        try {
            if (s.charAt(s.length() - 1) != '\n') {
                this.buf.append("\n");
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.map = null;
    }

    public void put(String key, String value, boolean append) {
        if (append && this.map == null) {
            this.buf.append(key + ": " + value + "\n");
            return;
        }
        if (this.map == null) {
            this.convertToMap();
        }
        List<String> values = this.map.containsKey(key) && append ? this.map.get(key) : new ArrayList<String>();
        values.add(value);
        this.map.put(key, values);
    }

    public void put(String key, String value) {
        this.put(key, value, true);
    }

    public void remove(String key) {
        this.convertToMap();
        this.map.remove(key);
    }

    public XTraceMetadata getMetadata() {
        this.convertToMap();
        List<String> xtrlist = this.map.get("X-Trace");
        if (xtrlist == null || xtrlist.size() < 1) {
            return null;
        }
        String xtrstr = xtrlist.iterator().next();
        XTraceMetadata xtr = null;
        try {
            xtr = XTraceMetadata.createFromString(xtrstr);
        }
        catch (Exception e) {
            return null;
        }
        return xtr;
    }

    public List<String> get(String key) {
        this.convertToMap();
        return this.map.get(key);
    }

    public String toString() {
        if (this.map == null) {
            return this.buf.toString();
        }
        StringBuilder buf = new StringBuilder("X-Trace Report ver 1.0\n");
        for (Map.Entry<String, List<String>> entry : this.map.entrySet()) {
            for (String v : entry.getValue()) {
                buf.append(entry.getKey() + ": " + v + "\n");
            }
        }
        return buf.toString();
    }

    public static Report createFromString(String s) {
        return new Report(s);
    }

    private void convertToMap() {
        if (this.map != null) {
            return;
        }
        this.map = new HashMap();
        BufferedReader in = new BufferedReader(new StringReader(this.buf.toString()));
        try {
            String firstLine = in.readLine();
            if (!firstLine.equals("X-Trace Report ver 1.0")) {
                this.buf = new StringBuilder("X-Trace Report ver 1.0\n");
                this.map = null;
            }
        }
        catch (IOException e) {
            this.buf = new StringBuilder("X-Trace Report ver 1.0\n");
            this.map = null;
        }
        String line = null;
        try {
            while ((line = in.readLine()) != null) {
                int idx = line.indexOf(":");
                if (idx < 0) continue;
                String key = line.substring(0, idx).trim();
                String value = line.substring(idx + 1, line.length()).trim();
                this.put(key, value);
            }
        }
        catch (IOException e) {
            this.buf = new StringBuilder("X-Trace Report ver 1.0\n");
            this.map = null;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Report)) {
            return false;
        }
        Report r = (Report)o;
        return this.toString().trim().equalsIgnoreCase(r.toString().trim());
    }
}

