/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.xtrace.reporting;

import edu.berkeley.xtrace.TaskID;
import edu.berkeley.xtrace.XTraceMetadata;
import edu.berkeley.xtrace.reporting.Report;
import edu.berkeley.xtrace.reporting.Reporter;
import java.util.Random;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import org.apache.log4j.Logger;
import org.junit.Test;

public final class ReportLoadTest {
    private static final Logger LOG = Logger.getLogger(ReportLoadTest.class);
    private static int testDuration;
    private static int numThreads;
    private static CyclicBarrier barrier;
    private static Worker[] workers;

    public static void main(String[] args) {
        ReportLoadTest.out("X-Trace report infrastructure load test");
        if (args.length == 0 || args[0].equalsIgnoreCase("--help")) {
            ReportLoadTest.usage();
            System.exit(1);
        } else if (args.length == 2) {
            testDuration = Integer.parseInt(args[0]);
            numThreads = Integer.parseInt(args[1]);
        } else {
            ReportLoadTest.usage();
            System.exit(1);
        }
        ReportLoadTest.performTest();
    }

    private static void performTest() {
        int i;
        barrier = new CyclicBarrier(numThreads);
        workers = new Worker[numThreads];
        for (int i2 = 0; i2 < numThreads; ++i2) {
            ReportLoadTest.workers[i2] = new Worker();
            workers[i2].start();
        }
        try {
            Thread.sleep(testDuration * 1000);
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted", e);
        }
        for (i = 0; i < workers.length; ++i) {
            workers[i].shutdown();
        }
        for (i = 0; i < workers.length; ++i) {
            try {
                workers[i].join();
                continue;
            }
            catch (InterruptedException e) {
                LOG.warn("Interrupted", e);
            }
        }
        for (i = 0; i < workers.length; ++i) {
            ReportLoadTest.out("Worker " + i + ": " + workers[i].numSent());
        }
    }

    private static void usage() {
        ReportLoadTest.out("ReportLoadTest --help");
        ReportLoadTest.out("ReportLoadTest <testDuration> <numThreads>");
    }

    private static void out(String s) {
        System.out.println(s);
    }

    @Test
    public void nullTest() {
    }

    static class Worker
    extends Thread {
        private Random r = new Random();
        private TaskID task = new TaskID(4);
        private boolean shouldStop = false;
        private int numSent;

        Worker() {
        }

        public void shutdown() {
            this.shouldStop = true;
        }

        public int numSent() {
            return this.numSent;
        }

        @Override
        public void run() {
            Reporter c = Reporter.getReporter();
            try {
                barrier.await();
            }
            catch (InterruptedException e) {
                LOG.fatal("Interrupted", e);
            }
            catch (BrokenBarrierException e) {
                LOG.fatal("Broken", e);
            }
            this.numSent = 0;
            while (!this.shouldStop) {
                Report r = this.randomReport(this.task);
                c.sendReport(r);
            }
        }

        private Report randomReport(TaskID task) {
            Report report = new Report();
            int numKeys = this.r.nextInt(15);
            for (int i = 0; i < numKeys; ++i) {
                report.put("Key" + i, this.randomString(10 + this.r.nextInt(20)));
            }
            report.put("Timestamp", "" + System.currentTimeMillis());
            report.put("Sequence", "" + this.numSent++);
            report.put("X-Trace", new XTraceMetadata(task, this.r.nextInt()).toString());
            report.put("Tag", "loadtest");
            report.put("Title", "Load Test");
            return report;
        }

        private String randomString(int length) {
            char[] ar = new char[length];
            for (int i = 0; i < length; ++i) {
                ar[i] = (char)(97 + this.r.nextInt(25));
            }
            return new String(ar);
        }
    }
}

