/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.xtrace.reporting;

import edu.berkeley.xtrace.reporting.Report;
import edu.berkeley.xtrace.reporting.Reporter;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import org.apache.log4j.Logger;

public final class TcpReporter
extends Reporter {
    private static final Logger LOG = Logger.getLogger(TcpReporter.class);
    private Socket socket;
    private DataOutputStream out;

    TcpReporter() {
        LOG.info("Creating TcpReportingContext");
        InetAddress host = null;
        int port = 0;
        String tcpDest = System.getProperty("xtrace.tcpdest");
        if (tcpDest == null) {
            LOG.warn("TcpReportingContext was used, but no xtrace.tcpdest  system property has been set. X-Trace reports  will be ignored. Please specify the command line option -Dxtrace.tcpdest=host:port to provide a destination for X-Trace reports.");
            return;
        }
        try {
            String[] split = tcpDest.split(":");
            host = InetAddress.getByName(split[0]);
            port = Integer.parseInt(split[1]);
        }
        catch (Exception e) {
            LOG.warn("Invalid xtrace.tcpdest property. Expected host:port.", e);
            System.exit(1);
        }
        try {
            this.socket = new Socket(host, port);
            this.out = new DataOutputStream(this.socket.getOutputStream());
        }
        catch (Exception se) {
            LOG.warn("Failed to create X-Trace TCP socket", se);
            this.socket = null;
        }
    }

    @Override
    public synchronized void close() {
        if (this.socket != null) {
            LOG.info("Closing TcpReporter");
            try {
                this.out.flush();
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.socket = null;
        }
    }

    @Override
    public synchronized void flush() {
        super.flush();
        if (this.socket != null) {
            try {
                this.out.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public synchronized void sendReport(Report r) {
        try {
            if (this.socket != null) {
                byte[] bytes = r.toString().getBytes("UTF-8");
                this.out.writeInt(bytes.length);
                this.out.write(bytes);
            }
        }
        catch (IOException e) {
            LOG.warn("Couldn't send report", e);
            this.close();
        }
    }
}

