/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.xtrace.server;

import edu.berkeley.xtrace.XTraceException;
import edu.berkeley.xtrace.server.ReportSource;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import org.apache.log4j.Logger;

public class NonblockingTcpReportSource
implements ReportSource {
    private static final Logger LOG = Logger.getLogger(NonblockingTcpReportSource.class);
    private static final int MAX_REPORT_LENGTH = 262144;
    private int tcpport;
    private BlockingQueue<String> q;
    private ServerSocketChannel serverChannel;
    private Selector selector;
    private ByteBuffer readBuffer = ByteBuffer.allocateDirect(262144);

    @Override
    public void initialize() throws XTraceException {
        String tcpportstr = System.getProperty("xtrace.backend.tcpport", "7831");
        try {
            this.tcpport = Integer.parseInt(tcpportstr);
        }
        catch (NumberFormatException nfe) {
            LOG.warn("Invalid tcp report port: " + tcpportstr, nfe);
            this.tcpport = 7831;
        }
        try {
            this.selector = SelectorProvider.provider().openSelector();
            this.serverChannel = ServerSocketChannel.open();
            this.serverChannel.configureBlocking(false);
            this.serverChannel.socket().bind(new InetSocketAddress("0.0.0.0", this.tcpport));
            this.serverChannel.register(this.selector, 16);
        }
        catch (IOException e) {
            throw new XTraceException("Unable to open TCP server socket", e);
        }
    }

    @Override
    public void setReportQueue(BlockingQueue<String> q) {
        this.q = q;
    }

    @Override
    public void shutdown() {
        try {
            this.serverChannel.close();
            this.selector.close();
        }
        catch (IOException e) {
            LOG.warn("Unable to close TCP server socket", e);
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                block3: while (true) {
                    this.selector.select();
                    Iterator<SelectionKey> iter = this.selector.selectedKeys().iterator();
                    while (true) {
                        if (!iter.hasNext()) continue block3;
                        SelectionKey key = iter.next();
                        iter.remove();
                        if (!key.isValid()) continue;
                        if (key.isAcceptable()) {
                            this.accept(key);
                            continue;
                        }
                        if (!key.isReadable()) continue;
                        this.read(key);
                    }
                    break;
                }
            }
            catch (IOException e) {
                LOG.warn("Error in select loop", e);
                continue;
            }
            break;
        }
    }

    private void accept(SelectionKey key) throws IOException {
        SocketChannel channel = ((ServerSocketChannel)key.channel()).accept();
        channel.configureBlocking(false);
        channel.register(this.selector, 1);
    }

    private void read(SelectionKey key) throws IOException {
        ReadHandler handler = (ReadHandler)key.attachment();
        if (handler == null) {
            handler = new ReadHandler(key);
            key.attach(handler);
        }
        handler.handleRead();
    }

    private final class ReadHandler {
        private final SelectionKey key;
        private int msgPos = 0;
        private byte[] msgBuf = null;
        private int lengthPos = 0;
        private byte[] lengthBuf = new byte[4];

        public ReadHandler(SelectionKey key) {
            this.key = key;
        }

        public void handleRead() throws IOException {
            SocketChannel channel = (SocketChannel)this.key.channel();
            NonblockingTcpReportSource.this.readBuffer.clear();
            int numBytes = 0;
            try {
                numBytes = channel.read(NonblockingTcpReportSource.this.readBuffer);
            }
            catch (IOException e) {
                this.key.cancel();
                channel.close();
                return;
            }
            if (numBytes < 0) {
                this.key.cancel();
                channel.close();
                return;
            }
            NonblockingTcpReportSource.this.readBuffer.flip();
            while (NonblockingTcpReportSource.this.readBuffer.hasRemaining()) {
                int num;
                if (this.msgBuf != null) {
                    num = Math.min(NonblockingTcpReportSource.this.readBuffer.remaining(), this.msgBuf.length - this.msgPos);
                    NonblockingTcpReportSource.this.readBuffer.get(this.msgBuf, this.msgPos, num);
                    this.msgPos += num;
                    if (this.msgPos != this.msgBuf.length) continue;
                    String message = new String(this.msgBuf, 0, this.msgBuf.length, "UTF-8");
                    NonblockingTcpReportSource.this.q.offer(message);
                    this.msgBuf = null;
                    this.msgPos = 0;
                    continue;
                }
                num = Math.min(NonblockingTcpReportSource.this.readBuffer.remaining(), this.lengthBuf.length - this.lengthPos);
                NonblockingTcpReportSource.this.readBuffer.get(this.lengthBuf, this.lengthPos, num);
                this.lengthPos += num;
                if (this.lengthPos != this.lengthBuf.length) continue;
                int length = new DataInputStream(new ByteArrayInputStream(this.lengthBuf)).readInt();
                if (length <= 0 || length > 262144) {
                    Socket sock = channel.socket();
                    LOG.warn("Closing ReadReportsThread for " + sock.getInetAddress() + ":" + sock.getPort() + " due to invalid length: " + length);
                    this.key.cancel();
                    channel.close();
                    return;
                }
                this.lengthPos = 0;
                this.msgBuf = new byte[length];
                this.msgPos = 0;
            }
        }
    }
}

