/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.xtrace.server;

import com.facebook.thrift.TException;
import com.facebook.thrift.server.TThreadPoolServer;
import com.facebook.thrift.transport.TServerSocket;
import com.facebook.thrift.transport.TServerTransport;
import com.facebook.thrift.transport.TTransportException;
import edu.berkeley.xtrace.XTraceException;
import edu.berkeley.xtrace.reporting.XTraceReporter;
import edu.berkeley.xtrace.server.ReportSource;
import java.util.concurrent.BlockingQueue;
import org.apache.log4j.Logger;

public class ThriftReportSource
implements ReportSource {
    private static final Logger LOG = Logger.getLogger(ThriftReportSource.class);
    static BlockingQueue<String> q;
    private int thriftport;
    private TThreadPoolServer server;
    TServerTransport serverTransport;

    @Override
    public void initialize() throws XTraceException {
        String thriftportstr = System.getProperty("xtrace.backend.thriftport", "7832");
        try {
            this.thriftport = Integer.parseInt(thriftportstr);
        }
        catch (NumberFormatException nfe) {
            LOG.warn("Invalid thrift report port: " + this.thriftport, nfe);
            this.thriftport = 7832;
        }
        XTraceReporterHandler handler = new XTraceReporterHandler();
        XTraceReporter.Processor processor = new XTraceReporter.Processor(handler);
        try {
            this.serverTransport = new TServerSocket(this.thriftport);
        }
        catch (TTransportException e) {
            throw new XTraceException("Unable to open Thrift server", e);
        }
        this.server = new TThreadPoolServer(processor, this.serverTransport);
    }

    @Override
    public void setReportQueue(BlockingQueue<String> q) {
        ThriftReportSource.q = q;
    }

    @Override
    public void shutdown() {
        this.serverTransport.close();
    }

    @Override
    public void run() {
        LOG.info("Starting the Thrift report source on port " + this.thriftport);
        this.server.serve();
    }

    public static class XTraceReporterHandler
    implements XTraceReporter.Iface {
        private static final Logger LOG = Logger.getLogger(XTraceReporterHandler.class);

        @Override
        public void ping() throws TException {
            LOG.info("Received ping() request");
        }

        @Override
        public void sendReport(String report) throws TException {
            LOG.debug("Received report: " + report);
            q.offer(report);
        }
    }
}

