/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.nagios;

import java.util.Map;
import javax.management.Notification;
import org.apache.log4j.nagios.NagiosAlertListenerMBean;
import org.apache.log4j.nagios.NagiosAppender;
import org.jboss.monitor.JBossMonitorNotification;
import org.jboss.monitor.alerts.JBossAlertListener;
import org.jboss.util.Strings;

public class NagiosAlertListener
extends JBossAlertListener
implements NagiosAlertListenerMBean {
    private NagiosAppender nagiosAppender = null;
    private String nagiosHost = null;
    private String nagiosPort = null;
    private String nscaConfigFile = null;
    private String messageTemplate = "Message Template Not Set";
    private int nagiosLevel = -1;
    private boolean useShortHostname = false;
    private String virtualHostname = null;
    private String nagiosServiceName = "NOT_SET";

    public String getName() {
        return "Nagios Alert";
    }

    public void setNscaConfigFile(String nscaConfigFile) {
        this.nscaConfigFile = nscaConfigFile;
    }

    public void setNagiosHost(String host) {
        this.nagiosHost = host;
    }

    public void setNagiosPort(String port) {
        this.nagiosPort = port;
    }

    public void setNagiosLevelOK(String ignore) throws IllegalStateException {
        if (this.nagiosLevel != -1) {
            throw new IllegalStateException("NagiosAlertListener.setNagiosLevelOK(): level has already been set");
        }
        this.nagiosLevel = 0;
    }

    public void setNagiosLevelWARN(String ignore) {
        if (this.nagiosLevel != -1) {
            throw new IllegalStateException("NagiosAlertListener.setNagiosLevelWARN(): level has already been set");
        }
        this.nagiosLevel = 1;
    }

    public void setNagiosLevelCRITICAL(String ignore) {
        if (this.nagiosLevel != -1) {
            throw new IllegalStateException("NagiosAlertListener.setNagiosLevelCRITICAL(): level has already been set");
        }
        this.nagiosLevel = 2;
    }

    public void setNagiosLevelUNKNOWN(String ignore) {
        if (this.nagiosLevel != -1) {
            throw new IllegalStateException("NagiosAlertListener.setNagiosLevelUNKNOWN(): level has already been set");
        }
        this.nagiosLevel = 3;
    }

    public void setNagiosVirtualHost(String virtualHostname) {
        this.virtualHostname = virtualHostname;
    }

    public void setNagiosServiceName(String serviceName) {
        this.nagiosServiceName = serviceName;
    }

    public void setUseShortHostname(String ignore) {
        this.useShortHostname = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        NagiosAlertListener nagiosAlertListener = this;
        synchronized (nagiosAlertListener) {
            if (null != this.nagiosAppender) {
                return;
            }
            this.nagiosAppender = new NagiosAppender();
            this.nagiosAppender.setHost(this.nagiosHost);
            this.nagiosAppender.setPort(this.nagiosPort);
            if (this.useShortHostname) {
                this.nagiosAppender.setUseShortHostName(true);
            } else {
                this.nagiosAppender.setUseShortHostName(false);
            }
            this.nagiosAppender.setServiceNameDefault(this.nagiosServiceName);
            if (null != this.virtualHostname) {
                this.nagiosAppender.setUseMDCHostName(true);
                this.nagiosAppender.setMDCHostNameKey("NagiosAlertHostname");
                this.nagiosAppender.setInitializeMDCHostNameValue(this.virtualHostname);
            }
            this.nagiosAppender.setConfigFile(this.nscaConfigFile);
            this.nagiosAppender.activateOptions();
        }
    }

    public void handleNotification(Notification notification, Object handback) {
        if (!(notification instanceof JBossMonitorNotification)) {
            return;
        }
        if (null == this.nagiosAppender) {
            this.init();
        }
        Map substitutions = ((JBossMonitorNotification)notification).substitutionMap();
        if (this.useShortHostname) {
            substitutions.put("HOSTNAME", this.nagiosAppender.getMyHostName(true));
        } else {
            substitutions.put("HOSTNAME", this.nagiosAppender.getMyHostName(false));
        }
        String message = Strings.subst((String)this.messageTemplate, (Map)substitutions, (String)"%(", (String)")");
        this.nagiosAppender.send(message, this.nagiosLevel);
    }

    public String getMessageTemplate() {
        return this.messageTemplate;
    }

    public void setMessageTemplate(String messageTemplate) {
        this.messageTemplate = messageTemplate;
    }
}

