/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.nagios;

import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.nagios.NagiosAppender;

public class NscaSend {
    private NagiosAppender nagiosAppender = null;
    private String nagiosHost = null;
    private String nagiosPort = null;
    private String nscaConfigFile = null;
    private boolean useShortHostname = false;
    private String virtualHostname = null;
    private String nagiosServiceName = "NOT_SET";
    private Properties props = new Properties();

    public void setNscaConfigFile(String nscaConfigFile) {
        this.nscaConfigFile = nscaConfigFile;
    }

    public void setNagiosHost(String host) {
        this.nagiosHost = host;
    }

    public void setNagiosPort(String port) {
        this.nagiosPort = port;
    }

    public void setNagiosVirtualHost(String virtualHostname) {
        this.virtualHostname = virtualHostname;
    }

    public void setNagiosServiceName(String serviceName) {
        this.nagiosServiceName = serviceName;
    }

    public void setUseShortHostname() {
        this.useShortHostname = true;
    }

    public void setMessageProperties(Properties customProps) {
        this.props = customProps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        NscaSend nscaSend = this;
        synchronized (nscaSend) {
            if (null != this.nagiosAppender) {
                return;
            }
            this.nagiosAppender = new NagiosAppender();
            if (null != this.props && null == this.props.getProperty("HOSTNAME")) {
                this.props.put("HOSTNAME", this.nagiosAppender.getMyHostName(this.useShortHostname));
            }
            this.nagiosAppender.setHost(this.nagiosHost);
            this.nagiosAppender.setPort(this.nagiosPort);
            if (this.useShortHostname) {
                this.nagiosAppender.setUseShortHostName(true);
            } else {
                this.nagiosAppender.setUseShortHostName(false);
            }
            this.nagiosAppender.setServiceNameDefault(this.nagiosServiceName);
            if (null != this.virtualHostname) {
                this.nagiosAppender.setUseMDCHostName(true);
                this.nagiosAppender.setMDCHostNameKey("NagiosAlertHostname");
                this.nagiosAppender.setInitializeMDCHostNameValue(this.virtualHostname);
            }
            this.nagiosAppender.setConfigFile(this.nscaConfigFile);
            this.nagiosAppender.activateOptions();
        }
    }

    public void send(int level, String message) {
        if (level < 0 || level > 3) {
            return;
        }
        if (null == this.nagiosAppender) {
            this.init();
        }
        try {
            int count;
            ReplacementInputStream input = new ReplacementInputStream(new ByteArrayInputStream(message.getBytes()), this.props);
            byte[] buffer = new byte[1024];
            while ((count = ((InputStream)input).read(buffer)) > -1) {
            }
            this.nagiosAppender.send(new String(buffer), level);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        System.out.println("creating instance of NscaSend ...");
        NscaSend nscaSend = new NscaSend();
        nscaSend.setNscaConfigFile("conf/nsca_send_clear.cfg");
        nscaSend.setNagiosHost("localhost");
        nscaSend.setNagiosPort("5667");
        nscaSend.setNagiosVirtualHost("production");
        nscaSend.setNagiosServiceName("MyApplication");
        nscaSend.setUseShortHostname();
        nscaSend.send(2, "server: [HOSTNAME]: something bad just happened ....");
        Properties customProps = new Properties();
        customProps.put("FOO", "foo");
        customProps.put("BAR", "bar");
        nscaSend.setMessageProperties(customProps);
        nscaSend.send(2, "server: [HOSTNAME]: checking custom properties .... do you see foobar?: [FOO][BAR]");
    }

    private class ReplacementInputStream
    extends FilterInputStream {
        protected Properties properties;
        protected int start = 91;
        protected int stop = 93;
        protected final int escape = 96;
        protected boolean escaping = false;
        protected boolean encodeQuotes = true;
        private transient String key = "";

        public ReplacementInputStream(InputStream input, Properties properties) {
            this(input, properties, 91, 93);
        }

        public ReplacementInputStream(InputStream input, Properties properties, int start, int stop) {
            super(input);
            this.properties = properties;
            this.start = start;
            this.stop = stop;
        }

        private int popKey() {
            char chr = this.key.charAt(0);
            this.key = this.key.substring(1);
            return chr;
        }

        public int read() throws IOException {
            if (this.properties == null) {
                return this.in.read();
            }
            if (this.key.length() > 0) {
                return this.popKey();
            }
            do {
                int more;
                int chr;
                if ((chr = this.in.read()) == 96) {
                    boolean bl = this.escaping = !this.escaping;
                    if (this.escaping) continue;
                }
                if (chr != this.start || this.escaping) {
                    this.escaping = false;
                    return chr;
                }
                this.escaping = false;
                while ((more = this.in.read()) != this.stop) {
                    this.key = this.key + (char)more;
                }
                if (this.key.length() <= 0) continue;
                this.key = this.encodeQuotes(this.properties.getProperty(this.key, ""));
            } while (this.key.length() == 0);
            return this.popKey();
        }

        public int read(byte[] buffer, int off, int len) throws IOException {
            int count;
            if (len <= 0) {
                return 0;
            }
            int chr = this.read();
            if (chr == -1) {
                return -1;
            }
            buffer[off] = (byte)chr;
            try {
                for (count = 1; count < len && (chr = this.read()) != -1; ++count) {
                    if (buffer == null) continue;
                    buffer[off + count] = (byte)chr;
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            return count;
        }

        protected String encodeQuotes(String val) {
            if (!this.encodeQuotes) {
                return val;
            }
            StringBuffer buf = new StringBuffer(val.length());
            for (int i = 0; i < val.length(); ++i) {
                char ch = val.charAt(i);
                if (ch == '\"') {
                    buf.append("&quot");
                    continue;
                }
                buf.append(ch);
            }
            return buf.toString();
        }
    }
}

