/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.pig.backend.hadoop.datastorage.ConfigurationUtil;

public class MiniCluster {
    private MiniDFSCluster m_dfs = null;
    private MiniMRCluster m_mr = null;
    private FileSystem m_fileSys = null;
    private JobConf m_conf = null;
    private static final MiniCluster INSTANCE = new MiniCluster();

    private MiniCluster() {
        this.setupMiniDfsAndMrClusters();
    }

    private void setupMiniDfsAndMrClusters() {
        try {
            int dataNodes = 4;
            int taskTrackers = 4;
            Configuration config = new Configuration();
            this.m_dfs = new MiniDFSCluster(config, 4, true, null);
            this.m_fileSys = this.m_dfs.getFileSystem();
            this.m_mr = new MiniMRCluster(4, this.m_fileSys.getUri().toString(), 1);
            File conf_dir = new File(System.getProperty("user.home"), "pigtest/conf/");
            conf_dir.mkdirs();
            File conf_file = new File(conf_dir, "hadoop-site.xml");
            this.m_conf = this.m_mr.createJobConf();
            this.m_conf.setInt("mapred.submit.replication", 2);
            this.m_conf.set("dfs.datanode.address", "0.0.0.0:0");
            this.m_conf.set("dfs.datanode.http.address", "0.0.0.0:0");
            this.m_conf.writeXml((OutputStream)new FileOutputStream(conf_file));
            System.setProperty("cluster", this.m_conf.get("mapred.job.tracker"));
            System.setProperty("namenode", this.m_conf.get("fs.default.name"));
            System.setProperty("junit.hadoop.conf", conf_dir.getPath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static MiniCluster buildCluster() {
        return INSTANCE;
    }

    protected void finalize() {
        this.shutdownMiniDfsAndMrClusters();
    }

    private void shutdownMiniDfsAndMrClusters() {
        try {
            if (this.m_fileSys != null) {
                this.m_fileSys.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.m_dfs != null) {
            this.m_dfs.shutdown();
        }
        if (this.m_mr != null) {
            this.m_mr.shutdown();
        }
    }

    public Properties getProperties() {
        return ConfigurationUtil.toProperties((Configuration)this.m_conf);
    }

    public void setProperty(String name, String value) {
        this.m_conf.set(name, value);
    }

    public FileSystem getFileSystem() {
        return this.m_fileSys;
    }
}

