/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.util.List;
import org.apache.pig.impl.logicalLayer.BinaryExpressionOperator;
import org.apache.pig.impl.logicalLayer.ExpressionOperator;
import org.apache.pig.impl.logicalLayer.LOBinCond;
import org.apache.pig.impl.logicalLayer.LOCast;
import org.apache.pig.impl.logicalLayer.LOCogroup;
import org.apache.pig.impl.logicalLayer.LOConst;
import org.apache.pig.impl.logicalLayer.LOCross;
import org.apache.pig.impl.logicalLayer.LODistinct;
import org.apache.pig.impl.logicalLayer.LOFilter;
import org.apache.pig.impl.logicalLayer.LOForEach;
import org.apache.pig.impl.logicalLayer.LOLimit;
import org.apache.pig.impl.logicalLayer.LOLoad;
import org.apache.pig.impl.logicalLayer.LOProject;
import org.apache.pig.impl.logicalLayer.LORegexp;
import org.apache.pig.impl.logicalLayer.LOSort;
import org.apache.pig.impl.logicalLayer.LOSplit;
import org.apache.pig.impl.logicalLayer.LOStore;
import org.apache.pig.impl.logicalLayer.LOUnion;
import org.apache.pig.impl.logicalLayer.LOUserFunc;
import org.apache.pig.impl.logicalLayer.LOVisitor;
import org.apache.pig.impl.logicalLayer.LogicalOperator;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.logicalLayer.UnaryExpressionOperator;
import org.apache.pig.impl.plan.DependencyOrderWalker;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.impl.plan.OperatorPlan;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;

public class OpLimitOptimizerPrinter
extends LOVisitor {
    private StringBuilder sb = new StringBuilder();

    public OpLimitOptimizerPrinter(LogicalPlan plan) {
        super(plan, (PlanWalker)new DependencyOrderWalker((OperatorPlan)plan));
    }

    protected void visit(LogicalOperator op) {
        this.appendEdges(op);
    }

    protected void visit(ExpressionOperator op) {
        this.appendEdges((LogicalOperator)op);
    }

    protected void visit(BinaryExpressionOperator op) {
        this.appendEdges((LogicalOperator)op);
    }

    protected void visit(UnaryExpressionOperator op) {
        this.appendEdges((LogicalOperator)op);
    }

    protected void visit(LOCogroup op) throws VisitorException {
        this.appendEdges((LogicalOperator)op);
    }

    protected void visit(LOForEach op) throws VisitorException {
        this.appendOp((LogicalOperator)op);
        boolean hasFlatten = false;
        List mFlatten = op.getFlatten();
        for (Boolean b : mFlatten) {
            if (!b.equals(true)) continue;
            hasFlatten = true;
        }
        if (hasFlatten) {
            this.sb.append(" [hasflat=\"true\"]");
        } else {
            this.sb.append(" [hasflat=\"false\"]");
        }
        this.sb.append(";\n");
        this.appendEdges((LogicalOperator)op);
    }

    protected void visit(LOSort op) {
        this.appendOp((LogicalOperator)op);
        this.sb.append(" [limit=\"" + op.getLimit() + "\"]");
        this.sb.append(";\n");
        this.appendEdges((LogicalOperator)op);
    }

    protected void visit(LOFilter op) throws VisitorException {
        this.appendEdges((LogicalOperator)op);
    }

    protected void visit(LOSplit op) {
        this.appendEdges((LogicalOperator)op);
    }

    protected void visit(LOUserFunc op) {
        this.appendEdges((LogicalOperator)op);
    }

    protected void visit(LOBinCond op) {
        this.appendEdges((LogicalOperator)op);
    }

    protected void visit(LOCross op) {
        this.appendEdges((LogicalOperator)op);
    }

    protected void visit(LOUnion op) {
        this.appendEdges((LogicalOperator)op);
    }

    protected void visit(LOCast op) {
        this.appendEdges((LogicalOperator)op);
    }

    protected void visit(LOLoad op) {
        this.appendEdges((LogicalOperator)op);
    }

    protected void visit(LOStore op) {
        this.appendEdges((LogicalOperator)op);
    }

    protected void visit(LOConst op) {
        this.appendEdges((LogicalOperator)op);
    }

    protected void visit(LORegexp op) {
        this.appendEdges((LogicalOperator)op);
    }

    protected void visit(LOProject op) {
        this.appendEdges((LogicalOperator)op);
    }

    protected void visit(LODistinct op) {
        this.appendEdges((LogicalOperator)op);
    }

    protected void visit(LOLimit op) {
        this.appendOp((LogicalOperator)op);
        this.sb.append(" [limit=\"" + op.getLimit() + "\"]");
        this.sb.append(";\n");
        this.appendEdges((LogicalOperator)op);
    }

    private void appendOp(LogicalOperator op) {
        this.sb.append("    " + op.getClass().getSimpleName() + op.getOperatorKey().getId());
    }

    private void appendEdges(LogicalOperator op) {
        List list = ((LogicalPlan)this.mCurrentWalker.getPlan()).getSuccessors((Operator)op);
        if (list != null) {
            for (LogicalOperator tmp : list) {
                this.sb.append("    " + op.getClass().getSimpleName() + op.getOperatorKey().getId() + " -> ");
                this.sb.append(tmp.getClass().getSimpleName() + tmp.getOperatorKey().getId() + ";\n");
            }
        }
    }

    public String printToString() {
        try {
            this.visit();
        }
        catch (VisitorException vse) {
            throw new AssertionError((Object)"Error while transforming type graph to text");
        }
        return this.sb.toString();
    }
}

