/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import junit.framework.TestCase;
import org.apache.pig.ExecType;
import org.apache.pig.PigServer;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.Tuple;
import org.apache.pig.test.MiniCluster;
import org.apache.pig.test.Util;
import org.junit.After;
import org.junit.Before;

public class TestAccumulator
extends TestCase {
    private static final String INPUT_FILE = "AccumulatorInput.txt";
    private static final String INPUT_FILE2 = "AccumulatorInput2.txt";
    private static final String INPUT_FILE3 = "AccumulatorInput3.txt";
    private static final String INPUT_FILE4 = "AccumulatorInput4.txt";
    private PigServer pigServer;
    private MiniCluster cluster = MiniCluster.buildCluster();

    public TestAccumulator() throws ExecException, IOException {
        this.pigServer = new PigServer(ExecType.MAPREDUCE, this.cluster.getProperties());
        this.pigServer.getPigContext().getProperties().setProperty("pig.accumulative.batchsize", "2");
        this.pigServer.getPigContext().getProperties().setProperty("pig.exec.batchsize", "2");
        this.pigServer.getPigContext().getProperties().setProperty("pig.exec.nocombiner", "true");
        this.pigServer.getPigContext().getProperties().setProperty("mapred.map.max.attempts", "1");
        this.pigServer.getPigContext().getProperties().setProperty("mapred.reduce.max.attempts", "1");
    }

    @Before
    public void setUp() throws Exception {
        this.pigServer.getPigContext().getProperties().remove("opt.accumulator");
        this.createFiles();
    }

    private void createFiles() throws IOException {
        PrintWriter w = new PrintWriter(new FileWriter(INPUT_FILE));
        w.println("100\tapple");
        w.println("200\torange");
        w.println("300\tstrawberry");
        w.println("300\tpear");
        w.println("100\tapple");
        w.println("300\tpear");
        w.println("400\tapple");
        w.close();
        Util.copyFromLocalToCluster(this.cluster, INPUT_FILE, INPUT_FILE);
        w = new PrintWriter(new FileWriter(INPUT_FILE2));
        w.println("100\t");
        w.println("100\t");
        w.println("200\t");
        w.println("200\t");
        w.println("300\tstrawberry");
        w.close();
        Util.copyFromLocalToCluster(this.cluster, INPUT_FILE2, INPUT_FILE2);
        w = new PrintWriter(new FileWriter(INPUT_FILE3));
        w.println("100\t1.0");
        w.println("100\t2.0");
        w.println("200\t1.1");
        w.println("200\t2.1");
        w.println("100\t3.0");
        w.println("100\t4.0");
        w.println("200\t3.1");
        w.println("100\t5.0");
        w.println("300\t3.3");
        w.println("400\t");
        w.println("400\t");
        w.close();
        Util.copyFromLocalToCluster(this.cluster, INPUT_FILE3, INPUT_FILE3);
        w = new PrintWriter(new FileWriter(INPUT_FILE4));
        w.println("100\thttp://ibm.com,ibm");
        w.println("100\thttp://ibm.com,ibm");
        w.println("200\thttp://yahoo.com,yahoo");
        w.println("300\thttp://sun.com,sun");
        w.close();
        Util.copyFromLocalToCluster(this.cluster, INPUT_FILE4, INPUT_FILE4);
    }

    @After
    public void tearDown() throws Exception {
        new File(INPUT_FILE).delete();
        Util.deleteFile(this.cluster, INPUT_FILE);
        new File(INPUT_FILE2).delete();
        Util.deleteFile(this.cluster, INPUT_FILE2);
        new File(INPUT_FILE3).delete();
        Util.deleteFile(this.cluster, INPUT_FILE3);
        new File(INPUT_FILE4).delete();
        Util.deleteFile(this.cluster, INPUT_FILE4);
    }

    public void testAccumBasic() throws IOException {
        Tuple t;
        this.pigServer.registerQuery("A = load 'AccumulatorInput.txt' as (id:int, fruit);");
        this.pigServer.registerQuery("B = group A by id;");
        this.pigServer.registerQuery("C = foreach B generate group,  org.apache.pig.test.utils.AccumulatorBagCount(A);");
        HashMap<Integer, Integer> expected = new HashMap<Integer, Integer>();
        expected.put(100, 2);
        expected.put(200, 1);
        expected.put(300, 3);
        expected.put(400, 1);
        Iterator iter = this.pigServer.openIterator("C");
        while (iter.hasNext()) {
            t = (Tuple)iter.next();
            TestAccumulator.assertEquals(expected.get((Integer)t.get(0)), (Object)((Integer)t.get(1)));
        }
        this.pigServer.registerQuery("B = group A by id;");
        this.pigServer.registerQuery("C = foreach B generate group,  org.apache.pig.test.utils.AccumulatorBagCount(A), org.apache.pig.test.utils.BagCount(A);");
        try {
            iter = this.pigServer.openIterator("C");
            while (iter.hasNext()) {
                t = (Tuple)iter.next();
                TestAccumulator.assertEquals(expected.get((Integer)t.get(0)), (Object)((Integer)t.get(1)));
            }
            TestAccumulator.fail((String)"accumulator should not be called.");
        }
        catch (IOException e) {
            // empty catch block
        }
        this.pigServer.registerQuery("A = load 'AccumulatorInput.txt' as (id:int, fruit);");
        this.pigServer.registerQuery("B = load 'AccumulatorInput.txt' as (id:int, fruit);");
        this.pigServer.registerQuery("C = cogroup A by id, B by id;");
        this.pigServer.registerQuery("D = foreach C generate group,  org.apache.pig.test.utils.AccumulatorBagCount(A), org.apache.pig.test.utils.AccumulatorBagCount(B);");
        HashMap<Integer, String> expected2 = new HashMap<Integer, String>();
        expected2.put(100, "2,2");
        expected2.put(200, "1,1");
        expected2.put(300, "3,3");
        expected2.put(400, "1,1");
        iter = this.pigServer.openIterator("D");
        while (iter.hasNext()) {
            Tuple t2 = (Tuple)iter.next();
            TestAccumulator.assertEquals((String)((String)expected2.get((Integer)t2.get(0))), (String)(t2.get(1).toString() + "," + t2.get(2).toString()));
        }
    }

    public void testAccumWithNegative() throws IOException {
        this.pigServer.registerQuery("A = load 'AccumulatorInput.txt' as (id:int, fruit);");
        this.pigServer.registerQuery("B = group A by id;");
        this.pigServer.registerQuery("C = foreach B generate group,  -org.apache.pig.test.utils.AccumulatorBagCount(A);");
        HashMap<Integer, Integer> expected = new HashMap<Integer, Integer>();
        expected.put(100, -2);
        expected.put(200, -1);
        expected.put(300, -3);
        expected.put(400, -1);
        Iterator iter = this.pigServer.openIterator("C");
        while (iter.hasNext()) {
            Tuple t = (Tuple)iter.next();
            TestAccumulator.assertEquals(expected.get((Integer)t.get(0)), (Object)((Integer)t.get(1)));
        }
    }

    public void testAccumWithAdd() throws IOException {
        Tuple t;
        this.pigServer.registerQuery("A = load 'AccumulatorInput.txt' as (id:int, fruit);");
        this.pigServer.registerQuery("B = group A by id;");
        this.pigServer.registerQuery("C = foreach B generate group,  org.apache.pig.test.utils.AccumulatorBagCount(A)+1.0;");
        HashMap<Integer, Number> expected = new HashMap<Integer, Number>();
        expected.put(100, 3.0);
        expected.put(200, 2.0);
        expected.put(300, 4.0);
        expected.put(400, 2.0);
        Iterator iter = this.pigServer.openIterator("C");
        while (iter.hasNext()) {
            t = (Tuple)iter.next();
            TestAccumulator.assertEquals(expected.get((Integer)t.get(0)), (Object)((Double)t.get(1)));
        }
        this.pigServer.registerQuery("C = foreach B generate group,  org.apache.pig.test.utils.AccumulatorBagCount(A)+org.apache.pig.test.utils.AccumulatorBagCount(A);");
        expected = new HashMap();
        expected.put(100, 4);
        expected.put(200, 2);
        expected.put(300, 6);
        expected.put(400, 2);
        iter = this.pigServer.openIterator("C");
        while (iter.hasNext()) {
            t = (Tuple)iter.next();
            TestAccumulator.assertEquals(expected.get((Integer)t.get(0)), (Object)((Integer)t.get(1)));
        }
    }

    public void testAccumWithMinus() throws IOException {
        this.pigServer.registerQuery("A = load 'AccumulatorInput.txt' as (id:int, fruit);");
        this.pigServer.registerQuery("B = group A by id;");
        this.pigServer.registerQuery("C = foreach B generate group,  org.apache.pig.test.utils.AccumulatorBagCount(A)*3.0-org.apache.pig.test.utils.AccumulatorBagCount(A);");
        HashMap<Integer, Double> expected = new HashMap<Integer, Double>();
        expected.put(100, 4.0);
        expected.put(200, 2.0);
        expected.put(300, 6.0);
        expected.put(400, 2.0);
        Iterator iter = this.pigServer.openIterator("C");
        while (iter.hasNext()) {
            Tuple t = (Tuple)iter.next();
            TestAccumulator.assertEquals(expected.get((Integer)t.get(0)), (Object)((Double)t.get(1)));
        }
    }

    public void testAccumWithMod() throws IOException {
        this.pigServer.registerQuery("A = load 'AccumulatorInput.txt' as (id:int, fruit);");
        this.pigServer.registerQuery("B = group A by id;");
        this.pigServer.registerQuery("C = foreach B generate group,  org.apache.pig.test.utils.AccumulatorBagCount(A) % 2;");
        HashMap<Integer, Integer> expected = new HashMap<Integer, Integer>();
        expected.put(100, 0);
        expected.put(200, 1);
        expected.put(300, 1);
        expected.put(400, 1);
        Iterator iter = this.pigServer.openIterator("C");
        while (iter.hasNext()) {
            Tuple t = (Tuple)iter.next();
            TestAccumulator.assertEquals(expected.get((Integer)t.get(0)), (Object)((Integer)t.get(1)));
        }
    }

    public void testAccumWithDivide() throws IOException {
        this.pigServer.registerQuery("A = load 'AccumulatorInput.txt' as (id:int, fruit);");
        this.pigServer.registerQuery("B = group A by id;");
        this.pigServer.registerQuery("C = foreach B generate group,  org.apache.pig.test.utils.AccumulatorBagCount(A)/2;");
        HashMap<Integer, Integer> expected = new HashMap<Integer, Integer>();
        expected.put(100, 1);
        expected.put(200, 0);
        expected.put(300, 1);
        expected.put(400, 0);
        Iterator iter = this.pigServer.openIterator("C");
        while (iter.hasNext()) {
            Tuple t = (Tuple)iter.next();
            TestAccumulator.assertEquals(expected.get((Integer)t.get(0)), (Object)((Integer)t.get(1)));
        }
    }

    public void testAccumWithAnd() throws IOException {
        this.pigServer.registerQuery("A = load 'AccumulatorInput.txt' as (id:int, fruit);");
        this.pigServer.registerQuery("B = group A by id;");
        this.pigServer.registerQuery("C = foreach B generate group,  ((org.apache.pig.test.utils.AccumulatorBagCount(A)>1 and org.apache.pig.test.utils.AccumulatorBagCount(A)<3)?0:1);");
        HashMap<Integer, Integer> expected = new HashMap<Integer, Integer>();
        expected.put(100, 0);
        expected.put(200, 1);
        expected.put(300, 1);
        expected.put(400, 1);
        Iterator iter = this.pigServer.openIterator("C");
        while (iter.hasNext()) {
            Tuple t = (Tuple)iter.next();
            TestAccumulator.assertEquals(expected.get((Integer)t.get(0)), (Object)((Integer)t.get(1)));
        }
    }

    public void testAccumWithOr() throws IOException {
        this.pigServer.registerQuery("A = load 'AccumulatorInput.txt' as (id:int, fruit);");
        this.pigServer.registerQuery("B = group A by id;");
        this.pigServer.registerQuery("C = foreach B generate group,  ((org.apache.pig.test.utils.AccumulatorBagCount(A)>3 or org.apache.pig.test.utils.AccumulatorBagCount(A)<2)?0:1);");
        HashMap<Integer, Integer> expected = new HashMap<Integer, Integer>();
        expected.put(100, 1);
        expected.put(200, 0);
        expected.put(300, 1);
        expected.put(400, 0);
        Iterator iter = this.pigServer.openIterator("C");
        while (iter.hasNext()) {
            Tuple t = (Tuple)iter.next();
            TestAccumulator.assertEquals(expected.get((Integer)t.get(0)), (Object)((Integer)t.get(1)));
        }
    }

    public void testAccumWithRegexp() throws IOException {
        this.pigServer.registerQuery("A = load 'AccumulatorInput.txt' as (id:int, fruit);");
        this.pigServer.registerQuery("B = group A by id;");
        this.pigServer.registerQuery("C = foreach B generate group,  (((chararray)org.apache.pig.test.utils.AccumulatorBagCount(A)) matches '1*' ?0:1);");
        HashMap<Integer, Integer> expected = new HashMap<Integer, Integer>();
        expected.put(100, 1);
        expected.put(200, 0);
        expected.put(300, 1);
        expected.put(400, 0);
        Iterator iter = this.pigServer.openIterator("C");
        while (iter.hasNext()) {
            Tuple t = (Tuple)iter.next();
            TestAccumulator.assertEquals(expected.get((Integer)t.get(0)), (Object)((Integer)t.get(1)));
        }
    }

    public void testAccumWithIsNull() throws IOException {
        this.pigServer.registerQuery("A = load 'AccumulatorInput2.txt' as (id:int, fruit);");
        this.pigServer.registerQuery("B = group A by id;");
        this.pigServer.registerQuery("C = foreach B generate group,  ((chararray)org.apache.pig.test.utils.AccumulativeSumBag(A) is null?0:1);");
        HashMap<Integer, Integer> expected = new HashMap<Integer, Integer>();
        expected.put(100, 0);
        expected.put(200, 0);
        expected.put(300, 1);
        Iterator iter = this.pigServer.openIterator("C");
        while (iter.hasNext()) {
            Tuple t = (Tuple)iter.next();
            TestAccumulator.assertEquals(expected.get((Integer)t.get(0)), (Object)((Integer)t.get(1)));
        }
    }

    public void testAccumWithDistinct() throws IOException {
        this.pigServer.registerQuery("A = load 'AccumulatorInput.txt' as (id:int, f);");
        this.pigServer.registerQuery("B = group A by id;");
        this.pigServer.registerQuery("C = foreach B { D = distinct A; generate group, org.apache.pig.test.utils.AccumulatorBagCount(D)+1;};");
        HashMap<Integer, Integer> expected = new HashMap<Integer, Integer>();
        expected.put(100, 2);
        expected.put(200, 2);
        expected.put(300, 3);
        expected.put(400, 2);
        Iterator iter = this.pigServer.openIterator("C");
        while (iter.hasNext()) {
            Tuple t = (Tuple)iter.next();
            TestAccumulator.assertEquals(expected.get((Integer)t.get(0)), (Object)((Integer)t.get(1)));
        }
    }

    public void testAccumWithSort() throws IOException {
        this.pigServer.registerQuery("A = load 'AccumulatorInput.txt' as (id:int, f);");
        this.pigServer.registerQuery("B = foreach A generate id, f, id as t;");
        this.pigServer.registerQuery("C = group B by id;");
        this.pigServer.registerQuery("D = foreach C { E = order B by f; F = E.f; generate group, org.apache.pig.test.utils.AccumulativeSumBag(F);};");
        HashMap<Integer, String> expected = new HashMap<Integer, String>();
        expected.put(100, "(apple)(apple)");
        expected.put(200, "(orange)");
        expected.put(300, "(pear)(pear)(strawberry)");
        expected.put(400, "(apple)");
        Iterator iter = this.pigServer.openIterator("D");
        while (iter.hasNext()) {
            Tuple t = (Tuple)iter.next();
            TestAccumulator.assertEquals((String)((String)expected.get((Integer)t.get(0))), (String)((String)t.get(1)));
        }
    }

    public void testAccumWithBuildinAvg() throws IOException {
        HashMap<Integer, Double> expected = new HashMap<Integer, Double>();
        expected.put(100, 3.0);
        expected.put(200, 2.1);
        expected.put(300, 3.3);
        expected.put(400, null);
        String[] types = new String[]{"double", "float", "int", "long"};
        for (int i = 0; i < types.length; ++i) {
            if (i > 1) {
                expected.put(200, 2.0);
                expected.put(300, 3.0);
            }
            this.pigServer.registerQuery("A = load 'AccumulatorInput3.txt' as (id:int, v:" + types[i] + ");");
            this.pigServer.registerQuery("C = group A by id;");
            this.pigServer.registerQuery("D = foreach C generate group, AVG(A.v);");
            Iterator iter = this.pigServer.openIterator("D");
            while (iter.hasNext()) {
                Tuple t = (Tuple)iter.next();
                Double v = (Double)expected.get((Integer)t.get(0));
                if (v != null) {
                    TestAccumulator.assertEquals((double)v, (double)((Number)t.get(1)).doubleValue(), (double)1.0E-4);
                    continue;
                }
                TestAccumulator.assertEquals(null, (Object)t.get(1));
            }
        }
    }

    public void testAccumWithBuildin() throws IOException {
        this.pigServer.registerQuery("A = load 'AccumulatorInput3.txt' as (id:int, v:double);");
        this.pigServer.registerQuery("C = group A by id;");
        this.pigServer.registerQuery("D = foreach C generate group, SUM(A.v), COUNT(A.v), MIN(A.v), MAX(A.v);");
        HashMap<Integer, Double[]> expected = new HashMap<Integer, Double[]>();
        expected.put(100, new Double[]{15.0, 5.0, 1.0, 5.0});
        expected.put(200, new Double[]{6.3, 3.0, 1.1, 3.1});
        expected.put(300, new Double[]{3.3, 1.0, 3.3, 3.3});
        expected.put(400, new Double[]{null, 0.0, null, null});
        Iterator iter = this.pigServer.openIterator("D");
        while (iter.hasNext()) {
            Tuple t = (Tuple)iter.next();
            Double[] v = (Double[])expected.get((Integer)t.get(0));
            for (int i = 0; i < v.length; ++i) {
                if (v[i] != null) {
                    TestAccumulator.assertEquals((double)v[i], (double)((Number)t.get(i + 1)).doubleValue(), (double)1.0E-4);
                    continue;
                }
                TestAccumulator.assertEquals(null, (Object)t.get(i + 1));
            }
        }
    }

    public void testAccumWithMultiBuildin() throws IOException {
        this.pigServer.registerQuery("A = load 'AccumulatorInput.txt' as (id:int, c:chararray);");
        this.pigServer.registerQuery("C = group A by 1;");
        this.pigServer.registerQuery("D = foreach C generate SUM(A.id), 1+SUM(A.id)+SUM(A.id);");
        Iterator iter = this.pigServer.openIterator("D");
        while (iter.hasNext()) {
            Tuple t = (Tuple)iter.next();
            t.get(0).toString().equals("1700");
            t.get(1).toString().equals("3401");
        }
    }

    public void testAccumCountStar() throws IOException {
        this.pigServer.registerQuery("A = load 'AccumulatorInput3.txt' as (id:int, v:double);");
        this.pigServer.registerQuery("C = group A by id;");
        this.pigServer.registerQuery("D = foreach C generate group, COUNT_STAR(A.id);");
        try {
            Iterator iter = this.pigServer.openIterator("D");
        }
        catch (Exception e) {
            TestAccumulator.fail((String)"COUNT_STAR should be supported by accumulator interface");
        }
    }

    public void testAccumulatorOff() throws IOException {
        this.pigServer.getPigContext().getProperties().setProperty("opt.accumulator", "false");
        this.pigServer.registerQuery("A = load 'AccumulatorInput2.txt' as (id:int, fruit);");
        this.pigServer.registerQuery("B = group A by id;");
        this.pigServer.registerQuery("C = foreach B generate group, org.apache.pig.test.utils.AccumulativeSumBag(A);");
        try {
            Iterator iter = this.pigServer.openIterator("C");
            int c = 0;
            while (iter.hasNext()) {
                iter.next();
                ++c;
            }
            TestAccumulator.fail((String)"Accumulator should be off.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testAccumWithMap() throws IOException {
        this.pigServer.registerQuery("A = load 'AccumulatorInput4.txt' as (id, url);");
        this.pigServer.registerQuery("B = group A by (id, url);");
        this.pigServer.registerQuery("C = foreach B generate COUNT(A), org.apache.pig.test.utils.URLPARSE(group.url)#'url';");
        HashMap<Integer, String> expected = new HashMap<Integer, String>();
        expected.put(2, "http://ibm.com");
        expected.put(1, "http://yahoo.com");
        expected.put(1, "http://sun.com");
        Iterator iter = this.pigServer.openIterator("C");
        while (iter.hasNext()) {
            Tuple t = (Tuple)iter.next();
            TestAccumulator.assertEquals((String)((String)expected.get((Long)t.get(0))), (String)((String)t.get(1)));
        }
    }
}

