/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.pig.ExecType;
import org.apache.pig.PigServer;
import org.apache.pig.builtin.PigStorage;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.test.MiniCluster;
import org.apache.pig.test.Util;
import org.junit.Before;
import org.junit.Test;

public class TestAlgebraicEval
extends TestCase {
    private int LOOP_COUNT = 1024;
    private PigServer pig;
    Boolean[] nullFlags = new Boolean[]{false, true};
    MiniCluster cluster = MiniCluster.buildCluster();

    @Before
    protected void setUp() throws Exception {
        this.pig = new PigServer(ExecType.MAPREDUCE, this.cluster.getProperties());
    }

    @Test
    public void testGroupCountWithMultipleFields() throws Throwable {
        File tmpFile = File.createTempFile("test", "txt");
        for (int k = 0; k < this.nullFlags.length; ++k) {
            PrintStream ps;
            System.err.println("Running testGroupCountWithMultipleFields with nullFlags set to " + this.nullFlags[k]);
            int groupKeyWithNulls = 0;
            if (!this.nullFlags[k].booleanValue()) {
                ps = new PrintStream(new FileOutputStream(tmpFile));
                for (int i = 0; i < this.LOOP_COUNT; ++i) {
                    for (int j = 0; j < this.LOOP_COUNT; ++j) {
                        ps.println(i + "\t" + i + "\t" + j % 2);
                    }
                }
                ps.close();
            } else {
                ps = new PrintStream(new FileOutputStream(tmpFile));
                Random r = new Random();
                for (int i = 0; i < this.LOOP_COUNT; ++i) {
                    int j;
                    int rand = r.nextInt(this.LOOP_COUNT);
                    if ((double)rand <= 0.2 * (double)this.LOOP_COUNT) {
                        for (j = 0; j < this.LOOP_COUNT; ++j) {
                            ps.println("\t" + i + "\t" + j % 2);
                        }
                        continue;
                    }
                    if ((double)rand > 0.2 * (double)this.LOOP_COUNT && (double)rand <= 0.4 * (double)this.LOOP_COUNT) {
                        for (j = 0; j < this.LOOP_COUNT; ++j) {
                            ps.println(i + "\t" + "\t" + j % 2);
                        }
                        continue;
                    }
                    if ((double)rand > 0.4 * (double)this.LOOP_COUNT && (double)rand <= 0.6 * (double)this.LOOP_COUNT) {
                        for (j = 0; j < this.LOOP_COUNT; ++j) {
                            ps.println("\t\t" + j % 2);
                        }
                        ++groupKeyWithNulls;
                        continue;
                    }
                    for (j = 0; j < this.LOOP_COUNT; ++j) {
                        ps.println(i + "\t" + i + "\t" + j % 2);
                    }
                }
                ps.close();
            }
            this.pig.registerQuery(" a = group (load '" + Util.generateURI(tmpFile.toString(), this.pig.getPigContext()) + "') by ($0,$1);");
            this.pig.registerQuery("b = foreach a generate flatten(group), SUM($1.$2);");
            Iterator it = this.pig.openIterator("b");
            int count = 0;
            System.err.println("XX Starting");
            while (it.hasNext()) {
                Tuple t = (Tuple)it.next();
                System.err.println("XX " + t);
                int sum = ((Double)t.get(2)).intValue();
                if (t.get(0) == null && t.get(1) == null) {
                    TestAlgebraicEval.assertEquals((String)("Running testGroupCountWithMultipleFields with nullFlags set to " + this.nullFlags[k]), (int)(this.LOOP_COUNT / 2 * groupKeyWithNulls), (int)sum);
                } else {
                    TestAlgebraicEval.assertEquals((String)("Running testGroupCountWithMultipleFields with nullFlags set to " + this.nullFlags[k]), (int)(this.LOOP_COUNT / 2), (int)sum);
                }
                ++count;
            }
            System.err.println("XX done");
            if (groupKeyWithNulls == 0) {
                TestAlgebraicEval.assertEquals((String)("Running testGroupCountWithMultipleFields with nullFlags set to " + this.nullFlags[k]), (int)this.LOOP_COUNT, (int)count);
                continue;
            }
            TestAlgebraicEval.assertEquals((String)("Running testGroupCountWithMultipleFields with nullFlags set to " + this.nullFlags[k]), (int)(this.LOOP_COUNT - groupKeyWithNulls + 1), (int)count);
        }
        tmpFile.delete();
    }

    @Test
    public void testSimpleCount() throws Exception {
        File tmpFile = File.createTempFile("test", "txt");
        for (int i = 0; i < this.nullFlags.length; ++i) {
            System.err.println("Testing testSimpleCount with null flag:" + this.nullFlags[i]);
            PrintStream ps = new PrintStream(new FileOutputStream(tmpFile));
            this.generateInput(ps, this.nullFlags[i]);
            String query = "myid =  foreach (group (load '" + Util.generateURI(tmpFile.toString(), this.pig.getPigContext()) + "') all) generate COUNT($1);";
            System.out.println(query);
            this.pig.registerQuery(query);
            Iterator it = this.pig.openIterator("myid");
            tmpFile.delete();
            Tuple t = (Tuple)it.next();
            Long count = DataType.toLong((Object)t.get(0));
            TestAlgebraicEval.assertEquals((String)(this.getName() + "with nullFlags set to: " + this.nullFlags[i]), (long)count, (long)this.LOOP_COUNT);
        }
    }

    @Test
    public void testGroupCount() throws Throwable {
        File tmpFile = File.createTempFile("test", "txt");
        for (int i = 0; i < this.nullFlags.length; ++i) {
            System.err.println("Testing testGroupCount with null flag:" + this.nullFlags[i]);
            PrintStream ps = new PrintStream(new FileOutputStream(tmpFile));
            this.generateInput(ps, this.nullFlags[i]);
            String query = "myid = foreach (group (load '" + Util.generateURI(tmpFile.toString(), this.pig.getPigContext()) + "') all) generate group, COUNT($1) ;";
            System.out.println(query);
            this.pig.registerQuery(query);
            Iterator it = this.pig.openIterator("myid");
            tmpFile.delete();
            Tuple t = (Tuple)it.next();
            Long count = DataType.toLong((Object)t.get(1));
            TestAlgebraicEval.assertEquals((String)(this.getName() + "with nullFlags set to: " + this.nullFlags[i]), (long)count, (long)this.LOOP_COUNT);
        }
    }

    @Test
    public void testGroupReorderCount() throws Throwable {
        File tmpFile = File.createTempFile("test", "txt");
        for (int i = 0; i < this.nullFlags.length; ++i) {
            System.err.println("Testing testGroupCount with null flag:" + this.nullFlags[i]);
            PrintStream ps = new PrintStream(new FileOutputStream(tmpFile));
            this.generateInput(ps, this.nullFlags[i]);
            String query = "myid = foreach (group (load '" + Util.generateURI(tmpFile.toString(), this.pig.getPigContext()) + "') all) generate COUNT($1), group ;";
            System.out.println(query);
            this.pig.registerQuery(query);
            Iterator it = this.pig.openIterator("myid");
            tmpFile.delete();
            Tuple t = (Tuple)it.next();
            Long count = DataType.toLong((Object)t.get(0));
            TestAlgebraicEval.assertEquals((String)(this.getName() + "with nullFlags set to: " + this.nullFlags[i]), (long)count, (long)this.LOOP_COUNT);
        }
    }

    @Test
    public void testGroupUniqueColumnCount() throws Throwable {
        File tmpFile = File.createTempFile("test", "txt");
        for (int i = 0; i < this.nullFlags.length; ++i) {
            int j;
            PrintStream ps = new PrintStream(new FileOutputStream(tmpFile));
            long groupsize = 0L;
            if (!this.nullFlags[i].booleanValue()) {
                for (j = 0; j < this.LOOP_COUNT; ++j) {
                    if (j % 10 == 0) {
                        ++groupsize;
                    }
                    ps.println(j % 10 + ":" + j);
                }
            } else {
                for (j = 0; j < this.LOOP_COUNT; ++j) {
                    if (j % 10 == 0) {
                        ++groupsize;
                    }
                    if (j % 20 == 0) {
                        ps.println(j % 10 + ":");
                        --groupsize;
                        continue;
                    }
                    ps.println(j % 10 + ":" + j);
                }
            }
            ps.close();
            String query = "myid = foreach (group (load '" + Util.generateURI(tmpFile.toString(), this.pig.getPigContext()) + "' using " + PigStorage.class.getName() + "(':')) by $0) generate group, COUNT($1.$1) ;";
            System.out.println(query);
            this.pig.registerQuery(query);
            Iterator it = this.pig.openIterator("myid");
            tmpFile.delete();
            System.err.println("Output from testGroupUniqueColumnCount");
            while (it.hasNext()) {
                Tuple t = (Tuple)it.next();
                System.err.println(t);
                String a = t.get(0).toString();
                Double group = Double.valueOf(a.toString());
                if (group != 0.0) continue;
                Long count = DataType.toLong((Object)t.get(1));
                TestAlgebraicEval.assertEquals((String)(this.getName() + "with nullFlags set to: " + this.nullFlags[i]), (long)groupsize, (long)count);
            }
        }
    }

    @Test
    public void testGroupDuplicateColumnCount() throws Throwable {
        File tmpFile = File.createTempFile("test", "txt");
        for (int i = 0; i < this.nullFlags.length; ++i) {
            int j;
            PrintStream ps = new PrintStream(new FileOutputStream(tmpFile));
            long groupsize = 0L;
            long nonNullCnt = 0L;
            if (!this.nullFlags[i].booleanValue()) {
                for (j = 0; j < this.LOOP_COUNT; ++j) {
                    if (j % 10 == 0) {
                        ++groupsize;
                        ++nonNullCnt;
                    }
                    ps.println(j % 10 + ":" + j);
                }
            } else {
                for (j = 0; j < this.LOOP_COUNT; ++j) {
                    if (j % 10 == 0) {
                        ++groupsize;
                        ++nonNullCnt;
                    }
                    if (j % 20 == 0) {
                        --nonNullCnt;
                        ps.println(j % 10 + ":");
                        continue;
                    }
                    ps.println(j % 10 + ":" + j);
                }
            }
            ps.close();
            String query = "myid = foreach (group (load '" + Util.generateURI(tmpFile.toString(), this.pig.getPigContext()) + "' using " + PigStorage.class.getName() + "(':')) by $0) generate group, COUNT($1.$1), COUNT($1.$0) ;";
            System.out.println(query);
            this.pig.registerQuery(query);
            Iterator it = this.pig.openIterator("myid");
            tmpFile.delete();
            System.err.println("Output from testGroupDuplicateColumnCount");
            while (it.hasNext()) {
                Tuple t = (Tuple)it.next();
                System.err.println(t);
                String a = t.get(0).toString();
                Double group = Double.valueOf(a.toString());
                if (group != 0.0) continue;
                Long count = DataType.toLong((Object)t.get(2));
                TestAlgebraicEval.assertEquals((String)(this.getName() + "with nullFlags set to: " + this.nullFlags[i]), (long)groupsize, (long)count);
                count = DataType.toLong((Object)t.get(1));
                TestAlgebraicEval.assertEquals((String)(this.getName() + "with nullFlags set to: " + this.nullFlags[i]), (long)nonNullCnt, (long)count);
            }
        }
    }

    private int generateInput(PrintStream ps, boolean withNulls) {
        int numNulls = 0;
        if (withNulls) {
            for (int i = 0; i < this.LOOP_COUNT; ++i) {
                int rand = new Random().nextInt(this.LOOP_COUNT);
                if ((double)rand <= 0.3 * (double)this.LOOP_COUNT) {
                    ps.println(":");
                    ++numNulls;
                    continue;
                }
                ps.println(i + ":" + i);
            }
        } else {
            for (int i = 0; i < this.LOOP_COUNT; ++i) {
                ps.println(i + ":" + i);
            }
        }
        ps.close();
        return numNulls;
    }
}

