/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Iterator;
import org.apache.pig.Algebraic;
import org.apache.pig.EvalFunc;
import org.apache.pig.ExecType;
import org.apache.pig.PigServer;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.test.MiniCluster;
import org.apache.pig.test.Util;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestAlgebraicInstantiation {
    Boolean[] nullFlags = new Boolean[]{false, true};
    MiniCluster cluster = MiniCluster.buildCluster();
    private PigServer pig = new PigServer(ExecType.MAPREDUCE, this.cluster.getProperties());
    private File tmpFile;

    @Before
    public void setUp() throws Exception {
        this.tmpFile = File.createTempFile("test", "txt");
        PrintStream ps = new PrintStream(new FileOutputStream(this.tmpFile));
        ps.println("1\t2");
        ps.close();
    }

    @Test
    public void testAlgebraicInstantiation() throws IOException {
        this.pig.registerQuery("a = group (load '" + Util.generateURI(this.tmpFile.toString(), this.pig.getPigContext()) + "') by ($0);");
        this.pig.registerQuery("b = foreach a generate org.apache.pig.test.TestAlgebraicInstantiation$AlgInstUDF($1.$1);");
        Iterator tupIter = this.pig.openIterator("b");
        Assert.assertEquals((Object)"no-args", (Object)((Tuple)tupIter.next()).toDelimitedString(","));
        this.pig.registerQuery("DEFINE instantiated org.apache.pig.test.TestAlgebraicInstantiation$AlgInstUDF('args');");
        this.pig.registerQuery("b = foreach a generate instantiated($1.$1);");
        tupIter = this.pig.openIterator("b");
        Assert.assertEquals((Object)"args", (Object)((Tuple)tupIter.next()).toDelimitedString(","));
    }

    @Test
    public void testRegularInstantiation() throws IOException {
        this.pig.registerQuery("a = group (load '" + Util.generateURI(this.tmpFile.toString(), this.pig.getPigContext()) + "') by ($0);");
        this.pig.registerQuery("b = foreach a generate org.apache.pig.test.TestAlgebraicInstantiation$ParamUDF($1.$1);");
        Iterator tupIter = this.pig.openIterator("b");
        Assert.assertEquals((Object)"no-args", (Object)((Tuple)tupIter.next()).toDelimitedString(","));
        this.pig.registerQuery("DEFINE instantiated org.apache.pig.test.TestAlgebraicInstantiation$ParamUDF('args');");
        this.pig.registerQuery("b = foreach a generate instantiated($1.$1);");
        tupIter = this.pig.openIterator("b");
        Assert.assertEquals((Object)"args", (Object)((Tuple)tupIter.next()).toDelimitedString(","));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AlgInstUDF
    extends EvalFunc<String>
    implements Algebraic {
        private String initType;

        public AlgInstUDF() {
            this.initType = "no-args";
        }

        public AlgInstUDF(String s) {
            this.initType = s;
        }

        public String exec(Tuple input) throws IOException {
            return this.initType;
        }

        public String getFinal() {
            return Final.class.getName();
        }

        public String getInitial() {
            return Initial.class.getName();
        }

        public String getIntermed() {
            return Intermed.class.getName();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Final
        extends EvalFunc<String> {
            private String initType;

            public Final() {
                this.initType = "no-args";
            }

            public Final(String s) {
                this.initType = s;
            }

            public String exec(Tuple input) {
                return this.initType;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Intermed
        extends EvalFunc<Tuple> {
            private String initType;

            public Intermed() {
                this.initType = "no-args";
            }

            public Intermed(String s) {
                this.initType = s;
            }

            public Tuple exec(Tuple input) {
                return TupleFactory.getInstance().newTuple((Object)this.initType);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Initial
        extends EvalFunc<Tuple> {
            private String initType;

            public Initial() {
                this.initType = "no-args";
            }

            public Initial(String s) {
                this.initType = s;
            }

            public Tuple exec(Tuple input) {
                return TupleFactory.getInstance().newTuple((Object)this.initType);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ParamUDF
    extends EvalFunc<String> {
        private String initType;

        public ParamUDF() {
            this.initType = "no-args";
        }

        public ParamUDF(String s) {
            this.initType = s;
        }

        public String exec(Tuple input) {
            return this.initType;
        }
    }
}

