/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.pig.ExecType;
import org.apache.pig.PigServer;
import org.apache.pig.backend.hadoop.datastorage.ConfigurationUtil;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.PigContext;
import org.apache.pig.test.MiniCluster;
import org.apache.pig.test.Util;
import org.apache.tools.bzip2r.CBZip2InputStream;
import org.apache.tools.bzip2r.CBZip2OutputStream;
import org.junit.Assert;
import org.junit.Test;

public class TestBZip {
    MiniCluster cluster = MiniCluster.buildCluster();

    @Test
    public void testBzipInPig() throws Exception {
        PigServer pig = new PigServer(ExecType.MAPREDUCE, this.cluster.getProperties());
        File in = File.createTempFile("junit", ".bz2");
        in.deleteOnExit();
        File out = File.createTempFile("junit", ".bz2");
        out.deleteOnExit();
        out.delete();
        CBZip2OutputStream cos = new CBZip2OutputStream((OutputStream)new FileOutputStream(in));
        for (int i = 1; i < 100; ++i) {
            StringBuffer sb = new StringBuffer();
            sb.append(i).append("\n").append(-i).append("\n");
            byte[] bytes = sb.toString().getBytes();
            cos.write(bytes);
        }
        cos.close();
        pig.registerQuery("AA = load '" + Util.generateURI(in.getAbsolutePath(), pig.getPigContext()) + "';");
        pig.registerQuery("A = foreach (group (filter AA by $0 > 0) all) generate flatten($1);");
        pig.registerQuery("store A into '" + out.getAbsolutePath() + "';");
        FileSystem fs = FileSystem.get((Configuration)ConfigurationUtil.toConfiguration((Properties)pig.getPigContext().getProperties()));
        FSDataInputStream is = fs.open(new Path(out.getAbsolutePath() + "/part-r-00000.bz2"));
        CBZip2InputStream cis = new CBZip2InputStream(is);
        Assert.assertEquals((long)100L, (long)cis.read(new byte[100]));
        cis.close();
        pig.registerQuery("B = load '" + out.getAbsolutePath() + "';");
        Iterator i = pig.openIterator("B");
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        while (i.hasNext()) {
            Integer val = DataType.toInteger((Object)((Tuple)i.next()).get(0));
            map.put(val, val);
        }
        Assert.assertEquals((Object)new Integer(99), (Object)new Integer(map.keySet().size()));
        for (int j = 1; j < 100; ++j) {
            Assert.assertEquals((Object)new Integer(j), map.get(j));
        }
        in.delete();
        out.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRecordDelims() throws Exception {
        String[] inputData = new String[]{"1\t2\r3\t4", "5\t6\r", "7\t8", "9\t10\r"};
        File in = File.createTempFile("junit", ".bz2");
        String compressedInputFileName = in.getAbsolutePath();
        in.deleteOnExit();
        String unCompressedInputFileName = "testRecordDelims-uncomp.txt";
        Util.createInputFile(this.cluster, unCompressedInputFileName, inputData);
        try {
            CBZip2OutputStream cos = new CBZip2OutputStream((OutputStream)new FileOutputStream(in));
            for (int i = 0; i < inputData.length; ++i) {
                StringBuffer sb = new StringBuffer();
                sb.append(inputData[i]).append("\n");
                byte[] bytes = sb.toString().getBytes();
                cos.write(bytes);
            }
            cos.close();
            Util.copyFromLocalToCluster(this.cluster, compressedInputFileName, compressedInputFileName);
            String script = "a = load '" + unCompressedInputFileName + "';";
            PigServer pig = new PigServer(ExecType.MAPREDUCE, this.cluster.getProperties());
            pig.registerQuery(script);
            Iterator it1 = pig.openIterator("a");
            script = "a = load '" + compressedInputFileName + "';";
            pig.registerQuery(script);
            Iterator it2 = pig.openIterator("a");
            while (it1.hasNext()) {
                Tuple t1 = (Tuple)it1.next();
                Tuple t2 = (Tuple)it2.next();
                junit.framework.Assert.assertEquals((Object)t1, (Object)t2);
            }
            junit.framework.Assert.assertFalse((boolean)it2.hasNext());
        }
        finally {
            in.delete();
            Util.deleteFile(this.cluster, unCompressedInputFileName);
        }
    }

    @Test
    public void testEmptyBzipInPig() throws Exception {
        PigServer pig = new PigServer(ExecType.MAPREDUCE, this.cluster.getProperties());
        File in = File.createTempFile("junit", ".tmp");
        in.deleteOnExit();
        File out = File.createTempFile("junit", ".bz2");
        out.deleteOnExit();
        out.delete();
        FileOutputStream fos = new FileOutputStream(in);
        fos.write("55\n".getBytes());
        fos.close();
        System.out.println(in.getAbsolutePath());
        pig.registerQuery("AA = load '" + Util.generateURI(in.getAbsolutePath(), pig.getPigContext()) + "';");
        pig.registerQuery("A=foreach (group (filter AA by $0 < '0') all) generate flatten($1);");
        pig.registerQuery("store A into '" + out.getAbsolutePath() + "';");
        FileSystem fs = FileSystem.get((Configuration)ConfigurationUtil.toConfiguration((Properties)pig.getPigContext().getProperties()));
        FSDataInputStream is = fs.open(new Path(out.getAbsolutePath() + "/part-r-00000.bz2"));
        CBZip2InputStream cis = new CBZip2InputStream(is);
        Assert.assertEquals((long)-1L, (long)cis.read(new byte[100]));
        cis.close();
        pig.registerQuery("B = load '" + out.getAbsolutePath() + "';");
        pig.openIterator("B");
        in.delete();
        out.delete();
    }

    @Test
    public void testEmptyBzip() throws Exception {
        File tmp = File.createTempFile("junit", ".tmp");
        tmp.deleteOnExit();
        CBZip2OutputStream cos = new CBZip2OutputStream((OutputStream)new FileOutputStream(tmp));
        cos.close();
        Assert.assertNotSame((Object)0, (Object)tmp.length());
        LocalFileSystem fs = FileSystem.getLocal((Configuration)new Configuration(false));
        CBZip2InputStream cis = new CBZip2InputStream(fs.open(new Path(tmp.getAbsolutePath())));
        Assert.assertEquals((long)-1L, (long)cis.read(new byte[100]));
        cis.close();
        tmp.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBlockHeaderEndingAtSplitNotByteAligned() throws IOException {
        String inputFileName = "test/org/apache/pig/test/data/bzipdir1.bz2";
        Long expectedCount = 74999L;
        int splitSize = 136500;
        try {
            Util.copyFromLocalToCluster(this.cluster, inputFileName, inputFileName);
            this.testCount(inputFileName, expectedCount, splitSize, "PigStorage()");
            this.testCount(inputFileName, expectedCount, splitSize, "TextLoader()");
        }
        finally {
            Util.deleteFile(this.cluster, inputFileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBlockHeaderEndingWithCR() throws IOException {
        String inputFileName = "test/org/apache/pig/test/data/blockEndingInCR.txt.bz2";
        Long expectedCount = 82094L;
        try {
            int splitSize = 136498;
            Util.copyFromLocalToCluster(this.cluster, inputFileName, inputFileName);
            this.testCount(inputFileName, expectedCount, splitSize, "PigStorage()");
        }
        finally {
            Util.deleteFile(this.cluster, inputFileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBlockHeaderEndingAtSplitOverCounting() throws IOException {
        String inputFileName = "test/org/apache/pig/test/data/blockHeaderEndsAt136500.txt.bz2";
        Long expectedCount = 1041046L;
        int splitSize = 136500;
        try {
            Util.copyFromLocalToCluster(this.cluster, inputFileName, inputFileName);
            this.testCount(inputFileName, expectedCount, splitSize, "PigStorage()");
        }
        finally {
            Util.deleteFile(this.cluster, inputFileName);
        }
    }

    private void testCount(String inputFileName, Long expectedCount, int splitSize, String loadFuncSpec) throws IOException {
        String outputFile = "/tmp/bz-output";
        String scriptToTestSplitting = "a = load '" + inputFileName + "' using " + loadFuncSpec + "; store a into '" + outputFile + "';";
        String script = "a = load '" + inputFileName + "';" + "b = group a all;" + "c = foreach b generate COUNT_STAR(a);";
        Properties props = new Properties();
        for (Map.Entry<Object, Object> entry : this.cluster.getProperties().entrySet()) {
            props.put(entry.getKey(), entry.getValue());
        }
        props.setProperty("mapred.max.split.size", Integer.toString(splitSize));
        PigContext pigContext = new PigContext(ExecType.MAPREDUCE, props);
        PigServer pig = new PigServer(pigContext);
        FileSystem fs = FileSystem.get((Configuration)ConfigurationUtil.toConfiguration((Properties)props));
        fs.delete(new Path(outputFile), true);
        Util.registerMultiLineQuery(pig, scriptToTestSplitting);
        FileStatus[] files = fs.listStatus(new Path(outputFile));
        int numPartFiles = 0;
        for (FileStatus fileStatus : files) {
            if (!fileStatus.getPath().getName().startsWith("part")) continue;
            ++numPartFiles;
        }
        Assert.assertEquals((Object)true, (Object)(numPartFiles > 0 ? 1 : 0));
        Util.registerMultiLineQuery(pig, script);
        Iterator it = pig.openIterator("c");
        Long result = (Long)((Tuple)it.next()).get(0);
        Assert.assertEquals((Object)expectedCount, (Object)result);
    }
}

