/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.apache.pig.EvalFunc;
import org.apache.pig.ExecType;
import org.apache.pig.FuncSpec;
import org.apache.pig.PigException;
import org.apache.pig.PigServer;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.util.LogUtils;
import org.apache.pig.test.MiniCluster;
import org.apache.pig.test.Util;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestBestFitCast
extends TestCase {
    private PigServer pigServer;
    private MiniCluster cluster = MiniCluster.buildCluster();
    String inputFile;
    String inputFile2;
    int LOOP_SIZE = 20;

    @Before
    public void setUp() throws Exception {
        int i;
        this.pigServer = new PigServer(ExecType.MAPREDUCE, this.cluster.getProperties());
        this.inputFile = "TestBestFitCast-input.txt";
        String[] input = new String[this.LOOP_SIZE];
        long l = 0L;
        for (i = 1; i <= this.LOOP_SIZE; ++i) {
            input[i - 1] = l + "\t" + i;
        }
        Util.createInputFile(this.cluster, this.inputFile, input);
        this.inputFile2 = "TestBestFitCast-input2.txt";
        l = 0L;
        for (i = 1; i <= this.LOOP_SIZE; ++i) {
            input[i - 1] = l + "\t" + i + "\t" + i;
        }
        Util.createInputFile(this.cluster, this.inputFile2, input);
    }

    @After
    public void tearDown() throws Exception {
        Util.deleteFile(this.cluster, this.inputFile);
        Util.deleteFile(this.cluster, this.inputFile2);
    }

    @Test
    public void testByteArrayCast1() throws IOException {
        boolean exceptionCaused = false;
        this.pigServer.registerQuery("A = LOAD '" + this.inputFile + "' as (x:float, y);");
        this.pigServer.registerQuery("B = FOREACH A generate x, " + UDF3.class.getName() + "(x,y);");
        try {
            Iterator iter = this.pigServer.openIterator("B");
        }
        catch (Exception e) {
            exceptionCaused = true;
            PigException pe = LogUtils.getPigException((Throwable)e);
            String msg = pe == null ? e.getMessage() : pe.getMessage();
            TestBestFitCast.assertTrue((boolean)msg.contains("Multiple matching functions"));
            TestBestFitCast.assertTrue((boolean)msg.contains("{float,double}, {float,long}"));
        }
        TestBestFitCast.assertTrue((boolean)exceptionCaused);
    }

    @Test
    public void testByteArrayCast2() throws IOException, ExecException {
        this.pigServer.registerQuery("A = LOAD '" + this.inputFile + "' as (x, y:int);");
        this.pigServer.registerQuery("B = FOREACH A generate x, " + UDF3.class.getName() + "(x,y);");
        Iterator iter = this.pigServer.openIterator("B");
        if (!iter.hasNext()) {
            TestBestFitCast.fail((String)"No Output received");
        }
        int cnt = 0;
        while (iter.hasNext()) {
            Tuple t = (Tuple)iter.next();
            TestBestFitCast.assertTrue((boolean)(((Tuple)t.get(1)).get(0) instanceof Float));
            TestBestFitCast.assertEquals((Object)((Float)((Tuple)t.get(1)).get(0)), (Object)Float.valueOf(0.0f));
            TestBestFitCast.assertTrue((boolean)(((Tuple)t.get(1)).get(1) instanceof Long));
            TestBestFitCast.assertEquals((Object)((Long)((Tuple)t.get(1)).get(1)), (Object)new Long(cnt + 1));
            ++cnt;
        }
        TestBestFitCast.assertEquals((int)this.LOOP_SIZE, (int)cnt);
    }

    @Test
    public void testByteArrayCast3() throws IOException, ExecException {
        this.pigServer.registerQuery("A = LOAD '" + this.inputFile + "' as (x, y:long);");
        this.pigServer.registerQuery("B = FOREACH A generate x, " + UDF3.class.getName() + "(x, y);");
        Iterator iter = this.pigServer.openIterator("B");
        if (!iter.hasNext()) {
            TestBestFitCast.fail((String)"No Output received");
        }
        int cnt = 0;
        while (iter.hasNext()) {
            Tuple t = (Tuple)iter.next();
            TestBestFitCast.assertTrue((boolean)(((Tuple)t.get(1)).get(0) instanceof Float));
            TestBestFitCast.assertEquals((Object)((Float)((Tuple)t.get(1)).get(0)), (Object)Float.valueOf(0.0f));
            TestBestFitCast.assertTrue((boolean)(((Tuple)t.get(1)).get(1) instanceof Long));
            TestBestFitCast.assertEquals((Object)((Long)((Tuple)t.get(1)).get(1)), (Object)new Long(cnt + 1));
            ++cnt;
        }
        TestBestFitCast.assertEquals((int)this.LOOP_SIZE, (int)cnt);
    }

    @Test
    public void testByteArrayCast4() throws IOException, ExecException {
        this.pigServer.registerQuery("A = LOAD '" + this.inputFile + "' as (x, y:double);");
        this.pigServer.registerQuery("B = FOREACH A generate x, " + UDF3.class.getName() + "(x,y);");
        Iterator iter = this.pigServer.openIterator("B");
        if (!iter.hasNext()) {
            TestBestFitCast.fail((String)"No Output received");
        }
        int cnt = 0;
        while (iter.hasNext()) {
            Tuple t = (Tuple)iter.next();
            TestBestFitCast.assertTrue((boolean)(((Tuple)t.get(1)).get(0) instanceof Float));
            TestBestFitCast.assertEquals((Object)((Float)((Tuple)t.get(1)).get(0)), (Object)Float.valueOf(0.0f));
            TestBestFitCast.assertTrue((boolean)(((Tuple)t.get(1)).get(1) instanceof Double));
            TestBestFitCast.assertEquals((Object)((Double)((Tuple)t.get(1)).get(1)), (Object)new Double(cnt + 1));
            ++cnt;
        }
        TestBestFitCast.assertEquals((int)this.LOOP_SIZE, (int)cnt);
    }

    @Test
    public void testByteArrayCast5() throws IOException, ExecException {
        boolean exceptionCaused = false;
        this.pigServer.registerQuery("A = LOAD '" + this.inputFile + "' as (x, y:int);");
        this.pigServer.registerQuery("B = FOREACH A generate x, " + UDF3.class.getName() + "(x,y, y);");
        try {
            Iterator iter = this.pigServer.openIterator("B");
        }
        catch (Exception e) {
            exceptionCaused = true;
            PigException pe = LogUtils.getPigException((Throwable)e);
            String msg = pe == null ? e.getMessage() : pe.getMessage();
            TestBestFitCast.assertTrue((boolean)msg.contains("Multiple matching functions"));
            TestBestFitCast.assertTrue((boolean)msg.contains("({float,double,long}, {float,long,double})"));
        }
        TestBestFitCast.assertTrue((boolean)exceptionCaused);
    }

    @Test
    public void testByteArrayCast6() throws IOException, ExecException {
        boolean exceptionCaused = false;
        this.pigServer.registerQuery("A = LOAD '" + this.inputFile + "' as (x, y:long);");
        this.pigServer.registerQuery("B = FOREACH A generate x, " + UDF3.class.getName() + "(x,y, y);");
        try {
            Iterator iter = this.pigServer.openIterator("B");
        }
        catch (Exception e) {
            exceptionCaused = true;
            PigException pe = LogUtils.getPigException((Throwable)e);
            String msg = pe == null ? e.getMessage() : pe.getMessage();
            TestBestFitCast.assertTrue((boolean)msg.contains("Multiple matching functions"));
            TestBestFitCast.assertTrue((boolean)msg.contains("({float,double,long}, {float,long,double})"));
        }
        TestBestFitCast.assertTrue((boolean)exceptionCaused);
    }

    @Test
    public void testByteArrayCast7() throws IOException, ExecException {
        boolean exceptionCaused = false;
        this.pigServer.registerQuery("A = LOAD '" + this.inputFile + "' as (x, y:double);");
        this.pigServer.registerQuery("B = FOREACH A generate x, " + UDF3.class.getName() + "(x,y, y);");
        try {
            Iterator iter = this.pigServer.openIterator("B");
        }
        catch (Exception e) {
            exceptionCaused = true;
            PigException pe = LogUtils.getPigException((Throwable)e);
            String msg = pe == null ? e.getMessage() : pe.getMessage();
            TestBestFitCast.assertTrue((boolean)msg.contains("Could not infer the matching function"));
        }
        TestBestFitCast.assertTrue((boolean)exceptionCaused);
    }

    @Test
    public void testByteArrayCast8() throws IOException, ExecException {
        this.pigServer.registerQuery("A = LOAD '" + this.inputFile2 + "' as (x, y:long, z:double);");
        this.pigServer.registerQuery("B = FOREACH A generate x, " + UDF3.class.getName() + "(x,y,z);");
        Iterator iter = this.pigServer.openIterator("B");
        if (!iter.hasNext()) {
            TestBestFitCast.fail((String)"No Output received");
        }
        int cnt = 0;
        while (iter.hasNext()) {
            Tuple t = (Tuple)iter.next();
            TestBestFitCast.assertTrue((boolean)(((Tuple)t.get(1)).get(0) instanceof Float));
            TestBestFitCast.assertEquals((Object)((Float)((Tuple)t.get(1)).get(0)), (Object)Float.valueOf(0.0f));
            TestBestFitCast.assertTrue((boolean)(((Tuple)t.get(1)).get(1) instanceof Long));
            TestBestFitCast.assertEquals((Object)((Long)((Tuple)t.get(1)).get(1)), (Object)new Long(cnt + 1));
            TestBestFitCast.assertTrue((boolean)(((Tuple)t.get(1)).get(2) instanceof Double));
            TestBestFitCast.assertEquals((Object)((Double)((Tuple)t.get(1)).get(2)), (Object)new Double(cnt + 1));
            ++cnt;
        }
        TestBestFitCast.assertEquals((int)this.LOOP_SIZE, (int)cnt);
    }

    @Test
    public void testByteArrayCast9() throws IOException, ExecException {
        this.pigServer.registerQuery("A = LOAD '" + this.inputFile2 + "' as (x, y:double, z:long);");
        this.pigServer.registerQuery("B = FOREACH A generate x, " + UDF3.class.getName() + "(x,y,z);");
        Iterator iter = this.pigServer.openIterator("B");
        if (!iter.hasNext()) {
            TestBestFitCast.fail((String)"No Output received");
        }
        int cnt = 0;
        while (iter.hasNext()) {
            Tuple t = (Tuple)iter.next();
            TestBestFitCast.assertTrue((boolean)(((Tuple)t.get(1)).get(0) instanceof Float));
            TestBestFitCast.assertEquals((Object)((Float)((Tuple)t.get(1)).get(0)), (Object)Float.valueOf(0.0f));
            TestBestFitCast.assertTrue((boolean)(((Tuple)t.get(1)).get(1) instanceof Double));
            TestBestFitCast.assertEquals((Object)((Double)((Tuple)t.get(1)).get(1)), (Object)new Double(cnt + 1));
            TestBestFitCast.assertTrue((boolean)(((Tuple)t.get(1)).get(2) instanceof Long));
            TestBestFitCast.assertEquals((Object)((Long)((Tuple)t.get(1)).get(2)), (Object)new Long(cnt + 1));
            ++cnt;
        }
        TestBestFitCast.assertEquals((int)this.LOOP_SIZE, (int)cnt);
    }

    @Test
    public void testByteArrayCast10() throws IOException, ExecException {
        this.pigServer.registerQuery("A = LOAD '" + this.inputFile2 + "' as (x:float, y:long, z);");
        this.pigServer.registerQuery("B = FOREACH A generate x, " + UDF3.class.getName() + "(x,y,z);");
        Iterator iter = this.pigServer.openIterator("B");
        if (!iter.hasNext()) {
            TestBestFitCast.fail((String)"No Output received");
        }
        int cnt = 0;
        while (iter.hasNext()) {
            Tuple t = (Tuple)iter.next();
            TestBestFitCast.assertTrue((boolean)(((Tuple)t.get(1)).get(0) instanceof Float));
            TestBestFitCast.assertEquals((Object)((Float)((Tuple)t.get(1)).get(0)), (Object)Float.valueOf(0.0f));
            TestBestFitCast.assertTrue((boolean)(((Tuple)t.get(1)).get(1) instanceof Long));
            TestBestFitCast.assertEquals((Object)((Long)((Tuple)t.get(1)).get(1)), (Object)new Long(cnt + 1));
            TestBestFitCast.assertTrue((boolean)(((Tuple)t.get(1)).get(2) instanceof Double));
            TestBestFitCast.assertEquals((Object)((Double)((Tuple)t.get(1)).get(2)), (Object)new Double(cnt + 1));
            ++cnt;
        }
        TestBestFitCast.assertEquals((int)this.LOOP_SIZE, (int)cnt);
    }

    @Test
    public void testByteArrayCast11() throws IOException, ExecException {
        this.pigServer.registerQuery("A = LOAD '" + this.inputFile2 + "' as (x:float, y, z:long);");
        this.pigServer.registerQuery("B = FOREACH A generate x, " + UDF3.class.getName() + "(x,y,z);");
        Iterator iter = this.pigServer.openIterator("B");
        if (!iter.hasNext()) {
            TestBestFitCast.fail((String)"No Output received");
        }
        int cnt = 0;
        while (iter.hasNext()) {
            Tuple t = (Tuple)iter.next();
            TestBestFitCast.assertTrue((boolean)(((Tuple)t.get(1)).get(0) instanceof Float));
            TestBestFitCast.assertEquals((Object)((Float)((Tuple)t.get(1)).get(0)), (Object)Float.valueOf(0.0f));
            TestBestFitCast.assertTrue((boolean)(((Tuple)t.get(1)).get(1) instanceof Double));
            TestBestFitCast.assertEquals((Object)((Double)((Tuple)t.get(1)).get(1)), (Object)new Double(cnt + 1));
            TestBestFitCast.assertTrue((boolean)(((Tuple)t.get(1)).get(2) instanceof Long));
            TestBestFitCast.assertEquals((Object)((Long)((Tuple)t.get(1)).get(2)), (Object)new Long(cnt + 1));
            ++cnt;
        }
        TestBestFitCast.assertEquals((int)this.LOOP_SIZE, (int)cnt);
    }

    @Test
    public void testByteArrayCast12() throws IOException, ExecException {
        boolean exceptionCaused = false;
        this.pigServer.registerQuery("A = LOAD '" + this.inputFile2 + "' as (x:float, y, z:int);");
        this.pigServer.registerQuery("B = FOREACH A generate x, " + UDF3.class.getName() + "(x,y, y);");
        try {
            Iterator iter = this.pigServer.openIterator("B");
        }
        catch (Exception e) {
            exceptionCaused = true;
            PigException pe = LogUtils.getPigException((Throwable)e);
            String msg = pe == null ? e.getMessage() : pe.getMessage();
            TestBestFitCast.assertTrue((boolean)msg.contains("Multiple matching functions"));
            TestBestFitCast.assertTrue((boolean)msg.contains("({float,double,long}, {float,long,double}"));
        }
        TestBestFitCast.assertTrue((boolean)exceptionCaused);
    }

    @Test
    public void testByteArrayCast13() throws IOException, ExecException {
        this.pigServer.registerQuery("A = LOAD '" + this.inputFile2 + "' as (x, y:long, z:int);");
        this.pigServer.registerQuery("B = FOREACH A generate x, " + UDF3.class.getName() + "(x,y,z);");
        Iterator iter = this.pigServer.openIterator("B");
        if (!iter.hasNext()) {
            TestBestFitCast.fail((String)"No Output received");
        }
        int cnt = 0;
        while (iter.hasNext()) {
            Tuple t = (Tuple)iter.next();
            TestBestFitCast.assertTrue((boolean)(((Tuple)t.get(1)).get(0) instanceof Float));
            TestBestFitCast.assertEquals((Object)((Float)((Tuple)t.get(1)).get(0)), (Object)Float.valueOf(0.0f));
            TestBestFitCast.assertTrue((boolean)(((Tuple)t.get(1)).get(1) instanceof Long));
            TestBestFitCast.assertEquals((Object)((Long)((Tuple)t.get(1)).get(1)), (Object)new Long(cnt + 1));
            TestBestFitCast.assertTrue((boolean)(((Tuple)t.get(1)).get(2) instanceof Double));
            TestBestFitCast.assertEquals((Object)((Double)((Tuple)t.get(1)).get(2)), (Object)new Double(cnt + 1));
            ++cnt;
        }
        TestBestFitCast.assertEquals((int)this.LOOP_SIZE, (int)cnt);
    }

    @Test
    public void testByteArrayCast14() throws IOException, ExecException {
        this.pigServer.registerQuery("A = LOAD '" + this.inputFile + "' as (x, y);");
        this.pigServer.registerQuery("B = group A all;");
        this.pigServer.registerQuery("C = FOREACH B generate SUM(A.y);");
        Iterator iter = this.pigServer.openIterator("C");
        Tuple t = (Tuple)iter.next();
        TestBestFitCast.assertTrue((boolean)(t.get(0) instanceof Double));
        TestBestFitCast.assertEquals((Object)new Double(210.0), (Object)((Double)t.get(0)));
    }

    @Test
    public void testByteArrayCast15() throws IOException, ExecException {
        this.pigServer.registerQuery("A = LOAD '" + this.inputFile + "' as (x, y);");
        this.pigServer.registerQuery("B = FOREACH A generate " + UDF3.class.getName() + "(y);");
        Iterator iter = this.pigServer.openIterator("B");
        if (!iter.hasNext()) {
            TestBestFitCast.fail((String)"No Output received");
        }
        int cnt = 0;
        while (iter.hasNext()) {
            Tuple t = (Tuple)iter.next();
            TestBestFitCast.assertTrue((boolean)(((Tuple)t.get(0)).get(0) instanceof DataByteArray));
            byte[] expected = Integer.toString(cnt + 1).getBytes();
            byte[] actual = ((DataByteArray)((Tuple)t.get(0)).get(0)).get();
            TestBestFitCast.assertEquals((int)expected.length, (int)actual.length);
            for (int i = 0; i < expected.length; ++i) {
                TestBestFitCast.assertEquals((byte)expected[i], (byte)actual[i]);
            }
            ++cnt;
        }
        TestBestFitCast.assertEquals((int)this.LOOP_SIZE, (int)cnt);
    }

    @Test
    public void testByteArrayCast16() throws IOException, ExecException {
        this.pigServer.registerQuery("A = LOAD '" + this.inputFile + "' as (x, y:int);");
        this.pigServer.registerQuery("B = FOREACH A generate " + UDF3.class.getName() + "(y);");
        Iterator iter = this.pigServer.openIterator("B");
        if (!iter.hasNext()) {
            TestBestFitCast.fail((String)"No Output received");
        }
        int cnt = 0;
        while (iter.hasNext()) {
            Tuple t = (Tuple)iter.next();
            TestBestFitCast.assertTrue((boolean)(((Tuple)t.get(0)).get(0) instanceof Integer));
            TestBestFitCast.assertEquals((Object)new Integer(cnt + 1), (Object)((Integer)((Tuple)t.get(0)).get(0)));
            ++cnt;
        }
        TestBestFitCast.assertEquals((int)this.LOOP_SIZE, (int)cnt);
    }

    @Test
    public void testIntSum() throws IOException, ExecException {
        this.pigServer.registerQuery("A = LOAD '" + this.inputFile + "' as (x, y:int);");
        this.pigServer.registerQuery("B = group A all;");
        this.pigServer.registerQuery("C = FOREACH B generate SUM(A.y);");
        Iterator iter = this.pigServer.openIterator("C");
        Tuple t = (Tuple)iter.next();
        TestBestFitCast.assertTrue((boolean)(t.get(0) instanceof Long));
        TestBestFitCast.assertEquals((Object)new Long(210L), (Object)((Long)t.get(0)));
    }

    @Test
    public void testLongSum() throws IOException, ExecException {
        this.pigServer.registerQuery("A = LOAD '" + this.inputFile + "' as (x, y:long);");
        this.pigServer.registerQuery("B = group A all;");
        this.pigServer.registerQuery("C = FOREACH B generate SUM(A.y);");
        Iterator iter = this.pigServer.openIterator("C");
        Tuple t = (Tuple)iter.next();
        TestBestFitCast.assertTrue((boolean)(t.get(0) instanceof Long));
        TestBestFitCast.assertEquals((Object)new Long(210L), (Object)((Long)t.get(0)));
    }

    @Test
    public void testFloatSum() throws IOException, ExecException {
        this.pigServer.registerQuery("A = LOAD '" + this.inputFile + "' as (x, y:float);");
        this.pigServer.registerQuery("B = group A all;");
        this.pigServer.registerQuery("C = FOREACH B generate SUM(A.y);");
        Iterator iter = this.pigServer.openIterator("C");
        Tuple t = (Tuple)iter.next();
        TestBestFitCast.assertTrue((boolean)(t.get(0) instanceof Double));
        TestBestFitCast.assertEquals((Object)new Double(210.0), (Object)((Double)t.get(0)));
    }

    @Test
    public void testDoubleSum() throws IOException, ExecException {
        this.pigServer.registerQuery("A = LOAD '" + this.inputFile + "' as (x, y:double);");
        this.pigServer.registerQuery("B = group A all;");
        this.pigServer.registerQuery("C = FOREACH B generate SUM(A.y);");
        Iterator iter = this.pigServer.openIterator("C");
        Tuple t = (Tuple)iter.next();
        TestBestFitCast.assertTrue((boolean)(t.get(0) instanceof Double));
        TestBestFitCast.assertEquals((Object)new Double(210.0), (Object)((Double)t.get(0)));
    }

    @Test
    public void test1() throws Exception {
        this.pigServer.registerQuery("A = LOAD '" + this.inputFile + "' as (x:long, y:int);");
        this.pigServer.registerQuery("B = FOREACH A generate x, " + UDF1.class.getName() + "(x,y);");
        Iterator iter = this.pigServer.openIterator("B");
        if (!iter.hasNext()) {
            TestBestFitCast.fail((String)"No Output received");
        }
        int cnt = 0;
        while (iter.hasNext()) {
            Tuple t = (Tuple)iter.next();
            TestBestFitCast.assertEquals((boolean)true, (boolean)(((Tuple)t.get(1)).get(0) instanceof Long));
            TestBestFitCast.assertEquals((boolean)true, (boolean)(((Tuple)t.get(1)).get(1) instanceof Double));
            ++cnt;
        }
        TestBestFitCast.assertEquals((int)20, (int)cnt);
    }

    @Test
    public void test2() throws Exception {
        this.pigServer.registerQuery("A = LOAD '" + this.inputFile + "' as (x:long, y:int);");
        this.pigServer.registerQuery("B = FOREACH A generate x, " + UDF1.class.getName() + "(y,y);");
        try {
            this.pigServer.openIterator("B");
        }
        catch (Exception e) {
            PigException pe = LogUtils.getPigException((Throwable)e);
            String msg = pe == null ? e.getMessage() : pe.getMessage();
            TestBestFitCast.assertEquals((boolean)true, (boolean)msg.contains("as multiple or none of them fit"));
        }
    }

    @Test
    public void test3() throws Exception {
        this.pigServer.registerQuery("A = LOAD '" + this.inputFile + "' as (x:long, y:int);");
        this.pigServer.registerQuery("B = FOREACH A generate x, " + UDF1.class.getName() + "((float)y,(float)y);");
        Iterator iter = this.pigServer.openIterator("B");
        if (!iter.hasNext()) {
            TestBestFitCast.fail((String)"No Output received");
        }
        int cnt = 0;
        while (iter.hasNext()) {
            Tuple t = (Tuple)iter.next();
            TestBestFitCast.assertEquals((boolean)true, (boolean)(((Tuple)t.get(1)).get(0) instanceof Float));
            TestBestFitCast.assertEquals((boolean)true, (boolean)(((Tuple)t.get(1)).get(1) instanceof Float));
            ++cnt;
        }
        TestBestFitCast.assertEquals((int)20, (int)cnt);
    }

    @Test
    public void test4() throws Exception {
        this.pigServer.registerQuery("A = LOAD '" + this.inputFile + "' as (x:long, y:int);");
        this.pigServer.registerQuery("B = FOREACH A generate x, " + UDF1.class.getName() + "(x);");
        Iterator iter = this.pigServer.openIterator("B");
        if (!iter.hasNext()) {
            TestBestFitCast.fail((String)"No Output received");
        }
        int cnt = 0;
        while (iter.hasNext()) {
            Tuple t = (Tuple)iter.next();
            TestBestFitCast.assertEquals((boolean)true, (boolean)(((Tuple)t.get(1)).get(0) instanceof Float));
            ++cnt;
        }
        TestBestFitCast.assertEquals((int)20, (int)cnt);
    }

    @Test
    public void test5() throws Exception {
        this.pigServer.registerQuery("A = LOAD '" + this.inputFile + "';");
        this.pigServer.registerQuery("B = FOREACH A generate $0, " + UDF1.class.getName() + "($1,$1);");
        try {
            this.pigServer.openIterator("B");
        }
        catch (Exception e) {
            PigException pe = LogUtils.getPigException((Throwable)e);
            String msg = pe == null ? e.getMessage() : pe.getMessage();
            TestBestFitCast.assertEquals((boolean)true, (boolean)msg.contains("Multiple matching functions"));
        }
    }

    @Test
    public void test6() throws Exception {
        Util.createInputFile(this.cluster, "test6", new String[]{"abc"});
        this.pigServer.registerQuery("A = LOAD 'test6';");
        this.pigServer.registerQuery("B = FOREACH A GENERATE " + UDF2.class.getName() + "($0);");
        Iterator iter = this.pigServer.openIterator("B");
        if (!iter.hasNext()) {
            TestBestFitCast.fail((String)"No Output received");
        }
        Tuple t = (Tuple)iter.next();
        TestBestFitCast.assertEquals((Object)"ABC", (Object)t.get(0));
        Util.deleteFile(this.cluster, "test6");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UDF3
    extends EvalFunc<Tuple> {
        public Tuple exec(Tuple input) throws IOException {
            return input;
        }

        public List<FuncSpec> getArgToFuncMapping() throws FrontendException {
            ArrayList<FuncSpec> funcList = new ArrayList<FuncSpec>();
            funcList.add(new FuncSpec(((Object)((Object)this)).getClass().getName(), new Schema(new Schema.FieldSchema(null, 50))));
            funcList.add(new FuncSpec(((Object)((Object)this)).getClass().getName(), new Schema(new Schema.FieldSchema(null, 10))));
            funcList.add(new FuncSpec(((Object)((Object)this)).getClass().getName(), new Schema(Arrays.asList(new Schema.FieldSchema(null, 20), new Schema.FieldSchema(null, 25)))));
            funcList.add(new FuncSpec(((Object)((Object)this)).getClass().getName(), new Schema(Arrays.asList(new Schema.FieldSchema(null, 20), new Schema.FieldSchema(null, 15)))));
            funcList.add(new FuncSpec(((Object)((Object)this)).getClass().getName(), new Schema(Arrays.asList(new Schema.FieldSchema(null, 20), new Schema.FieldSchema(null, 25), new Schema.FieldSchema(null, 15)))));
            funcList.add(new FuncSpec(((Object)((Object)this)).getClass().getName(), new Schema(Arrays.asList(new Schema.FieldSchema(null, 20), new Schema.FieldSchema(null, 15), new Schema.FieldSchema(null, 25)))));
            return funcList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UDF2
    extends EvalFunc<String> {
        public String exec(Tuple input) throws IOException {
            try {
                String str = (String)input.get(0);
                return str.toUpperCase();
            }
            catch (Exception e) {
                return null;
            }
        }

        public List<FuncSpec> getArgToFuncMapping() throws FrontendException {
            ArrayList<FuncSpec> funcList = new ArrayList<FuncSpec>();
            funcList.add(new FuncSpec(((Object)((Object)this)).getClass().getName(), new Schema(new Schema.FieldSchema(null, 55))));
            return funcList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UDF1
    extends EvalFunc<Tuple> {
        public Tuple exec(Tuple input) throws IOException {
            return input;
        }

        public List<FuncSpec> getArgToFuncMapping() throws FrontendException {
            ArrayList<FuncSpec> funcList = new ArrayList<FuncSpec>();
            funcList.add(new FuncSpec(((Object)((Object)this)).getClass().getName(), new Schema(Arrays.asList(new Schema.FieldSchema(null, 20), new Schema.FieldSchema(null, 20)))));
            funcList.add(new FuncSpec(((Object)((Object)this)).getClass().getName(), new Schema(Arrays.asList(new Schema.FieldSchema(null, 15), new Schema.FieldSchema(null, 25)))));
            funcList.add(new FuncSpec(((Object)((Object)this)).getClass().getName(), new Schema(new Schema.FieldSchema(null, 20))));
            funcList.add(new FuncSpec(((Object)((Object)this)).getClass().getName(), new Schema(new Schema.FieldSchema(null, 10))));
            funcList.add(new FuncSpec(((Object)((Object)this)).getClass().getName(), new Schema(new Schema.FieldSchema(null, 25))));
            return funcList;
        }
    }
}

