/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.util.Random;
import junit.framework.TestCase;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.BinaryExpressionOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.ConstantExpression;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.ExpressionOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POAnd;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.PONot;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POOr;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.UnaryExpressionOperator;
import org.apache.pig.impl.plan.OperatorKey;
import org.junit.Before;
import org.junit.Test;

public class TestBoolean
extends TestCase {
    Random r = new Random();
    ConstantExpression lt;
    ConstantExpression rt;
    BinaryExpressionOperator bop;
    UnaryExpressionOperator uop;
    Boolean dummy = new Boolean(true);

    @Before
    public void setUp() throws Exception {
        this.lt = new ConstantExpression(new OperatorKey("", this.r.nextLong()));
        this.lt.setResultType((byte)5);
        this.rt = new ConstantExpression(new OperatorKey("", this.r.nextLong()));
        this.rt.setResultType((byte)5);
    }

    private void setupAnd() {
        this.bop = new POAnd(new OperatorKey("", this.r.nextLong()));
        this.bop.setLhs((ExpressionOperator)this.lt);
        this.bop.setRhs((ExpressionOperator)this.rt);
    }

    private void setupOr() {
        this.bop = new POOr(new OperatorKey("", this.r.nextLong()));
        this.bop.setLhs((ExpressionOperator)this.lt);
        this.bop.setRhs((ExpressionOperator)this.rt);
    }

    private void setupNot() {
        this.uop = new PONot(new OperatorKey("", this.r.nextLong()));
        this.uop.setExpr((ExpressionOperator)this.lt);
    }

    @Test
    public void testAndNull() throws ExecException {
        Result res;
        int i;
        this.setupAnd();
        Boolean[] testWith = new Boolean[]{false, true, null};
        for (i = 0; i < testWith.length; ++i) {
            this.lt.setValue(null);
            this.rt.setValue((Object)testWith[i]);
            res = this.bop.getNext(this.dummy);
            TestBoolean.assertEquals((byte)0, (byte)res.returnStatus);
            if (testWith[i] != null && !testWith[i].booleanValue()) {
                TestBoolean.assertEquals((Object)new Boolean(false), (Object)((Boolean)res.result));
                continue;
            }
            TestBoolean.assertEquals(null, (Object)((Boolean)res.result));
        }
        for (i = 0; i < testWith.length; ++i) {
            this.lt.setValue((Object)testWith[i]);
            this.rt.setValue(null);
            res = this.bop.getNext(this.dummy);
            TestBoolean.assertEquals((byte)0, (byte)res.returnStatus);
            if (testWith[i] != null && !testWith[i].booleanValue()) {
                TestBoolean.assertEquals((Object)new Boolean(false), (Object)((Boolean)res.result));
                continue;
            }
            TestBoolean.assertEquals(null, (Object)((Boolean)res.result));
        }
    }

    @Test
    public void testOrNull() throws ExecException {
        Result res;
        int i;
        this.setupOr();
        Boolean[] testWith = new Boolean[]{false, true, null};
        for (i = 0; i < testWith.length; ++i) {
            this.lt.setValue(null);
            this.rt.setValue((Object)testWith[i]);
            res = this.bop.getNext(this.dummy);
            TestBoolean.assertEquals((byte)0, (byte)res.returnStatus);
            if (testWith[i] != null && testWith[i].booleanValue()) {
                TestBoolean.assertEquals((Object)new Boolean(true), (Object)((Boolean)res.result));
                continue;
            }
            TestBoolean.assertEquals(null, (Object)((Boolean)res.result));
        }
        for (i = 0; i < testWith.length; ++i) {
            this.lt.setValue((Object)testWith[i]);
            this.rt.setValue(null);
            res = this.bop.getNext(this.dummy);
            TestBoolean.assertEquals((byte)0, (byte)res.returnStatus);
            if (testWith[i] != null && testWith[i].booleanValue()) {
                TestBoolean.assertEquals((Object)new Boolean(true), (Object)((Boolean)res.result));
                continue;
            }
            TestBoolean.assertEquals(null, (Object)((Boolean)res.result));
        }
    }

    @Test
    public void testAndFirstFalse() throws ExecException {
        this.setupAnd();
        this.lt.setValue((Object)new Boolean(false));
        this.rt.setValue((Object)new Boolean(true));
        Result res = this.bop.getNext(this.dummy);
        TestBoolean.assertEquals((byte)0, (byte)res.returnStatus);
        TestBoolean.assertFalse((boolean)((Boolean)res.result));
    }

    @Test
    public void testAndSecondFalse() throws ExecException {
        this.setupAnd();
        this.lt.setValue((Object)new Boolean(true));
        this.rt.setValue((Object)new Boolean(false));
        Result res = this.bop.getNext(this.dummy);
        TestBoolean.assertEquals((byte)0, (byte)res.returnStatus);
        TestBoolean.assertFalse((boolean)((Boolean)res.result));
    }

    @Test
    public void testAndBothFalse() throws ExecException {
        this.setupAnd();
        this.lt.setValue((Object)new Boolean(false));
        this.rt.setValue((Object)new Boolean(false));
        Result res = this.bop.getNext(this.dummy);
        TestBoolean.assertEquals((byte)0, (byte)res.returnStatus);
        TestBoolean.assertFalse((boolean)((Boolean)res.result));
    }

    @Test
    public void testAndTrue() throws ExecException {
        this.setupAnd();
        this.lt.setValue((Object)new Boolean(true));
        this.rt.setValue((Object)new Boolean(true));
        Result res = this.bop.getNext(this.dummy);
        TestBoolean.assertEquals((byte)0, (byte)res.returnStatus);
        TestBoolean.assertTrue((boolean)((Boolean)res.result));
    }

    @Test
    public void testOrFirstFalse() throws ExecException {
        this.setupOr();
        this.lt.setValue((Object)new Boolean(false));
        this.rt.setValue((Object)new Boolean(true));
        Result res = this.bop.getNext(this.dummy);
        TestBoolean.assertEquals((byte)0, (byte)res.returnStatus);
        TestBoolean.assertTrue((boolean)((Boolean)res.result));
    }

    @Test
    public void testOrSecondFalse() throws ExecException {
        this.setupOr();
        this.lt.setValue((Object)new Boolean(true));
        this.rt.setValue((Object)new Boolean(false));
        Result res = this.bop.getNext(this.dummy);
        TestBoolean.assertEquals((byte)0, (byte)res.returnStatus);
        TestBoolean.assertTrue((boolean)((Boolean)res.result));
    }

    @Test
    public void testOrBothFalse() throws ExecException {
        this.setupOr();
        this.lt.setValue((Object)new Boolean(false));
        this.rt.setValue((Object)new Boolean(false));
        Result res = this.bop.getNext(this.dummy);
        TestBoolean.assertEquals((byte)0, (byte)res.returnStatus);
        TestBoolean.assertFalse((boolean)((Boolean)res.result));
    }

    @Test
    public void testOrTrue() throws ExecException {
        this.setupOr();
        this.lt.setValue((Object)new Boolean(true));
        this.rt.setValue((Object)new Boolean(true));
        Result res = this.bop.getNext(this.dummy);
        TestBoolean.assertEquals((byte)0, (byte)res.returnStatus);
        TestBoolean.assertTrue((boolean)((Boolean)res.result));
    }

    @Test
    public void testNotTrue() throws ExecException {
        this.setupNot();
        this.lt.setValue((Object)new Boolean(true));
        Result res = this.uop.getNext(this.dummy);
        TestBoolean.assertEquals((byte)0, (byte)res.returnStatus);
        TestBoolean.assertFalse((boolean)((Boolean)res.result));
    }

    @Test
    public void testNotFalse() throws ExecException {
        this.setupNot();
        this.lt.setValue((Object)new Boolean(false));
        Result res = this.uop.getNext(this.dummy);
        TestBoolean.assertEquals((byte)0, (byte)res.returnStatus);
        TestBoolean.assertTrue((boolean)((Boolean)res.result));
    }

    @Test
    public void testNotNull() throws ExecException {
        this.setupNot();
        this.lt.setValue(null);
        Result res = this.uop.getNext(this.dummy);
        TestBoolean.assertEquals((byte)0, (byte)res.returnStatus);
        TestBoolean.assertEquals(null, (Object)((Boolean)res.result));
    }
}

