/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.text.ParseException;
import junit.framework.TestCase;
import org.apache.pig.tools.cmdline.CmdLineParser;
import org.junit.Test;

public class TestCmdLineParser
extends TestCase {
    @Test
    public void testRegisterDash() {
        String[] args = new String[]{"a", "b", "c"};
        CmdLineParser p = new CmdLineParser(args);
        try {
            p.registerOpt('-', "alpha", CmdLineParser.ValueExpected.NOT_ACCEPTED);
            TestCmdLineParser.fail((String)"Should have thrown an AssertionError");
        }
        catch (AssertionError e) {
            TestCmdLineParser.assertEquals((String)((Throwable)((Object)e)).getMessage(), (String)"CmdLineParser:  '-' is not a legal single character designator.");
        }
    }

    @Test
    public void testDoubleRegisterShort() {
        String[] args = new String[]{"a", "b", "c"};
        CmdLineParser p = new CmdLineParser(args);
        try {
            p.registerOpt('a', "alpha", CmdLineParser.ValueExpected.NOT_ACCEPTED);
            p.registerOpt('a', "beta", CmdLineParser.ValueExpected.NOT_ACCEPTED);
            TestCmdLineParser.fail((String)"Should have thrown an AssertionError");
        }
        catch (AssertionError e) {
            TestCmdLineParser.assertEquals((String)((Throwable)((Object)e)).getMessage(), (String)"CmdLineParser:  You have already registered option a");
        }
    }

    @Test
    public void testDoubleRegisterLong() {
        String[] args = new String[]{"a", "b", "c"};
        CmdLineParser p = new CmdLineParser(args);
        try {
            p.registerOpt('a', "alpha", CmdLineParser.ValueExpected.NOT_ACCEPTED);
            p.registerOpt('b', "alpha", CmdLineParser.ValueExpected.NOT_ACCEPTED);
            TestCmdLineParser.fail((String)"Should have thrown an AssertionError");
        }
        catch (AssertionError e) {
            TestCmdLineParser.assertEquals((String)((Throwable)((Object)e)).getMessage(), (String)"CmdLineParser:  You have already registered option alpha");
        }
    }

    @Test
    public void testRegister() {
        String[] args = new String[]{"a", "b", "c"};
        CmdLineParser p = new CmdLineParser(args);
        p.registerOpt('a', "alpha", CmdLineParser.ValueExpected.NOT_ACCEPTED);
        p.registerOpt('b', "beta", CmdLineParser.ValueExpected.REQUIRED);
        p.registerOpt('c', null, CmdLineParser.ValueExpected.OPTIONAL);
    }

    @Test
    public void testParseNoArgs() throws ParseException {
        String[] args = new String[]{};
        CmdLineParser p = new CmdLineParser(args);
        p.registerOpt('a', "alpha", CmdLineParser.ValueExpected.NOT_ACCEPTED);
        TestCmdLineParser.assertEquals((char)p.getNextOpt(), (char)'-');
    }

    @Test
    public void testParseNoDash() throws ParseException {
        String[] args = new String[]{"a"};
        CmdLineParser p = new CmdLineParser(args);
        p.registerOpt('a', "alpha", CmdLineParser.ValueExpected.NOT_ACCEPTED);
        TestCmdLineParser.assertEquals((char)p.getNextOpt(), (char)'-');
        String[] remainders = p.getRemainingArgs();
        TestCmdLineParser.assertEquals((String)remainders[0], (String)"a");
    }

    @Test
    public void testParseLongShortNoLeftover() throws ParseException {
        String[] args = new String[]{"-a", "--beta", "beth", "--c"};
        CmdLineParser p = new CmdLineParser(args);
        p.registerOpt('a', "alpha", CmdLineParser.ValueExpected.NOT_ACCEPTED);
        p.registerOpt('b', "beta", CmdLineParser.ValueExpected.REQUIRED);
        p.registerOpt('c', null, CmdLineParser.ValueExpected.OPTIONAL);
        TestCmdLineParser.assertEquals((char)p.getNextOpt(), (char)'a');
        TestCmdLineParser.assertEquals((char)p.getNextOpt(), (char)'b');
        TestCmdLineParser.assertEquals((String)p.getValStr(), (String)"beth");
        TestCmdLineParser.assertEquals((char)p.getNextOpt(), (char)'c');
        TestCmdLineParser.assertNull((Object)p.getValStr());
        TestCmdLineParser.assertEquals((char)p.getNextOpt(), (char)'-');
        TestCmdLineParser.assertNull((Object)p.getRemainingArgs());
    }

    @Test
    public void testParseLongShortLeftover1() throws ParseException {
        String[] args = new String[]{"-a", "--beta", "beth", "--c", "gimel", "-", "hi", "i'm", "left", "over"};
        CmdLineParser p = new CmdLineParser(args);
        p.registerOpt('a', "alpha", CmdLineParser.ValueExpected.NOT_ACCEPTED);
        p.registerOpt('b', "beta", CmdLineParser.ValueExpected.REQUIRED);
        p.registerOpt('c', null, CmdLineParser.ValueExpected.OPTIONAL);
        TestCmdLineParser.assertEquals((char)p.getNextOpt(), (char)'a');
        TestCmdLineParser.assertEquals((char)p.getNextOpt(), (char)'b');
        TestCmdLineParser.assertEquals((String)p.getValStr(), (String)"beth");
        TestCmdLineParser.assertEquals((char)p.getNextOpt(), (char)'c');
        TestCmdLineParser.assertEquals((String)p.getValStr(), (String)"gimel");
        TestCmdLineParser.assertEquals((char)p.getNextOpt(), (char)'-');
        String[] r = p.getRemainingArgs();
        TestCmdLineParser.assertEquals((int)r.length, (int)4);
    }

    @Test
    public void testParseLongShortLeftover2() throws ParseException {
        String[] args = new String[]{"-a", "-beta", "beth", "--c", "gimel", "--", "hi", "i'm", "left", "over"};
        CmdLineParser p = new CmdLineParser(args);
        p.registerOpt('a', "alpha", CmdLineParser.ValueExpected.NOT_ACCEPTED);
        p.registerOpt('b', "beta", CmdLineParser.ValueExpected.REQUIRED);
        p.registerOpt('c', null, CmdLineParser.ValueExpected.OPTIONAL);
        TestCmdLineParser.assertEquals((char)p.getNextOpt(), (char)'a');
        TestCmdLineParser.assertEquals((char)p.getNextOpt(), (char)'b');
        TestCmdLineParser.assertEquals((String)p.getValStr(), (String)"beth");
        TestCmdLineParser.assertEquals((char)p.getNextOpt(), (char)'c');
        TestCmdLineParser.assertEquals((String)p.getValStr(), (String)"gimel");
        TestCmdLineParser.assertEquals((char)p.getNextOpt(), (char)'-');
        String[] r = p.getRemainingArgs();
        TestCmdLineParser.assertEquals((int)r.length, (int)4);
    }

    @Test
    public void testParseLongShortLeftover3() throws ParseException {
        String[] args = new String[]{"-a", "--beta", "5", "--c", "--"};
        CmdLineParser p = new CmdLineParser(args);
        p.registerOpt('a', "alpha", CmdLineParser.ValueExpected.NOT_ACCEPTED);
        p.registerOpt('b', "beta", CmdLineParser.ValueExpected.REQUIRED);
        p.registerOpt('c', null, CmdLineParser.ValueExpected.OPTIONAL);
        TestCmdLineParser.assertEquals((char)p.getNextOpt(), (char)'a');
        TestCmdLineParser.assertEquals((char)p.getNextOpt(), (char)'b');
        Integer ii = p.getValInt();
        TestCmdLineParser.assertEquals((int)ii, (int)5);
        TestCmdLineParser.assertEquals((char)p.getNextOpt(), (char)'c');
        TestCmdLineParser.assertNull((Object)p.getValInt());
        TestCmdLineParser.assertEquals((char)p.getNextOpt(), (char)'-');
        String[] r = p.getRemainingArgs();
        TestCmdLineParser.assertNull((Object)p.getRemainingArgs());
    }

    @Test
    public void testParseValueNotAcceptedProvided1() throws ParseException {
        String[] args = new String[]{"-a", "aleph"};
        CmdLineParser p = new CmdLineParser(args);
        p.registerOpt('a', "alpha", CmdLineParser.ValueExpected.NOT_ACCEPTED);
        TestCmdLineParser.assertEquals((char)p.getNextOpt(), (char)'a');
        String[] r = p.getRemainingArgs();
        TestCmdLineParser.assertEquals((int)r.length, (int)1);
        TestCmdLineParser.assertEquals((String)r[0], (String)"aleph");
    }

    @Test
    public void testParseValueNotAcceptedProvided2() throws ParseException {
        String[] args = new String[]{"-alpha", "aleph"};
        CmdLineParser p = new CmdLineParser(args);
        p.registerOpt('a', "alpha", CmdLineParser.ValueExpected.NOT_ACCEPTED);
        TestCmdLineParser.assertEquals((char)p.getNextOpt(), (char)'a');
        String[] r = p.getRemainingArgs();
        TestCmdLineParser.assertEquals((int)r.length, (int)1);
        TestCmdLineParser.assertEquals((String)r[0], (String)"aleph");
    }

    @Test
    public void testParseValueRequiredNotProvided1() {
        String[] args = new String[]{"-a"};
        CmdLineParser p = new CmdLineParser(args);
        p.registerOpt('a', "alpha", CmdLineParser.ValueExpected.REQUIRED);
        try {
            p.getNextOpt();
            TestCmdLineParser.fail((String)"Should have thrown a ParseException");
        }
        catch (ParseException e) {
            TestCmdLineParser.assertEquals((String)e.getMessage(), (String)"Option -a requires a value but you did not provide one.");
        }
    }

    @Test
    public void testParseValueRequiredNotProvided2() {
        String[] args = new String[]{"--alpha", "-b"};
        CmdLineParser p = new CmdLineParser(args);
        p.registerOpt('a', "alpha", CmdLineParser.ValueExpected.REQUIRED);
        p.registerOpt('b', "beta", CmdLineParser.ValueExpected.NOT_ACCEPTED);
        try {
            p.getNextOpt();
            TestCmdLineParser.fail((String)"Should have thrown a ParseException");
        }
        catch (ParseException e) {
            TestCmdLineParser.assertEquals((String)e.getMessage(), (String)"Option --alpha requires a value but you did not provide one.");
        }
    }

    @Test
    public void testParseValueStrForInt() throws ParseException {
        String[] args = new String[]{"-alpha", "b"};
        CmdLineParser p = new CmdLineParser(args);
        p.registerOpt('a', "alpha", CmdLineParser.ValueExpected.REQUIRED);
        try {
            p.getNextOpt();
            Integer ii = p.getValInt();
            TestCmdLineParser.fail((String)"Should have thrown a NumberFormatException");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Test
    public void testParseUnknownShort() {
        String[] args = new String[]{"-alpha", "b", "-z"};
        CmdLineParser p = new CmdLineParser(args);
        p.registerOpt('a', "alpha", CmdLineParser.ValueExpected.REQUIRED);
        try {
            p.getNextOpt();
            TestCmdLineParser.assertEquals((String)p.getValStr(), (String)"b");
            p.getNextOpt();
            TestCmdLineParser.fail((String)"Should have thrown a ParseException");
        }
        catch (ParseException e) {
            TestCmdLineParser.assertEquals((String)e.getMessage(), (String)"Found unknown option (-z) at position 3");
        }
    }

    @Test
    public void testParseUnknownLong() {
        String[] args = new String[]{"--zeta"};
        CmdLineParser p = new CmdLineParser(args);
        p.registerOpt('a', "alpha", CmdLineParser.ValueExpected.REQUIRED);
        try {
            p.getNextOpt();
            TestCmdLineParser.fail((String)"Should have thrown a ParseException");
        }
        catch (ParseException e) {
            TestCmdLineParser.assertEquals((String)e.getMessage(), (String)"Found unknown option (--zeta) at position 1");
        }
    }
}

