/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.pig.CollectableLoadFunc;
import org.apache.pig.ExecType;
import org.apache.pig.PigServer;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.MRCompilerException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POCollectedGroup;
import org.apache.pig.builtin.PigStorage;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.logicalLayer.LOCogroup;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.test.MiniCluster;
import org.apache.pig.test.Util;
import org.apache.pig.test.utils.LogicalPlanTester;
import org.apache.pig.test.utils.TestHelper;
import org.junit.After;
import org.junit.Before;

public class TestCollectedGroup
extends TestCase {
    private static final String INPUT_FILE = "MapSideGroupInput.txt";
    private PigServer pigServer;
    private MiniCluster cluster = MiniCluster.buildCluster();

    public TestCollectedGroup() throws ExecException, IOException {
        this.pigServer = new PigServer(ExecType.MAPREDUCE, this.cluster.getProperties());
    }

    @Before
    public void setUp() throws Exception {
        this.createFiles();
    }

    private void createFiles() throws IOException {
        PrintWriter w = new PrintWriter(new FileWriter(INPUT_FILE));
        w.println("100\tapple1\t95");
        w.println("100\tapple2\t83");
        w.println("100\tapple2\t74");
        w.println("200\torange1\t100");
        w.println("200\torange2\t89");
        w.println("300\tstrawberry\t64");
        w.println("300\tstrawberry\t64");
        w.println("300\tstrawberry\t76");
        w.println("400\tpear\t78");
        w.close();
        Util.copyFromLocalToCluster(this.cluster, INPUT_FILE, INPUT_FILE);
    }

    @After
    public void tearDown() throws Exception {
        new File(INPUT_FILE).delete();
        Util.deleteFile(this.cluster, INPUT_FILE);
    }

    public void testNonCollectableLoader() throws Exception {
        LogicalPlanTester lpt = new LogicalPlanTester();
        lpt.buildPlan("A = LOAD 'MapSideGroupInput.txt' as (id, name, grade);");
        LogicalPlan lp = lpt.buildPlan("B = group A by id using 'collected';");
        PigContext pc = new PigContext(ExecType.MAPREDUCE, this.cluster.getProperties());
        pc.connect();
        try {
            Util.buildMRPlan(Util.buildPhysicalPlan(lp, pc), pc);
            TestCollectedGroup.fail((String)"Must throw MRCompiler Exception");
        }
        catch (Exception e) {
            TestCollectedGroup.assertTrue((boolean)(e instanceof MRCompilerException));
        }
    }

    public void testCollectedGrpSpecifiedInSingleQuotes1() {
        LogicalPlanTester lpt = new LogicalPlanTester();
        lpt.buildPlan("A = LOAD 'MapSideGroupInput.txt' as (id, name, grade);");
        LogicalPlan lp = lpt.buildPlan("B = group A by id using 'collected';");
        TestCollectedGroup.assertEquals((Object)LOCogroup.GROUPTYPE.COLLECTED, (Object)((LOCogroup)lp.getLeaves().get(0)).getGroupType());
    }

    public void testCollectedGrpSpecifiedInSingleQuotes2() {
        LogicalPlanTester lpt = new LogicalPlanTester();
        lpt.buildPlan("A = LOAD 'MapSideGroupInput.txt' as (id, name, grade);");
        LogicalPlan lp = lpt.buildPlan("B = group A all using 'regular';");
        TestCollectedGroup.assertEquals((Object)LOCogroup.GROUPTYPE.REGULAR, (Object)((LOCogroup)lp.getLeaves().get(0)).getGroupType());
    }

    public void testPOMapsideGroupNoNullPlans() throws IOException {
        POCollectedGroup pmg = new POCollectedGroup(new OperatorKey());
        List plans = pmg.getPlans();
        Assert.assertTrue((plans != null ? 1 : 0) != 0);
        Assert.assertTrue((plans.size() == 0 ? 1 : 0) != 0);
    }

    public void testMapsideGroupParserNoSupportForMultipleInputs() throws IOException {
        this.pigServer = new PigServer(ExecType.MAPREDUCE, this.cluster.getProperties());
        this.pigServer.registerQuery("A = LOAD 'MapSideGroupInput.txt' as (id, name, grade);");
        this.pigServer.registerQuery("B = LOAD 'MapSideGroupInput.txt' as (id, name, grade);");
        try {
            this.pigServer.registerQuery("C = group A by id, B by id using \"collected\";");
            TestCollectedGroup.fail((String)"Pig doesn't support multi-input collected group.");
        }
        catch (Exception e) {
            Assert.assertEquals((String)e.getMessage(), (String)"Error during parsing. Collected group is only supported for single input");
        }
    }

    public void testMapsideGroupParserNoSupportForGroupAll() throws IOException {
        this.pigServer = new PigServer(ExecType.MAPREDUCE, this.cluster.getProperties());
        this.pigServer.registerQuery("A = LOAD 'MapSideGroupInput.txt' as (id, name, grade);");
        try {
            this.pigServer.registerQuery("B = group A all using \"collected\";");
            TestCollectedGroup.fail((String)"Pig doesn't support collected group all.");
        }
        catch (Exception e) {
            Assert.assertEquals((String)e.getMessage(), (String)"Error during parsing. Collected group is only supported for columns or star projection");
        }
    }

    public void testMapsideGroupParserNoSupportForByExpression() throws IOException {
        this.pigServer = new PigServer(ExecType.MAPREDUCE, this.cluster.getProperties());
        this.pigServer.registerQuery("A = LOAD 'MapSideGroupInput.txt' as (id, name, grade);");
        try {
            this.pigServer.registerQuery("B = group A by id*grade using \"collected\";");
            TestCollectedGroup.fail((String)"Pig doesn't support collected group by expression.");
        }
        catch (Exception e) {
            Assert.assertEquals((String)e.getMessage(), (String)"Error during parsing. Collected group is only supported for columns or star projection");
        }
    }

    public void testMapsideGroupByOneColumn() throws IOException {
        this.pigServer = new PigServer(ExecType.MAPREDUCE, this.cluster.getProperties());
        this.pigServer.registerQuery("A = LOAD 'MapSideGroupInput.txt' using " + DummyCollectableLoader.class.getName() + "() as (id, name, grade);");
        try {
            DataBag dbfrj = BagFactory.getInstance().newDefaultBag();
            DataBag dbshj = BagFactory.getInstance().newDefaultBag();
            this.pigServer.registerQuery("B = group A by id using \"collected\";");
            this.pigServer.registerQuery("C = foreach B generate group, COUNT(A);");
            Iterator iter = this.pigServer.openIterator("C");
            while (iter.hasNext()) {
                dbfrj.add((Tuple)iter.next());
            }
            this.pigServer.registerQuery("D = group A by id;");
            this.pigServer.registerQuery("E = foreach D generate group, COUNT(A);");
            iter = this.pigServer.openIterator("E");
            while (iter.hasNext()) {
                dbshj.add((Tuple)iter.next());
            }
            Assert.assertTrue((dbfrj.size() > 0L && dbshj.size() > 0L ? 1 : 0) != 0);
            Assert.assertEquals((boolean)true, (boolean)TestHelper.compareBags(dbfrj, dbshj));
        }
        catch (Exception e) {
            e.printStackTrace();
            TestCollectedGroup.fail((String)e.getMessage());
        }
    }

    public void testMapsideGroupByMultipleColumns() throws IOException {
        this.pigServer = new PigServer(ExecType.MAPREDUCE, this.cluster.getProperties());
        this.pigServer.registerQuery("A = LOAD 'MapSideGroupInput.txt' using " + DummyCollectableLoader.class.getName() + "() as (id, name, grade);");
        try {
            DataBag dbfrj = BagFactory.getInstance().newDefaultBag();
            DataBag dbshj = BagFactory.getInstance().newDefaultBag();
            this.pigServer.registerQuery("B = group A by (id, name) using \"collected\";");
            this.pigServer.registerQuery("C = foreach B generate group, COUNT(A);");
            Iterator iter = this.pigServer.openIterator("C");
            while (iter.hasNext()) {
                dbfrj.add((Tuple)iter.next());
            }
            this.pigServer.registerQuery("D = group A by (id, name);");
            this.pigServer.registerQuery("E = foreach D generate group, COUNT(A);");
            iter = this.pigServer.openIterator("E");
            while (iter.hasNext()) {
                dbshj.add((Tuple)iter.next());
            }
            Assert.assertTrue((dbfrj.size() > 0L && dbshj.size() > 0L ? 1 : 0) != 0);
            Assert.assertEquals((boolean)true, (boolean)TestHelper.compareBags(dbfrj, dbshj));
        }
        catch (Exception e) {
            e.printStackTrace();
            TestCollectedGroup.fail((String)e.getMessage());
        }
    }

    public void testMapsideGroupByStar() throws IOException {
        this.pigServer = new PigServer(ExecType.MAPREDUCE, this.cluster.getProperties());
        this.pigServer.registerQuery("A = LOAD 'MapSideGroupInput.txt' using " + DummyCollectableLoader.class.getName() + "() as (id, name, grade);");
        try {
            DataBag dbfrj = BagFactory.getInstance().newDefaultBag();
            DataBag dbshj = BagFactory.getInstance().newDefaultBag();
            this.pigServer.registerQuery("B = group A by * using \"collected\";");
            this.pigServer.registerQuery("C = foreach B generate group, COUNT(A);");
            Iterator iter = this.pigServer.openIterator("C");
            while (iter.hasNext()) {
                dbfrj.add((Tuple)iter.next());
            }
            this.pigServer.registerQuery("D = group A by *;");
            this.pigServer.registerQuery("E = foreach D generate group, COUNT(A);");
            iter = this.pigServer.openIterator("E");
            while (iter.hasNext()) {
                dbshj.add((Tuple)iter.next());
            }
            Assert.assertTrue((dbfrj.size() > 0L && dbshj.size() > 0L ? 1 : 0) != 0);
            Assert.assertEquals((boolean)true, (boolean)TestHelper.compareBags(dbfrj, dbshj));
        }
        catch (Exception e) {
            e.printStackTrace();
            TestCollectedGroup.fail((String)e.getMessage());
        }
    }

    public static class DummyCollectableLoader
    extends PigStorage
    implements CollectableLoadFunc {
        String udfContextSignature;

        public void setUDFContextSignature(String signature) {
            this.udfContextSignature = signature;
        }

        public void ensureAllKeyInstancesInSameSplit() throws IOException {
            Assert.assertNotNull((Object)this.udfContextSignature);
        }
    }
}

